/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;

public class TouchImageView
extends ImageView {
    Matrix matrix = new Matrix();
    final int maxSize = 4096;
    static final int NONE = 0;
    static final int DRAG = 1;
    static final int ZOOM = 2;
    int mode = 0;
    PointF last = new PointF();
    PointF start = new PointF();
    float minScale = 1.0f;
    float maxScale = 3.0f;
    float[] m;
    float redundantXSpace;
    float redundantYSpace;
    float width;
    float height;
    static final int CLICK = 3;
    float saveScale = 1.0f;
    float right;
    float bottom;
    float origWidth;
    float origHeight;
    float bmWidth;
    float bmHeight;
    ScaleGestureDetector mScaleDetector;
    Context context;

    public TouchImageView(Context context) {
        super(context);
        this.sharedConstructing(context);
    }

    public TouchImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.sharedConstructing(context);
    }

    private void sharedConstructing(Context context) {
        super.setClickable(true);
        this.context = context;
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.matrix.setTranslate(1.0f, 1.0f);
        this.m = new float[9];
        this.setImageMatrix(this.matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                TouchImageView.this.mScaleDetector.onTouchEvent(event);
                TouchImageView.this.matrix.getValues(TouchImageView.this.m);
                float x = TouchImageView.this.m[2];
                float y = TouchImageView.this.m[5];
                PointF curr = new PointF(event.getX(), event.getY());
                switch (event.getAction()) {
                    case 0: {
                        TouchImageView.this.last.set(event.getX(), event.getY());
                        TouchImageView.this.start.set(TouchImageView.this.last);
                        TouchImageView.this.mode = 1;
                        break;
                    }
                    case 2: {
                        if (TouchImageView.this.mode != 1) break;
                        float deltaX = curr.x - TouchImageView.this.last.x;
                        float deltaY = curr.y - TouchImageView.this.last.y;
                        float scaleWidth = Math.round(TouchImageView.this.origWidth * TouchImageView.this.saveScale);
                        float scaleHeight = Math.round(TouchImageView.this.origHeight * TouchImageView.this.saveScale);
                        if (scaleWidth < TouchImageView.this.width) {
                            deltaX = 0.0f;
                            if (y + deltaY > 0.0f) {
                                deltaY = -y;
                            } else if (y + deltaY < -TouchImageView.this.bottom) {
                                deltaY = -(y + TouchImageView.this.bottom);
                            }
                        } else if (scaleHeight < TouchImageView.this.height) {
                            deltaY = 0.0f;
                            if (x + deltaX > 0.0f) {
                                deltaX = -x;
                            } else if (x + deltaX < -TouchImageView.this.right) {
                                deltaX = -(x + TouchImageView.this.right);
                            }
                        } else {
                            if (x + deltaX > 0.0f) {
                                deltaX = -x;
                            } else if (x + deltaX < -TouchImageView.this.right) {
                                deltaX = -(x + TouchImageView.this.right);
                            }
                            if (y + deltaY > 0.0f) {
                                deltaY = -y;
                            } else if (y + deltaY < -TouchImageView.this.bottom) {
                                deltaY = -(y + TouchImageView.this.bottom);
                            }
                        }
                        TouchImageView.this.matrix.postTranslate(deltaX, deltaY);
                        TouchImageView.this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: {
                        TouchImageView.this.mode = 0;
                        int xDiff = (int)Math.abs(curr.x - TouchImageView.this.start.x);
                        int yDiff = (int)Math.abs(curr.y - TouchImageView.this.start.y);
                        if (xDiff >= 3 || yDiff >= 3) break;
                        TouchImageView.this.performClick();
                        break;
                    }
                    case 6: {
                        TouchImageView.this.mode = 0;
                    }
                }
                TouchImageView.this.setImageMatrix(TouchImageView.this.matrix);
                TouchImageView.this.invalidate();
                return true;
            }
        });
    }

    public void setImageBitmap(Bitmap bm) {
        Bitmap bmForDisplay = bm;
        if (bm != null) {
            this.bmWidth = bm.getWidth();
            this.bmHeight = bm.getHeight();
            boolean toScale = false;
            if (this.bmWidth > this.bmHeight && this.bmWidth > 4096.0f) {
                this.bmHeight = this.bmHeight * 4096.0f / this.bmWidth;
                this.bmWidth = 4096.0f;
                toScale = true;
            } else if (this.bmHeight > 4096.0f) {
                this.bmWidth = this.bmWidth * 4096.0f / this.bmHeight;
                this.bmHeight = 4096.0f;
                toScale = true;
            }
            if (toScale) {
                bmForDisplay = Bitmap.createScaledBitmap((Bitmap)bm, (int)((int)this.bmWidth), (int)((int)this.bmHeight), (boolean)false);
                bm.recycle();
            }
        }
        super.setImageBitmap(bmForDisplay);
    }

    public void setMaxZoom(float x) {
        this.maxScale = x;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float scaleX = this.width / this.bmWidth;
        float scaleY = this.height / this.bmHeight;
        float scale = Math.min(scaleX, scaleY);
        this.matrix.setScale(scale, scale);
        this.setImageMatrix(this.matrix);
        this.saveScale = 1.0f;
        this.redundantYSpace = this.height - scale * this.bmHeight;
        this.redundantXSpace = this.width - scale * this.bmWidth;
        this.redundantYSpace /= 2.0f;
        this.redundantXSpace /= 2.0f;
        this.matrix.postTranslate(this.redundantXSpace, this.redundantYSpace);
        this.origWidth = this.width - 2.0f * this.redundantXSpace;
        this.origHeight = this.height - 2.0f * this.redundantYSpace;
        this.right = this.width * this.saveScale - this.width - 2.0f * this.redundantXSpace * this.saveScale;
        this.bottom = this.height * this.saveScale - this.height - 2.0f * this.redundantYSpace * this.saveScale;
        this.setImageMatrix(this.matrix);
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            TouchImageView.this.mode = 2;
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mScaleFactor = detector.getScaleFactor();
            float origScale = TouchImageView.this.saveScale;
            TouchImageView.this.saveScale *= mScaleFactor;
            if (TouchImageView.this.saveScale > TouchImageView.this.maxScale) {
                TouchImageView.this.saveScale = TouchImageView.this.maxScale;
                mScaleFactor = TouchImageView.this.maxScale / origScale;
            } else if (TouchImageView.this.saveScale < TouchImageView.this.minScale) {
                TouchImageView.this.saveScale = TouchImageView.this.minScale;
                mScaleFactor = TouchImageView.this.minScale / origScale;
            }
            TouchImageView.this.right = TouchImageView.this.width * TouchImageView.this.saveScale - TouchImageView.this.width - 2.0f * TouchImageView.this.redundantXSpace * TouchImageView.this.saveScale;
            TouchImageView.this.bottom = TouchImageView.this.height * TouchImageView.this.saveScale - TouchImageView.this.height - 2.0f * TouchImageView.this.redundantYSpace * TouchImageView.this.saveScale;
            if (TouchImageView.this.origWidth * TouchImageView.this.saveScale <= TouchImageView.this.width || TouchImageView.this.origHeight * TouchImageView.this.saveScale <= TouchImageView.this.height) {
                TouchImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, TouchImageView.this.width / 2.0f, TouchImageView.this.height / 2.0f);
                if (mScaleFactor < 1.0f) {
                    TouchImageView.this.matrix.getValues(TouchImageView.this.m);
                    float x = TouchImageView.this.m[2];
                    float y = TouchImageView.this.m[5];
                    if (mScaleFactor < 1.0f) {
                        if ((float)Math.round(TouchImageView.this.origWidth * TouchImageView.this.saveScale) < TouchImageView.this.width) {
                            if (y < -TouchImageView.this.bottom) {
                                TouchImageView.this.matrix.postTranslate(0.0f, -(y + TouchImageView.this.bottom));
                            } else if (y > 0.0f) {
                                TouchImageView.this.matrix.postTranslate(0.0f, -y);
                            }
                        } else if (x < -TouchImageView.this.right) {
                            TouchImageView.this.matrix.postTranslate(-(x + TouchImageView.this.right), 0.0f);
                        } else if (x > 0.0f) {
                            TouchImageView.this.matrix.postTranslate(-x, 0.0f);
                        }
                    }
                }
            } else {
                TouchImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), detector.getFocusY());
                TouchImageView.this.matrix.getValues(TouchImageView.this.m);
                float x = TouchImageView.this.m[2];
                float y = TouchImageView.this.m[5];
                if (mScaleFactor < 1.0f) {
                    if (x < -TouchImageView.this.right) {
                        TouchImageView.this.matrix.postTranslate(-(x + TouchImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        TouchImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (y < -TouchImageView.this.bottom) {
                        TouchImageView.this.matrix.postTranslate(0.0f, -(y + TouchImageView.this.bottom));
                    } else if (y > 0.0f) {
                        TouchImageView.this.matrix.postTranslate(0.0f, -y);
                    }
                }
            }
            return true;
        }
    }
}

