/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.topimagesystems.R;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=11)
public class SelectionCroppingView
extends FrameLayout
implements View.OnTouchListener {
    protected Context context;
    private SelectionCroppingView selectionCroppingView;
    private ImageView pointer1;
    private ImageView pointer2;
    private ImageView pointer3;
    private ImageView pointer4;
    private ImageView midPointer13;
    private ImageView midPointer12;
    private ImageView midPointer34;
    private ImageView midPointer24;
    private Paint rectPaint;
    private Paint movingPointerPaint = new Paint();
    private Drawable validPointerDrawable;
    private Drawable invalidPointerDrawable;
    private float pointerRadius;
    private boolean isZooming = false;
    private float magnifierScale;
    private int magnifierRadius;
    private int magnifierDistance;
    private PointF zoomPosition;
    private Matrix magnifierMatrix;
    private Bitmap magnifierBitmap;
    private BitmapShader magnifierShader;
    private Paint magnifierPaint = new Paint();
    private Path magnifierPath = new Path();
    private Drawable magnifierCircleDrawable;
    private boolean isValidRect = true;
    private boolean isPointsAlreadySet = false;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private View movingView = null;
    private ISelectionListener selectionListener;
    private final float pointerDrawRatio = this.getResources().getDimension(R.dimen.cropping_selection_circle_size) / this.getResources().getDimension(R.dimen.cropping_selection_circle_extra_size);
    private boolean magnifierLocatedLeft = true;
    private boolean magnifierLocatedTop = true;

    public SelectionCroppingView(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    public SelectionCroppingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init();
    }

    public SelectionCroppingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init();
    }

    private void init() {
        this.setDrawingCacheEnabled(false);
        this.selectionCroppingView = this;
        this.pointer1 = this.getImageView(0, 0);
        this.pointer1.post(new Runnable(){

            @Override
            public void run() {
                SelectionCroppingView.this.pointerRadius = SelectionCroppingView.this.pointer1.getHeight() / 2;
            }
        });
        this.pointer2 = this.getImageView(this.getWidth(), 0);
        this.pointer3 = this.getImageView(0, this.getHeight());
        this.pointer4 = this.getImageView(this.getWidth(), this.getHeight());
        this.midPointer13 = this.getImageView(0, this.getHeight() / 2);
        this.midPointer13.setOnTouchListener((View.OnTouchListener)new MidPointTouchListenerImpl(this.pointer1, this.pointer3));
        this.midPointer12 = this.getImageView(0, this.getWidth() / 2);
        this.midPointer12.setOnTouchListener((View.OnTouchListener)new MidPointTouchListenerImpl(this.pointer1, this.pointer2));
        this.midPointer34 = this.getImageView(0, this.getHeight() / 2);
        this.midPointer34.setOnTouchListener((View.OnTouchListener)new MidPointTouchListenerImpl(this.pointer3, this.pointer4));
        this.midPointer24 = this.getImageView(0, this.getHeight() / 2);
        this.midPointer24.setOnTouchListener((View.OnTouchListener)new MidPointTouchListenerImpl(this.pointer2, this.pointer4));
        this.addView((View)this.pointer1);
        this.addView((View)this.pointer2);
        this.addView((View)this.midPointer13);
        this.addView((View)this.midPointer12);
        this.addView((View)this.midPointer34);
        this.addView((View)this.midPointer24);
        this.addView((View)this.pointer3);
        this.addView((View)this.pointer4);
        this.rectPaint = new Paint();
        this.rectPaint.setColor(this.getResources().getColor(R.color.croppingValidColor));
        this.rectPaint.setStrokeWidth(2.0f);
        this.rectPaint.setAntiAlias(true);
        this.movingPointerPaint.setColor(this.getResources().getColor(R.color.croppingPointerMoving));
        this.movingPointerPaint.setAntiAlias(true);
        this.zoomPosition = new PointF(0.0f, 0.0f);
        this.magnifierMatrix = new Matrix();
        Resources res = this.getResources();
        this.magnifierRadius = res.getDimensionPixelSize(R.dimen.cropping_magnifier_circle_size) / 2;
        this.magnifierDistance = res.getDimensionPixelOffset(R.dimen.cropping_magnifier_distance);
        this.magnifierScale = Float.valueOf(res.getString(R.string.cropping_magnifier_scale)).floatValue();
        this.magnifierCircleDrawable = res.getDrawable(R.drawable.cropping_magnifier);
        this.validPointerDrawable = res.getDrawable(R.drawable.cropping_pointer);
        this.invalidPointerDrawable = res.getDrawable(R.drawable.cropping_pointer_invalid);
        this.setBoundaries();
    }

    protected void attachViewToParent(View child, int index, ViewGroup.LayoutParams params) {
        super.attachViewToParent(child, index, params);
    }

    protected void detachViewFromParent(View child) {
        if (this.magnifierBitmap != null) {
            if (!this.magnifierBitmap.isRecycled()) {
                this.magnifierBitmap.recycle();
            }
            this.magnifierBitmap = null;
        }
        this.selectionListener = null;
        super.detachViewFromParent(child);
    }

    public void setSelectionListener(ISelectionListener listener) {
        this.selectionListener = listener;
    }

    public List<PointF> getPointsInsideBounds() {
        ArrayList<PointF> points = new ArrayList<PointF>();
        points.add(new PointF(this.pointer1.getX() + this.pointerRadius - this.minX, this.pointer1.getY() + this.pointerRadius - this.minY));
        points.add(new PointF(this.pointer2.getX() + this.pointerRadius - this.minX, this.pointer2.getY() + this.pointerRadius - this.minY));
        points.add(new PointF(this.pointer3.getX() + this.pointerRadius - this.minX, this.pointer3.getY() + this.pointerRadius - this.minY));
        points.add(new PointF(this.pointer4.getX() + this.pointerRadius - this.minX, this.pointer4.getY() + this.pointerRadius - this.minY));
        return points;
    }

    public Map<Integer, PointF> getPoints() {
        ArrayList<PointF> points = new ArrayList<PointF>();
        points.add(new PointF(this.pointer1.getX(), this.pointer1.getY()));
        points.add(new PointF(this.pointer2.getX(), this.pointer2.getY()));
        points.add(new PointF(this.pointer3.getX(), this.pointer3.getY()));
        points.add(new PointF(this.pointer4.getX(), this.pointer4.getY()));
        return this.getOrderedPoints(points);
    }

    public Map<Integer, PointF> getOrderedPoints(List<PointF> points) {
        PointF centerPoint = new PointF();
        int size = points.size();
        for (PointF pointF : points) {
            centerPoint.x += pointF.x / (float)size;
            centerPoint.y += pointF.y / (float)size;
        }
        PointF[] orderedPoints = points.toArray(new PointF[size]);
        UserInterfaceUtils.sortPointsClockwise(orderedPoints, centerPoint);
        double closestDistanceToTopLeft = Double.MAX_VALUE;
        int closestIndexToTopLeft = -1;
        int i = 0;
        while (i < orderedPoints.length) {
            PointF pointF = orderedPoints[i];
            double distance = Math.sqrt(Math.pow(pointF.x, 2.0) + Math.pow(pointF.y, 2.0));
            if (distance < closestDistanceToTopLeft) {
                closestDistanceToTopLeft = distance;
                closestIndexToTopLeft = i;
            }
            centerPoint.x += pointF.x / (float)size;
            centerPoint.y += pointF.y / (float)size;
            ++i;
        }
        HashMap<Integer, PointF> orderedPointsMap = new HashMap<Integer, PointF>();
        orderedPointsMap.put(0, orderedPoints[closestIndexToTopLeft]);
        orderedPointsMap.put(1, orderedPoints[(closestIndexToTopLeft + 1) % 4]);
        orderedPointsMap.put(2, orderedPoints[(closestIndexToTopLeft + 3) % 4]);
        orderedPointsMap.put(3, orderedPoints[(closestIndexToTopLeft + 2) % 4]);
        return orderedPointsMap;
    }

    public boolean isConvex(Map<Integer, PointF> points) {
        PointF[] vertices = new PointF[points.size()];
        if (vertices.length < 4) {
            return false;
        }
        vertices[0] = points.get(0);
        vertices[1] = points.get(1);
        vertices[2] = points.get(3);
        vertices[3] = points.get(2);
        boolean sign = false;
        int n = vertices.length;
        int i = 0;
        while (i < n) {
            double dx1 = vertices[(i + 2) % n].x - vertices[(i + 1) % n].x;
            double dy1 = vertices[(i + 2) % n].y - vertices[(i + 1) % n].y;
            double dx2 = vertices[i].x - vertices[(i + 1) % n].x;
            double dy2 = vertices[i].y - vertices[(i + 1) % n].y;
            double zcrossproduct = dx1 * dy2 - dy1 * dx2;
            if (i == 0) {
                sign = zcrossproduct > 0.0;
            } else if (sign != zcrossproduct > 0.0) {
                return false;
            }
            ++i;
        }
        this.correctThePointsOrder(points);
        return true;
    }

    private void correctThePointsOrder(Map<Integer, PointF> pointFMap) {
        if (this.pointerRadius == 0.0f) {
            this.pointerRadius = this.pointer1.getWidth() / 2;
        }
        if (pointFMap == null) {
            this.hidePoints();
            return;
        }
        this.showPoints();
        if (pointFMap.size() == 4) {
            Object[] keys;
            Object[] objectArray = keys = pointFMap.keySet().toArray();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                PointF pointF = pointFMap.get(key);
                this.movePointInsideBoundaries(pointF);
                ++n2;
            }
            this.setPointsCoordinates(pointFMap);
            this.isPointsAlreadySet = true;
            this.invalidate();
        }
    }

    public void setPoints(Map<Integer, PointF> pointFMap) {
        if (this.pointerRadius == 0.0f) {
            this.pointerRadius = this.pointer1.getWidth() / 2;
        }
        if (pointFMap == null) {
            this.hidePoints();
            return;
        }
        this.showPoints();
        if (pointFMap.size() == 4) {
            Object[] keys;
            Object[] objectArray = keys = pointFMap.keySet().toArray();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                PointF pointF = pointFMap.get(key);
                pointF.x += this.minX;
                pointF.y += this.minY;
                pointF.x -= this.pointerRadius;
                pointF.y -= this.pointerRadius;
                this.movePointInsideBoundaries(pointF);
                ++n2;
            }
            this.setPointsCoordinates(pointFMap);
            this.updateSelectionColorAndListener();
            this.isPointsAlreadySet = true;
            this.invalidate();
        }
    }

    private void movePointInsideBoundaries(PointF pointF) {
        pointF.x = Math.min(Math.max(pointF.x, this.minX - this.pointerRadius), this.maxX - this.pointerRadius);
        pointF.y = Math.min(Math.max(pointF.y, this.minY - this.pointerRadius), this.maxY - this.pointerRadius);
    }

    private void hidePoints() {
        this.pointer1.setVisibility(8);
        this.pointer2.setVisibility(8);
        this.pointer3.setVisibility(8);
        this.pointer4.setVisibility(8);
        this.midPointer12.setVisibility(8);
        this.midPointer13.setVisibility(8);
        this.midPointer24.setVisibility(8);
        this.midPointer34.setVisibility(8);
    }

    private void showPoints() {
        this.pointer1.setVisibility(0);
        this.pointer2.setVisibility(0);
        this.pointer3.setVisibility(0);
        this.pointer4.setVisibility(0);
        this.midPointer12.setVisibility(0);
        this.midPointer13.setVisibility(0);
        this.midPointer24.setVisibility(0);
        this.midPointer34.setVisibility(0);
    }

    private void setPointsCoordinates(Map<Integer, PointF> pointFMap) {
        this.pointer1.setX(pointFMap.get((Object)Integer.valueOf((int)0)).x);
        this.pointer1.setY(pointFMap.get((Object)Integer.valueOf((int)0)).y);
        this.pointer2.setX(pointFMap.get((Object)Integer.valueOf((int)1)).x);
        this.pointer2.setY(pointFMap.get((Object)Integer.valueOf((int)1)).y);
        this.midPointer12.setX((pointFMap.get((Object)Integer.valueOf((int)0)).x + pointFMap.get((Object)Integer.valueOf((int)1)).x) / 2.0f);
        this.midPointer12.setY((pointFMap.get((Object)Integer.valueOf((int)0)).y + pointFMap.get((Object)Integer.valueOf((int)1)).y) / 2.0f);
        this.pointer3.setX(pointFMap.get((Object)Integer.valueOf((int)2)).x);
        this.pointer3.setY(pointFMap.get((Object)Integer.valueOf((int)2)).y);
        this.midPointer13.setX((pointFMap.get((Object)Integer.valueOf((int)0)).x + pointFMap.get((Object)Integer.valueOf((int)2)).x) / 2.0f);
        this.midPointer13.setY((pointFMap.get((Object)Integer.valueOf((int)0)).y + pointFMap.get((Object)Integer.valueOf((int)2)).y) / 2.0f);
        this.pointer4.setX(pointFMap.get((Object)Integer.valueOf((int)3)).x);
        this.pointer4.setY(pointFMap.get((Object)Integer.valueOf((int)3)).y);
        this.midPointer24.setX((pointFMap.get((Object)Integer.valueOf((int)1)).x + pointFMap.get((Object)Integer.valueOf((int)3)).x) / 2.0f);
        this.midPointer24.setY((pointFMap.get((Object)Integer.valueOf((int)1)).y + pointFMap.get((Object)Integer.valueOf((int)3)).y) / 2.0f);
        this.midPointer34.setX((pointFMap.get((Object)Integer.valueOf((int)2)).x + pointFMap.get((Object)Integer.valueOf((int)3)).x) / 2.0f);
        this.midPointer34.setY((pointFMap.get((Object)Integer.valueOf((int)2)).y + pointFMap.get((Object)Integer.valueOf((int)3)).y) / 2.0f);
    }

    private void drawPointerOnMagnifierCanvas(Canvas canvas, PointF pointF) {
        int l = (int)(pointF.x - this.pointerRadius);
        int t = (int)(pointF.y - this.pointerRadius);
        int r = (int)(pointF.x + this.pointerRadius);
        int b = (int)(pointF.y + this.pointerRadius);
        Drawable d = this.isValidRect ? this.validPointerDrawable : this.invalidPointerDrawable;
        d.setBounds(l, t, r, b);
        d.draw(canvas);
    }

    private void drawPointerOnMagnifierCanvas(Canvas canvas, PointF pointF, boolean isMoving) {
        this.drawPointerOnMagnifierCanvas(canvas, pointF);
        if (isMoving) {
            canvas.drawCircle(pointF.x, pointF.y, this.pointerRadius * this.pointerDrawRatio * 0.8f, this.movingPointerPaint);
        }
    }

    private PointF getCenterPointFromImage(ImageView circle) {
        float xPosition = circle.getX() + (float)(circle.getWidth() / 2);
        float yPosition = circle.getY() + (float)(circle.getHeight() / 2);
        return new PointF(xPosition, yPosition);
    }

    private PointF getCenterPointFromImage(ImageView circle, float scaling, PointF scalingPivot) {
        float xPosition = scalingPivot.x - scaling * (scalingPivot.x - (circle.getX() + (float)(circle.getWidth() / 2)));
        float yPosition = scalingPivot.y - scaling * (scalingPivot.y - (circle.getY() + (float)(circle.getHeight() / 2)));
        return new PointF(xPosition, yPosition);
    }

    protected void drawSelectionOnMagnifierCanvas(Canvas canvas) {
        PointF p1 = this.getCenterPointFromImage(this.pointer1, this.magnifierScale, this.zoomPosition);
        PointF p2 = this.getCenterPointFromImage(this.pointer2, this.magnifierScale, this.zoomPosition);
        PointF p3 = this.getCenterPointFromImage(this.pointer3, this.magnifierScale, this.zoomPosition);
        PointF p4 = this.getCenterPointFromImage(this.pointer4, this.magnifierScale, this.zoomPosition);
        this.drawPointerOnMagnifierCanvas(canvas, p1, this.movingView == this.pointer1);
        this.drawPointerOnMagnifierCanvas(canvas, p2, this.movingView == this.pointer2);
        this.drawPointerOnMagnifierCanvas(canvas, p3, this.movingView == this.pointer3);
        this.drawPointerOnMagnifierCanvas(canvas, p4, this.movingView == this.pointer4);
        this.drawPointerOnMagnifierCanvas(canvas, this.getCenterPointFromImage(this.midPointer13, this.magnifierScale, this.zoomPosition));
        this.drawPointerOnMagnifierCanvas(canvas, this.getCenterPointFromImage(this.midPointer24, this.magnifierScale, this.zoomPosition));
        this.drawPointerOnMagnifierCanvas(canvas, this.getCenterPointFromImage(this.midPointer34, this.magnifierScale, this.zoomPosition));
        this.drawPointerOnMagnifierCanvas(canvas, this.getCenterPointFromImage(this.midPointer12, this.magnifierScale, this.zoomPosition));
        canvas.drawLine(p1.x, p1.y, p3.x, p3.y, this.rectPaint);
        canvas.drawLine(p1.x, p1.y, p2.x, p2.y, this.rectPaint);
        canvas.drawLine(p2.x, p2.y, p4.x, p4.y, this.rectPaint);
        canvas.drawLine(p3.x, p3.y, p4.x, p4.y, this.rectPaint);
    }

    protected void drawSelectionOnBasicCanvas(Canvas canvas) {
        PointF p1center = this.getCenterPointFromImage(this.pointer1);
        PointF p2center = this.getCenterPointFromImage(this.pointer2);
        PointF p3center = this.getCenterPointFromImage(this.pointer3);
        PointF p4center = this.getCenterPointFromImage(this.pointer4);
        canvas.drawLine(p1center.x, p1center.y, p3center.x, p3center.y, this.rectPaint);
        canvas.drawLine(p1center.x, p1center.y, p2center.x, p2center.y, this.rectPaint);
        canvas.drawLine(p2center.x, p2center.y, p4center.x, p4center.y, this.rectPaint);
        canvas.drawLine(p3center.x, p3center.y, p4center.x, p4center.y, this.rectPaint);
        this.midPointer13.setX((this.pointer3.getX() + this.pointer1.getX()) / 2.0f);
        this.midPointer13.setY((this.pointer3.getY() + this.pointer1.getY()) / 2.0f);
        this.midPointer24.setX((this.pointer4.getX() + this.pointer2.getX()) / 2.0f);
        this.midPointer24.setY((this.pointer4.getY() + this.pointer2.getY()) / 2.0f);
        this.midPointer34.setX((this.pointer4.getX() + this.pointer3.getX()) / 2.0f);
        this.midPointer34.setY((this.pointer4.getY() + this.pointer3.getY()) / 2.0f);
        this.midPointer12.setX((this.pointer2.getX() + this.pointer1.getX()) / 2.0f);
        this.midPointer12.setY((this.pointer2.getY() + this.pointer1.getY()) / 2.0f);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        canvas.translate(0.0f, 0.0f);
        this.drawSelectionOnBasicCanvas(canvas);
        if (!this.isZooming || this.magnifierBitmap == null || this.magnifierShader == null) {
            return;
        }
        this.magnifierMatrix.reset();
        this.magnifierMatrix.postScale(this.magnifierScale, this.magnifierScale, this.zoomPosition.x, this.zoomPosition.y);
        this.magnifierPaint.getShader().setLocalMatrix(this.magnifierMatrix);
        float w = this.getWidth();
        if (this.magnifierLocatedLeft && this.zoomPosition.x > w * 0.6666667f) {
            this.magnifierLocatedLeft = false;
        } else if (!this.magnifierLocatedLeft && this.zoomPosition.x < w * 0.33333334f) {
            this.magnifierLocatedLeft = true;
        }
        float translateX = this.magnifierLocatedLeft ? -this.zoomPosition.x + (float)this.magnifierRadius : w - this.zoomPosition.x - (float)this.magnifierRadius;
        float h = this.getHeight();
        if (this.magnifierLocatedTop && this.zoomPosition.y < h * 0.33333334f) {
            this.magnifierLocatedTop = false;
        } else if (!this.magnifierLocatedTop && this.zoomPosition.y > h * 0.6666667f) {
            this.magnifierLocatedTop = true;
        }
        float translateY = this.magnifierLocatedTop ? -this.zoomPosition.y + (float)this.magnifierRadius : h - this.zoomPosition.y - (float)this.magnifierRadius;
        canvas.translate(translateX, translateY);
        canvas.drawCircle(this.zoomPosition.x, this.zoomPosition.y, (float)this.magnifierRadius, this.magnifierPaint);
        this.magnifierPath.reset();
        this.magnifierPath.addCircle(this.zoomPosition.x, this.zoomPosition.y, (float)this.magnifierRadius, Path.Direction.CCW);
        canvas.clipPath(this.magnifierPath, Region.Op.INTERSECT);
        this.drawSelectionOnMagnifierCanvas(canvas);
        int l = (int)(this.zoomPosition.x - (float)this.magnifierRadius);
        int t = (int)(this.zoomPosition.y - (float)this.magnifierRadius);
        int r = (int)(this.zoomPosition.x + (float)this.magnifierRadius);
        int b = (int)(this.zoomPosition.y + (float)this.magnifierRadius);
        this.magnifierCircleDrawable.setBounds(l, t, r, b);
        this.magnifierCircleDrawable.draw(canvas);
    }

    private ImageView getImageView(int x, int y) {
        ImageView imageView = new ImageView(this.context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setImageResource(R.drawable.cropping_pointer);
        imageView.setX((float)(x - 16));
        imageView.setY((float)(y - 16));
        imageView.setOnTouchListener((View.OnTouchListener)new TouchListenerImpl());
        return imageView;
    }

    public void setBoundaries() {
        this.minX = 0.0f;
        this.minY = 0.0f;
        this.maxX = this.getWidth();
        this.maxY = this.getHeight();
    }

    public void setBoundaries(RectF rectF) {
        this.minX = rectF.left;
        this.minY = rectF.top;
        this.maxX = rectF.right;
        this.maxY = rectF.bottom;
    }

    public RectF getBoundaries() {
        return new RectF(this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean onTouch(View v, MotionEvent event) {
        return false;
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        if (this.magnifierBitmap != null) {
            if (!this.magnifierBitmap.isRecycled()) {
                this.magnifierBitmap.recycle();
            }
            this.magnifierBitmap = null;
        }
        this.magnifierBitmap = bitmap;
        this.magnifierShader = new BitmapShader(this.magnifierBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.magnifierPaint.setShader((Shader)this.magnifierShader);
        this.magnifierPaint.setAntiAlias(true);
    }

    public boolean isPointsAlreadySet() {
        return this.isPointsAlreadySet;
    }

    private boolean isValidShape(Map<Integer, PointF> pointFMap) {
        return this.isConvex(pointFMap);
    }

    public boolean isValid() {
        return this.isValidRect;
    }

    private void updateSelectionColorAndListener() {
        this.isValidRect = this.isValidShape(this.getPoints());
        this.rectPaint.setColor(this.getResources().getColor(this.isValidRect ? R.color.croppingValidColor : R.color.croppingInvalidColor));
        this.pointer1.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.pointer2.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.pointer3.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.pointer4.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.midPointer12.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.midPointer34.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.midPointer24.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        this.midPointer13.setImageResource(this.isValidRect ? R.drawable.cropping_pointer : R.drawable.cropping_pointer_invalid);
        if (this.selectionListener != null) {
            this.selectionListener.onSelectionChanged();
        }
    }

    public static interface ISelectionListener {
        public void onSelectionChanged();

        public void onSelectionStarted();
    }

    private class MidPointTouchListenerImpl
    implements View.OnTouchListener {
        PointF DownPT = new PointF();
        PointF StartPT = new PointF();
        private ImageView mainPointer1;
        private ImageView mainPointer2;

        public MidPointTouchListenerImpl(ImageView mainPointer1, ImageView mainPointer2) {
            this.mainPointer1 = mainPointer1;
            this.mainPointer2 = mainPointer2;
        }

        public boolean onTouch(View v, MotionEvent event) {
            int eid = event.getAction();
            switch (eid) {
                case 2: {
                    PointF mv = new PointF(event.getX() - this.DownPT.x, event.getY() - this.DownPT.y);
                    this.mainPointer2.setY((float)((int)(this.mainPointer2.getY() + mv.y)));
                    this.mainPointer1.setY((float)((int)(this.mainPointer1.getY() + mv.y)));
                    v.setY((this.mainPointer2.getY() + this.mainPointer1.getY()) / 2.0f);
                    this.mainPointer2.setX((float)((int)(this.mainPointer2.getX() + mv.x)));
                    this.mainPointer1.setX((float)((int)(this.mainPointer1.getX() + mv.x)));
                    v.setX((this.mainPointer2.getX() + this.mainPointer1.getX()) / 2.0f);
                    break;
                }
                case 0: {
                    this.DownPT.x = event.getX();
                    this.DownPT.y = event.getY();
                    this.StartPT = new PointF(v.getX(), v.getY());
                    if (SelectionCroppingView.this.selectionListener == null) break;
                    SelectionCroppingView.this.selectionListener.onSelectionStarted();
                    break;
                }
                case 1: {
                    PointF location = new PointF(this.mainPointer1.getX() * 1.0f, this.mainPointer1.getY() * 1.0f);
                    SelectionCroppingView.this.movePointInsideBoundaries(location);
                    this.mainPointer1.setX(location.x);
                    this.mainPointer1.setY(location.y);
                    location = new PointF(this.mainPointer2.getX() * 1.0f, this.mainPointer2.getY() * 1.0f);
                    SelectionCroppingView.this.movePointInsideBoundaries(location);
                    this.mainPointer2.setX(location.x);
                    this.mainPointer2.setY(location.y);
                    SelectionCroppingView.this.isZooming = false;
                    SelectionCroppingView.this.invalidate();
                    SelectionCroppingView.this.updateSelectionColorAndListener();
                    break;
                }
            }
            SelectionCroppingView.this.isZooming = false;
            SelectionCroppingView.this.selectionCroppingView.invalidate();
            return true;
        }
    }

    private class TouchListenerImpl
    implements View.OnTouchListener {
        PointF DownPT = new PointF();
        PointF StartPT = new PointF();

        private TouchListenerImpl() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            int eid = event.getAction() & 0xFF;
            switch (eid) {
                case 2: {
                    PointF mv = new PointF(event.getX() - this.DownPT.x, event.getY() - this.DownPT.y);
                    v.setX((float)((int)(this.StartPT.x + mv.x)));
                    v.setY((float)((int)(this.StartPT.y + mv.y)));
                    this.StartPT = new PointF(v.getX(), v.getY());
                    SelectionCroppingView.this.isZooming = true;
                    break;
                }
                case 0: {
                    this.DownPT.x = event.getX();
                    this.DownPT.y = event.getY();
                    this.StartPT = new PointF(v.getX(), v.getY());
                    if (SelectionCroppingView.this.selectionListener != null) {
                        SelectionCroppingView.this.selectionListener.onSelectionStarted();
                    }
                    SelectionCroppingView.this.isZooming = true;
                    break;
                }
                case 1: 
                case 3: {
                    PointF location = new PointF(v.getX() * 1.0f, v.getY() * 1.0f);
                    SelectionCroppingView.this.movePointInsideBoundaries(location);
                    v.setX(location.x);
                    v.setY(location.y);
                    SelectionCroppingView.this.isZooming = false;
                    SelectionCroppingView.this.invalidate();
                    SelectionCroppingView.this.updateSelectionColorAndListener();
                    break;
                }
                default: {
                    SelectionCroppingView.this.isZooming = false;
                }
            }
            if (SelectionCroppingView.this.isZooming) {
                SelectionCroppingView.this.movingView = v;
                ((SelectionCroppingView)SelectionCroppingView.this).zoomPosition.x = v.getX() + SelectionCroppingView.this.pointerRadius;
                ((SelectionCroppingView)SelectionCroppingView.this).zoomPosition.y = v.getY() + SelectionCroppingView.this.pointerRadius;
            }
            SelectionCroppingView.this.selectionCroppingView.invalidate();
            return true;
        }
    }
}

