/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.topimagesystems.R;

public class OneUnitLeveler
extends ImageView {
    private boolean isValidOrintation = false;
    private Paint circlePaint;
    private Paint rectanglePaintContainer;
    private Paint rectanglePaintInner;
    private float levelerTrashold = 0.01389f;
    private float convertPixelsToAccelerometerValues;
    private RectF mainRectangle;
    private RectF validationRectangle;
    private Context context;
    private float xValue = 0.0f;
    private float yValue = 0.0f;
    private boolean isFadeAnimationEnable = false;
    private boolean isDraggingEnable = false;
    private int colorOrientationPassContainer;
    private int colorOrientationFailContainer;
    private int colorOrientationPassInner;
    private int colorOrientationFailInner;
    private int colorOrientationPassCircle;
    private int colorOrientationFailCircle;
    private int strokeWidthContainer = 7;
    private int strokeWidthInner = 7;

    public OneUnitLeveler(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
        this.colorOrientationPassContainer = -16711936;
        this.colorOrientationFailContainer = -65536;
        this.colorOrientationPassInner = -16711936;
        this.colorOrientationFailInner = -65536;
        this.colorOrientationPassCircle = -16711936;
        this.colorOrientationFailCircle = -65536;
        this.strokeWidthInner = this.strokeWidthContainer = oneLevelerData.getInteger(R.styleable.OneUnitsLeveler_levelerThickness, this.strokeWidthContainer);
        this.isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
        this.isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);
        oneLevelerData.recycle();
        this.init();
    }

    public OneUnitLeveler(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    public boolean isFadeAnimationEnable() {
        return this.isFadeAnimationEnable;
    }

    public boolean isDraggingEnable() {
        return this.isDraggingEnable;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.circlePaint = new Paint();
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setColor(this.colorOrientationFailCircle);
        this.rectanglePaintContainer = new Paint();
        this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
        this.rectanglePaintContainer.setStyle(Paint.Style.STROKE);
        this.rectanglePaintContainer.setStrokeWidth((float)this.strokeWidthContainer);
        this.rectanglePaintInner = new Paint();
        this.rectanglePaintInner.setColor(this.colorOrientationFailInner);
        this.rectanglePaintInner.setStyle(Paint.Style.STROKE);
        this.rectanglePaintInner.setStrokeWidth((float)this.strokeWidthInner);
    }

    public void showLeveler() {
        this.setVisibility(0);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mainRectangle == null || this.validationRectangle == null) {
            int imageWidth = this.getWidth();
            int imageHeight = this.getHeight();
            this.mainRectangle = new RectF((float)this.strokeWidthContainer, (float)this.strokeWidthContainer, (float)(imageWidth - this.strokeWidthContainer), (float)(imageHeight - this.strokeWidthContainer));
            this.validationRectangle = new RectF((float)(imageWidth / 5), (float)(imageHeight / 5), (float)(imageWidth * 4 / 5), (float)(imageHeight * 4 / 5));
        }
        if (this.isValidOrintation) {
            this.rectanglePaintContainer.setColor(this.colorOrientationPassContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationPassInner);
            this.circlePaint.setColor(this.colorOrientationPassCircle);
        } else {
            this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationFailInner);
            this.circlePaint.setColor(this.colorOrientationFailCircle);
        }
        canvas.drawRoundRect(this.mainRectangle, 20.0f, 20.0f, this.rectanglePaintContainer);
        canvas.drawRoundRect(this.validationRectangle, 20.0f, 20.0f, this.rectanglePaintInner);
        this.convertPixelsToAccelerometerValues = this.mainRectangle.bottom * this.levelerTrashold;
        float circleX = this.validationRectangle.height();
        float circleRadios = circleX / 4.0f;
        float circleXLocation = this.checkCircleSize(this.validationRectangle.centerX() + this.xValue * this.convertPixelsToAccelerometerValues, true, this.mainRectangle, circleRadios);
        float circleYLocation = this.checkCircleSize(this.validationRectangle.centerY() - this.yValue * this.convertPixelsToAccelerometerValues, false, this.mainRectangle, circleRadios);
        canvas.drawCircle(circleXLocation, circleYLocation, circleRadios, this.circlePaint);
    }

    private float checkCircleSize(float location, boolean isXVal, RectF mainRectangle, float radios) {
        float locationResult = location;
        if (location < mainRectangle.left + radios) {
            locationResult = 0.0f + radios;
        }
        if (location > mainRectangle.bottom - radios) {
            locationResult = mainRectangle.bottom - radios;
        }
        return locationResult;
    }

    public void updateLevelerLocation(float[] values, boolean _isValidOrientation, boolean isPortrait) {
        this.isValidOrintation = _isValidOrientation;
        this.yValue = values[2];
        this.xValue = values[1];
        if (isPortrait) {
            this.xValue = values[2];
            this.yValue = values[1];
        }
        this.invalidate();
    }
}

