/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit;

import com.topimagesystems.credit.CardType;
import com.topimagesystems.credit.StringHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;

class CreditCardNumber {
    CreditCardNumber() {
    }

    public static boolean passesLuhnChecksum(String number) {
        int even = 0;
        int sum = 0;
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 6;
        nArray2[4] = 8;
        nArray2[5] = 1;
        nArray2[6] = 3;
        nArray2[7] = 5;
        nArray2[8] = 7;
        nArray2[9] = 9;
        nArrayArray[1] = nArray2;
        int[][] sums = nArrayArray;
        StringCharacterIterator iter = new StringCharacterIterator(number);
        char c = iter.last();
        while (c != '\uffff') {
            if (!Character.isDigit(c)) {
                return false;
            }
            int cInt = c - 48;
            sum += sums[even++ & 1][cInt];
            c = iter.previous();
        }
        return sum % 10 == 0;
    }

    public static String formatString(String numStr) {
        return CreditCardNumber.formatString(numStr, true, null);
    }

    public static String formatString(String numStr, boolean filterDigits, CardType type) {
        String digits = filterDigits ? StringHelper.getDigitsOnlyString(numStr) : numStr;
        if (type == null) {
            type = CardType.fromCardNumber(digits);
        }
        int numLen = type.numberLength();
        if (digits.length() == numLen) {
            if (numLen == 16) {
                return CreditCardNumber.formatSixteenString(digits);
            }
            if (numLen == 15) {
                return CreditCardNumber.formatFifteenString(digits);
            }
        }
        return numStr;
    }

    private static String formatFifteenString(String digits) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 15) {
            if (i == 4 || i == 10) {
                sb.append(' ');
            }
            sb.append(digits.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static String formatSixteenString(String digits) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 16) {
            if (i != 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(digits.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isDateValid(int expiryMonth, int expiryYear) {
        if (expiryMonth < 1 || 12 < expiryMonth) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        int thisYear = now.get(1);
        int thisMonth = now.get(2) + 1;
        if (expiryYear < thisYear) {
            return false;
        }
        if (expiryYear == thisYear && expiryMonth < thisMonth) {
            return false;
        }
        return expiryYear <= thisYear + 15;
    }

    public static boolean isDateValid(String dateString) {
        String digitsOnly = StringHelper.getDigitsOnlyString(dateString);
        SimpleDateFormat validDate = CreditCardNumber.getDateFormatForLength(digitsOnly.length());
        if (validDate == null) {
            return false;
        }
        try {
            validDate.setLenient(false);
            Date enteredDate = validDate.parse(digitsOnly);
            return CreditCardNumber.isDateValid(enteredDate.getMonth() + 1, enteredDate.getYear() + 1900);
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static SimpleDateFormat getDateFormatForLength(int len) {
        if (len == 4) {
            return new SimpleDateFormat("MMyy");
        }
        if (len == 6) {
            return new SimpleDateFormat("MMyyyy");
        }
        return null;
    }

    public static Date getDateForString(String dateString) {
        String digitsOnly = StringHelper.getDigitsOnlyString(dateString);
        SimpleDateFormat validDate = CreditCardNumber.getDateFormatForLength(digitsOnly.length());
        if (validDate != null) {
            try {
                validDate.setLenient(false);
                Date date = validDate.parse(digitsOnly);
                return date;
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return null;
    }
}

