/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import com.topimagesystems.credit.CardType;
import com.topimagesystems.credit.CreditCardNumber;
import com.topimagesystems.credit.StringHelper;
import com.topimagesystems.credit.Validator;

class CardNumberValidator
implements Validator {
    private String numberString;
    static final int[] AMEX_SPACER = new int[]{4, 11};
    static final int[] NORMAL_SPACER = new int[]{4, 9, 14};
    private int spacerToDelete;

    public CardNumberValidator() {
    }

    public CardNumberValidator(String number) {
        this.numberString = number;
    }

    public void afterTextChanged(Editable source) {
        this.numberString = StringHelper.getDigitsOnlyString(source.toString());
        CardType type = CardType.fromCardNumber(this.numberString);
        if (this.spacerToDelete > 1) {
            int e = this.spacerToDelete;
            int s = this.spacerToDelete - 1;
            this.spacerToDelete = 0;
            if (e > s) {
                source.delete(s, e);
            }
        }
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (type.numberLength() == 15 && (i == 4 || i == 11) || (type.numberLength() == 16 || type.numberLength() == 14) && (i == 4 || i == 9 || i == 14)) {
                if (c != ' ') {
                    source.insert(i, (CharSequence)" ");
                }
            } else if (c == ' ') {
                source.delete(i, i + 1);
                --i;
            }
            ++i;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    @Override
    public boolean hasFullLength() {
        if (TextUtils.isEmpty((CharSequence)this.numberString)) {
            return false;
        }
        CardType type = CardType.fromCardNumber(this.numberString);
        return this.numberString.length() == type.numberLength();
    }

    @Override
    public boolean isValid() {
        if (!this.hasFullLength()) {
            return false;
        }
        return CreditCardNumber.passesLuhnChecksum(this.numberString);
    }

    @Override
    public String getValue() {
        return this.numberString;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        String updated = new SpannableStringBuilder((CharSequence)dest).replace(dstart, dend, source, start, end).toString();
        String updatedDigits = StringHelper.getDigitsOnlyString(updated);
        CardType type = CardType.fromCardNumber(updatedDigits);
        int maxLength = type.numberLength();
        if (updatedDigits.length() > maxLength) {
            return "";
        }
        SpannableStringBuilder result = new SpannableStringBuilder(source);
        int[] spacers = maxLength == 15 ? AMEX_SPACER : NORMAL_SPACER;
        int replen = dend - dstart;
        int i = 0;
        while (i < spacers.length) {
            int loc;
            if (source.length() == 0 && dstart == spacers[i] && dest.charAt(dstart) == ' ') {
                this.spacerToDelete = spacers[i];
            }
            if (dstart - replen <= spacers[i] && dstart + end - replen >= spacers[i] && ((loc = spacers[i] - dstart) == end || loc >= 0 && loc < end && result.charAt(loc) != ' ')) {
                result.insert(loc, (CharSequence)" ");
                ++end;
            }
            ++i;
        }
        return result;
    }
}

