/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.controllers.imageanalyze.PreviewCallback;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class RawImagesFlowManager {
    public static final int NONE = -1;
    public static final int SAVE_MODE = 0;
    public static final int LOAD_MODE = 1;
    private static final String logTag = "**Automation**";
    private static final boolean debugImages = false;
    private static String originalImagesPath = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + "qa_session";
    static RawImagesFlowManager _instance;
    private int processMode = -1;
    private File originalImagesDir = null;
    private File debugDir = null;
    private CameraController cameraControllerActivity;
    private Context context;
    private int totalNumberOfImages = 0;
    private int loadingCounter = 0;
    private File[] originalSessionImages;
    private TextView imageProcessTextView;
    private TextView imageCounterTextView;
    private ProgressBar progressBarView;
    private boolean waitingForStillImage = false;
    private LoadStateHandlerThread loadStateHandlerThread = new LoadStateHandlerThread();

    private RawImagesFlowManager() {
    }

    public static boolean isActive() {
        return _instance != null;
    }

    static boolean isSaveMode() {
        return _instance != null && RawImagesFlowManager._instance.processMode == 0;
    }

    static boolean isLoadMode() {
        return _instance != null && RawImagesFlowManager._instance.processMode == 1;
    }

    public static synchronized void handleLog(String tag, String text) {
        if (RawImagesFlowManager.isLoadMode() || RawImagesFlowManager.isSaveMode()) {
            if (text == null) {
                return;
            }
            FileUtils.addToLogFile(tag, text, RawImagesFlowManager._instance.context, String.valueOf(RawImagesFlowManager._instance.originalImagesDir.getAbsolutePath()) + File.separator + (RawImagesFlowManager.isLoadMode() ? "load_" : "save_") + "log.txt");
        }
    }

    public static void handleAlertLog(String title, String message) {
        RawImagesFlowManager.handleLog("Alert Message", "\nTitle:" + title + "\nMessage:" + message);
    }

    protected static void handleDebugMat(Mat mat) {
    }

    public static synchronized void init(final int processMode, final String directoryPath, final Context context) {
        if (processMode == -1) {
            if (_instance != null) {
                if (RawImagesFlowManager._instance.loadStateHandlerThread != null && RawImagesFlowManager._instance.loadStateHandlerThread.isAlive()) {
                    RawImagesFlowManager._instance.loadStateHandlerThread.quit();
                    RawImagesFlowManager._instance.loadStateHandlerThread = null;
                }
                _instance = null;
            }
            return;
        }
        if (_instance == null) {
            _instance = new RawImagesFlowManager();
        }
        RawImagesFlowManager._instance.context = context;
        RawImagesFlowManager.handleLog(logTag, "init with process mode:" + (processMode == 0 ? "Save" : "Load"));
        RawImagesFlowManager._instance.processMode = processMode;
        RawImagesFlowManager._instance.totalNumberOfImages = 0;
        RawImagesFlowManager._instance.loadingCounter = 0;
        if (processMode == 0 || processMode == 1) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    _instance.ensureFileSystemDirectories(processMode, directoryPath == null ? originalImagesPath : directoryPath, context);
                }
            };
            thread.start();
        }
    }

    private synchronized void ensureFileSystemDirectories(int processMode, String directoryPath, Context context) {
        File loadLog;
        this.originalImagesDir = new File(directoryPath);
        if (!this.originalImagesDir.exists()) {
            this.originalImagesDir.mkdirs();
        }
        this.debugDir = new File(String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + ".debugmobiflow");
        if (processMode == 0) {
            FileUtils.clearFiles(context, this.originalImagesDir.getAbsolutePath());
        } else if (processMode == 1 && (loadLog = new File(String.valueOf(this.originalImagesDir.getAbsolutePath()) + File.separator + "load_log.txt")).exists()) {
            loadLog.delete();
            Logger.i(logTag, "deleting -> " + this.originalImagesDir.getAbsolutePath() + File.separator + "load_log.txt");
        }
    }

    synchronized void handleSave(Mat originalMat) {
        this.handleSave(originalMat, false);
    }

    synchronized void handleSave(Mat originalMat, boolean isStillsImage) {
        if (this.originalImagesDir == null || !this.originalImagesDir.exists()) {
            return;
        }
        if (isStillsImage && !CameraManagerController.isStillMode) {
            return;
        }
        Mat rgbaMatOut = new Mat();
        if (isStillsImage && CameraManagerController.imageType != CaptureIntent.TISDocumentType.FULL_PAGE && CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT) {
            Imgproc.cvtColor((Mat)originalMat, (Mat)rgbaMatOut, (int)2, (int)0);
        } else {
            rgbaMatOut = originalMat;
        }
        ++this.totalNumberOfImages;
        String filePath = null;
        boolean saveSuccess = false;
        if (isStillsImage) {
            filePath = String.valueOf(this.originalImagesDir.getAbsolutePath()) + File.separator + StringUtils.getNumberWithLeadingZeros(this.totalNumberOfImages, 5) + "_stills.jpeg";
            saveSuccess = Imgcodecs.imwrite((String)filePath, (Mat)rgbaMatOut);
        } else {
            filePath = String.valueOf(this.originalImagesDir.getAbsolutePath()) + File.separator + StringUtils.getNumberWithLeadingZeros(this.totalNumberOfImages, 5) + ".png";
            MatOfInt mPngCompressionRate = new MatOfInt(new int[]{16, 0});
            saveSuccess = Imgcodecs.imwrite((String)filePath, (Mat)rgbaMatOut, (MatOfInt)mPngCompressionRate);
        }
        if (!saveSuccess) {
            --this.totalNumberOfImages;
        } else {
            RawImagesFlowManager.handleLog(logTag, "image saved in path:" + filePath);
        }
    }

    void startLoadImagesFlow(CameraController cameraController) {
        this.cameraControllerActivity = cameraController;
        if (this.originalImagesDir == null || !this.originalImagesDir.exists() || !this.originalImagesDir.isDirectory()) {
            Toast.makeText((Context)this.cameraControllerActivity, (CharSequence)"Images directory not found", (int)1).show();
            RawImagesFlowManager.handleLog(logTag, "Images directory not found");
            this.stopRunning();
            return;
        }
        this.imageProcessTextView = (TextView)this.cameraControllerActivity.findViewById(R.id.ImageNumberTitle);
        this.imageCounterTextView = (TextView)this.cameraControllerActivity.findViewById(R.id.ImageNumberCounter);
        this.progressBarView = (ProgressBar)this.cameraControllerActivity.findViewById(R.id.progress_bar);
        if (this.cameraControllerActivity.getHandler() == null) {
            this.cameraControllerActivity.handler = CameraManagerController.isDynamicCapture ? new DynamicCaptureCameraController.DynamicCameraActivityHandler(DynamicCaptureCameraController.getInstance(), true) : new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
            CameraController.getInstance().mobiCHECKOCR.setHandler(this.cameraControllerActivity.handler);
        }
        if (this.loadStateHandlerThread == null) {
            this.loadStateHandlerThread = new LoadStateHandlerThread();
        } else {
            this.loadStateHandlerThread.cleanQueue();
        }
        this.loadStateHandlerThread.start();
        File[] files = this.originalImagesDir.listFiles();
        this.sortFileArrayByName(files);
        ArrayList<File> imageFiles = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.endsWith(".png") || fileName.endsWith(".jpeg")) {
                imageFiles.add(file);
            }
            ++n2;
        }
        this.originalSessionImages = imageFiles.toArray(new File[imageFiles.size()]);
        this.sortFileArrayByName(this.originalSessionImages);
        this.updateProgressView();
        RawImagesFlowManager.handleLog(logTag, "starting load images flow with " + this.originalSessionImages.length + " images");
    }

    private boolean isStillImage(File file) {
        return file.getName().endsWith("_stills.jpeg");
    }

    private void sortFileArrayByName(File[] files) {
        if (files != null && files.length > 1) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    return lhs.getName().compareToIgnoreCase(rhs.getName());
                }
            });
        }
    }

    boolean hasMoreVideoFrames() {
        return this.originalSessionImages != null && this.loadingCounter < this.originalSessionImages.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void loadNextImage() {
        if (this.originalSessionImages != null && this.loadingCounter < this.originalSessionImages.length) {
            if (!this.isStillImage(this.originalSessionImages[this.loadingCounter])) {
                this.loadStateHandlerThread.processVideoImage(this.originalSessionImages[this.loadingCounter]);
                return;
            }
            if (this.waitingForStillImage) {
                this.loadNextStillImage();
                return;
            }
            RawImagesFlowManager.handleLog(logTag, "No more video images to load before the next Still image.... finishing..");
            this.stopRunning();
            return;
        }
        if (this.loadingCounter < this.originalSessionImages.length) return;
        if (CameraController.getInstance().cameraSessionManager.getState() == CameraSessionManager.State.CAPTURING_IMAGE) return;
        RawImagesFlowManager.handleLog(logTag, "No more images to load.... finishing..");
        this.stopRunning();
    }

    private void stopRunning() {
        if (this.loadStateHandlerThread != null) {
            this.loadStateHandlerThread.quit();
        }
        if (this.cameraControllerActivity != null && !this.cameraControllerActivity.isFinishing()) {
            this.cameraControllerActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RawImagesFlowManager.this.cameraControllerActivity.setResult(0);
                    RawImagesFlowManager.this.cameraControllerActivity.finish();
                }
            });
        }
    }

    protected synchronized void waitForStillImage() {
        this.waitingForStillImage = true;
        this.loadNextImage();
    }

    private synchronized void loadNextStillImage() {
        if (this.originalSessionImages != null && this.loadingCounter < this.originalSessionImages.length && this.isStillImage(this.originalSessionImages[this.loadingCounter]) && this.waitingForStillImage && CameraController.getInstance().cameraSessionManager.getState() != CameraSessionManager.State.CAPTURING_IMAGE) {
            this.waitingForStillImage = false;
            CameraController.getInstance().cameraSessionManager.setState(CameraSessionManager.State.CAPTURING_IMAGE);
            this.loadStateHandlerThread.processStillImage(this.originalSessionImages[this.loadingCounter]);
        }
    }

    private void updateProgressView() {
        if (this.cameraControllerActivity != null && !this.cameraControllerActivity.isFinishing()) {
            this.cameraControllerActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RawImagesFlowManager.this.progressBarView.setMax(RawImagesFlowManager.this.originalSessionImages.length);
                    RawImagesFlowManager.this.imageProcessTextView.setText((CharSequence)"processing image");
                    RawImagesFlowManager.this.imageCounterTextView.setText((CharSequence)String.format("%s/%s", RawImagesFlowManager.this.loadingCounter, RawImagesFlowManager.this.originalSessionImages.length));
                    RawImagesFlowManager.this.progressBarView.setProgress(RawImagesFlowManager.this.loadingCounter);
                }
            });
        }
    }

    static /* synthetic */ void access$1(RawImagesFlowManager rawImagesFlowManager, int n) {
        rawImagesFlowManager.loadingCounter = n;
    }

    static /* synthetic */ void access$2(RawImagesFlowManager rawImagesFlowManager) {
        rawImagesFlowManager.updateProgressView();
    }

    static /* synthetic */ void access$3(RawImagesFlowManager rawImagesFlowManager) {
        rawImagesFlowManager.stopRunning();
    }

    public class LoadStateHandlerThread
    extends HandlerThread {
        private Handler mHandler;

        public LoadStateHandlerThread() {
            super("LoadStateHandlerThread", 10);
        }

        protected void onLooperPrepared() {
            super.onLooperPrepared();
            this.mHandler = new Handler(this.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public void handleMessage(Message msg) {
                    if (CameraController.getInstance() == null || CameraController.getInstance().getHandler() == null) {
                        LoadStateHandlerThread.this.cleanQueue();
                        return;
                    }
                    switch (msg.what) {
                        case 1: {
                            if (CameraSessionManager.getInstance().previewCallback == null) {
                                LoadStateHandlerThread.this.cleanQueue();
                                return;
                            }
                            file = (File)msg.obj;
                            filePath = file.getAbsolutePath();
                            RawImagesFlowManager.handleLog("**Automation**", "loading image file:" + filePath);
                            bmp = BitmapFactory.decodeFile((String)filePath);
                            bgrMat = Imgcodecs.imread((String)filePath);
                            rgbaMatOut = new Mat();
                            Imgproc.cvtColor((Mat)bgrMat, (Mat)rgbaMatOut, (int)2, (int)0);
                            var7_9 = RawImagesFlowManager._instance;
                            synchronized (var7_9) {
                                v0 = LoadStateHandlerThread.access$0(LoadStateHandlerThread.this);
                                RawImagesFlowManager.access$1(v0, RawImagesFlowManager.access$0(v0) + 1);
                            }
                            CameraSessionManager.getInstance().previewCallback.processFrame(null, null, bgrMat.width(), bgrMat.height(), rgbaMatOut);
                            RawImagesFlowManager.access$2(LoadStateHandlerThread.access$0(LoadStateHandlerThread.this));
                            break;
                        }
                        case 2: {
                            file = (File)msg.obj;
                            filePath = file.getAbsolutePath();
                            data = null;
                            fis = null;
                            errorOccur = false;
                            try {
                                fis = new FileInputStream(filePath);
                                data = new byte[fis.available()];
                                while (fis.read(data) > -1) {
                                }
                                fis.close();
                            }
                            catch (FileNotFoundException e) {
                                errorOccur = true;
                                RawImagesFlowManager.handleLog("**Automation**", "File not found: " + e.getMessage());
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (IOException e) {
                                        Logger.e("**Automation**", "Error closing a stream: " + e.getMessage());
                                        errorOccur = true;
                                    }
                                }
                                ** GOTO lbl75
                            }
                            catch (IOException e) {
                                try {
                                    RawImagesFlowManager.handleLog("**Automation**", "Error accessing file: " + e.getMessage());
                                    errorOccur = true;
                                    ** GOTO lbl75
                                }
                                catch (Throwable var11_22) {
                                    throw var11_22;
                                }
                                finally {
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (IOException e) {
                                            Logger.e("**Automation**", "Error closing a stream: " + e.getMessage());
                                            errorOccur = true;
                                        }
                                    }
                                }
                            }
                            if (fis == null) ** GOTO lbl75
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                Logger.e("**Automation**", "Error closing a stream: " + e.getMessage());
                                errorOccur = true;
                            }
lbl75:
                            // 6 sources

                            if (errorOccur) {
                                RawImagesFlowManager.access$3(LoadStateHandlerThread.access$0(LoadStateHandlerThread.this));
                                return;
                            }
                            v2 = isFront = CameraManagerController.getOcrAnalyzeSession((Context)RawImagesFlowManager.access$4((RawImagesFlowManager)LoadStateHandlerThread.access$0((LoadStateHandlerThread)LoadStateHandlerThread.this))).captureMode == CameraTypes.CaptureMode.FRONT;
                            if (isFront) {
                                SessionResultParams.originalFront = data;
                            } else {
                                SessionResultParams.originalBack = data;
                            }
                            RawImagesFlowManager.handleLog("**Automation**", "loading still image:" + filePath);
                            cameraResolution = CameraConfigurationManager.cameraCaptureResolution;
                            message = CameraController.getInstance().getHandler().obtainMessage(8);
                            message.obj = PreviewCallback.getImagePath(isFront);
                            message.arg1 = cameraResolution.x;
                            message.arg2 = cameraResolution.y;
                            message.sendToTarget();
                            var13_24 = RawImagesFlowManager._instance;
                            synchronized (var13_24) {
                                v3 = LoadStateHandlerThread.access$0(LoadStateHandlerThread.this);
                                RawImagesFlowManager.access$1(v3, RawImagesFlowManager.access$0(v3) + 1);
                            }
                            RawImagesFlowManager.access$2(LoadStateHandlerThread.access$0(LoadStateHandlerThread.this));
                        }
                    }
                }
            };
        }

        protected void processVideoImage(File imageFile) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = imageFile;
            this.mHandler.sendMessage(msg);
        }

        protected void processStillImage(File imageFile) {
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = imageFile;
            this.mHandler.sendMessage(msg);
        }

        protected void cleanQueue() {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }

        static /* synthetic */ RawImagesFlowManager access$0(LoadStateHandlerThread loadStateHandlerThread) {
            return loadStateHandlerThread.RawImagesFlowManager.this;
        }
    }
}

