/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.cropping;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.ui.SelectionCroppingView;
import com.topimagesystems.ui.TouchImageView;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencv.android.Utils;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

@TargetApi(value=11)
public class ManualCroppingController
extends Fragment {
    public static final String EXTRA_IS_FRONT = "com.topimagesystems.controllers.manualcapture.isFront";
    public static final int ORIENTATION_LANDSCAPE = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_SESSION = 2;
    private Bitmap originalBitmap;
    private ImageView originalImageView;
    private ImageView backgroundImageView;
    private Bitmap[] scaledBitmaps = new Bitmap[4];
    private SelectionCroppingView selectionPolygonView;
    private GenericBoundingBoxResult originalBoundingBoxResult;
    private GenericBoundingBoxResult currentBoundingBoxResult;
    private FrameLayout imageFrameLayout;
    private ImageButton backBtn;
    private ImageButton rotateCWBtn;
    private ImageButton rotateCCWBtn;
    private ImageButton expandBtn;
    private ImageButton magnetBtn;
    private ImageButton confirmBtn;
    private ProgressBar spinner;
    private int rotateState = 0;
    SelectionCroppingView.ISelectionListener selectionListener;
    FrameLayout confirmLayout;
    private TranslateAnimation translateAnimation;
    private boolean shouldScaleWhileRotate = true;
    private boolean isInConfirmState = false;
    private int toDegrees;
    private CameraController activity;
    private Fragment fragment;
    private View fragmentView;
    private boolean isCurrentlyStarting;
    String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean hasOriginalBoundingBox = true;
    private final int[][] pointIndexForRotation;

    public ManualCroppingController() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = 3;
        nArray2[3] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 3;
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 2;
        nArray4[2] = 3;
        nArray4[3] = 1;
        nArrayArray[3] = nArray4;
        this.pointIndexForRotation = nArrayArray;
        this.isCurrentlyStarting = true;
    }

    public void onStart() {
        super.onStart();
        this.isCurrentlyStarting = false;
    }

    public synchronized boolean isStarting() {
        return this.isCurrentlyStarting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.fragment = this;
        this.activity = (CameraController)this.getActivity();
        this.fragmentView = inflater.inflate(R.layout.manual_cropping_layout, container, false);
        this.originalImageView = (ImageView)this.fragmentView.findViewById(R.id.originalImageView);
        this.backgroundImageView = (ImageView)this.fragmentView.findViewById(R.id.backgroundImageView);
        this.selectionPolygonView = (SelectionCroppingView)this.fragmentView.findViewById(R.id.selectionPolygonView);
        ManualCroppingController manualCroppingController = this;
        synchronized (manualCroppingController) {
            try {
                this.originalBitmap = this.getImageFromBundle();
            }
            catch (Exception e) {
                AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).setTitle((CharSequence)"Error").setMessage((CharSequence)e.getMessage()).setCancelable(false).setPositiveButton((CharSequence)StringUtils.dynamicString(this.activity.getBaseContext(), "TISFlowOK"), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ManualCroppingController.this.getActivity().getFragmentManager().beginTransaction().remove(ManualCroppingController.this.fragment).commit();
                    }
                }).create();
                alertDialog.show();
                return this.fragmentView;
            }
            this.imageFrameLayout = (FrameLayout)this.fragmentView.findViewById(R.id.imageFrameLayout);
            this.originalImageView.post(new Runnable(){

                @Override
                public void run() {
                    if (ManualCroppingController.this.originalBitmap != null) {
                        if (!ManualCroppingController.this.hasOriginalBoundingBox) {
                            ManualCroppingController.this.setBoundingBoxIfRectNotFound();
                        }
                        ((ManualCroppingController)ManualCroppingController.this).scaledBitmaps[0] = ManualCroppingController.this.scaledBitmap(ManualCroppingController.this.originalBitmap, ManualCroppingController.this.originalImageView.getWidth(), ManualCroppingController.this.originalImageView.getHeight());
                        ManualCroppingController.this.initViews();
                    }
                }
            });
        }
        this.backBtn = (ImageButton)this.fragmentView.findViewById(R.id.cancelImageBtn);
        this.backBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doBack(v);
            }
        });
        this.rotateCWBtn = (ImageButton)this.fragmentView.findViewById(R.id.rotateImageBtn);
        this.rotateCWBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doRotate(v);
            }
        });
        this.rotateCCWBtn = (ImageButton)this.fragmentView.findViewById(R.id.rotateRevImageBtn);
        this.rotateCCWBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doRotate(v);
            }
        });
        this.expandBtn = (ImageButton)this.fragmentView.findViewById(R.id.expandImageBtn);
        this.expandBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doExpand(v);
            }
        });
        this.expandBtn.setEnabled(this.hasOriginalBoundingBox);
        this.magnetBtn = (ImageButton)this.fragmentView.findViewById(R.id.magnetImageBtn);
        this.magnetBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doMagnet(v);
            }
        });
        this.confirmBtn = (ImageButton)this.fragmentView.findViewById(R.id.confirmImageBtn);
        this.confirmBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ManualCroppingController.this.doConfirm(v);
            }
        });
        this.selectionListener = new SelectionCroppingView.ISelectionListener(){

            @Override
            public void onSelectionChanged() {
                if (ManualCroppingController.this.isCurrentlyStarting) {
                    return;
                }
                ManualCroppingController.this.enableAllButtons();
                Map currentPoints = ManualCroppingController.this.orderedValidEdgePoints(ManualCroppingController.this.selectionPolygonView.getBoundaries(), ManualCroppingController.this.selectionPolygonView.getPointsInsideBounds());
                if (ManualCroppingController.this.hasOriginalBoundingBox) {
                    Map magnetPoints = ManualCroppingController.this.getOriginalEdgePoints(ManualCroppingController.this.selectionPolygonView.getBoundaries());
                    if (!ManualCroppingController.this.isMapPointsEqual(magnetPoints, currentPoints)) {
                        ManualCroppingController.this.magnetBtn.setVisibility(0);
                        ManualCroppingController.this.expandBtn.setVisibility(8);
                    } else {
                        ManualCroppingController.this.magnetBtn.setVisibility(8);
                        ManualCroppingController.this.expandBtn.setVisibility(0);
                    }
                } else {
                    Map edgePoints = ManualCroppingController.this.getOutlinePoints(ManualCroppingController.this.selectionPolygonView.getBoundaries());
                    ManualCroppingController.this.expandBtn.setEnabled(!ManualCroppingController.this.isMapPointsEqual(edgePoints, currentPoints));
                }
                ManualCroppingController.this.confirmBtn.setEnabled(ManualCroppingController.this.selectionPolygonView.isValid());
            }

            @Override
            public void onSelectionStarted() {
                ManualCroppingController.this.disableAllButtons();
            }
        };
        this.selectionPolygonView.setSelectionListener(this.selectionListener);
        this.confirmLayout = (FrameLayout)this.fragmentView.findViewById(R.id.confirmLayout);
        FrameLayout.LayoutParams confirmLayoutParams = (FrameLayout.LayoutParams)this.confirmLayout.getLayoutParams();
        confirmLayoutParams.leftMargin = 10000;
        this.confirmLayout.setLayoutParams((ViewGroup.LayoutParams)confirmLayoutParams);
        this.spinner = (ProgressBar)this.fragmentView.findViewById(R.id.mc_progress_bar);
        this.spinner.setVisibility(8);
        return this.fragmentView;
    }

    private void disableAllButtons() {
        this.backBtn.setEnabled(false);
        this.rotateCWBtn.setEnabled(false);
        this.rotateCCWBtn.setEnabled(false);
        this.expandBtn.setEnabled(false);
        this.magnetBtn.setEnabled(false);
        this.confirmBtn.setEnabled(false);
    }

    private void enableAllButtons() {
        this.backBtn.setEnabled(true);
        this.rotateCWBtn.setEnabled(true);
        this.rotateCCWBtn.setEnabled(true);
        this.expandBtn.setEnabled(true);
        this.magnetBtn.setEnabled(true);
        this.confirmBtn.setEnabled(true);
    }

    public void onDetach() {
        if (this.originalBitmap != null && !this.originalBitmap.isRecycled()) {
            this.originalBitmap.recycle();
            this.originalBitmap = null;
        }
        int i = 0;
        while (i < this.scaledBitmaps.length) {
            if (this.scaledBitmaps[i] != null && !this.scaledBitmaps[i].isRecycled()) {
                this.scaledBitmaps[i].recycle();
            }
            this.scaledBitmaps[i] = null;
            ++i;
        }
        this.scaledBitmaps = null;
        this.selectionListener = null;
        if (this.translateAnimation != null) {
            this.translateAnimation.setAnimationListener(null);
            this.translateAnimation = null;
        }
        super.onDetach();
    }

    public void onBackPressed() {
        if (this.isInConfirmState) {
            this.translateAnimation = new TranslateAnimation(1, 0.0f, 1, -1.0f, 0, 0.0f, 0, 0.0f);
            this.translateAnimation.setDuration(500L);
            this.translateAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ManualCroppingController.this.translateAnimation.setAnimationListener(null);
                    FrameLayout.LayoutParams confirmLayoutParams = (FrameLayout.LayoutParams)ManualCroppingController.this.confirmLayout.getLayoutParams();
                    confirmLayoutParams.leftMargin = 10000;
                    ManualCroppingController.this.confirmLayout.setLayoutParams((ViewGroup.LayoutParams)confirmLayoutParams);
                    ManualCroppingController.this.enableAllButtons();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.confirmLayout.startAnimation((Animation)this.translateAnimation);
            this.isInConfirmState = false;
        } else if (this.activity != null && this.activity.getHandler() != null) {
            Message message = this.activity.getHandler().obtainMessage(28);
            message.obj = false;
            message.sendToTarget();
        } else {
            try {
                this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
            }
            catch (Exception e) {
                Logger.e(((Object)((Object)this)).getClass().getSimpleName(), e.toString());
            }
        }
    }

    public void doBack(View v) {
        this.onBackPressed();
    }

    public void doExpand(View v) {
        if (this.selectionPolygonView == null || this.selectionPolygonView.getBoundaries() == null) {
            return;
        }
        Map<Integer, PointF> orderedPoints = this.getOutlinePoints(this.selectionPolygonView.getBoundaries());
        this.selectionPolygonView.setPoints(orderedPoints);
        if (this.hasOriginalBoundingBox) {
            this.expandBtn.setVisibility(8);
            this.magnetBtn.setVisibility(0);
        } else {
            this.expandBtn.setEnabled(false);
        }
    }

    public void doMagnet(View v) {
        if (this.selectionPolygonView == null || this.selectionPolygonView.getBoundaries() == null || this.originalBoundingBoxResult == null) {
            return;
        }
        Map<Integer, PointF> orderedPoints = this.getOriginalEdgePoints(this.selectionPolygonView.getBoundaries());
        this.selectionPolygonView.setPoints(orderedPoints);
        this.magnetBtn.setVisibility(8);
        this.expandBtn.setVisibility(0);
    }

    public void doConfirm(View v) {
        this.disableAllButtons();
        if (this.isInConfirmState) {
            this.spinner.setVisibility(0);
            float[] coordinates = new float[8];
            UserInterfaceUtils.fillPointsArrayFromBoundingBox(coordinates, this.currentBoundingBoxResult);
            CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setCroppingCoordinates(coordinates);
            CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setStillsBoundingBox(this.currentBoundingBoxResult.getRect());
            if (this.activity != null && this.activity.getHandler() != null) {
                CameraController.CameraActivityHandler handler = this.activity.getHandler();
                Message message = handler.obtainMessage(8);
                String filePath = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).captureMode == CameraTypes.CaptureMode.FRONT ? CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getFrontImagePath() : CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getBackImagePath();
                message.obj = filePath;
                message.arg1 = CameraConfigurationManager.videoResolutionWidth;
                message.arg2 = CameraConfigurationManager.videoResolutionHeight;
                message.sendToTarget();
            }
            return;
        }
        new CropImageAndDisplay().execute(new Void[0]);
    }

    public void doRotate(View v) {
        this.fragmentView.findViewById(R.id.rotateImageBtn).setEnabled(false);
        this.fragmentView.findViewById(R.id.rotateRevImageBtn).setEnabled(false);
        this.calculateCurrentBoundingBox(false);
        boolean clockwise = v.getTag().toString().equals("clock");
        if (clockwise) {
            ++this.rotateState;
        } else {
            if (this.rotateState == 0) {
                this.rotateState = 4;
            }
            --this.rotateState;
        }
        this.toDegrees = this.rotateState * 90;
        this.originalImageView.setVisibility(4);
        this.rotateBitmap();
        this.rotateState %= 4;
        this.shouldScaleWhileRotate = !this.shouldScaleWhileRotate;
    }

    private void rotateBitmap() {
        if (this.scaledBitmaps[this.toDegrees / 90 % 4] == null) {
            Mat mat = new Mat();
            Utils.bitmapToMat((Bitmap)this.scaledBitmaps[0], (Mat)mat);
            mat = FileUtils.rotateMatInAngle(mat, this.toDegrees);
            this.scaledBitmaps[this.toDegrees / 90 % 4] = Bitmap.createBitmap((int)mat.cols(), (int)mat.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap((Mat)mat, (Bitmap)this.scaledBitmaps[this.toDegrees / 90 % 4]);
        }
        this.originalImageView.setImageBitmap(this.scaledBitmaps[this.toDegrees / 90 % 4]);
        this.originalImageView.post(new Runnable(){

            @Override
            public void run() {
                ManualCroppingController.this.resizeImageViewAndSelection();
                ManualCroppingController.this.originalImageView.setVisibility(0);
                ManualCroppingController.this.updateSelectionBitmap();
                ManualCroppingController.this.updateBackgroundView();
                ManualCroppingController.this.fragmentView.findViewById(R.id.rotateRevImageBtn).setEnabled(true);
                ManualCroppingController.this.fragmentView.findViewById(R.id.rotateImageBtn).setEnabled(true);
            }
        });
    }

    private void updateSelectionBitmap() {
        this.imageFrameLayout.buildDrawingCache();
        Bitmap magnifierBitmap = this.imageFrameLayout.getDrawingCache();
        this.selectionPolygonView.setBitmap(Bitmap.createBitmap((Bitmap)magnifierBitmap));
    }

    private void updateBackgroundView() {
        this.backgroundImageView.setDrawingCacheEnabled(false);
        this.backgroundImageView.setImageMatrix(this.originalImageView.getImageMatrix());
        this.backgroundImageView.invalidate();
        this.backgroundImageView.setImageDrawable(null);
        this.backgroundImageView.setImageBitmap(this.scaledBitmaps[this.rotateState % 4]);
    }

    private void initViews() {
        this.originalImageView.setImageBitmap(this.scaledBitmaps[0]);
        this.selectionPolygonView.setVisibility(0);
        this.originalImageView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 17) {
                    ManualCroppingController.this.originalImageView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    ManualCroppingController.this.originalImageView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                ManualCroppingController.this.resizeImageViewAndSelection();
                ManualCroppingController.this.updateSelectionBitmap();
                ManualCroppingController.this.updateBackgroundView();
            }
        });
    }

    private void resizeImageViewAndSelection() {
        int measuredWidth = this.originalImageView.getMeasuredWidth();
        int measuredHeight = this.originalImageView.getMeasuredHeight();
        Drawable drawable2 = this.originalImageView.getDrawable();
        RectF rectDrawable = new RectF(drawable2.getBounds());
        float leftOffset = ((float)measuredWidth - rectDrawable.width()) / 2.0f;
        float topOffset = ((float)measuredHeight - rectDrawable.height()) / 2.0f;
        Matrix matrix = new Matrix();
        float scale = 1.0f;
        if (leftOffset < 0.0f) {
            scale = 1.0f * (float)measuredWidth / rectDrawable.width();
        } else if (topOffset < 0.0f) {
            scale = 1.0f * (float)measuredHeight / rectDrawable.height();
        }
        if ((double)scale != 1.0) {
            rectDrawable = new RectF(0.0f, 0.0f, rectDrawable.width() * scale, rectDrawable.height() * scale);
            leftOffset = ((float)measuredWidth - rectDrawable.width()) / 2.0f;
            topOffset = ((float)measuredHeight - rectDrawable.height()) / 2.0f;
        }
        matrix.postTranslate(leftOffset, topOffset);
        matrix.postScale(scale, scale, leftOffset, topOffset);
        this.originalImageView.setImageMatrix(matrix);
        this.originalImageView.invalidate();
        this.originalImageView.setImageDrawable(null);
        this.originalImageView.setImageBitmap(this.scaledBitmaps[this.rotateState % 4]);
        Matrix selectionMat = new Matrix();
        RectF bounds = new RectF(rectDrawable);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.imageFrameLayout.getLayoutParams();
        float frameLeftOffset = this.imageFrameLayout.getPaddingLeft() + params.leftMargin;
        float frameTopOffset = this.imageFrameLayout.getPaddingTop() + params.topMargin;
        selectionMat.setRectToRect(bounds, new RectF(frameLeftOffset, frameTopOffset, (float)measuredWidth + frameLeftOffset, (float)measuredHeight + frameTopOffset), Matrix.ScaleToFit.CENTER);
        selectionMat.mapRect(bounds);
        this.selectionPolygonView.setBoundaries(bounds);
        if (this.originalBoundingBoxResult == null) {
            this.selectionPolygonView.setPoints(null);
            this.disableAllButtons();
        } else {
            Map<Integer, PointF> pointFs = this.getLastEdgePoints(bounds);
            this.selectionPolygonView.setPoints(pointFs);
        }
    }

    private synchronized Bitmap getImageFromBundle() throws Exception {
        byte[] data;
        Bundle args = this.getArguments();
        if (args == null) {
            throw new Exception("Has no image to display");
        }
        boolean isFront = args.getBoolean(EXTRA_IS_FRONT, true);
        byte[] byArray = data = isFront ? SessionResultParams.originalFront : SessionResultParams.originalBack;
        if (data == null) {
            throw new Exception("Has no image to display");
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        if (bitmap == null) {
            throw new Exception("Not a valid bitmap");
        }
        return bitmap;
    }

    private void setBoundingBoxIfRectNotFound() {
        if (this.originalBitmap == null || this.hasOriginalBoundingBox) {
            return;
        }
        this.originalBoundingBoxResult = new GenericBoundingBoxResult();
        this.originalBoundingBoxResult.y = 0;
        this.originalBoundingBoxResult.x = 0;
        this.originalBoundingBoxResult.width = this.originalBitmap.getWidth();
        this.originalBoundingBoxResult.height = this.originalBitmap.getHeight();
        this.originalBoundingBoxResult.topRightY = 0.0f;
        this.originalBoundingBoxResult.bottomLeftX = 0.0f;
        this.originalBoundingBoxResult.topLeftY = 0.0f;
        this.originalBoundingBoxResult.topLeftX = 0.0f;
        this.originalBoundingBoxResult.bottomRightX = this.originalBoundingBoxResult.topRightX = (float)this.originalBitmap.getWidth();
        this.originalBoundingBoxResult.bottomLeftY = this.originalBoundingBoxResult.bottomRightY = (float)this.originalBitmap.getHeight();
    }

    public synchronized void setFirstCoordinates(GenericBoundingBoxResult gbbr) {
        this.originalBoundingBoxResult = gbbr;
        if (this.originalBoundingBoxResult == null) {
            this.hasOriginalBoundingBox = false;
            if (this.originalBitmap != null) {
                this.setBoundingBoxIfRectNotFound();
            }
        }
        if (this.backBtn != null) {
            this.enableAllButtons();
        }
        if (this.selectionPolygonView != null) {
            RectF bounds = this.selectionPolygonView.getBoundaries();
            Map<Integer, PointF> pointFs = this.getLastEdgePoints(bounds);
            this.selectionPolygonView.setPoints(pointFs);
        }
        if (this.expandBtn != null) {
            this.expandBtn.setEnabled(this.hasOriginalBoundingBox);
        }
    }

    private boolean isMapPointsEqual(Map<Integer, PointF> firstMap, Map<Integer, PointF> secondMap) {
        int delta = 2;
        return firstMap.get(0) != null && secondMap.get(0) != null && Math.abs(firstMap.get((Object)Integer.valueOf((int)0)).x - secondMap.get((Object)Integer.valueOf((int)0)).x) < 2.0f && Math.abs(firstMap.get((Object)Integer.valueOf((int)0)).y - secondMap.get((Object)Integer.valueOf((int)0)).y) < 2.0f && firstMap.get(1) != null && secondMap.get(1) != null && Math.abs(firstMap.get((Object)Integer.valueOf((int)1)).x - secondMap.get((Object)Integer.valueOf((int)1)).x) < 2.0f && Math.abs(firstMap.get((Object)Integer.valueOf((int)1)).y - secondMap.get((Object)Integer.valueOf((int)1)).y) < 2.0f && firstMap.get(2) != null && secondMap.get(2) != null && Math.abs(firstMap.get((Object)Integer.valueOf((int)2)).x - secondMap.get((Object)Integer.valueOf((int)2)).x) < 2.0f && Math.abs(firstMap.get((Object)Integer.valueOf((int)2)).y - secondMap.get((Object)Integer.valueOf((int)2)).y) < 2.0f && firstMap.get(3) != null && secondMap.get(3) != null && Math.abs(firstMap.get((Object)Integer.valueOf((int)3)).x - secondMap.get((Object)Integer.valueOf((int)3)).x) < 2.0f && Math.abs(firstMap.get((Object)Integer.valueOf((int)3)).y - secondMap.get((Object)Integer.valueOf((int)3)).y) < 2.0f;
    }

    private Map<Integer, PointF> getLastEdgePoints(RectF bounds) {
        List<PointF> pointFs = this.getContourEdgePoints(bounds, false);
        return this.orderedValidEdgePoints(bounds, pointFs);
    }

    private Map<Integer, PointF> getOriginalEdgePoints(RectF bounds) {
        List<PointF> pointFs = this.getContourEdgePoints(bounds, true);
        return this.orderedValidEdgePoints(bounds, pointFs);
    }

    private synchronized Bitmap scaledBitmap(Bitmap bitmap, int width, int height) {
        int toHeight;
        int toWidth;
        int longerAxis = Math.max(width, height);
        int shorterAxis = Math.min(width, height);
        if (bitmap.getWidth() > bitmap.getHeight()) {
            toWidth = longerAxis;
            toHeight = shorterAxis;
        } else {
            toWidth = shorterAxis;
            toHeight = longerAxis;
        }
        Matrix m = new Matrix();
        m.setRectToRect(new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight()), new RectF(0.0f, 0.0f, (float)toWidth, (float)toHeight), Matrix.ScaleToFit.CENTER);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
    }

    private Map<Integer, PointF> orderedValidEdgePoints(RectF rect, List<PointF> pointFs) {
        Map<Integer, PointF> orderedPoints = this.selectionPolygonView.getOrderedPoints(pointFs);
        if (!this.selectionPolygonView.isValid()) {
            orderedPoints = this.getOutlinePoints(rect);
        }
        return orderedPoints;
    }

    private Map<Integer, PointF> getOutlinePoints(RectF rect) {
        HashMap<Integer, PointF> outlinePoints = new HashMap<Integer, PointF>();
        outlinePoints.put(0, new PointF(0.0f, 0.0f));
        outlinePoints.put(1, new PointF(rect.width(), 0.0f));
        outlinePoints.put(2, new PointF(0.0f, rect.height()));
        outlinePoints.put(3, new PointF(rect.width(), rect.height()));
        return outlinePoints;
    }

    private float[] getBoundingBoxWithRotation(GenericBoundingBoxResult boundingBoxResult, int rotation) {
        float[] resultPoints = new float[8];
        float[] genericPoints = new float[8];
        UserInterfaceUtils.fillPointsArrayFromBoundingBox(genericPoints, boundingBoxResult);
        float pivotX = this.originalBitmap.getWidth() / 2;
        float pivotY = this.originalBitmap.getHeight() / 2;
        if (rotation == 1) {
            pivotX = pivotY;
        } else if (rotation == 3) {
            pivotY = pivotX;
        }
        Matrix rotateMat = new Matrix();
        rotateMat.setRotate((float)(rotation * 90), pivotX, pivotY);
        rotateMat.mapPoints(resultPoints, genericPoints);
        return resultPoints;
    }

    private List<PointF> getContourEdgePoints(RectF rect, boolean forceOriginalBox) {
        if (this.originalBoundingBoxResult == null) {
            return null;
        }
        float xRatio = rect.width() * 1.0f / (float)(this.rotateState % 2 == 0 ? this.originalBitmap.getWidth() : this.originalBitmap.getHeight());
        float yRatio = rect.height() * 1.0f / (float)(this.rotateState % 2 == 0 ? this.originalBitmap.getHeight() : this.originalBitmap.getWidth());
        float[] points = this.getBoundingBoxWithRotation(forceOriginalBox || this.currentBoundingBoxResult == null ? this.originalBoundingBoxResult : this.currentBoundingBoxResult, this.rotateState);
        float x1 = points[0] * xRatio;
        float y1 = points[1] * yRatio;
        float x2 = points[2] * xRatio;
        float y2 = points[3] * yRatio;
        float x3 = points[4] * xRatio;
        float y3 = points[5] * yRatio;
        float x4 = points[6] * xRatio;
        float y4 = points[7] * yRatio;
        ArrayList<PointF> pointFs = new ArrayList<PointF>();
        pointFs.add(new PointF(x1, y1));
        pointFs.add(new PointF(x2, y2));
        pointFs.add(new PointF(x3, y3));
        pointFs.add(new PointF(x4, y4));
        return pointFs;
    }

    private int getPointIndexForRotation(int index, int rotation) {
        return this.pointIndexForRotation[rotation % 4][index];
    }

    private GenericBoundingBoxResult calculateCurrentBoundingBox(boolean returnRotated) {
        int[] currentIndexesOrder = new int[]{this.getPointIndexForRotation(0, this.rotateState), this.getPointIndexForRotation(1, this.rotateState), this.getPointIndexForRotation(2, this.rotateState), this.getPointIndexForRotation(3, this.rotateState)};
        if (this.currentBoundingBoxResult == null) {
            this.currentBoundingBoxResult = new GenericBoundingBoxResult();
        }
        Map<Integer, PointF> currentPoints = this.orderedValidEdgePoints(this.selectionPolygonView.getBoundaries(), this.selectionPolygonView.getPointsInsideBounds());
        RectF currentBounds = this.selectionPolygonView.getBoundaries();
        float xRatio = currentBounds.width() * 1.0f / (float)(this.rotateState % 2 == 0 ? this.originalBitmap.getWidth() : this.originalBitmap.getHeight());
        float yRatio = currentBounds.height() * 1.0f / (float)(this.rotateState % 2 == 0 ? this.originalBitmap.getHeight() : this.originalBitmap.getWidth());
        float[] selectionPoints = new float[8];
        this.fillPointsArrWithPointsMap(selectionPoints, currentPoints, new PointF(xRatio, yRatio), currentIndexesOrder);
        float pivotX = this.originalBitmap.getWidth() / 2;
        float pivotY = this.originalBitmap.getHeight() / 2;
        if (this.rotateState == 1) {
            pivotX = pivotY;
        } else if (this.rotateState == 3) {
            pivotY = pivotX;
        }
        Matrix rotateMat = new Matrix();
        rotateMat.setRotate((float)(-this.rotateState * 90), pivotX, pivotY);
        float[] points = new float[8];
        rotateMat.mapPoints(points, selectionPoints);
        UserInterfaceUtils.fillGenericBBUsingPointsArr(this.currentBoundingBoxResult, points);
        if (!returnRotated || this.rotateState % 4 == 0) {
            return this.currentBoundingBoxResult;
        }
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.fillPointsArrWithPointsMap(selectionPoints, currentPoints, new PointF(xRatio, yRatio), nArray);
        points = new float[8];
        rotateMat.mapPoints(points, selectionPoints);
        GenericBoundingBoxResult bbForRotation = new GenericBoundingBoxResult();
        UserInterfaceUtils.fillGenericBBUsingPointsArr(bbForRotation, points);
        return bbForRotation;
    }

    private void fillPointsArrWithPointsMap(float[] points, Map<Integer, PointF> map, PointF ratioConversion, int[] indexOrder) {
        points[0] = map.get((Object)Integer.valueOf((int)indexOrder[0])).x / ratioConversion.x;
        points[1] = map.get((Object)Integer.valueOf((int)indexOrder[0])).y / ratioConversion.y;
        points[2] = map.get((Object)Integer.valueOf((int)indexOrder[1])).x / ratioConversion.x;
        points[3] = map.get((Object)Integer.valueOf((int)indexOrder[1])).y / ratioConversion.y;
        points[4] = map.get((Object)Integer.valueOf((int)indexOrder[2])).x / ratioConversion.x;
        points[5] = map.get((Object)Integer.valueOf((int)indexOrder[2])).y / ratioConversion.y;
        points[6] = map.get((Object)Integer.valueOf((int)indexOrder[3])).x / ratioConversion.x;
        points[7] = map.get((Object)Integer.valueOf((int)indexOrder[3])).y / ratioConversion.y;
    }

    private class CropImageAndDisplay
    extends AsyncTask<Void, Integer, Bitmap> {
        private CropImageAndDisplay() {
        }

        protected void onPreExecute() {
        }

        protected Bitmap doInBackground(Void ... arg0) {
            GenericBoundingBoxResult bb = ManualCroppingController.this.calculateCurrentBoundingBox(false);
            double topWidth = Math.sqrt(Math.pow(bb.topRightX - bb.topLeftX, 2.0) + Math.pow(bb.topRightY - bb.topLeftY, 2.0));
            double bottomWidth = Math.sqrt(Math.pow(bb.bottomRightX - bb.bottomLeftX, 2.0) + Math.pow(bb.bottomRightY - bb.bottomLeftY, 2.0));
            double leftHeight = Math.sqrt(Math.pow(bb.bottomLeftX - bb.topLeftX, 2.0) + Math.pow(bb.bottomLeftY - bb.topLeftY, 2.0));
            double rightHeight = Math.sqrt(Math.pow(bb.bottomRightX - bb.topRightX, 2.0) + Math.pow(bb.bottomRightY - bb.topRightY, 2.0));
            double destW = Math.min(bottomWidth, topWidth);
            double destH = Math.min(leftHeight, rightHeight);
            ArrayList<Point> srcPoints = new ArrayList<Point>();
            srcPoints.add(new Point((double)bb.topLeftX, (double)bb.topLeftY));
            srcPoints.add(new Point((double)bb.topRightX, (double)bb.topRightY));
            srcPoints.add(new Point((double)bb.bottomRightX, (double)bb.bottomRightY));
            srcPoints.add(new Point((double)bb.bottomLeftX, (double)bb.bottomLeftY));
            ArrayList<Point> destPoints = new ArrayList<Point>();
            destPoints.add(new Point(0.0, 0.0));
            destPoints.add(new Point(destW - 1.0, 0.0));
            destPoints.add(new Point(destW - 1.0, destH - 1.0));
            destPoints.add(new Point(0.0, destH));
            Mat srcMat = Converters.vector_Point2f_to_Mat(srcPoints);
            Mat dstMat = Converters.vector_Point2f_to_Mat(destPoints);
            Mat perspectiveTransformation = Imgproc.getPerspectiveTransform((Mat)srcMat, (Mat)dstMat);
            Mat inputMat = new Mat();
            Utils.bitmapToMat((Bitmap)ManualCroppingController.this.originalBitmap, (Mat)inputMat);
            Mat outputMat = new Mat((int)destH, (int)destW, CvType.CV_8UC4);
            Imgproc.warpPerspective((Mat)inputMat, (Mat)outputMat, (Mat)perspectiveTransformation, (Size)new Size(destW, destH));
            Bitmap outputBmp = Bitmap.createBitmap((int)((int)destW), (int)((int)destH), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap((Mat)outputMat, (Bitmap)outputBmp);
            Imgproc.cvtColor((Mat)outputMat, (Mat)outputMat, (int)2);
            if (CameraManagerController.getOcrAnalyzeSession((Context)((ManualCroppingController)ManualCroppingController.this).activity).captureMode == CameraTypes.CaptureMode.FRONT) {
                CameraManagerController.getOcrAnalyzeSession((Context)ManualCroppingController.this.activity).setFrontCroppedStillsMat(outputMat);
            } else {
                CameraManagerController.getOcrAnalyzeSession((Context)ManualCroppingController.this.activity).setBackCroppedStillsMat(outputMat);
            }
            return outputBmp;
        }

        protected void onProgressUpdate(Integer ... a) {
        }

        protected void onPostExecute(Bitmap outputBmp) {
            TouchImageView previewView = (TouchImageView)ManualCroppingController.this.fragmentView.findViewById(R.id.previewCroppedImage);
            previewView.setImageBitmap(outputBmp);
            previewView.setScaleType(ImageView.ScaleType.MATRIX);
            previewView.setMaxZoom(4.0f);
            ManualCroppingController.this.translateAnimation = new TranslateAnimation(1, -1.0f, 1, 0.0f, 0, 0.0f, 0, 0.0f);
            ManualCroppingController.this.translateAnimation.setDuration(500L);
            FrameLayout.LayoutParams confirmLayoutParams = (FrameLayout.LayoutParams)ManualCroppingController.this.confirmLayout.getLayoutParams();
            confirmLayoutParams.leftMargin = 0;
            ManualCroppingController.this.confirmLayout.setLayoutParams((ViewGroup.LayoutParams)confirmLayoutParams);
            ManualCroppingController.this.confirmLayout.startAnimation((Animation)ManualCroppingController.this.translateAnimation);
            ManualCroppingController.this.spinner.setVisibility(8);
            ManualCroppingController.this.translateAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ManualCroppingController.this.isInConfirmState = true;
                    ManualCroppingController.this.confirmBtn.setEnabled(true);
                    ManualCroppingController.this.backBtn.setEnabled(true);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
    }
}

