/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.File;
import java.util.StringTokenizer;
import org.opencv.android.InstallCallbackInterface;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.core.Core;
import org.opencv.engine.OpenCVEngineInterface;

class AsyncServiceHelper {
    protected static final String TAG = "OpenCVManager/Helper";
    protected static final int MINIMUM_ENGINE_VERSION = 2;
    protected OpenCVEngineInterface mEngineService;
    protected LoaderCallbackInterface mUserAppCallback;
    protected String mOpenCVersion;
    protected Context mAppContext;
    protected static boolean mServiceInstallationProgress = false;
    protected static boolean mLibraryInstallationProgress = false;
    protected static final String OPEN_CV_SERVICE_URL = "market://details?id=org.opencv.engine";
    protected ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d((String)AsyncServiceHelper.TAG, (String)"Service connection created");
            AsyncServiceHelper.this.mEngineService = OpenCVEngineInterface.Stub.asInterface(service);
            if (null == AsyncServiceHelper.this.mEngineService) {
                Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV Manager Service connection fails. May be service was not installed?");
                AsyncServiceHelper.InstallService(AsyncServiceHelper.this.mAppContext, AsyncServiceHelper.this.mUserAppCallback);
            } else {
                mServiceInstallationProgress = false;
                try {
                    int status;
                    if (AsyncServiceHelper.this.mEngineService.getEngineVersion() < 2) {
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 4");
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                        AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                        AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(4);
                        return;
                    }
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Trying to get library path");
                    String path = AsyncServiceHelper.this.mEngineService.getLibPathByVersion(AsyncServiceHelper.this.mOpenCVersion);
                    if (null == path || path.length() == 0) {
                        if (!mLibraryInstallationProgress) {
                            InstallCallbackInterface InstallQuery = new InstallCallbackInterface(){

                                @Override
                                public String getPackageName() {
                                    return "OpenCV library";
                                }

                                @Override
                                public void install() {
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Trying to install OpenCV lib via Google Play");
                                    try {
                                        if (AsyncServiceHelper.this.mEngineService.installVersion(AsyncServiceHelper.this.mOpenCVersion)) {
                                            mLibraryInstallationProgress = true;
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Package installation statred");
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                            AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                        } else {
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV package was not installed!");
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 2");
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                            AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                            AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(2);
                                        }
                                    }
                                    catch (RemoteException e) {
                                        e.printStackTrace();
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 255");
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                        AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                        AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(255);
                                    }
                                }

                                @Override
                                public void cancel() {
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV library installation was canceled");
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 3");
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                    AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                    AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(3);
                                }

                                @Override
                                public void wait_install() {
                                    Log.e((String)AsyncServiceHelper.TAG, (String)"Instalation was not started! Nothing to wait!");
                                }
                            };
                            AsyncServiceHelper.this.mUserAppCallback.onPackageInstall(0, InstallQuery);
                        } else {
                            InstallCallbackInterface WaitQuery = new InstallCallbackInterface(){

                                @Override
                                public String getPackageName() {
                                    return "OpenCV library";
                                }

                                @Override
                                public void install() {
                                    Log.e((String)AsyncServiceHelper.TAG, (String)"Nothing to install we just wait current installation");
                                }

                                @Override
                                public void cancel() {
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV library installation was canceled");
                                    mLibraryInstallationProgress = false;
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 3");
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                    AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                    AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(3);
                                }

                                @Override
                                public void wait_install() {
                                    Log.d((String)AsyncServiceHelper.TAG, (String)"Waiting for current installation");
                                    try {
                                        if (!AsyncServiceHelper.this.mEngineService.installVersion(AsyncServiceHelper.this.mOpenCVersion)) {
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV package was not installed!");
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 2");
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                            AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(2);
                                        } else {
                                            Log.d((String)AsyncServiceHelper.TAG, (String)"Wating for package installation");
                                        }
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                        AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                    }
                                    catch (RemoteException e) {
                                        e.printStackTrace();
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 255");
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                                        AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                                        Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                                        AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(255);
                                    }
                                }
                            };
                            AsyncServiceHelper.this.mUserAppCallback.onPackageInstall(1, WaitQuery);
                        }
                        return;
                    }
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Trying to get library list");
                    mLibraryInstallationProgress = false;
                    String libs = AsyncServiceHelper.this.mEngineService.getLibraryList(AsyncServiceHelper.this.mOpenCVersion);
                    Log.d((String)AsyncServiceHelper.TAG, (String)("Library list: \"" + libs + "\""));
                    Log.d((String)AsyncServiceHelper.TAG, (String)"First attempt to load libs");
                    if (AsyncServiceHelper.this.initOpenCVLibs(path, libs)) {
                        Log.d((String)AsyncServiceHelper.TAG, (String)"First attempt to load libs is OK");
                        String eol = System.getProperty("line.separator");
                        for (String str : Core.getBuildInformation().split(eol)) {
                            Log.i((String)AsyncServiceHelper.TAG, (String)str);
                        }
                        status = 0;
                    } else {
                        Log.d((String)AsyncServiceHelper.TAG, (String)"First attempt to load libs fails");
                        status = 255;
                    }
                    Log.d((String)AsyncServiceHelper.TAG, (String)("Init finished with status " + status));
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                    AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                    AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(status);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Init finished with status 255");
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                    AsyncServiceHelper.this.mAppContext.unbindService(AsyncServiceHelper.this.mServiceConnection);
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                    AsyncServiceHelper.this.mUserAppCallback.onManagerConnected(255);
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            AsyncServiceHelper.this.mEngineService = null;
        }
    };

    public static boolean initOpenCV(String Version, Context AppContext, LoaderCallbackInterface Callback) {
        AsyncServiceHelper helper = new AsyncServiceHelper(Version, AppContext, Callback);
        Intent intent = new Intent("org.opencv.engine.BIND");
        intent.setPackage("org.opencv.engine");
        if (AppContext.bindService(intent, helper.mServiceConnection, 1)) {
            return true;
        }
        AppContext.unbindService(helper.mServiceConnection);
        AsyncServiceHelper.InstallService(AppContext, Callback);
        return false;
    }

    protected AsyncServiceHelper(String Version, Context AppContext, LoaderCallbackInterface Callback) {
        this.mOpenCVersion = Version;
        this.mUserAppCallback = Callback;
        this.mAppContext = AppContext;
    }

    protected static boolean InstallServiceQuiet(Context context) {
        boolean result = true;
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)OPEN_CV_SERVICE_URL));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    protected static void InstallService(final Context AppContext, final LoaderCallbackInterface Callback) {
        if (!mServiceInstallationProgress) {
            Log.d((String)TAG, (String)"Request new service installation");
            InstallCallbackInterface InstallQuery = new InstallCallbackInterface(){
                private LoaderCallbackInterface mUserAppCallback;
                {
                    this.mUserAppCallback = Callback;
                }

                @Override
                public String getPackageName() {
                    return "OpenCV Manager";
                }

                @Override
                public void install() {
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Trying to install OpenCV Manager via Google Play");
                    boolean result = AsyncServiceHelper.InstallServiceQuiet(AppContext);
                    if (result) {
                        mServiceInstallationProgress = true;
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Package installation started");
                    } else {
                        Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV package was not installed!");
                        int Status = 2;
                        Log.d((String)AsyncServiceHelper.TAG, (String)("Init finished with status " + Status));
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Unbind from service");
                        Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                        this.mUserAppCallback.onManagerConnected(Status);
                    }
                }

                @Override
                public void cancel() {
                    Log.d((String)AsyncServiceHelper.TAG, (String)"OpenCV library installation was canceled");
                    int Status = 3;
                    Log.d((String)AsyncServiceHelper.TAG, (String)("Init finished with status " + Status));
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                    this.mUserAppCallback.onManagerConnected(Status);
                }

                @Override
                public void wait_install() {
                    Log.e((String)AsyncServiceHelper.TAG, (String)"Instalation was not started! Nothing to wait!");
                }
            };
            Callback.onPackageInstall(0, InstallQuery);
        } else {
            Log.d((String)TAG, (String)"Waiting current installation process");
            InstallCallbackInterface WaitQuery = new InstallCallbackInterface(){
                private LoaderCallbackInterface mUserAppCallback;
                {
                    this.mUserAppCallback = Callback;
                }

                @Override
                public String getPackageName() {
                    return "OpenCV Manager";
                }

                @Override
                public void install() {
                    Log.e((String)AsyncServiceHelper.TAG, (String)"Nothing to install we just wait current installation");
                }

                @Override
                public void cancel() {
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Wating for OpenCV canceled by user");
                    mServiceInstallationProgress = false;
                    int Status = 3;
                    Log.d((String)AsyncServiceHelper.TAG, (String)("Init finished with status " + Status));
                    Log.d((String)AsyncServiceHelper.TAG, (String)"Calling using callback");
                    this.mUserAppCallback.onManagerConnected(Status);
                }

                @Override
                public void wait_install() {
                    AsyncServiceHelper.InstallServiceQuiet(AppContext);
                }
            };
            Callback.onPackageInstall(1, WaitQuery);
        }
    }

    private boolean loadLibrary(String AbsPath) {
        boolean result = true;
        Log.d((String)TAG, (String)("Trying to load library " + AbsPath));
        try {
            System.load(AbsPath);
            Log.d((String)TAG, (String)"OpenCV libs init was ok!");
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)TAG, (String)("Cannot load library \"" + AbsPath + "\""));
            e.printStackTrace();
            result &= false;
        }
        return result;
    }

    private boolean initOpenCVLibs(String Path2, String Libs) {
        Log.d((String)TAG, (String)"Trying to init OpenCV libs");
        if (null != Path2 && Path2.length() != 0) {
            boolean result = true;
            if (null != Libs && Libs.length() != 0) {
                Log.d((String)TAG, (String)"Trying to load libs by dependency list");
                StringTokenizer splitter = new StringTokenizer(Libs, ";");
                while (splitter.hasMoreTokens()) {
                    String AbsLibraryPath = Path2 + File.separator + splitter.nextToken();
                    result &= this.loadLibrary(AbsLibraryPath);
                }
            } else {
                String AbsLibraryPath = Path2 + File.separator + "libopencv_java3.so";
                result &= this.loadLibrary(AbsLibraryPath);
            }
            return result;
        }
        Log.d((String)TAG, (String)("Library path \"" + Path2 + "\" is empty"));
        return false;
    }
}

