/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit;

import android.os.Parcel;
import android.os.Parcelable;
import com.topimagesystems.credit.CardType;
import com.topimagesystems.credit.CreditCardNumber;
import java.util.UUID;

public class CreditCard
implements Parcelable {
    public static final int EXPIRY_MAX_FUTURE_YEARS = 15;
    private static final String TAG = CreditCard.class.getSimpleName();
    public String cardNumber;
    public int expiryMonth = 0;
    public int expiryYear = 0;
    public String cvv;
    public String postalCode;
    public String cardholderName;
    String scanId;
    boolean flipped = false;
    int yoff;
    int[] xoff;
    public static final Parcelable.Creator<CreditCard> CREATOR = new Parcelable.Creator<CreditCard>(){

        public CreditCard createFromParcel(Parcel source) {
            return new CreditCard(source, null);
        }

        public CreditCard[] newArray(int size) {
            return new CreditCard[size];
        }
    };

    public CreditCard() {
        this.xoff = new int[16];
        this.scanId = UUID.randomUUID().toString();
    }

    public CreditCard(String number, int month, int year, String code, String postalCode, String cardholderName) {
        this.cardNumber = number;
        this.expiryMonth = month;
        this.expiryYear = year;
        this.cvv = code;
        this.postalCode = postalCode;
        this.cardholderName = cardholderName;
    }

    private CreditCard(Parcel src) {
        this.cardNumber = src.readString();
        this.expiryMonth = src.readInt();
        this.expiryYear = src.readInt();
        this.cvv = src.readString();
        this.postalCode = src.readString();
        this.cardholderName = src.readString();
        this.scanId = src.readString();
        this.yoff = src.readInt();
        this.xoff = src.createIntArray();
    }

    public int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cardNumber);
        dest.writeInt(this.expiryMonth);
        dest.writeInt(this.expiryYear);
        dest.writeString(this.cvv);
        dest.writeString(this.postalCode);
        dest.writeString(this.cardholderName);
        dest.writeString(this.scanId);
        dest.writeInt(this.yoff);
        dest.writeIntArray(this.xoff);
    }

    public String getLastFourDigitsOfCardNumber() {
        if (this.cardNumber != null) {
            int available = Math.min(4, this.cardNumber.length());
            return this.cardNumber.substring(this.cardNumber.length() - available);
        }
        return "";
    }

    public String getRedactedCardNumber() {
        if (this.cardNumber != null) {
            String redacted = "";
            if (this.cardNumber.length() > 4) {
                redacted = String.valueOf(redacted) + String.format("%" + (this.cardNumber.length() - 4) + "s", "").replace(' ', '\u2022');
            }
            redacted = String.valueOf(redacted) + this.getLastFourDigitsOfCardNumber();
            return CreditCardNumber.formatString(redacted, false, CardType.fromCardNumber(this.cardNumber));
        }
        return "";
    }

    public CardType getCardType() {
        return CardType.fromCardNumber(this.cardNumber);
    }

    public String getFormattedCardNumber() {
        return CreditCardNumber.formatString(this.cardNumber);
    }

    public boolean isExpiryValid() {
        return CreditCardNumber.isDateValid(this.expiryMonth, this.expiryYear);
    }

    public String toString() {
        String s = "{" + (Object)((Object)this.getCardType()) + ": " + this.getRedactedCardNumber();
        if (this.expiryMonth > 0 || this.expiryYear > 0) {
            s = String.valueOf(s) + "  expiry:" + this.expiryMonth + "/" + this.expiryYear;
        }
        if (this.postalCode != null) {
            s = String.valueOf(s) + "  postalCode:" + this.postalCode;
        }
        if (this.cardholderName != null) {
            s = String.valueOf(s) + "  cardholderName:" + this.cardholderName;
        }
        if (this.cvv != null) {
            s = String.valueOf(s) + "  cvvLength:" + (this.cvv != null ? this.cvv.length() : 0);
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    /* synthetic */ CreditCard(Parcel parcel, CreditCard creditCard) {
        this(parcel);
    }
}

