/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.credit.CreditCard;
import com.topimagesystems.credit.DetectionInfo;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.ImageUtils;
import com.topimagesystems.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

public class CardScanner
implements Camera.PreviewCallback,
Camera.AutoFocusCallback {
    public static final String EXTRA_LANGUAGE_OR_LOCALE = "com.topimagesystems.credit.languageOrLocale";
    private static final String TAG = CardScanner.class.getSimpleName();
    private static final float MIN_FOCUS_SCORE = 4.0f;
    private static final int DEFAULT_UNBLUR_DIGITS = 4;
    static final int ORIENTATION_PORTRAIT = 1;
    static final int CREDIT_CARD_TARGET_WIDTH = 428;
    static final int CREDIT_CARD_TARGET_HEIGHT = 270;
    private Bitmap detectedBitmap;
    private static boolean manualFallbackForError;
    private int mUnblurDigits = 4;
    private int mFrameOrientation = 1;
    private long mAutoFocusStartedAt;
    private long mAutoFocusCompletedAt;
    private byte[] mPreviewBuffer;
    protected boolean useCamera = true;
    private static boolean initialized;
    private static boolean processingInProgress;
    private int validFrameCount = 0;

    static {
        initialized = false;
        processingInProgress = false;
    }

    public static native boolean nUseNeon();

    public static native boolean nUseTegra();

    public static native boolean nUseX86();

    private native void nSetup(boolean var1, float var2);

    private native void nSetup(boolean var1, float var2, int var3);

    private native void nResetAnalytics();

    private native void nGetGuideFrame(int var1, int var2, int var3, Rect var4);

    private native void nScanFrame(byte[] var1, int var2, int var3, int var4, DetectionInfo var5, Bitmap var6, boolean var7);

    private native int nGetNumFramesScanned();

    private native void nCleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadingLibs() throws Exception {
        String errMsg;
        block12: {
            if (initialized) {
                return;
            }
            errMsg = "";
            try {
                CardScanner.loadLibrary("cardioDecider");
                Logger.d("card.io", "Loaded card decider library.");
                Logger.d("card.io", "    nUseNeon(): " + CardScanner.nUseNeon());
                Logger.d("card.io", "    nUseTegra():" + CardScanner.nUseTegra());
                Logger.d("card.io", "    nUseX86():  " + CardScanner.nUseX86());
                if (CardScanner.nUseNeon()) {
                    CardScanner.loadLibrary("cardioRecognizer");
                    Logger.i("card.io", "Loaded card.io NEON library");
                    break block12;
                }
                if (CardScanner.nUseX86()) {
                    CardScanner.loadLibrary("cardioRecognizer");
                    Logger.i("card.io", "Loaded card.io x86 library");
                    break block12;
                }
                if (CardScanner.nUseTegra()) {
                    CardScanner.loadLibrary("cardioRecognizer_tegra2");
                    Logger.i("card.io", "Loaded card.io Tegra2 library");
                    break block12;
                }
                Logger.w("card.io", "unsupported processor - card-io scanning requires ARMv7 or x86 architecture");
                manualFallbackForError = true;
                throw new Exception("unsupported processor - card-io scanning requires ARMv7 or x86 architecture");
            }
            catch (UnsatisfiedLinkError e) {
                String error = "Failed to load native library: " + e.getMessage();
                Logger.e("card.io", error);
                errMsg = e.getMessage();
                manualFallbackForError = true;
            }
            catch (Error e) {
                String error = "Failed to load native library: " + e.getMessage();
                Logger.e("card.io", error);
                errMsg = e.getMessage();
                manualFallbackForError = true;
            }
            catch (Exception e) {
                String error = "Failed to load native library: " + e.getMessage();
                Logger.e("card.io", error);
                errMsg = e.getMessage();
                manualFallbackForError = true;
            }
        }
        Class<CardScanner> clazz = CardScanner.class;
        synchronized (CardScanner.class) {
            initialized = !manualFallbackForError;
            // ** MonitorExit[var1_4] (shouldn't be in output)
            if (manualFallbackForError) {
                throw new Exception(errMsg);
            }
            return;
        }
    }

    private static void loadLibrary(String libraryName) throws UnsatisfiedLinkError {
        System.loadLibrary(libraryName);
    }

    private static boolean usesSupportedProcessorArch() {
        return CardScanner.nUseNeon() || CardScanner.nUseTegra() || CardScanner.nUseX86();
    }

    static boolean processorSupported() {
        return !manualFallbackForError && CardScanner.usesSupportedProcessorArch();
    }

    public CardScanner(int currentFrameOrientation) {
        if (!initialized) {
            try {
                CardScanner.loadingLibs();
            }
            catch (Exception e) {
                return;
            }
        }
        this.mUnblurDigits = 4;
        this.mFrameOrientation = currentFrameOrientation;
    }

    public void release() {
        if (this.mPreviewBuffer != null) {
            this.mPreviewBuffer = null;
        }
    }

    public void pauseScanning(Camera camera) {
        camera.addCallbackBuffer(null);
        camera.stopPreview();
        this.mPreviewBuffer = null;
    }

    public void endScanning(Camera camera) {
        this.pauseScanning(camera);
        this.nCleanup();
        this.mPreviewBuffer = null;
    }

    public void resumeSession(int bufferSize, Camera camera) {
        this.nSetup(false, 4.0f, this.mUnblurDigits);
        this.mPreviewBuffer = new byte[bufferSize];
        camera.addCallbackBuffer(this.mPreviewBuffer);
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        boolean sufficientFocus;
        if (data == null) {
            Logger.w(TAG, "frame is null! skipping");
            return;
        }
        Camera.Parameters p = null;
        try {
            p = camera.getParameters();
        }
        catch (Exception e) {
            Logger.w(TAG, "camera is released! skipping");
            camera.addCallbackBuffer(null);
            return;
        }
        int format = p.getPreviewFormat();
        int pWidth = p.getPreviewSize().width;
        int pHeight = p.getPreviewSize().height;
        if (processingInProgress) {
            Logger.e(TAG, "processing in progress.... dropping frame");
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
            return;
        }
        if (this.detectedBitmap == null) {
            this.detectedBitmap = Bitmap.createBitmap((int)428, (int)270, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        processingInProgress = true;
        DetectionInfo dInfo = new DetectionInfo();
        this.nScanFrame(data, pWidth, pHeight, this.mFrameOrientation, dInfo, this.detectedBitmap, this.validFrameCount < 10);
        boolean bl = sufficientFocus = dInfo.focusScore >= 4.0f;
        if (!sufficientFocus) {
            this.triggerAutoFocus(camera);
            this.validFrameCount = 0;
        } else if (dInfo.predicted()) {
            Logger.d(TAG, "detected card: " + dInfo.creditCard());
            this.saveVideoMat(data, camera);
            ByteArrayOutputStream scaledCardBytes = new ByteArrayOutputStream();
            this.detectedBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)scaledCardBytes);
            SessionResultParams.colorFront = scaledCardBytes.toByteArray();
            this.sendResults(dInfo.creditCard());
            if (camera != null) {
                this.mPreviewBuffer = null;
                camera = null;
            }
        } else {
            this.validFrameCount = dInfo.detected() ? ++this.validFrameCount : 0;
        }
        if (camera != null) {
            camera.addCallbackBuffer(data);
        }
        processingInProgress = false;
    }

    private synchronized void sendResults(CreditCard creditCard) {
        CameraController cameraController = CameraController.getInstance();
        if (cameraController == null || cameraController.getHandler() == null) {
            return;
        }
        cameraController.getHandler().removeAllMessages();
        Bundle messageBundle = new Bundle();
        Message message = Message.obtain((Handler)cameraController.getHandler(), (int)26);
        if (message != null) {
            message.obj = true;
            messageBundle.putDouble("orientation", (double)this.mFrameOrientation);
            messageBundle.putBoolean("proceedWithProcessing", false);
            messageBundle.putParcelable("creditCardResult", (Parcelable)creditCard);
            message.setData(messageBundle);
            message.sendToTarget();
        }
    }

    void onEdgeUpdate(DetectionInfo dInfo) {
        CameraController cameraController = CameraController.getInstance();
        if (cameraController == null || cameraController.cameraOverlayView == null) {
            return;
        }
        if (dInfo.detected()) {
            CameraController.getInstance().cameraOverlayView.setConfirmationIndicators();
        } else {
            CameraController.getInstance().cameraOverlayView.setNonConfirmationIndicators();
        }
    }

    private void saveVideoMat(byte[] data, Camera camera) {
        CameraController cameraController = CameraController.getInstance();
        if (cameraController == null || CameraManagerController.getOcrAnalyzeSession((Context)cameraController) == null) {
            return;
        }
        Camera.Size size = camera.getParameters().getPreviewSize();
        int width = size.width;
        int height = size.height;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            YuvImage yuvImage = new YuvImage(data, 17, width, height, null);
            yuvImage.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)baos);
            byte[] output = baos.toByteArray();
            Bitmap outputBmp = ImageUtils.decodeByteArray(output);
            Mat mat = new Mat();
            Utils.bitmapToMat((Bitmap)outputBmp, (Mat)mat);
            Mat matRgba = new Mat();
            Imgproc.cvtColor((Mat)mat, (Mat)matRgba, (int)2, (int)0);
            if (CameraManagerController.deviceName.equals("LGE Nexus 5X")) {
                matRgba = FileUtils.rotateMat(matRgba, 90);
                matRgba = FileUtils.rotateMat(matRgba, 90);
            }
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                matRgba = FileUtils.rotateMat(matRgba, 90);
            }
            CameraManagerController.getOcrAnalyzeSession((Context)cameraController).setVideoMat(matRgba);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Rect getGuideFrame(int orientation, int previewWidth, int previewHeight) {
        boolean ORIENTATION_PORTRAIT = true;
        int ORIENTATION_PORTRAIT_UPSIDE_DOWN = 2;
        int ORIENTATION_LANDSCAPE_RIGHT = 3;
        int ORIENTATION_LANDSCAPE_LEFT = 4;
        switch (orientation) {
            case 0: {
                this.setDeviceOrientation(3);
                int tmp = previewWidth;
                previewWidth = previewHeight;
                previewHeight = tmp;
                break;
            }
            case 1: {
                this.setDeviceOrientation(orientation);
            }
        }
        orientation = this.getDeviceOrientation();
        Rect r = null;
        if (CardScanner.processorSupported()) {
            r = new Rect();
            this.nGetGuideFrame(orientation, previewWidth, previewHeight, r);
        }
        if ((orientation == 3 || orientation == 4) && r != null) {
            r.set(r.top, r.left, r.bottom, r.right);
        }
        return r;
    }

    void setDeviceOrientation(int orientation) {
        this.mFrameOrientation = orientation;
    }

    int getDeviceOrientation() {
        return this.mFrameOrientation;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.mAutoFocusCompletedAt = System.currentTimeMillis();
    }

    boolean isAutoFocusing() {
        return this.mAutoFocusCompletedAt < this.mAutoFocusStartedAt || System.currentTimeMillis() - this.mAutoFocusStartedAt < 1000L;
    }

    void triggerAutoFocus(Camera camera) {
        if (this.useCamera && !this.isAutoFocusing()) {
            try {
                this.mAutoFocusStartedAt = System.currentTimeMillis();
                camera.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException e) {
                Logger.w(TAG, "could not trigger auto focus: " + e);
            }
        }
    }
}

