/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.os.IBinder;
import com.topimagesystems.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FlashlightManager {
    private static final String TAG = Logger.makeLogTag("FlashlightManager");
    private static final Object iHardwareService = FlashlightManager.getHardwareService();
    private static final Method setFlashEnabledMethod = FlashlightManager.getSetFlashEnabledMethod(iHardwareService);

    static {
        if (iHardwareService == null) {
            Logger.v(TAG, "This device does supports control of a flashlight");
        } else {
            Logger.v(TAG, "This device does not support control of a flashlight");
        }
    }

    private FlashlightManager() {
    }

    private static Object getHardwareService() {
        Class<?> serviceManagerClass = FlashlightManager.maybeForName("android.os.ServiceManager");
        if (serviceManagerClass == null) {
            return null;
        }
        Method getServiceMethod = FlashlightManager.maybeGetMethod(serviceManagerClass, "getService", String.class);
        if (getServiceMethod == null) {
            return null;
        }
        Object hardwareService = FlashlightManager.invoke(getServiceMethod, null, "hardware");
        if (hardwareService == null) {
            return null;
        }
        Class<?> iHardwareServiceStubClass = FlashlightManager.maybeForName("android.os.IHardwareService$Stub");
        if (iHardwareServiceStubClass == null) {
            return null;
        }
        Method asInterfaceMethod = FlashlightManager.maybeGetMethod(iHardwareServiceStubClass, "asInterface", IBinder.class);
        if (asInterfaceMethod == null) {
            return null;
        }
        return FlashlightManager.invoke(asInterfaceMethod, null, hardwareService);
    }

    private static Method getSetFlashEnabledMethod(Object iHardwareService) {
        if (iHardwareService == null) {
            return null;
        }
        Class<?> proxyClass = iHardwareService.getClass();
        return FlashlightManager.maybeGetMethod(proxyClass, "setFlashlightEnabled", Boolean.TYPE);
    }

    private static Class<?> maybeForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (RuntimeException re) {
            Logger.w(TAG, "Unexpected error while finding class " + name, re);
            return null;
        }
    }

    private static Method maybeGetMethod(Class<?> clazz, String name, Class<?> ... argClasses) {
        try {
            return clazz.getMethod(name, argClasses);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (RuntimeException re) {
            Logger.w(TAG, "Unexpected error while finding method " + name, re);
            return null;
        }
    }

    private static Object invoke(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            Logger.w(TAG, "Unexpected error while invoking " + method, e);
            return null;
        }
        catch (InvocationTargetException e) {
            Logger.w(TAG, "Unexpected error while invoking " + method, e.getCause());
            return null;
        }
        catch (RuntimeException re) {
            Logger.w(TAG, "Unexpected error while invoking " + method, re);
            return null;
        }
    }

    static void enableFlashlight() {
        FlashlightManager.setFlashlight(true);
    }

    static void disableFlashlight() {
        FlashlightManager.setFlashlight(false);
    }

    private static void setFlashlight(boolean active) {
        if (iHardwareService != null) {
            FlashlightManager.invoke(setFlashEnabledMethod, iHardwareService, active);
        }
    }
}

