/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.topimagesystems.Common;
import com.topimagesystems.R;
import com.topimagesystems.controllers.BaseController;
import com.topimagesystems.controllers.NavigationManager;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.controllers.imageanalyze.OCRAnalyzeSession;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.data.TISLicenseParameters;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.micr.TISCreditCardProcessingResults;
import com.topimagesystems.util.CryptLib;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CameraManagerController
extends BaseController {
    public static final String INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS = "INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS";
    public static final String CONTINUE_ANYWAY_APPROVED = "FIND_RECT_ON_HIGH_RES_IMAGE";
    public static final String IMAGE_PATH_AFTER_FALIURE = "IMAGE_PATH_AFTER_FALIURE";
    public static final int OCR_TEST_RESULT = 111;
    public static final int RESULT_FINISH_MAX_TRIES = 112;
    public static final int RESULT_CLOSE_SESSION = 113;
    public static final int RESULT_CANCELED_FROM_ALERT = 114;
    public static final int RESULT_FINISH_WITH_SESSION_RESULT = 117;
    public static final int RESULT_MULTI_CAPTURE_FINISH = 118;
    public static final int RESULT_LIBRARY_ERROR = 119;
    public static final int RESULT_CAMERA_PERMISSION_ACSSES_DENIED = 120;
    public static final int RESULT_LICENSE_INVALID = 121;
    public static final String INVALID_LISENSE_KEY = " Invalid License (b)";
    public static final String VALID_LISENSE_KEY = "Valid License Key";
    public static final String INVALID_LISENSE = "Invalid License (a)";
    public static final String INVALID_SDK_VERSION = "Invalid License (c)";
    public static final String INVALID_EXPERATION_DATE = "License Expired";
    public static final String INVALID_LISENSE_GENERAL = "Invalid License";
    private String tag = Logger.makeLogTag("CameraManagerController");
    private BaseController baseController = this;
    private View processingOverlay;
    private Handler handler;
    public static boolean isDebug;
    public static OCRAnalyzeSession ocrAnalyzeSession;
    public static String[] indicatorString;
    public static boolean scanFrontOnly;
    public static boolean scanBackOnly;
    public static int[] frontImageRectArray;
    public static boolean shouldOutputGrayscaleImage;
    public static boolean shouldOutputOriginalImage;
    public static boolean shouldOutputColoredImage;
    public static boolean shouldOutputBWImage;
    public static boolean isStillMode;
    protected static boolean isInfoScreenEnable;
    protected static long infoScreenInterval;
    public static boolean isBlurEnabled;
    public static boolean isBlurOnBackEnabled;
    public static int maxVideoFramesToProcess;
    public static int BarcodeDetectionTries;
    public static int maxBarcodeTries;
    public static CaptureIntent.TISDocumentType imageType;
    public static Common.OCRType ocrType;
    public static CaptureIntent.SessionType sessionType;
    public static CaptureIntent.LevelerType levlerType;
    private Bundle data;
    private Bundle licenseBundle;
    public static boolean showGuidelinesIndicators;
    public static boolean captureHighResImages;
    public static boolean enableSoftCaptureAndImageAligment;
    public static boolean showMicrOverlay;
    public static HashMap<String, String> dynamicStrings;
    private static CaptureIntent.callbackReturnMessage callBack;
    public static int binarizationType;
    public static float binarizationThreshold;
    public static int[] grayScaleSize;
    public static boolean doOcrOnImage;
    public static boolean countDownSound;
    public static String deviceModal;
    public static String deviceBrand;
    public static String deviceName;
    public static boolean continueNotSupportedHw;
    public static boolean isMultiCapture;
    public static boolean isCustomView;
    public static boolean enableProcessingView;
    private SessionResultParams sessionResults;
    public static int falseRecognitionVideoFrames;
    public static boolean tapToFocus;
    public static boolean showCountDown;
    Bundle savedState;
    public static boolean isSessionStartsInStills;
    public static boolean isDynamicCapture;
    public static boolean useCameraAPI2;
    public static boolean invertedCamera;
    private float minRatioHW;
    private float maxRatioHW;
    protected static CaptureIntent.TISScanBarcodeLocation scanBarcodeLocation;
    protected static boolean enableBarcodeDetection;
    protected static ArrayList<CameraTypes.TISBarcodeType> barcodeTypes;
    protected static boolean useQRFrameForBarcode;
    protected static float colorImageCompression;
    public static float grayScaleImageCompression;
    public static boolean useMaxResolutionStills;
    public int txtValidFrom;
    protected static float videoFrameRectFoundAR;
    protected static float prevRectToCurrentAR;
    protected static int identicalRectanglesToCapture;
    protected static boolean enableTransitionBetweenRectangles;
    protected static float softCaptureThreshold;
    public static boolean sessionRestored;
    public static boolean showErrorSignatureOverMICR;
    protected static boolean enableCroppingController;
    protected static boolean enableManualCapture;
    protected static boolean showGridInLivePreview;
    protected static float maxFrameHeight;
    protected static float maxFrameWidth;

    static {
        isStillMode = true;
        isInfoScreenEnable = true;
        maxBarcodeTries = 13;
        levlerType = null;
        showGuidelinesIndicators = true;
        captureHighResImages = false;
        showMicrOverlay = false;
        grayScaleSize = null;
        countDownSound = false;
        deviceModal = null;
        continueNotSupportedHw = false;
        isMultiCapture = false;
        isCustomView = false;
        enableProcessingView = false;
        tapToFocus = true;
        showCountDown = false;
        isSessionStartsInStills = false;
        isDynamicCapture = false;
        useCameraAPI2 = false;
        invertedCamera = false;
        scanBarcodeLocation = CaptureIntent.TISScanBarcodeLocation.BARCODE_NONE;
        enableBarcodeDetection = true;
        barcodeTypes = null;
        useQRFrameForBarcode = false;
        colorImageCompression = 1.0f;
        grayScaleImageCompression = 1.0f;
        useMaxResolutionStills = false;
        videoFrameRectFoundAR = 0.4f;
        prevRectToCurrentAR = 0.6f;
        identicalRectanglesToCapture = 3;
        enableTransitionBetweenRectangles = true;
        softCaptureThreshold = 0.0f;
        sessionRestored = false;
        showErrorSignatureOverMICR = false;
        enableCroppingController = false;
        enableManualCapture = false;
        showGridInLivePreview = true;
        maxFrameHeight = 0.75f;
        maxFrameWidth = 0.99f;
    }

    @Override
    @SuppressLint(value={"MissingSuperCall"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, isCustomView ? R.layout.custom_mbck_camera_manager_layout : R.layout.mbck_camera_manager_layout);
        if (savedInstanceState == null) {
            if (sessionRestored) {
                Logger.i(this.tag, "sessionRestored true");
                sessionRestored = false;
                this.finish();
                return;
            }
            Logger.i(CameraController.TAG, "onCreate sessionRestored " + sessionRestored);
            Bundle data = this.getIntent().getExtras();
            Bundle licenseBundle = this.getIntent().getBundleExtra("tisLicenseBundle");
            if (data != null && licenseBundle != null) {
                try {
                    TISLicenseParameters licenseOblect = (TISLicenseParameters)licenseBundle.getParcelable("tisLicense");
                    String licenseResult = this.checkLicenseValidation(licenseOblect);
                    if (!licenseResult.equals(VALID_LISENSE_KEY)) {
                        Intent intentData = new Intent();
                        intentData.putExtra("MOBIFLOW_ERROR_DETAILS", licenseResult);
                        Toast.makeText((Context)this.getBaseContext(), (CharSequence)licenseResult, (int)0).show();
                        this.setResult(121, intentData);
                        this.finish();
                        return;
                    }
                }
                catch (Exception e) {
                    Log.e((String)this.tag, (String)"Cannot read License class");
                    Intent intentData = new Intent();
                    intentData.putExtra("MOBIFLOW_ERROR_DETAILS", "Failed to Parse License");
                    Toast.makeText((Context)this.getBaseContext(), (CharSequence)"Failed to Parse License", (int)0).show();
                    this.setResult(121, intentData);
                    this.finish();
                    return;
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.savedState = savedInstanceState;
                if (!this.askPermission()) {
                    return;
                }
            }
            this.initSession();
        } else {
            Logger.i(CameraController.TAG, "restore session");
            this.restoreSession(savedInstanceState);
        }
    }

    private void restoreSession(Bundle savedInstanceState) {
        sessionRestored = true;
        Logger.i(this.tag, "restoreSession start");
        this.minRatioHW = this.getIntent().getFloatExtra("INTENT_MIN_RATIO_HEIGHT_WIDTH", 0.3f);
        this.maxRatioHW = this.getIntent().getFloatExtra("INTENT_MAX_RATIO_HEIGHT_WIDTH", 0.65f);
        int resultCode = -1;
        if (CameraController.getInstance() != null) {
            resultCode = CameraController.getInstance().resultCode;
        }
        this.finishActivityForResult(true, resultCode);
    }

    private void initSession() {
        try {
            deviceModal = FileUtils.getDeviceModel();
            deviceBrand = FileUtils.getDeviceBrand();
            deviceName = FileUtils.getDeviceName();
            this.handler = new Handler();
            this.processingOverlay = this.findViewById(isCustomView ? R.id.customProcessingOverlay : R.id.processingOverlay);
            ocrType = Common.OCRType.OFF;
            isDebug = true;
            int maxNumberOfRetries = 1000;
            this.minRatioHW = 0.3f;
            this.maxRatioHW = 0.65f;
            boolean isUseCustomAlgorithmOnBack = true;
            boolean isBinarizeBackSameAsFront = false;
            float outputHeightInInch = -1.0f;
            float outputWidthInInch = -1.0f;
            float minRatioHWBack = -1.0f;
            float maxRatioHWBack = -1.0f;
            int txtValidFrom = 10;
            int txtValidTo = 50;
            boolean isIQAEnabled = false;
            int maxBarcodeTriesVal = this.getResources().getInteger(R.integer.max_barcode_tries);
            if (maxBarcodeTriesVal > 2) {
                maxBarcodeTries = maxBarcodeTriesVal;
            }
            captureHighResImages = false;
            IQASettingsIntent iqaSettings = null;
            this.checkExceptionalDevices();
            if (this.getIntent() != null) {
                FileUtils.internalStorageLocation = this.getFilesDir().getPath();
                FileUtils.logFilePath = String.valueOf(FileUtils.internalStorageLocation) + "/.mobiflow/log.txt";
                FileUtils.clearMemory();
                isDebug = this.getIntent().getBooleanExtra("IS_DEBUG", true);
                String micrTypeName = this.getIntent().getStringExtra("MICR_TYPE");
                if (!StringUtils.isEmptyOrNull(micrTypeName)) {
                    ocrType = Common.OCRType.valueOf(micrTypeName);
                    captureHighResImages = true;
                } else {
                    ocrType = Common.OCRType.OFF;
                }
                doOcrOnImage = true;
                if (ocrType == Common.OCRType.OFF || ocrType == Common.OCRType.UNKNOWN) {
                    doOcrOnImage = false;
                }
                boolean isPortrait = false;
                if (imageType == CaptureIntent.TISDocumentType.FULL_PAGE || sessionType == CaptureIntent.SessionType.PORTRAIT) {
                    this.setRequestedOrientation(1);
                    isPortrait = true;
                } else {
                    this.setRequestedOrientation(0);
                }
                maxFrameHeight = this.getIntent().getFloatExtra("MAX_FRAME_HEIGHT_PERCENTAGE", isPortrait ? 0.86f : 0.75f);
                maxFrameWidth = this.getIntent().getFloatExtra("MAX_FRAME_WIDTH_PERCENTAGE", 0.99f);
                scanFrontOnly = this.getIntent().getBooleanExtra("SCAN_FRONT_ONLY", false) || imageType == CaptureIntent.TISDocumentType.PASSPORT;
                scanBackOnly = this.getIntent().getBooleanExtra("SCAN_BACK_ONLY", false);
                scanFrontOnly = scanBackOnly ? false : scanFrontOnly;
                isDynamicCapture = this.getIntent().getBooleanExtra("ENABLE_DYNAMIC_CAPTURE", false) && imageType != CaptureIntent.TISDocumentType.PASSPORT && (imageType != CaptureIntent.TISDocumentType.CARD || ocrType != Common.OCRType.CREDIT);
                deviceName = FileUtils.getDeviceName();
                maxNumberOfRetries = 1000;
                this.getIntent().getIntExtra("INTENT_MAX_NUMBER_OF_RETRIES", 5);
                this.minRatioHW = this.getIntent().getFloatExtra("INTENT_MIN_RATIO_HEIGHT_WIDTH", 0.3f);
                this.maxRatioHW = this.getIntent().getFloatExtra("INTENT_MAX_RATIO_HEIGHT_WIDTH", 0.65f);
                showGridInLivePreview = this.getIntent().getBooleanExtra("SHOW_GRID_IN_LIVE_PREVIEW", true);
                isBlurEnabled = this.getIntent().getBooleanExtra("IS_BLUR_ENABLED", false);
                isBlurOnBackEnabled = this.getIntent().getBooleanExtra("IS_BLUR_ENABLED_ON_BACK_SIDE", false);
                isUseCustomAlgorithmOnBack = false;
                outputHeightInInch = -1.0f;
                outputWidthInInch = -1.0f;
                txtValidFrom = this.getIntent().getIntExtra("INTENT_TXT_VALID_FROM", 10);
                txtValidTo = this.getIntent().getIntExtra("INTENT_TXT_VALID_TO", 50);
                shouldOutputGrayscaleImage = this.getIntent().getBooleanExtra("GRAY_SCALE", false);
                shouldOutputOriginalImage = this.getIntent().getBooleanExtra("SAVE_ORIGINAL_IMAGE", false);
                shouldOutputColoredImage = this.getIntent().getBooleanExtra("OUTPUT_COLORED_IMAGE", false);
                shouldOutputBWImage = this.getIntent().getBooleanExtra("OUTPUT_BW_IMAGE", true);
                showGuidelinesIndicators = this.getIntent().getBooleanExtra("GUIDLINES_INDICATOR", true);
                enableProcessingView = this.getIntent().getBooleanExtra("ENABLE_PROCESSING_VIEW", false);
                maxVideoFramesToProcess = this.getIntent().getIntExtra("MAX_VIDEO_FRAMES_TO_CAPTURE", 7);
                isBinarizeBackSameAsFront = this.getIntent().getBooleanExtra("IS_BINARIZE_BACK_SAME_AS_FRONT", false);
                isCustomView = this.getIntent().getBooleanExtra("IS_CUSTOM_VIEW", false);
                isMultiCapture = this.getIntent().getBooleanExtra("ENABLE_MULTI_CAPTURE", false);
                grayScaleSize = this.getIntent().getIntArrayExtra("GRAY_SCALE_SIZE");
                isIQAEnabled = this.getIntent().getBooleanExtra("INTENT_IQA_ENABLED", false);
                countDownSound = this.getIntent().getBooleanExtra("ENABLE_COUNTDOWN_SOUND", false);
                binarizationType = this.getIntent().getIntExtra("BINARIZATION_TYPE", 0);
                enableSoftCaptureAndImageAligment = this.getIntent().getBooleanExtra("ENABLE_SOFT_CAPTURE", false);
                enableTransitionBetweenRectangles = this.getIntent().getBooleanExtra("ENABLE_TRANSIATION_BETWEEN_ANIMATION", true);
                showErrorSignatureOverMICR = this.getIntent().getBooleanExtra("SHOW_ERROR_MICR_OVER_SIGNATURE", true);
                showMicrOverlay = this.getIntent().getBooleanExtra("INTENT_SHOW_MICR_OVERALY", false) && imageType == CaptureIntent.TISDocumentType.CHECK && ocrType == Common.OCRType.CMC7;
                useMaxResolutionStills = this.getIntent().getBooleanExtra("USE_MAX_RESOLUTION_STILLS", false);
                useCameraAPI2 = this.getIntent().getBooleanExtra("USE_CAMERA_API2", false);
                if (Build.VERSION.SDK_INT < 21) {
                    useCameraAPI2 = false;
                }
                if ((binarizationThreshold = this.getIntent().getFloatExtra("BINARIZATION_TRASHOLD", 30.0f)) > 0.0f && binarizationThreshold < 1.0f) {
                    binarizationThreshold *= 100.0f;
                }
                if (ocrType == Common.OCRType.CREDIT || imageType == CaptureIntent.TISDocumentType.PASSPORT) {
                    enableCroppingController = false;
                    enableManualCapture = false;
                } else {
                    enableManualCapture = this.getIntent().getBooleanExtra("INTENT_IS_MANUAL_CAPTURE", false);
                    enableCroppingController = this.getIntent().getBooleanExtra("INTENT_USE_CROPPING_CONTROLLER", false);
                }
                scanBarcodeLocation = CaptureIntent.TISScanBarcodeLocation.getEnum(this.getIntent().getIntExtra("SCAN_BARCODE_LOCATION", CaptureIntent.TISScanBarcodeLocation.BARCODE_NONE.getValue()));
                boolean bl = enableBarcodeDetection = scanBarcodeLocation != CaptureIntent.TISScanBarcodeLocation.BARCODE_NONE;
                if (enableBarcodeDetection) {
                    barcodeTypes = CameraTypes.TISBarcodeType.getEnumArrayListFromIntegerList(this.getIntent().getIntegerArrayListExtra("BARCODE_TYPES"));
                    if (barcodeTypes == null || barcodeTypes.size() == 0) {
                        barcodeTypes = BarcodeReader.getAllTISBarcodeTypes();
                    }
                    useQRFrameForBarcode = false;
                    for (CameraTypes.TISBarcodeType barcodeType : barcodeTypes) {
                        if (barcodeType != CameraTypes.TISBarcodeType.QR_CODE && barcodeType != CameraTypes.TISBarcodeType.DATA_MATRIX_CODE && barcodeType != CameraTypes.TISBarcodeType.AZTEC_CODE) continue;
                        useQRFrameForBarcode = true;
                        break;
                    }
                }
                colorImageCompression = Math.min(Math.max(this.getIntent().getFloatExtra("COLOR_IMAGE_COMPRESSION", 1.0f), 0.0f), 1.0f);
                softCaptureThreshold = enableSoftCaptureAndImageAligment ? this.getIntent().getFloatExtra("TIS_SOFT_CAPTURE_THRESHOLD", 0.0f) : 0.0f;
                if (sessionType == CaptureIntent.SessionType.TEST) {
                    CameraManagerController.initOcrAnalyzeSession(this.getApplicationContext(), ocrType, maxNumberOfRetries, this.minRatioHW, this.maxRatioHW, enableManualCapture, isUseCustomAlgorithmOnBack, isBinarizeBackSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo, isIQAEnabled, iqaSettings, false);
                    String folderLocation = this.getIntent().getStringExtra("FOLDER_LOCATION");
                    Bundle extras = new Bundle();
                    extras.putString("FOLDER_LOCATION", folderLocation);
                    Intent i = !isDynamicCapture ? new Intent(this.getBaseContext(), CameraController.class) : new Intent(this.getBaseContext(), DynamicCaptureCameraController.class);
                    isDebug = true;
                    i.putExtras(extras);
                    this.startActivityForResult(i, 111);
                }
                isInfoScreenEnable = this.getIntent().getBooleanExtra("INFO_SCREEN_ENABLED", true);
                infoScreenInterval = this.getIntent().getLongExtra("INFO_SCREEN_INTERVAL", 10000L);
                tapToFocus = this.getIntent().getBooleanExtra("TAP_TO_FOCUS", true);
                iqaSettings = this.populateIQASettings();
                this.setIndicatorsString();
            }
            colorImageCompression = Math.min(Math.max(this.getIntent().getFloatExtra("COLOR_IMAGE_COMPRESSION", 1.0f), 0.0f), 1.0f);
            grayScaleImageCompression = Math.min(Math.max(this.getIntent().getFloatExtra("GRAY_SCALE_IMAGE_COMPRESSION", 1.0f), 0.0f), 1.0f);
            Logger.setIsDebugMode(isDebug);
            Logger.setMinLogLevel(6);
            CameraManagerController.initOcrAnalyzeSession(this.getApplicationContext(), ocrType, maxNumberOfRetries, this.minRatioHW, this.maxRatioHW, enableManualCapture, isUseCustomAlgorithmOnBack, isBinarizeBackSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo, isIQAEnabled, iqaSettings, isBlurEnabled);
            isSessionStartsInStills = isStillMode = !this.getIntent().getBooleanExtra("ENABLE_VIDEO_MODE", false) || imageType == CaptureIntent.TISDocumentType.FULL_PAGE || !CameraConfigurationManager.isVideoModeSupported((Context)this) || enableManualCapture || enableCroppingController;
            boolean bl = showCountDown = this.getIntent().getBooleanExtra("SHOW_COUNT_DOWN", false) && isStillMode;
            if (isIQAEnabled || isStillMode || imageType != CaptureIntent.TISDocumentType.CHECK) {
                shouldOutputBWImage = true;
            }
            if (scanBackOnly) {
                int[] size = this.getIntent().getIntArrayExtra("FRONT_IMAGE_RECT_ARRAY");
                if (size != null) {
                    int[] nArray = new int[4];
                    nArray[2] = size[0];
                    nArray[3] = size[1];
                    CameraManagerController.getOcrAnalyzeSession((Context)this).frontImageRect = FileUtils.arrayToRect(nArray);
                }
                this.openCameraForBackCapture(false);
            } else if (sessionType != CaptureIntent.SessionType.TEST) {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (this.askPermission()) {
                        this.openCameraForFrontCapture(false);
                    }
                } else {
                    this.openCameraForFrontCapture(false);
                }
            }
            CameraController.timeVideoCaptureEnd = false;
            if (isDebug) {
                this.saveIncomingParametersToLogFile();
            }
        }
        catch (Exception e) {
            String errorMessage = Log.getStackTraceString((Throwable)e);
            if (errorMessage == null) {
                errorMessage = "";
            }
            if (isDebug) {
                FileUtils.addToLogFile(String.valueOf(this.tag) + " Exception ", errorMessage, this.getApplicationContext());
            }
            Intent data = new Intent();
            Log.e((String)this.tag, (String)errorMessage);
            data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
            this.setResult(119, data);
            this.finish();
        }
    }

    private IQASettingsIntent populateIQASettings() {
        if (this.getIntent().hasExtra("INTENT_IQA_SETTINGS")) {
            Bundle bundleIQASettings = this.getIntent().getBundleExtra("INTENT_IQA_SETTINGS");
            IQASettingsIntent iqaSettings = new IQASettingsIntent(bundleIQASettings);
            return iqaSettings;
        }
        IQASettingsIntent iqaSettings = new IQASettingsIntent();
        return iqaSettings;
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        isDebug = savedInstanceState.getBoolean("isDebug");
        ocrAnalyzeSession = new OCRAnalyzeSession(savedInstanceState.getBundle("ocrAnalyzeSession"));
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("isDebug", isDebug);
        Bundle data = this.getIntent().getExtras();
        outState.putAll(data);
        if (ocrAnalyzeSession != null) {
            outState.putBundle("ocrAnalyzeSession", ocrAnalyzeSession.toBundle());
        }
        super.onSaveInstanceState(outState);
    }

    private void checkExceptionalDevices() {
        try {
            int i;
            invertedCamera = false;
            String all = "all";
            String[] invertedCameraList = this.getResources().getStringArray(R.array.calculateVideoToScreenAspectRatio);
            String[] useAPI2DevicesList = this.getResources().getStringArray(R.array.exception_devices_use_cameraAPI2);
            if (!(invertedCameraList != null && invertedCameraList.length != 0 || useAPI2DevicesList != null && useAPI2DevicesList.length != 0)) {
                return;
            }
            if (invertedCameraList != null && invertedCameraList.length > 0) {
                i = 0;
                while (i < invertedCameraList.length) {
                    invertedCameraList[i] = invertedCameraList[i].trim().toLowerCase();
                    if (invertedCameraList[i].equals(all.trim())) {
                        invertedCamera = true;
                        return;
                    }
                    ++i;
                }
                if (Arrays.asList(invertedCameraList).contains(deviceName.trim().toLowerCase())) {
                    invertedCamera = true;
                    return;
                }
            }
            if (useAPI2DevicesList != null && useAPI2DevicesList.length > 0 && !isDynamicCapture && !useCameraAPI2) {
                i = 0;
                while (i < useAPI2DevicesList.length) {
                    useAPI2DevicesList[i] = useAPI2DevicesList[i].trim().toLowerCase();
                    if (useAPI2DevicesList[i].toLowerCase(Locale.US).equals(all.trim())) {
                        useCameraAPI2 = true;
                        return;
                    }
                    ++i;
                }
                if (Arrays.asList(useAPI2DevicesList).contains(deviceName.trim().toLowerCase())) {
                    useCameraAPI2 = true;
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.e(CameraController.TAG, Log.getStackTraceString((Throwable)e));
        }
    }

    private void openCameraForFrontCapture(boolean isProcessCurrentImage) {
        Bundle extras = new Bundle();
        if (isProcessCurrentImage) {
            extras.putBoolean(INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, isProcessCurrentImage);
        }
        CameraManagerController.ocrAnalyzeSession.captureMode = CameraTypes.CaptureMode.FRONT;
        CameraManagerController.ocrAnalyzeSession.isBarcodeSession = enableBarcodeDetection && (scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_FRONT || scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);
        ocrAnalyzeSession.setCreditCardSession(ocrType == Common.OCRType.CREDIT, this.getRequestedOrientation());
        Class activityToUse = !isDynamicCapture ? CameraController.class : DynamicCaptureCameraController.class;
        NavigationManager.getInstance().showNewScreen(this.baseController, activityToUse, extras, 10004, false);
    }

    public void openCameraForBackCapture(boolean isProcessCurrentImage) {
        Bundle extras = new Bundle();
        if (isProcessCurrentImage) {
            extras.putBoolean(INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, isProcessCurrentImage);
        }
        CameraManagerController.ocrAnalyzeSession.captureMode = CameraTypes.CaptureMode.BACK;
        CameraManagerController.ocrAnalyzeSession.isBarcodeSession = enableBarcodeDetection && (scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_BACK || scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);
        ocrAnalyzeSession.setCreditCardSession(false, this.getRequestedOrientation());
        isBlurEnabled = isBlurOnBackEnabled;
        Class activityToUse = !isDynamicCapture ? CameraController.class : DynamicCaptureCameraController.class;
        NavigationManager.getInstance().showNewScreen(this.baseController, activityToUse, extras, 10004, false);
    }

    private void finishActivityForResult(boolean isSuccess, int resultCode) {
        try {
            Logger.i(this.tag, "create session params");
            Intent data = new Intent();
            this.setResult(resultCode, data);
            String[] ocrData = null;
            String[] barcodeData = null;
            if (ocrAnalyzeSession == null) {
                this.finish();
            }
            if (isSuccess) {
                Logger.i(this.tag, "finishActivityForResult " + isSuccess);
                ocrData = new String[4];
                if (ocrType == Common.OCRType.CMC7) {
                    ocrData = new String[5];
                }
                if (ocrAnalyzeSession != null && ocrAnalyzeSession.getOCRAnalyzeResult() != null && ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult() != null) {
                    OCRResult ocrResult = ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult();
                    Logger.i(this.tag, "add ocr parameters to SessionResultParams");
                    if (ocrResult != null) {
                        ocrData[0] = String.valueOf(ocrResult.digitalRowLength);
                        ocrData[1] = ocrResult.ocrResultWithDelimiter;
                        ocrData[2] = ocrResult.ocrRawResult;
                        ocrData[3] = ocrResult.scoreResult;
                        if (ocrType == Common.OCRType.CMC7) {
                            String string2 = ocrData[4] = ocrResult.signatureOverMicrDetected == 1 ? "true" : "false";
                        }
                        if (ocrResult instanceof TISCreditCardProcessingResults) {
                            TISCreditCardProcessingResults creditCardResult = (TISCreditCardProcessingResults)ocrResult;
                            ocrData[0] = String.valueOf(creditCardResult.cardNumber.length());
                            ocrData[1] = creditCardResult.getResultString();
                            ocrData[2] = creditCardResult.cardNumber;
                            ocrData[3] = creditCardResult.isExpiryValid ? "1" : "0";
                        }
                    }
                } else {
                    ocrData = null;
                    Logger.i(this.tag, "no OCR Results found");
                }
                barcodeData = new String[4];
                BarcodeReader.BarcodeResult barcodeResult = ocrAnalyzeSession.getBarcodeResult();
                if (!barcodeResult.isEmpty()) {
                    barcodeData[0] = String.valueOf(barcodeResult.getBarcodeTypeFrontForBundle());
                    barcodeData[1] = barcodeResult.getBarcodeDataFront();
                    barcodeData[2] = String.valueOf(barcodeResult.getBarcodeTypeBackForBundle());
                    barcodeData[3] = barcodeResult.getBarcodeDataBack();
                } else {
                    barcodeData = null;
                }
                this.sessionResults = new SessionResultParams(ocrData, FileUtils.rectToIntArray(CameraManagerController.ocrAnalyzeSession.frontImageRect), CameraManagerController.ocrAnalyzeSession.frontRetries, CameraManagerController.ocrAnalyzeSession.backRetries, barcodeData);
                data.putExtra("SESSION_PARAMETERS", (Parcelable)this.sessionResults);
                Logger.i(this.tag, "cameraManager result OK");
            } else {
                Logger.i(this.tag, "finishActivityForResult " + isSuccess);
            }
        }
        catch (Exception e) {
            if (e == null) {
                Logger.i(this.tag, "Exception");
            }
            Logger.i(this.tag, "Exception " + e.getMessage());
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Logger.i(this.tag, "Enter CameraManager on");
        if (sessionType == CaptureIntent.SessionType.TEST) {
            Logger.i(this.tag, "finish test session");
            this.finish();
        }
        switch (resultCode) {
            case 0: {
                Logger.i(this.tag, "onActivityResult CAMERA_REQUEST_CODE");
                this.clearOcrAnalyzeSession();
                SessionResultParams.originalFront = null;
                SessionResultParams.originalBack = null;
                this.setResult(0);
                this.finish();
                break;
            }
            case -1: {
                this.setResult(-1, data);
                this.finishActivityForResult(true, resultCode);
                break;
            }
            case 114: {
                this.finishActivityForResult(false, resultCode);
                break;
            }
            case 113: {
                this.finishActivityForResult(true, resultCode);
                break;
            }
            case 112: {
                this.finishActivityForResult(true, resultCode);
                break;
            }
            case 119: {
                this.setResult(resultCode, data);
                this.finish();
                break;
            }
            default: {
                this.finishActivityForResult(true, resultCode);
            }
        }
    }

    private void getVersionNumber() {
        block3: {
            try {
                PackageInfo pInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
                String version = this.getResources().getString(R.string.TISVersion);
                Logger.i(this.tag, version);
                if (isDebug) {
                    FileUtils.addToLogFile(this.tag, "Version Number is " + version, this.getApplicationContext());
                }
            }
            catch (Exception e) {
                if (!isDebug) break block3;
                FileUtils.addToLogFile(this.tag, "Version Number Not found ", this.getApplicationContext());
            }
        }
    }

    public SessionResultParams getImageResult() {
        return this.sessionResults;
    }

    public static OCRAnalyzeSession getOcrAnalyzeSession(Context context) {
        return ocrAnalyzeSession;
    }

    public static void setOcrAnalyzeSession(OCRAnalyzeSession ocrAnalyzeSession) {
        CameraManagerController.ocrAnalyzeSession = ocrAnalyzeSession;
    }

    public static OCRAnalyzeSession initOcrAnalyzeSession(Context context, Common.OCRType micrType, int maxNumberOfRetries, float minimumRatioHeightWidth, float maxRatioHeightWidth, boolean isManualCapture, boolean isUseCustomAlgorithmOnBack, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack, float maxRatioHWBack, int txtValidFrom, int txtValidTo, boolean isIQAEnabled, IQASettingsIntent iqaSettings, boolean isBlurEnabled) {
        CameraManagerController.setOcrAnalyzeSession(new OCRAnalyzeSession(context, micrType, maxNumberOfRetries, minimumRatioHeightWidth, maxRatioHeightWidth, isManualCapture, isUseCustomAlgorithmOnBack, isBinarizeBakSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo, isIQAEnabled, iqaSettings, null, isBlurEnabled));
        return ocrAnalyzeSession;
    }

    public void clearOcrAnalyzeSession() {
        if (ocrAnalyzeSession != null) {
            ocrAnalyzeSession.clear();
            ocrAnalyzeSession = null;
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    public String[] setIndicatorsString() {
        indicatorString = new String[17];
        CameraManagerController.indicatorString[0] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorTop");
        CameraManagerController.indicatorString[1] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorDown");
        CameraManagerController.indicatorString[2] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorLeft");
        CameraManagerController.indicatorString[3] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorRight");
        CameraManagerController.indicatorString[4] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorHold");
        CameraManagerController.indicatorString[5] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorAlign");
        CameraManagerController.indicatorString[6] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorRotateLeft");
        CameraManagerController.indicatorString[7] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorRotateRight");
        CameraManagerController.indicatorString[8] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorZoomIn");
        CameraManagerController.indicatorString[9] = StringUtils.dynamicString((Context)this, "TISFlowIindicatorZoomOut");
        CameraManagerController.indicatorString[10] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorLight");
        CameraManagerController.indicatorString[11] = StringUtils.dynamicString((Context)this, "ic_indicator_blur");
        CameraManagerController.indicatorString[12] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorAlignFlat");
        CameraManagerController.indicatorString[13] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorScanBarcode");
        CameraManagerController.indicatorString[14] = StringUtils.dynamicString((Context)this, "TISAspectRatioError");
        CameraManagerController.indicatorString[15] = StringUtils.dynamicString((Context)this, "TISFlowIndicatorScanCreditCard");
        CameraManagerController.indicatorString[16] = StringUtils.dynamicString((Context)this, "TISFlowInvalidRotation");
        return indicatorString;
    }

    private void saveIncomingParametersToLogFile() {
        try {
            FileUtils.addToLogFile("device: " + deviceName, (Context)this);
            FileUtils.addToLogFile("Version Number " + this.getString(R.string.TISVersion), (Context)this);
            FileUtils.addToLogFile("Debug " + isDebug, (Context)this);
            FileUtils.addToLogFile("scanBackOnly " + scanBackOnly, (Context)this);
            FileUtils.addToLogFile("scanFrontOnly " + scanFrontOnly, (Context)this);
            FileUtils.addToLogFile("frontImageRectArray " + frontImageRectArray, (Context)this);
            FileUtils.addToLogFile("shouldOutputGrayscaleImage " + shouldOutputGrayscaleImage, (Context)this);
            FileUtils.addToLogFile("shouldOutputOriginalImage " + shouldOutputOriginalImage, (Context)this);
            FileUtils.addToLogFile("shouldOutputColoredImage " + shouldOutputColoredImage, (Context)this);
            FileUtils.addToLogFile("shouldOutputBWImage " + shouldOutputBWImage, (Context)this);
            FileUtils.addToLogFile("isStillMode " + isStillMode, (Context)this);
            FileUtils.addToLogFile("isInfoScreenEnable " + isInfoScreenEnable, (Context)this);
            FileUtils.addToLogFile("infoScreenInterval " + infoScreenInterval, (Context)this);
            FileUtils.addToLogFile("isBlurEnabled " + isBlurEnabled, (Context)this);
            FileUtils.addToLogFile("isBlurOnBackSideEnabled " + isBlurOnBackEnabled, (Context)this);
            FileUtils.addToLogFile("maxVideoFramesToProcess " + maxVideoFramesToProcess, (Context)this);
            if (imageType != null && imageType.name() != null) {
                FileUtils.addToLogFile("imageType " + imageType.name(), (Context)this);
            }
            if (sessionType != null && sessionType.name() != null) {
                FileUtils.addToLogFile("sessionType " + sessionType.name(), (Context)this);
            }
            FileUtils.addToLogFile("showGuidelinesIndicators " + showGuidelinesIndicators, (Context)this);
            FileUtils.addToLogFile("enableSoftCaptureAndImageAligment " + enableSoftCaptureAndImageAligment, (Context)this);
            FileUtils.addToLogFile("countDownSound " + countDownSound, (Context)this);
            FileUtils.addToLogFile("continueNotSupportedHw " + continueNotSupportedHw, (Context)this);
            FileUtils.addToLogFile("isMultiCapture " + isMultiCapture, (Context)this);
            FileUtils.addToLogFile("isCustomView " + isCustomView, (Context)this);
            FileUtils.addToLogFile("enableProcessingView " + enableProcessingView, (Context)this);
            FileUtils.addToLogFile("falseRecognitionVideoFrames " + falseRecognitionVideoFrames, (Context)this);
            FileUtils.addToLogFile("enableProcessingView " + enableProcessingView, (Context)this);
            FileUtils.addToLogFile("showCountDown " + showCountDown, (Context)this);
            FileUtils.addToLogFile("isSessionStartsInStills " + isSessionStartsInStills, (Context)this);
            FileUtils.addToLogFile("isDynamicCapture " + isDynamicCapture, (Context)this);
            FileUtils.addToLogFile("enableBarcodeDetection " + enableBarcodeDetection, (Context)this);
            FileUtils.addToLogFile("useMaxResolutionStills " + useMaxResolutionStills, (Context)this);
            FileUtils.addToLogFile("AspectRatioMax " + this.maxRatioHW + " AspectRatioMin " + this.minRatioHW, (Context)this);
            FileUtils.addToLogFile("enableCroppingController " + enableCroppingController, (Context)this);
            FileUtils.addToLogFile("enableManualCapture " + enableManualCapture, (Context)this);
        }
        catch (Exception e) {
            String errorMessage = Log.getStackTraceString((Throwable)e);
            if (errorMessage == null) {
                errorMessage = "";
            }
            if (isDebug) {
                FileUtils.addToLogFile(String.valueOf(this.tag) + " Exception ", errorMessage, this.getApplicationContext());
            }
            Intent data = new Intent();
            Log.e((String)this.tag, (String)errorMessage);
            data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
            this.setResult(119, data);
        }
    }

    public static int getDocumentAsInt(CaptureIntent.TISDocumentType image) {
        switch (image) {
            case CHECK: {
                return 0;
            }
            case PAYMENT: {
                return 1;
            }
            case FULL_PAGE: {
                return 2;
            }
            case CUSTOM: {
                return 3;
            }
            case PASSPORT: {
                return 4;
            }
            case CARD: {
                return 5;
            }
        }
        return -1;
    }

    private void setScreenOrientation() {
        if (imageType == CaptureIntent.TISDocumentType.FULL_PAGE || sessionType == CaptureIntent.SessionType.PORTRAIT) {
            this.setRequestedOrientation(1);
        } else {
            int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
            if (rotation == 0) {
                this.setRequestedOrientation(0);
            } else if (rotation == 3) {
                this.setRequestedOrientation(8);
            } else if (rotation == 1) {
                this.setRequestedOrientation(0);
            } else if (rotation == 2) {
                this.setRequestedOrientation(8);
            }
        }
    }

    protected void onDestroy() {
        block2: {
            try {
                super.onDestroy();
            }
            catch (Exception e) {
                if (!isDebug) break block2;
                Logger.e(this.tag, Log.getStackTraceString((Throwable)e));
                FileUtils.addToLogFile(Log.getStackTraceString((Throwable)e), (Context)this);
            }
        }
    }

    @TargetApi(value=23)
    private boolean askPermission() {
        String permission;
        PackageManager pm = this.getPackageManager();
        int res = pm.checkPermission(permission = "android.permission.CAMERA", this.getPackageName());
        if (res == 0) {
            return true;
        }
        this.requestPermissions(new String[]{"android.permission.CAMERA"}, 111);
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 111: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.initSession();
                } else {
                    Intent data = new Intent();
                    String errorMessage = "Camera Permission was not Aprroved";
                    data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
                    this.setResult(120, data);
                    this.finish();
                }
                return;
            }
        }
    }

    public String checkLicenseValidation(TISLicenseParameters lisenceData) {
        String[] decryptValues;
        String lisenceResult;
        block19: {
            String licenseVersion;
            lisenceResult = INVALID_LISENSE_GENERAL;
            if (this.getPackageName().equals("com.topimagesystems.sample")) {
                lisenceResult = VALID_LISENSE_KEY;
                return lisenceResult;
            }
            if (lisenceData.getLicense().length() < 1) {
                lisenceResult = INVALID_LISENSE_GENERAL;
                return lisenceResult;
            }
            if (lisenceData == null || lisenceData.getLicense() == null || lisenceData.getLicenseKey() == null || lisenceData.getActiveLicense() == null) {
                return lisenceResult;
            }
            String iv = "9Image!Systems1%";
            byte[] ivBytes = iv.getBytes("US-ASCII");
            CryptLib crypt = new CryptLib();
            crypt._iv = ivBytes;
            String licenseKey = lisenceData.getLicenseKey().substring(0, 32);
            String decryptedLicense = crypt.decrypt(lisenceData.getActiveLicense(), licenseKey, null);
            decryptValues = decryptedLicense.split(";");
            if (!decryptValues[0].equals(lisenceData.getLicense())) {
                lisenceResult = INVALID_LISENSE;
                return INVALID_LISENSE;
            }
            if (!decryptValues[1].equals(lisenceData.getLicenseKey())) {
                lisenceResult = INVALID_LISENSE_KEY;
                return INVALID_LISENSE_KEY;
            }
            String currVersion = this.getResources().getString(R.string.TISVersion).substring(0, 5);
            if (!currVersion.equals(licenseVersion = decryptValues[2].substring(0, 5))) {
                lisenceResult = INVALID_SDK_VERSION;
                return INVALID_SDK_VERSION;
            }
            lisenceResult = VALID_LISENSE_KEY;
            if (!decryptValues[3].equals("00000000")) break block19;
            return VALID_LISENSE_KEY;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
            String currentDateAndTime = dateFormat.format(new Date());
            if (decryptValues[3].length() != 8) {
                lisenceResult = INVALID_EXPERATION_DATE;
                return INVALID_EXPERATION_DATE;
            }
            Date strDate = dateFormat.parse(decryptValues[3]);
            if (currentDateAndTime.equals(decryptValues[3])) {
                lisenceResult = VALID_LISENSE_KEY;
                return VALID_LISENSE_KEY;
            }
            if (new Date().after(strDate)) {
                lisenceResult = INVALID_EXPERATION_DATE;
                return INVALID_EXPERATION_DATE;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return lisenceResult;
    }

    @Override
    protected void ensureActionBar() {
    }

    public static interface TISMobiFlowMessages {
        public void onMobiFlowGeneralMessageReceived(CameraTypes.TISFlowGeneralMessages var1, Object[] var2, Context var3);

        public void onMobiFlowErrorMessageReceived(CameraTypes.TISFlowErrorMessage var1, Object[] var2, Context var3);

        public void onMobiFlowUIEventMessageReceived(CameraTypes.TISFlowUIMessages var1, ViewGroup var2);

        public void onFailed();
    }
}

