/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.micr;

import com.topimagesystems.R;

public class OCRCommon {

    public static enum ErrorCode {
        ok(0, R.string.TISFlowOK),
        detectableColor(1, R.string.TISFlowErrorIQANumSpots),
        notValidBoundaries(2, R.string.TISErrorNotValidBoundaries),
        emptyImage(3, R.string.TISFlowErrorNotValidImageSize),
        errorMinImageSizeInBytes(4, R.string.TISFlowErrorNotValidImageSize),
        errorMinImageDimensions(5, R.string.TISFlowErrorMinImageDimensions),
        errorIQACornerData(6, R.string.TISFlowErrorIQACornerData),
        errorIQAEdgeData(7, R.string.TISFlowErrorIQAEdgeData),
        errorIQASkew(8, R.string.TISFlowErrorIQASkew),
        errorIQADarkness(9, R.string.TISFlowErrorIQADarkness),
        errorIQANumSpots(10, R.string.TISFlowErrorIQANumSpots),
        errorIQAPiggyBack(23, R.string.TISFlowErrorPiggyBack),
        errorIQAHorizontalStreak(20, R.string.TISFlowErrorHorizontalStreaks),
        errorIQACarbonStrip(22, R.string.TISFlowErrorCarbonStrip),
        errorNoValidBoundingBox(11, R.string.TISFlowErrorNoValidBoundingBox),
        errorNotValidImageSize(12, R.string.TISFlowErrorNotValidImageSize),
        errorFileTooSmall(13, R.string.TISFlowErrorFileTooSmall),
        errorUnknown(14, R.string.TISFlowErrorUnknown),
        errorBlurDetectionFailed(15, R.string.TISErrorBlurFail),
        errorMicrInterrupted(16, R.string.TISFlowMicrInterrupted),
        errorMICRDetectedOnCheckBack(19, R.string.TISFlowWarningMICRDetectedOnCheckBack),
        errorPassportNotFound(17, R.string.TISFlowErrorReadingOCRMessage),
        errorPanNotFound(18, R.string.TISFlowErrorReadingOCRMessage),
        errorInializeOCR(21, R.string.TISFlowErrorReadingOCRMessage),
        error_deviceMemory(22, R.string.TISErrorDeviceMemory),
        errorOcrReading(23, R.string.TISFlowErrorReadingOCRMessage),
        errorBarcodeNotFound(24, R.string.TISFlowErrorReadingOCRMessage),
        errorMicrLength(25, R.string.TISFlowErrorMicrLength);

        int id;
        int resourceId;

        private ErrorCode(int id2, int resourceId) {
            this.id = id2;
            this.resourceId = resourceId;
        }

        public int getId() {
            return this.id;
        }

        public int getResourceId() {
            return this.resourceId;
        }

        public static ErrorCode instanceOf(int errorCodeId) {
            if (errorCodeId == ErrorCode.ok.id) {
                return ok;
            }
            if (errorCodeId == ErrorCode.errorInializeOCR.id) {
                return errorInializeOCR;
            }
            if (errorCodeId == ErrorCode.detectableColor.id) {
                return detectableColor;
            }
            if (errorCodeId == ErrorCode.notValidBoundaries.id) {
                return notValidBoundaries;
            }
            if (errorCodeId == ErrorCode.emptyImage.id) {
                return emptyImage;
            }
            if (errorCodeId == ErrorCode.errorMinImageSizeInBytes.id) {
                return errorMinImageSizeInBytes;
            }
            if (errorCodeId == ErrorCode.errorMinImageDimensions.id) {
                return errorMinImageDimensions;
            }
            if (errorCodeId == ErrorCode.errorIQACornerData.id) {
                return errorIQACornerData;
            }
            if (errorCodeId == ErrorCode.errorIQAEdgeData.id) {
                return errorIQAEdgeData;
            }
            if (errorCodeId == ErrorCode.errorIQASkew.id) {
                return errorIQASkew;
            }
            if (errorCodeId == ErrorCode.errorIQADarkness.id) {
                return errorIQADarkness;
            }
            if (errorCodeId == ErrorCode.errorIQANumSpots.id) {
                return errorIQANumSpots;
            }
            if (errorCodeId == ErrorCode.errorIQANumSpots.id) {
                return errorIQANumSpots;
            }
            if (errorCodeId == ErrorCode.errorIQACarbonStrip.id) {
                return errorIQACarbonStrip;
            }
            if (errorCodeId == ErrorCode.errorIQAHorizontalStreak.id) {
                return errorIQAHorizontalStreak;
            }
            if (errorCodeId == ErrorCode.errorIQAPiggyBack.id) {
                return errorIQAPiggyBack;
            }
            if (errorCodeId == ErrorCode.errorFileTooSmall.id) {
                return errorFileTooSmall;
            }
            if (errorCodeId == ErrorCode.errorNotValidImageSize.id) {
                return errorNotValidImageSize;
            }
            if (errorCodeId == ErrorCode.errorNoValidBoundingBox.id) {
                return errorNoValidBoundingBox;
            }
            if (errorCodeId == ErrorCode.errorUnknown.id) {
                return errorUnknown;
            }
            if (errorCodeId == ErrorCode.errorBlurDetectionFailed.id) {
                return errorBlurDetectionFailed;
            }
            if (errorCodeId == ErrorCode.errorOcrReading.id) {
                return errorOcrReading;
            }
            if (errorCodeId == ErrorCode.errorMicrLength.id) {
                return errorMicrLength;
            }
            if (errorCodeId == ErrorCode.errorMicrInterrupted.id) {
                return errorMicrInterrupted;
            }
            if (errorCodeId == ErrorCode.errorPanNotFound.id) {
                return errorPanNotFound;
            }
            if (errorCodeId == ErrorCode.errorPassportNotFound.id) {
                return errorPassportNotFound;
            }
            return null;
        }
    }

    public static enum OCRDetectorStatus {
        OCRDetectorStatusPreparing(0, R.string.TISFlowPreparingImage),
        OCRDetectorStatusValidating(1, R.string.TISFlowValidatingImage),
        OCRDetectorStatusPerforming(2, R.string.TISFlowPerformingOCR),
        OCRDetectorStatusLocatingBounderies(3, R.string.TISFlowPreparingForServerLocatingBoundaries),
        OCRDetectorStatusImageCropping(4, R.string.TISFlowPreparingForServerCropping),
        OCRDetectorStatusImageBinarazing(5, R.string.TISFlowPreparingForServerBinarizing);

        int id;
        int resourceId;

        private OCRDetectorStatus(int id2, int resourceId) {
            this.id = id2;
            this.resourceId = resourceId;
        }

        public int getId() {
            return this.id;
        }

        public int getResourceId() {
            return this.resourceId;
        }

        public static OCRDetectorStatus instanceOf(int codeId) {
            if (codeId == OCRDetectorStatus.OCRDetectorStatusPreparing.id) {
                return OCRDetectorStatusPreparing;
            }
            if (codeId == OCRDetectorStatus.OCRDetectorStatusValidating.id) {
                return OCRDetectorStatusValidating;
            }
            if (codeId == OCRDetectorStatus.OCRDetectorStatusPerforming.id) {
                return OCRDetectorStatusPerforming;
            }
            if (codeId == OCRDetectorStatus.OCRDetectorStatusLocatingBounderies.id) {
                return OCRDetectorStatusLocatingBounderies;
            }
            if (codeId == OCRDetectorStatus.OCRDetectorStatusImageCropping.id) {
                return OCRDetectorStatusImageCropping;
            }
            if (codeId == OCRDetectorStatus.OCRDetectorStatusImageBinarazing.id) {
                return OCRDetectorStatusImageBinarazing;
            }
            return null;
        }
    }
}

