/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.micr;

import android.content.Context;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class JavaNotifier {
    private static final String tag = Logger.makeLogTag("JavaNotifier");
    private CameraController.CameraActivityHandler handler;
    private Context context;

    public JavaNotifier(CameraController.CameraActivityHandler handler, Context context) {
        this.handler = handler;
        this.context = context;
    }

    public int notify(int messageCode) {
        OCRCommon.OCRDetectorStatus ocrDetectorStatus = OCRCommon.OCRDetectorStatus.instanceOf(messageCode);
        if (ocrDetectorStatus == null) {
            Logger.e(tag, "no matching notify message for :" + messageCode);
        }
        return 0;
    }

    public void abort(String why) {
        Logger.e(tag, "abort is called ! why:" + why);
    }

    void nativeCrashed() {
        new RuntimeException("crashed here (native trace should follow after the Java trace)").printStackTrace();
    }

    String getStackTrace(Throwable t) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(b, true));
        return b.toString();
    }
}

