/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit.i18n;

import android.util.Log;
import com.topimagesystems.credit.i18n.SupportedLocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class I18nManager<E extends Enum<?>> {
    private static final String TAG = I18nManager.class.getSimpleName();
    private static final Map<String, String> SPECIAL_LOCALE_MAP = new HashMap<String, String>();
    private static final Set<String> RIGHT_TO_LEFT_LOCALE_SET = new HashSet<String>();
    private Map<String, SupportedLocale<E>> supportedLocales = new LinkedHashMap<String, SupportedLocale<E>>();
    private SupportedLocale<E> currentLocale;
    private Class<E> enumClazz;

    static {
        SPECIAL_LOCALE_MAP.put("zh_CN", "zh-Hans");
        SPECIAL_LOCALE_MAP.put("zh_TW", "zh-Hant_TW");
        SPECIAL_LOCALE_MAP.put("zh_HK", "zh-Hant");
        SPECIAL_LOCALE_MAP.put("en_UK", "en_GB");
        SPECIAL_LOCALE_MAP.put("en_IE", "en_GB");
        SPECIAL_LOCALE_MAP.put("iw_IL", "he");
        SPECIAL_LOCALE_MAP.put("no", "nb");
        RIGHT_TO_LEFT_LOCALE_SET.add("he");
        RIGHT_TO_LEFT_LOCALE_SET.add("ar");
    }

    public I18nManager(Class<E> enumClazz, List<SupportedLocale<E>> locales) {
        this.enumClazz = enumClazz;
        for (SupportedLocale<E> locale : locales) {
            this.addLocale(locale);
        }
        this.setLanguage(null);
    }

    private void logMissingLocalizations(String localeName) {
        List<String> errorMessages = this.getMissingLocaleMessages(localeName);
        for (String errorMessage : errorMessages) {
            Log.i((String)TAG, (String)errorMessage);
        }
    }

    public List<String> getMissingLocaleMessages() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String locale : this.supportedLocales.keySet()) {
            errorMessages.addAll(this.getMissingLocaleMessages(locale));
        }
        return errorMessages;
    }

    private List<String> getMissingLocaleMessages(String localeName) {
        SupportedLocale<Enum> locale = this.supportedLocales.get(localeName);
        ArrayList<String> errorMessages = new ArrayList<String>();
        Log.i((String)TAG, (String)("Checking locale " + localeName));
        Enum[] enumArray = (Enum[])this.enumClazz.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum key = enumArray[n2];
            String prettyKeyValue = "[" + localeName + "," + key + "]";
            if (locale.getAdaptedDisplay(key, null) == null) {
                errorMessages.add("Missing " + prettyKeyValue);
            }
            ++n2;
        }
        return errorMessages;
    }

    public void setLanguage(String localeSpecifier) {
        Log.d((String)TAG, (String)("setLanguage(" + localeSpecifier + ")"));
        this.currentLocale = null;
        this.currentLocale = this.getLocaleFromSpecifier(localeSpecifier);
        assert (this.currentLocale != null);
        Log.d((String)TAG, (String)("setting locale to:" + this.currentLocale.getName()));
    }

    public SupportedLocale<E> getLocaleFromSpecifier(String localeSpecifier) {
        SupportedLocale<E> foundLocale = null;
        if (localeSpecifier != null) {
            foundLocale = this.lookupSupportedLocale(localeSpecifier);
        }
        if (foundLocale == null) {
            String phoneLanguage = Locale.getDefault().toString();
            Log.d((String)TAG, (String)(String.valueOf(localeSpecifier) + " not found.  Attempting to look for " + phoneLanguage));
            foundLocale = this.lookupSupportedLocale(phoneLanguage);
        }
        if (foundLocale == null) {
            Log.d((String)TAG, (String)"defaulting to english");
            foundLocale = this.supportedLocales.get("en");
        }
        assert (foundLocale != null);
        return foundLocale;
    }

    private SupportedLocale<E> lookupSupportedLocale(String localeSpecifier) {
        if (localeSpecifier == null || localeSpecifier.length() < 2) {
            return null;
        }
        SupportedLocale<E> supportedLocale = null;
        if (SPECIAL_LOCALE_MAP.containsKey(localeSpecifier)) {
            String localeToUse = SPECIAL_LOCALE_MAP.get(localeSpecifier);
            supportedLocale = this.supportedLocales.get(localeToUse);
            Log.d((String)TAG, (String)("Overriding locale specifier " + localeSpecifier + " with " + localeToUse));
        }
        if (supportedLocale == null) {
            String language_country = localeSpecifier.contains("_") ? localeSpecifier : String.valueOf(localeSpecifier) + "_" + Locale.getDefault().getCountry();
            supportedLocale = this.supportedLocales.get(language_country);
        }
        if (supportedLocale == null) {
            supportedLocale = this.supportedLocales.get(localeSpecifier);
        }
        if (supportedLocale == null) {
            String languageCode = localeSpecifier.substring(0, 2);
            supportedLocale = this.supportedLocales.get(languageCode);
        }
        return supportedLocale;
    }

    public String getString(E key) {
        return this.getString(key, this.currentLocale);
    }

    public String getString(E key, SupportedLocale<E> localeToTranslate) {
        String countryCode = Locale.getDefault().getCountry().toUpperCase(Locale.US);
        String s = localeToTranslate.getAdaptedDisplay(key, countryCode);
        if (s == null) {
            String errorMessage = "Missing localized string for [" + this.currentLocale.getName() + ",Key." + ((Enum)key).toString() + "]";
            Log.i((String)TAG, (String)errorMessage);
            s = this.supportedLocales.get("en").getAdaptedDisplay(key, countryCode);
        }
        if (s == null) {
            Log.i((String)TAG, (String)("Missing localized string for [en,Key." + ((Enum)key).toString() + "], so defaulting to keyname"));
            s = ((Enum)key).toString();
        }
        return s;
    }

    public List<String> getSupportedLocales() {
        return new ArrayList<String>(this.supportedLocales.keySet());
    }

    private void addLocale(SupportedLocale<E> supportedLocale) {
        String localeName = supportedLocale.getName();
        if (localeName == null) {
            throw new RuntimeException("Null localeName");
        }
        if (this.supportedLocales.containsKey(localeName)) {
            throw new RuntimeException("Locale " + localeName + " already added");
        }
        this.supportedLocales.put(localeName, supportedLocale);
        this.logMissingLocalizations(localeName);
    }

    public boolean isCurrentLocaleRightToLeftLang() {
        return RIGHT_TO_LEFT_LOCALE_SET.contains(this.currentLocale.getName());
    }
}

