/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.credit;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.hardware.Camera;
import android.os.Build;
import android.os.Debug;
import android.util.Log;
import com.topimagesystems.credit.CameraUnavailableException;
import com.topimagesystems.credit.CardScanner;
import java.util.List;

public class Util {
    private static final String TAG = Util.class.getSimpleName();
    private static final boolean TORCH_BLACK_LISTED = Build.MODEL.equals("DROID2");
    public static final String PUBLIC_LOG_TAG = "card.io";
    private static Boolean sHardwareSupported;

    public static boolean deviceSupportsTorch(Context context) {
        return !TORCH_BLACK_LISTED && context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public static String manifestHasConfigChange(ResolveInfo resolveInfo, Class activityClass) {
        String error = null;
        if (resolveInfo == null) {
            error = String.format("Didn't find %s in the AndroidManifest.xml", activityClass.getName());
        } else if (!Util.hasConfigFlag(resolveInfo.activityInfo.configChanges, 128)) {
            error = String.valueOf(activityClass.getName()) + " requires attribute android:configChanges=\"orientation\"";
        }
        if (error != null) {
            Log.e((String)PUBLIC_LOG_TAG, (String)error);
        }
        return error;
    }

    public static boolean hasConfigFlag(int config, int configFlag) {
        return (config & configFlag) == configFlag;
    }

    public static boolean hardwareSupported() {
        if (sHardwareSupported == null) {
            sHardwareSupported = Util.hardwareSupportCheck();
        }
        return sHardwareSupported;
    }

    private static boolean hardwareSupportCheck() {
        Log.i((String)PUBLIC_LOG_TAG, (String)"Checking hardware support...");
        if (!CardScanner.processorSupported()) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- Processor type is not supported");
            return false;
        }
        Camera c = null;
        try {
            c = Camera.open();
        }
        catch (RuntimeException e) {
            if (Build.VERSION.SDK_INT >= 23) {
                return true;
            }
            Log.w((String)PUBLIC_LOG_TAG, (String)("- Error opening camera: " + e));
            throw new CameraUnavailableException();
        }
        if (c == null) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- No camera found");
            return false;
        }
        List list = c.getParameters().getSupportedPreviewSizes();
        c.release();
        boolean supportsVGA = false;
        for (Camera.Size s : list) {
            if (s.width != 640 || s.height != 480) continue;
            supportsVGA = true;
            break;
        }
        if (!supportsVGA) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- Camera resolution is insufficient");
            return false;
        }
        return true;
    }

    public static String getNativeMemoryStats() {
        return "(free/alloc'd/total)" + Debug.getNativeHeapFreeSize() + "/" + Debug.getNativeHeapAllocatedSize() + "/" + Debug.getNativeHeapSize();
    }

    public static void logNativeMemoryStats() {
        Log.d((String)"MEMORY", (String)("Native memory stats: " + Util.getNativeMemoryStats()));
    }

    public static Rect rectGivenCenter(Point center, int width, int height) {
        return new Rect(center.x - width / 2, center.y - height / 2, center.x + width / 2, center.y + height / 2);
    }

    public static void setupTextPaintStyle(Paint paint) {
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        paint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
        paint.setAntiAlias(true);
        float[] black = new float[]{0.0f, 0.0f, 0.0f};
        paint.setShadowLayer(1.5f, 0.5f, 0.0f, Color.HSVToColor((int)200, (float[])black));
    }
}

