/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import java.util.ArrayList;
import java.util.List;

public class StabilityDetection {

    static class SampleList {
        private SampleNode head;

        SampleList() {
        }

        SampleNode acquire() {
            SampleNode acquired = this.head;
            if (acquired == null) {
                acquired = new SampleNode();
            } else {
                this.head = acquired.next;
            }
            return acquired;
        }

        void release(SampleNode sample) {
            sample.next = this.head;
            this.head = sample;
        }
    }

    static class SampleNode {
        long timestamp;
        boolean accelerating;
        SampleNode next;

        SampleNode() {
        }
    }

    static class StableSampleQueue {
        private static final long MAX_WINDOW_SIZE = 250000000L;
        private static final long MIN_WINDOW_SIZE = 125000000L;
        private static final int MIN_QUEUE_SIZE = 4;
        private final SampleList pool = new SampleList();
        private SampleNode oldest;
        private SampleNode newest;
        private int sampleCount;
        private int stableCount;

        StableSampleQueue() {
        }

        void addSample(long timestamp, boolean accelerating) {
            while (this.sampleCount >= 4 && this.oldest != null && timestamp - 250000000L - this.oldest.timestamp > 0L) {
                SampleNode removed = this.oldest;
                if (!removed.accelerating) {
                    --this.stableCount;
                }
                --this.sampleCount;
                this.oldest = removed.next;
                if (this.oldest == null) {
                    this.newest = null;
                }
                this.pool.release(removed);
            }
            SampleNode added = this.pool.acquire();
            added.timestamp = timestamp;
            added.accelerating = accelerating;
            added.next = null;
            if (this.newest != null) {
                this.newest.next = added;
            }
            this.newest = added;
            if (this.oldest == null) {
                this.oldest = added;
            }
            ++this.sampleCount;
            if (!accelerating) {
                ++this.stableCount;
            }
        }

        void clear() {
            while (this.oldest != null) {
                SampleNode removed = this.oldest;
                this.oldest = removed.next;
                this.pool.release(removed);
            }
            this.newest = null;
            this.sampleCount = 0;
            this.stableCount = 0;
        }

        List<SampleNode> asList() {
            ArrayList<SampleNode> list = new ArrayList<SampleNode>();
            SampleNode s = this.oldest;
            while (s != null) {
                list.add(s);
                s = s.next;
            }
            return list;
        }

        boolean isStable() {
            return this.newest != null && this.oldest != null && this.newest.timestamp - this.oldest.timestamp >= 125000000L && this.stableCount >= (this.sampleCount >> 1) + (this.sampleCount >> 2);
        }
    }
}

