/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.topimagesystems.Common;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.controllers.imageanalyze.PreviewCallback;
import com.topimagesystems.controllers.imageanalyze.RawImagesFlowManager;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.ImageSessionResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.ArrayList;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class ProcessStillImageThread
extends Thread {
    private static final String tag = Logger.makeLogTag("ProcessStillImageThread");
    private CameraSessionManager cameraSessionManager;
    private MobiCHECKOCR mobiCHECKOCR;
    private Handler handler;
    private Context context;
    private int timestamp;
    private int displayWidth;
    private OCRResult ocrData;
    private BoundingBoxResult rect;
    private Rect videoRect;
    private boolean isFrontCapture;
    private boolean foundMicrOnBackSide;
    private long lastFocusRequestTime;
    private ImageSessionResult imageResult = null;
    private Rect adjustedCheckRect;
    private Mat[] images;
    private final int MAX_BLUR_RECTS_FRONT = 1;
    private final int MAX_BLUR_RECTS_BACK = 2;
    private Mat currentMat = null;
    byte[] uploadImageData;

    public ProcessStillImageThread(Context context, Handler handler, MobiCHECKOCR mobiCHECKOCR, boolean isDebug, int timestamp) {
        this.handler = handler;
        this.mobiCHECKOCR = mobiCHECKOCR;
        this.context = context;
        this.cameraSessionManager = CameraSessionManager.getInstance();
        this.timestamp = timestamp;
        this.images = new Mat[1];
    }

    @Override
    public void run() {
        try {
            Message message;
            if (PreviewCallback.processingVideo) {
                return;
            }
            PreviewCallback.processingVideo = true;
            this.foundMicrOnBackSide = false;
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("process time starts ", FileUtils.getCurrentTime(), this.context);
            }
            String currentDateAndTime = FileUtils.getCurrentTime();
            Logger.d(tag, "starting time" + currentDateAndTime, null);
            this.displayWidth = CameraManagerController.sessionType != CaptureIntent.SessionType.TEST ? UserInterfaceUtils.getDisplayDimensions((Context)this.context).x : 1280;
            OCRResult result = new OCRResult();
            this.isFrontCapture = CameraManagerController.getOcrAnalyzeSession((Context)this.context).captureMode == CameraTypes.CaptureMode.FRONT && !CameraManagerController.scanBackOnly;
            this.videoRect = this.cameraSessionManager.getVideoRect() == null || CameraController.doOcrOnly || CameraManagerController.sessionType == CaptureIntent.SessionType.TEST ? CameraConfigurationManager.getVideoRect() : this.cameraSessionManager.getVideoRect();
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
            try {
                this.currentMat = CameraManagerController.getOcrAnalyzeSession(this.context).getCurrentMat(this.context, false, !CameraManagerController.enableCroppingController);
                if (this.currentMat == null) {
                    message = this.handler.obtainMessage(18);
                    this.handler.sendMessage(message);
                    Logger.e(tag, "out of memory while intializing Mat");
                }
                RawImagesFlowManager.handleDebugMat(this.currentMat);
                if (RawImagesFlowManager.isSaveMode()) {
                    RawImagesFlowManager._instance.handleSave(this.currentMat, true);
                }
            }
            catch (OutOfMemoryError e) {
                Message message2 = this.handler.obtainMessage(18);
                this.handler.sendMessage(message2);
                Logger.e(tag, "out of memory while intializing Mat", e);
                if (this.currentMat != null) {
                    this.currentMat.release();
                    this.currentMat = null;
                }
                CameraController.processStart = false;
                CameraController.getInstance().captureButtonPressed = false;
                PreviewCallback.processingVideo = false;
                return;
            }
            try {
                try {
                    if (CameraManagerController.getOcrAnalyzeSession(this.context).getStillsBoundingBox() != null) {
                        this.adjustedCheckRect = CameraManagerController.getOcrAnalyzeSession(this.context).getStillsBoundingBox().clone();
                    } else if (!CameraManagerController.invertedCamera) {
                        this.adjustedCheckRect = OCRHelper.calculateVideoStillMatRatio(CameraManagerController.getOcrAnalyzeSession((Context)this.context).checkRect, this.currentMat, this.displayWidth, CameraManagerController.getOcrAnalyzeSession(this.context).getVideoMat());
                    } else if (CameraManagerController.getOcrAnalyzeSession(this.context).getVideoBoundingBox() != null && CameraManagerController.getOcrAnalyzeSession((Context)this.context).getVideoBoundingBox().width > 0) {
                        this.adjustedCheckRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(CameraManagerController.getOcrAnalyzeSession(this.context).getVideoBoundingBox(), 2);
                    }
                    CameraController.processStart = true;
                    CameraController.getInstance().cancelInfoScreen();
                    switch (CameraManagerController.getOcrAnalyzeSession((Context)this.context).captureMode) {
                        case FRONT: {
                            if (CameraManagerController.isBlurEnabled && CameraManagerController.imageType != CaptureIntent.TISDocumentType.PAYMENT && this.perfromBlurOnImage()) break;
                            Logger.i(tag, "ocrResult:ocr currentImage number is " + CameraController.currentImage);
                            if (!CameraManagerController.shouldOutputBWImage) {
                                result = this.startNoBinarizationFlow(this.currentMat, this.adjustedCheckRect);
                                break;
                            }
                            if (!CameraManagerController.isStillMode && CameraManagerController.doOcrOnImage) {
                                result = this.performOcrBeforeBinarization(this.currentMat, this.adjustedCheckRect);
                            } else {
                                result.isValidRead = this.prepareImageForServer((Mat)this.currentMat, (int)this.timestamp, (Rect)this.adjustedCheckRect, (int)0).imageResult;
                            }
                            if (!CameraManagerController.isStillMode && !result.isValidRead) {
                                ++CameraManagerController.falseRecognitionVideoFrames;
                            }
                            CameraController.processStart = false;
                            break;
                        }
                        case BACK: {
                            boolean scanMicrOnBack;
                            if (CameraManagerController.isBlurOnBackEnabled && this.perfromBlurOnImage()) break;
                            OCRResult micrOnBack = null;
                            boolean bl = scanMicrOnBack = CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK && CameraManagerController.doOcrOnImage;
                            if (scanMicrOnBack && this.currentMat != null) {
                                micrOnBack = this.mobiCHECKOCR.readOCRData(this.currentMat, null, this.adjustedCheckRect, this.cameraSessionManager.getVideoRect(), CameraManagerController.getOcrAnalyzeSession((Context)this.context).checkRect, CameraManagerController.getOcrAnalyzeSession((Context)this.context).currentMICRType.getId(), true);
                                if (micrOnBack.digitalRowLength > 0 && micrOnBack.ocrRawResult.length() > 1) {
                                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
                                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorMICRDetectedOnCheckBack;
                                    result.isValidRead = false;
                                    this.foundMicrOnBackSide = true;
                                    break;
                                }
                            }
                            if (CameraManagerController.shouldOutputBWImage) {
                                result.isValidRead = this.prepareImageForServer((Mat)this.currentMat, (int)this.timestamp, (Rect)this.adjustedCheckRect, (int)0).imageResult;
                            } else {
                                result = this.startNoBinarizationFlow(this.currentMat, this.adjustedCheckRect);
                            }
                            if (!CameraManagerController.isStillMode && !result.isValidRead) {
                                ++CameraManagerController.falseRecognitionVideoFrames;
                            }
                            CameraController.processStart = false;
                        }
                    }
                }
                catch (Exception e) {
                    if (CameraManagerController.getOcrAnalyzeSession(this.context) != null) {
                        CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
                        if (e != null && e.getMessage() != null && e.getMessage().contains("readOCRData")) {
                            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.ERROR_MICR_LENGTH;
                        }
                        if (!CameraManagerController.isStillMode) {
                            ++CameraManagerController.falseRecognitionVideoFrames;
                        }
                        CameraController.processStart = false;
                    }
                    Logger.e(tag, "processCapturedImage:" + (e != null ? e.getMessage() : "null Exception"));
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("ProcessStillImageThread", "OCR read Exception!!!", this.context);
                    }
                    if (this.currentMat != null) {
                        this.currentMat.release();
                        this.currentMat = null;
                    }
                    CameraController.processStart = false;
                    CameraController.getInstance().captureButtonPressed = false;
                }
            }
            catch (Throwable throwable) {
                if (this.currentMat != null) {
                    this.currentMat.release();
                    this.currentMat = null;
                }
                CameraController.processStart = false;
                CameraController.getInstance().captureButtonPressed = false;
                throw throwable;
            }
            if (this.currentMat != null) {
                this.currentMat.release();
                this.currentMat = null;
            }
            CameraController.processStart = false;
            CameraController.getInstance().captureButtonPressed = false;
            if (this.handler == null) {
                this.handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
            }
            message = this.handler.obtainMessage(10);
            if (result == null) {
                message = this.handler.obtainMessage(6);
                message.obj = result;
                message.sendToTarget();
                return;
            }
            if (CameraManagerController.doOcrOnImage && result != null && result.isValidRead) {
                switch (CameraManagerController.imageType) {
                    case CHECK: {
                        if (this.isFrontCapture && this.checkOcrResult()) {
                            message = this.handler.obtainMessage(24);
                            break;
                        }
                        if (this.foundMicrOnBackSide) break;
                        if (FileUtils.isSamsungS5()) {
                            long currentTime = System.currentTimeMillis();
                            long estimatedTime = currentTime - this.lastFocusRequestTime;
                            if (estimatedTime < 5000L) break;
                            if (this.handler == null) {
                                this.handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
                            }
                            CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                            this.lastFocusRequestTime = System.currentTimeMillis();
                            break;
                        }
                        CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                        break;
                    }
                    case PASSPORT: {
                        message = this.handler.obtainMessage(22);
                        break;
                    }
                    case CARD: {
                        if (!this.isFrontCapture) break;
                        if (CameraManagerController.ocrType == Common.OCRType.PAN) {
                            message = this.handler.obtainMessage(23);
                            break;
                        }
                        if (CameraManagerController.ocrType != Common.OCRType.MRZ) break;
                        message = this.handler.obtainMessage(25);
                        break;
                    }
                }
            }
            if (!result.isValidRead && CameraManagerController.sessionType != CaptureIntent.SessionType.TEST && !CameraController.backPressed) {
                CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
            }
            if (!result.isValidRead) {
                String errorString = "analyzeErrorCode(" + CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode.toString() + ")";
                if (CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage != null) {
                    errorString = String.valueOf(errorString) + " ocrErrorMessage(" + CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage + ")";
                }
                if (CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode != null) {
                    errorString = String.valueOf(errorString) + " ocrErrorCode(" + (Object)((Object)CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode) + ")";
                }
                FileUtils.addToLogFile("FAIL_IMAGE_SESSION_RESULT", errorString, this.context);
            }
            if (CameraController.doOcrOnly) {
                message = this.handler.obtainMessage(19);
            }
            if (result.isValidRead && !CameraManagerController.isStillMode) {
                CameraController.videoImageTaken = true;
            }
            message.obj = result;
            message.sendToTarget();
        }
        finally {
            PreviewCallback.processingVideo = false;
        }
    }

    private boolean parseImageResult(ImageSessionResult imageResult) {
        try {
            boolean result = false;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
            if (imageResult == null) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = null;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE_GENERAL;
            } else if (imageResult.errorCodeId > -1) {
                Logger.i(tag, "error message:" + imageResult.errorMessage);
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = imageResult.getErrorCode();
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = imageResult.errorMessage;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = imageResult.errorCodeId == 18 || imageResult.errorCodeId == 19 ? CameraTypes.OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL : CameraTypes.OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
            } else if (imageResult.mat == null) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = null;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
            } else {
                if (this.isFrontCapture) {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect = new Rect(0, 0, imageResult.tiffWidth, imageResult.tiffHeight);
                } else {
                    CameraManagerController.getOcrAnalyzeSession(this.context).setBackImageTIFFPath(imageResult.filePath);
                }
                result = true;
            }
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("process time end ", FileUtils.getCurrentTime(), this.context);
            }
            Logger.i(tag, "parseImageResult | result:true analyzeErrorCode:" + (Object)((Object)CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode));
            return result;
        }
        catch (Exception e) {
            Logger.e(tag, Log.getStackTraceString((Throwable)e));
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile(tag, "check OCR string " + this.ocrData.ocrRawResult + "OCR With delimeter " + this.ocrData.ocrResultWithDelimiter + "OCR score " + this.ocrData.scoreResult, this.context);
            }
            return false;
        }
    }

    private OCRResult performOcrBeforeBinarization(Mat currentMat, Rect adjustedCheckRect) {
        OCRResult result = new OCRResult();
        try {
            this.ocrData = this.mobiCHECKOCR.readOCRData(currentMat, null, adjustedCheckRect, this.cameraSessionManager.getVideoRect(), CameraManagerController.getOcrAnalyzeSession(this.context).getVideoBoundingBox(), CameraManagerController.getOcrAnalyzeSession((Context)this.context).currentMICRType.getId(), false);
            CameraManagerController.getOcrAnalyzeSession(this.context).setOcrResult(this.ocrData);
        }
        catch (Exception e) {
            Logger.e(tag, Log.getStackTraceString((Throwable)e));
            return null;
        }
        result = this.ocrData;
        if (this.ocrData == null || this.ocrData.ocrRawResult == null || this.ocrData.ocrRawResult.length() < 1) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorOcrReading;
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                result.isValidRead = this.prepareImageForServer((Mat)currentMat, (int)this.timestamp, (Rect)adjustedCheckRect, (int)0).imageResult;
            }
        } else if (this.checkOcrResult()) {
            ImageSessionResult sessionResult = this.prepareImageForServer(currentMat, this.timestamp, adjustedCheckRect, this.ocrData.meanDigitHeight);
            result.isValidRead = sessionResult.imageResult;
        } else if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST && !result.isValidRead) {
            result.isValidRead = this.prepareImageForServer((Mat)currentMat, (int)this.timestamp, (Rect)adjustedCheckRect, (int)0).imageResult;
        }
        Logger.i(tag, "ocrResult:" + CameraManagerController.getOcrAnalyzeSession(this.context).getOcrResult());
        CameraController.processStart = false;
        return result;
    }

    private boolean checkOcrResult() {
        if (this.ocrData.signatureOverMicrDetected == 1 && CameraManagerController.showErrorSignatureOverMICR && CameraManagerController.ocrType == Common.OCRType.CMC7) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMicrInterrupted;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorMicrInterrupted;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOcrResult().errorCodeId = OCRCommon.ErrorCode.errorMicrInterrupted.getId();
        } else {
            if (CameraManagerController.getOcrAnalyzeSession(this.context).getOcrResult() == null || CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOcrResult().digitalRowLength < 1) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = null;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
                return false;
            }
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK && this.ocrData.digitalRowLength < CameraManagerController.getOcrAnalyzeSession((Context)this.context).txtValidFrom | this.ocrData.digitalRowLength > CameraManagerController.getOcrAnalyzeSession((Context)this.context).txtValidTo) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorMicrLength;
                CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOcrResult().errorCodeId = OCRCommon.ErrorCode.errorMicrLength.getId();
            }
        }
        int errorCodeId = CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOcrResult().errorCodeId;
        if (errorCodeId > -1) {
            OCRCommon.ErrorCode errorCode = OCRCommon.ErrorCode.instanceOf(errorCodeId);
            switch (errorCode) {
                case errorMicrInterrupted: {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMicrInterrupted;
                    break;
                }
                case errorMICRDetectedOnCheckBack: {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
                    break;
                }
                case errorMicrLength: {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.ERROR_MICR_LENGTH;
                    break;
                }
                default: {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
                }
            }
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = errorCode;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOcrResult().errorMessage;
            return false;
        }
        if (this.ocrData.ocrResultWithDelimiter.length() < 1 && this.ocrData.digitalRowLength == 0) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorOcrReading;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_READING_OCR_GENERAL;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
            return false;
        }
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CARD && CameraManagerController.ocrType == Common.OCRType.MRZ) {
            boolean candidateForAnotherValidation;
            OCRResult MRZRes = CameraManagerController.getOcrAnalyzeSession(this.context).getOcrResult();
            boolean validRead = true;
            if (!validRead && (candidateForAnotherValidation = OcrValidationUtils.correctMRZIDResults(MRZRes))) {
                validRead = OcrValidationUtils.validateIDCard(MRZRes);
            }
            return validRead;
        }
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile(tag, "check OCR string " + this.ocrData.ocrRawResult + "OCR With delimeter " + this.ocrData.ocrResultWithDelimiter + "OCR score " + this.ocrData.scoreResult, this.context);
        }
        CameraManagerController.getOcrAnalyzeSession(this.context).setOcrResult(this.ocrData);
        return true;
    }

    private ImageSessionResult prepareImageForServer(Mat currentMat, int timestamp, Rect checkRect, int meanDigitHeight) {
        String text = StringUtils.dynamicString(this.context, "TISFlowPreparingImage");
        Message message = this.handler.obtainMessage(12);
        message.obj = text;
        message.sendToTarget();
        Logger.i(tag, "currentVideoRect:" + this.cameraSessionManager.getVideoRect() + " | currentCheckRect:" + checkRect + " |currentOrientation:" + CameraManagerController.getOcrAnalyzeSession((Context)this.context).orientation + " |frontImageRect:" + CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect + " |isFront:" + this.isFrontCapture + " |isSendImageAsIs:");
        String imagePath = this.isFrontCapture ? CameraManagerController.getOcrAnalyzeSession(this.context).getFrontImagePath() : CameraManagerController.getOcrAnalyzeSession(this.context).getBackImagePath();
        Rect checkRectInfo = checkRect;
        if (!(this.isFrontCapture || CameraManagerController.imageType != CaptureIntent.TISDocumentType.CHECK || CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect != null && CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect.width != 0)) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect = new Rect(0, 0, 1200, 600);
        }
        boolean alignImage = false;
        if (!CameraManagerController.isDynamicCapture && (CameraManagerController.imageType != CaptureIntent.TISDocumentType.CHECK || CameraManagerController.enableSoftCaptureAndImageAligment)) {
            alignImage = true;
        }
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
            CameraConfigurationManager.captureResolutionHeight = currentMat.rows();
            CameraConfigurationManager.captureResolutionWidth = currentMat.cols();
        }
        String model = String.valueOf(FileUtils.getDeviceName()) + " Android version " + Build.VERSION.RELEASE;
        String make = this.context.getResources().getString(R.string.TISVersion);
        Mat outputCroppedImage = new Mat();
        if (CameraManagerController.enableCroppingController) {
            checkRectInfo = CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getStillsBoundingBox();
            outputCroppedImage = this.isFrontCapture ? CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getFrontCroppedStillsMat() : CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getBackCroppedStillsMat();
        }
        this.imageResult = this.mobiCHECKOCR.prepareCurrentImageForSending(currentMat, outputCroppedImage, timestamp, imagePath, this.videoRect, checkRectInfo, CameraManagerController.getOcrAnalyzeSession((Context)this.context).orientation, this.isFrontCapture, CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect, false, CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOCRAnalyzeResult().meanDigitHeight, this.doOcrOnBinImage(), CameraManagerController.imageType.ordinal(), CameraConfigurationManager.captureResolutionHeight * CameraConfigurationManager.captureResolutionWidth, alignImage, !CameraManagerController.isDynamicCapture, CameraManagerController.getOcrAnalyzeSession(this.context).getCroppingCoordinates(), model, make);
        if (!(CameraManagerController.isStillMode && CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT || outputCroppedImage == null || outputCroppedImage.cols() <= 1)) {
            Imgproc.cvtColor((Mat)outputCroppedImage, (Mat)outputCroppedImage, (int)2, (int)4);
        }
        CameraController.getInstance().captureButtonPressed = false;
        if (this.isFrontCapture) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).getOCRAnalyzeResult().meanDigitHeight = this.imageResult.meanDigitHeight;
        }
        try {
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST || CameraManagerController.shouldOutputGrayscaleImage || CameraManagerController.shouldOutputColoredImage || CameraManagerController.scanBackOnly) {
                this.rect = new BoundingBoxResult();
                if (this.imageResult != null && this.imageResult.width > 0 && this.imageResult.height > 0) {
                    this.rect.setRect(this.imageResult.x, this.imageResult.y, this.imageResult.width, this.imageResult.height);
                }
                this.createCroppedImages(outputCroppedImage, this.rect.getRect(), this.isFrontCapture, CameraManagerController.grayScaleSize);
                if (!this.isFrontCapture && CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                    checkRectInfo = this.rect.getRect();
                }
            }
        }
        catch (Exception e) {
            Logger.e(tag, "Failed to find rectangle");
        }
        if (this.doOcrOnBinImage()) {
            this.ocrData = new OCRResult();
            this.ocrData.digitalRowLength = this.imageResult.digitalRowLength;
            this.ocrData.meanDigitHeight = this.imageResult.meanDigitHeight;
            this.ocrData.ocrRawResult = this.imageResult.ocrRawResult;
            this.ocrData.scoreResult = this.imageResult.scoreResult;
            this.ocrData.ocrResultWithDelimiter = this.imageResult.ocrResultWithDelimiter;
            this.ocrData.signatureOverMicrDetected = this.imageResult.signatureOverMicrDetected;
            this.ocrData.errorCodeId = this.imageResult.errorCodeId;
            this.ocrData.errorMessage = this.imageResult.errorMessage;
            CameraManagerController.getOcrAnalyzeSession(this.context).setOcrResult(this.ocrData);
        }
        this.imageResult.imageResult = this.parseImageResult(this.imageResult);
        if (this.imageResult.imageResult && CameraManagerController.doOcrOnImage && this.isFrontCapture) {
            this.imageResult.imageResult = this.checkOcrResult();
        }
        return this.imageResult;
    }

    private void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
    }

    private long getDPIinFloat(int width, int height) {
        return (long)Math.sqrt(width * width + height * height) / 4L;
    }

    private int px(float dips) {
        float DP = this.context.getResources().getDisplayMetrics().density;
        return Math.round(dips * DP);
    }

    private void createCroppedImages(Mat croppedMat, Rect rect, boolean isFront, int[] size) {
        if ((rect.width == 0 || rect.height == 0) && !CameraManagerController.enableCroppingController || croppedMat.empty()) {
            return;
        }
        try {
            if (croppedMat.rows() == 1080 && croppedMat.cols() == 1920 && !CameraManagerController.shouldOutputBWImage) {
                croppedMat = new Mat(croppedMat, rect);
            }
            if (size == null) {
                size = new int[]{rect.height, rect.width};
            }
            if (CameraManagerController.shouldOutputGrayscaleImage) {
                Mat grayImage = new Mat();
                Imgproc.cvtColor((Mat)croppedMat, (Mat)grayImage, (int)7);
                Mat resizeimage = grayImage.clone();
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK && this.imageResult != null && this.imageResult.mat != null && this.imageResult.tiffHeight > 0) {
                    Size sz = new Size((double)this.imageResult.tiffWidth, (double)this.imageResult.tiffHeight);
                    Imgproc.resize((Mat)grayImage, (Mat)resizeimage, (Size)sz);
                }
                this.uploadImageData = FileUtils.convertJpgMatToByte(resizeimage, CameraManagerController.grayScaleImageCompression);
                this.uploadImageData[13] = 1;
                this.uploadImageData[14] = 0;
                this.uploadImageData[15] = -56;
                this.uploadImageData[16] = 0;
                this.uploadImageData[17] = -56;
            }
            if (CameraManagerController.shouldOutputColoredImage) {
                try {
                    if (this.isFrontCapture && croppedMat != null && !croppedMat.empty()) {
                        SessionResultParams.colorFront = FileUtils.convertJpgMatToByte(croppedMat, CameraManagerController.colorImageCompression);
                    } else {
                        SessionResultParams.colorBack = FileUtils.convertJpgMatToByte(croppedMat, CameraManagerController.colorImageCompression);
                    }
                }
                catch (Exception e) {
                    Logger.e(tag, "processCapturedImage:" + e.getMessage());
                }
            }
            if (CameraManagerController.shouldOutputGrayscaleImage) {
                if (isFront) {
                    SessionResultParams.grayscaleFront = this.uploadImageData;
                } else {
                    SessionResultParams.grayscaleBack = this.uploadImageData;
                }
            }
        }
        catch (Exception e) {
            Logger.e(tag, "createCroppedImages" + Log.getStackTraceString((Throwable)e));
            return;
        }
    }

    private boolean doOcrOnBinImage() {
        return CameraManagerController.isStillMode && this.isFrontCapture && CameraManagerController.doOcrOnImage;
    }

    private boolean detectBlurJava(Mat dst2) {
        long startTime = System.currentTimeMillis();
        int l = CvType.CV_8UC1;
        Mat laplacianImage = new Mat();
        dst2.convertTo(laplacianImage, l);
        Imgproc.Laplacian((Mat)dst2, (Mat)laplacianImage, (int)0);
        Mat laplacianImage8bit = new Mat();
        laplacianImage.convertTo(laplacianImage8bit, l);
        Bitmap bmp = Bitmap.createBitmap((int)laplacianImage8bit.cols(), (int)laplacianImage8bit.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Utils.matToBitmap((Mat)laplacianImage8bit, (Bitmap)bmp);
        int[] pixels = new int[bmp.getHeight() * bmp.getWidth()];
        bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());
        if (bmp != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        int maxLap = -16777216;
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] > maxLap) {
                maxLap = pixels[i];
            }
            ++i;
        }
        Logger.i(tag, "maxLap " + maxLap);
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile("Blur detection image  " + maxLap, this.context);
        }
        Double frontBlurTresh = Double.valueOf(this.context.getResources().getString(R.string.front_blur_treshold));
        Double backBlurTresh = Double.valueOf(this.context.getResources().getString(R.string.back_blur_treshold));
        int soglia = -9020000;
        if (CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT) {
            soglia = (int)((double)soglia * 1.2);
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CARD) {
                soglia = (int)((double)soglia * 1.1);
            }
        }
        if (frontBlurTresh > 0.0 && this.isFrontCapture) {
            soglia = (int)((double)soglia * frontBlurTresh);
        }
        if (CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).captureMode == CameraTypes.CaptureMode.BACK || CameraManagerController.scanBackOnly) {
            soglia = -14000000;
            if (backBlurTresh > 0.0) {
                soglia = (int)((double)soglia * backBlurTresh);
            }
        }
        return maxLap < soglia || maxLap == soglia;
    }

    private Rect findRectfindRectOnStillsOnStills(Mat originalMat) throws Exception {
        Mat boundingBoxMat = new Mat();
        GenericBoundingBoxResult genericBoundingBoxResult = this.mobiCHECKOCR.findGenericBoundingBox(originalMat, boundingBoxMat);
        if (genericBoundingBoxResult == null || genericBoundingBoxResult.width == 0 || genericBoundingBoxResult.height == 0) {
            CheckBoundaries cb = CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getCheckBoundaries();
            if (cb == null) {
                throw new Exception("problem finding Check Boundaries on stills");
            }
            Rect checkRect = cb.getValidationRect();
            if ((checkRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(checkRect, 2)) == null) {
                throw new Exception("problem finding validation rect on stills");
            }
            genericBoundingBoxResult = new GenericBoundingBoxResult();
            genericBoundingBoxResult.x = checkRect.x;
            genericBoundingBoxResult.topLeftX = genericBoundingBoxResult.bottomLeftX = (float)genericBoundingBoxResult.x;
            genericBoundingBoxResult.y = checkRect.y;
            genericBoundingBoxResult.topLeftY = genericBoundingBoxResult.topRightY = (float)genericBoundingBoxResult.y;
            genericBoundingBoxResult.topRightX = genericBoundingBoxResult.bottomRightX = (float)checkRect.br().x;
            genericBoundingBoxResult.bottomLeftY = genericBoundingBoxResult.bottomRightY = (float)checkRect.br().y;
            genericBoundingBoxResult.width = checkRect.width;
            genericBoundingBoxResult.height = checkRect.height;
        }
        float[] coordinates = new float[8];
        UserInterfaceUtils.fillPointsArrayFromBoundingBox(coordinates, genericBoundingBoxResult);
        CameraManagerController.getOcrAnalyzeSession(this.context).setCroppingCoordinates(coordinates);
        CameraManagerController.getOcrAnalyzeSession(this.context).setStillsBoundingBox(genericBoundingBoxResult.getRect());
        return genericBoundingBoxResult.getRect();
    }

    private OCRResult startNoBinarizationFlow(Mat currentMat, Rect adjustedCheckRect) {
        OCRResult result = new OCRResult();
        result.isValidRead = true;
        Rect highResImageRect = null;
        if (CameraManagerController.isStillMode) {
            highResImageRect = this.mobiCHECKOCR.findCheckBoundingBoxHighResImage(currentMat, 1L, this.videoRect, adjustedCheckRect, CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect, OCRHelper.scaleWidth, OCRHelper.scaleHeight).getRect();
        }
        if (adjustedCheckRect == null || adjustedCheckRect.width <= 0 || adjustedCheckRect.height <= 0 && CameraManagerController.isStillMode) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = null;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.FAILED_PREPARING_IMAGE;
            result.isValidRead = false;
        }
        if (CameraManagerController.doOcrOnImage && result.isValidRead && this.isFrontCapture) {
            this.ocrData = this.mobiCHECKOCR.readOCRData(currentMat, null, adjustedCheckRect, this.cameraSessionManager.getVideoRect(), CameraManagerController.getOcrAnalyzeSession(this.context).getVideoBoundingBox(), CameraManagerController.getOcrAnalyzeSession((Context)this.context).currentMICRType.getId(), false);
            CameraManagerController.getOcrAnalyzeSession(this.context).setOcrResult(this.ocrData);
            result.isValidRead = this.checkOcrResult();
        }
        if (result.isValidRead) {
            this.createCroppedImages(currentMat, CameraManagerController.isStillMode ? highResImageRect : adjustedCheckRect, this.isFrontCapture, CameraManagerController.grayScaleSize);
        } else if (!CameraManagerController.isStillMode) {
            ++CameraManagerController.falseRecognitionVideoFrames;
        }
        return result;
    }

    private boolean perfromBlurOnImage() {
        Mat img = CameraManagerController.isStillMode ? this.currentMat : CameraSessionManager.getInstance().currCroppedVideoMat;
        if (this.doBlur(img)) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMicrOnBack;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = OCRCommon.ErrorCode.errorBlurDetectionFailed;
            Message message = this.handler.obtainMessage(6);
            message.sendToTarget();
            return true;
        }
        return false;
    }

    private boolean doBlur(Mat image) {
        block22: {
            try {
                int maxInvalidRects;
                long startTime = System.currentTimeMillis();
                int blurRectangles = 0;
                int whiteRectangleCount = 0;
                int validRectangleCount = 0;
                Mat croppedImg = image.clone();
                int imageBorderToRemove = 50;
                ArrayList<Mat> validImagesGrid = new ArrayList<Mat>();
                Rect highResImageRect = new Rect();
                Mat smallBinImage = new Mat();
                if (CameraManagerController.sessionType != CaptureIntent.SessionType.TEST && OCRHelper.scaleWidth == 0.0f) {
                    if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                        OCRHelper.scaleHeight = CameraConfigurationManager.captureResolutionWidth / CameraConfigurationManager.videoResolutionWidth;
                        OCRHelper.scaleWidth = CameraConfigurationManager.captureResolutionHeight / CameraConfigurationManager.videoResolutionHeight;
                    } else {
                        OCRHelper.scaleWidth = CameraConfigurationManager.captureResolutionWidth / CameraConfigurationManager.videoResolutionWidth;
                        OCRHelper.scaleHeight = CameraConfigurationManager.captureResolutionHeight / CameraConfigurationManager.videoResolutionHeight;
                    }
                }
                String imPath = String.valueOf(FileUtils.getTestImagePath(this.context)) + "/" + "beforecrop.jpg";
                long startTime2 = System.currentTimeMillis();
                if (CameraManagerController.isStillMode) {
                    if (CameraManagerController.isDynamicCapture) {
                        croppedImg = new Mat(image, this.adjustedCheckRect);
                    } else {
                        highResImageRect = this.mobiCHECKOCR.findCheckBoundingBoxHighResImage(croppedImg, 1L, this.videoRect, this.adjustedCheckRect, CameraManagerController.getOcrAnalyzeSession((Context)this.context).frontImageRect, OCRHelper.scaleWidth, OCRHelper.scaleHeight).getRect();
                        if (highResImageRect.width == 0) {
                            highResImageRect = this.adjustedCheckRect;
                        }
                    }
                } else {
                    highResImageRect = new Rect(0, 0, croppedImg.width(), croppedImg.height());
                }
                long endTime2 = System.currentTimeMillis();
                Logger.i(tag, "Blur crop total time " + (endTime2 - startTime2));
                highResImageRect.x += imageBorderToRemove;
                highResImageRect.y += imageBorderToRemove;
                highResImageRect.width -= imageBorderToRemove;
                highResImageRect.height -= imageBorderToRemove;
                imPath = String.valueOf(FileUtils.getTestImagePath(this.context)) + "/" + "original.jpg";
                if (!CameraManagerController.isDynamicCapture) {
                    croppedImg = new Mat(croppedImg, highResImageRect);
                }
                Imgproc.cvtColor((Mat)croppedImg, (Mat)croppedImg, (int)7);
                Size smallSize = new Size((double)(croppedImg.width() / 3), (double)(croppedImg.height() / 3));
                int count = 0;
                int imgHeight = (int)smallSize.height;
                int imgWidth = (int)smallSize.width;
                int y = 0;
                while (y < croppedImg.rows() - imageBorderToRemove) {
                    int x = 0;
                    while (x < croppedImg.cols() - imageBorderToRemove) {
                        try {
                            Rect rect = new Rect(x, y, (int)smallSize.width, (int)smallSize.height);
                            Mat m = new Mat(croppedImg, rect);
                            Imgproc.threshold((Mat)m, (Mat)smallBinImage, (double)0.0, (double)255.0, (int)8);
                            int blackPixels = Core.countNonZero((Mat)smallBinImage);
                            long numOfPixels = croppedImg.total();
                            imPath = String.valueOf(FileUtils.getTestImagePath(this.context)) + "/" + count + ".jpg";
                            if (!((double)blackPixels <= 0.08 * (double)numOfPixels)) {
                                validImagesGrid.add(m);
                                ++count;
                                ++validRectangleCount;
                            } else {
                                ++whiteRectangleCount;
                            }
                        }
                        catch (Exception e) {
                            Logger.e(tag, Log.getStackTraceString((Throwable)e));
                        }
                        x += imgWidth;
                    }
                    y += imgHeight;
                }
                int i = 0;
                while (i < validImagesGrid.size()) {
                    if (this.detectBlurJava((Mat)validImagesGrid.get(i))) {
                        ++blurRectangles;
                    }
                    ++i;
                }
                long endTime = System.currentTimeMillis();
                int n = maxInvalidRects = this.isFrontCapture ? 1 : 2;
                if (blurRectangles <= maxInvalidRects) break block22;
                if (CameraManagerController.isDebug) {
                    FileUtils.addToLogFile("Image Blurry!", this.context);
                }
                Logger.e(tag, "Image Blurry, Blur Rectangles " + blurRectangles);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile("Image Sharp", this.context);
        }
        Logger.i(tag, "Image Sharp");
        return false;
    }
}

