/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.content.Context;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import java.util.Formatter;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class StringUtils {
    private static Pattern whiteSpaceTrim = Pattern.compile("^[\\s]+|[\\s]+$");

    public static String minutesToHours(int minutes) {
        String result = String.valueOf(minutes);
        Formatter formatter = null;
        try {
            try {
                formatter = new Formatter();
                Formatter format = formatter.format("%.1f", Float.valueOf((float)minutes / 60.0f));
                result = format.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (formatter != null) {
                    formatter.close();
                    formatter = null;
                }
            }
        }
        finally {
            if (formatter != null) {
                formatter.close();
                formatter = null;
            }
        }
        return result;
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || "".equals(value);
    }

    public static String removeAstrix(String text) {
        if (text == null) {
            return "";
        }
        String res = text;
        if (text.contains("*")) {
            res = text.toString().replace("*", "");
        }
        return res;
    }

    public static String checkEmptyOrNullString(String txt) {
        if (txt == null) {
            return "";
        }
        return txt;
    }

    public static String getUsaDateFormat(String date) {
        String[] splitDate = date.split("/");
        String res = String.valueOf(splitDate[1]) + "/" + splitDate[0] + "/" + splitDate[2];
        return res;
    }

    public static String checkDateFormat(String date) {
        if (date == null) {
            return date;
        }
        if (date.length() == 1) {
            date = "0" + date;
        }
        return date;
    }

    public static String isJsonFieldEmptyOrNull(JSONObject item, String fieldToSearch) {
        String jsonResult = null;
        try {
            if (item.getString(fieldToSearch) != null) {
                jsonResult = item.getString(fieldToSearch);
            }
        }
        catch (JSONException e) {
            return null;
        }
        return jsonResult;
    }

    public static String dynamicString(Context context, String key) {
        try {
            if (CameraManagerController.dynamicStrings == null) {
                return StringUtils.getStringResourceByName(context, key);
            }
            if (CameraManagerController.dynamicStrings.get(key) != null) {
                return CameraManagerController.dynamicStrings.get(key);
            }
            return StringUtils.getStringResourceByName(context, key);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getStringResourceByName(Context context, String aString) {
        String packageName = context.getPackageName();
        int resId = context.getResources().getIdentifier(aString, "string", packageName);
        if (resId == 0) {
            return aString;
        }
        return context.getResources().getString(resId);
    }

    public static String trimStringByChar(String text, char trimBy) {
        int start = 0;
        int end = text.length();
        while (start < end && text.charAt(start) == trimBy) {
            ++start;
        }
        while (start < end && text.charAt(end - 1) == trimBy) {
            --end;
        }
        return text.substring(start, end);
    }

    public static String trimAllWhiteSpace(String text) {
        return whiteSpaceTrim.matcher(text).replaceAll("");
    }
}

