/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.content.Context;
import android.os.Build;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.TextView;

public class AccessibilityUtils {
    private static AccessibilityManager accessibilityManager;

    public static void sendAnnouncement(Context context, TextView textView, String className) {
        if (accessibilityManager == null) {
            accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        }
        if (accessibilityManager.isEnabled()) {
            int ae = 16384;
            if (Build.VERSION.SDK_INT < 16) {
                ae = 64;
            }
            AccessibilityEvent e = AccessibilityEvent.obtain((int)ae);
            e.setEventType(ae);
            e.setClassName((CharSequence)className);
            e.setPackageName((CharSequence)context.getPackageName());
            e.setEnabled(true);
            if (Build.VERSION.SDK_INT < 16) {
                e.getText().add(textView.getContentDescription());
                accessibilityManager.sendAccessibilityEvent(e);
            } else {
                textView.setImportantForAccessibility(1);
                textView.announceForAccessibility(textView.getContentDescription());
            }
        }
    }

    public static boolean isAccessibilityEnabled(Context context) {
        if (accessibilityManager == null) {
            accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        }
        return accessibilityManager.isEnabled();
    }
}

