/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;

public class Counter
extends ImageView {
    private boolean isStartCountdown;
    private final float strokeWidth = 5.0f;
    private Paint circlePaint;
    private Paint borderPaint;
    private int countDownValue = 0;
    private TextPaint textPaint;
    private int beepSound = 0;
    private static final Canvas sTextResizeCanvas = new Canvas();
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private float textSize = 38.0f;
    private Path path;
    private Rect textBounds;
    private int initialValue;
    private Context context;
    private Typeface CounterTypface;
    private float totalTime;
    private final long defaultInterval = 1000L;
    private int startInteger = 2;
    private int endInteger = 0;
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private String counterFont = "BOLD";

    public Counter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.counter);
        this.startInteger = a.getInteger(R.styleable.counter_countDownStartValue, this.startInteger);
        this.endInteger = a.getInteger(R.styleable.counter_countDownStopValue, this.endInteger);
        this.backgroundColor = a.getResourceId(R.styleable.counter_counterBackground, R.color.counter_background);
        this.textColor = a.getResourceId(R.styleable.counter_counterTextColor, R.color.camera_counter_text_color);
        this.borderColor = a.getResourceId(R.styleable.counter_counterBorderColor, R.color.counter_border_color);
        this.textSize = a.getFloat(R.styleable.counter_counterTextSize, 38.0f);
        this.counterFont = a.getString(R.styleable.counter_counterFont);
        if (this.counterFont == null) {
            this.counterFont = "BOLD";
        }
        a.recycle();
        this.init();
    }

    public Counter(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    public int getCountDownStartNumber() {
        return this.startInteger;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.circlePaint = new Paint();
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setColor(this.context.getResources().getColor(this.backgroundColor));
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(5.0f);
        this.borderPaint.setColor(this.context.getResources().getColor(this.borderColor));
        this.borderPaint.setAntiAlias(true);
        this.textPaint = new TextPaint();
        if (this.counterFont.equals("BOLD")) {
            this.textPaint.setTypeface(Typeface.defaultFromStyle((int)1));
        } else if (this.counterFont.equals("BOLD_ITALIC")) {
            this.textPaint.setTypeface(Typeface.defaultFromStyle((int)3));
        } else if (this.counterFont.equals("ITALIC")) {
            this.textPaint.setTypeface(Typeface.defaultFromStyle((int)2));
        } else if (this.counterFont.equals("NORMAL")) {
            this.textPaint.setTypeface(Typeface.defaultFromStyle((int)0));
        } else {
            this.textPaint.setTypeface(Typeface.defaultFromStyle((int)1));
        }
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setColor(this.context.getResources().getColor(this.textColor));
        this.textPaint.setAntiAlias(true);
        this.path = new Path();
        this.textBounds = new Rect();
    }

    public void startCountdown(int from) {
        this.isStartCountdown = true;
        this.countDownValue = this.initialValue = from;
        this.setVisibility(0);
        this.invalidate();
    }

    public void stopCountdown() {
        this.isStartCountdown = false;
        this.setVisibility(8);
    }

    private int getTextHeight(CharSequence source, TextPaint paint, int width, float textSize) {
        paint.setTextSize(textSize);
        StaticLayout layout2 = new StaticLayout(source, paint, width, Layout.Alignment.ALIGN_NORMAL, this.mSpacingMult, this.mSpacingAdd, true);
        layout2.draw(sTextResizeCanvas);
        return layout2.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        int radius = this.getWidth() / 2;
        canvas.drawCircle((float)(radius - 2), (float)(radius - 2), (float)(radius - 4), this.circlePaint);
        this.path.addCircle((float)radius, (float)radius, (float)radius - 5.0f, Path.Direction.CW);
        canvas.drawPath(this.path, this.borderPaint);
        String textToDraw = String.valueOf(this.countDownValue);
        int textHeight = this.getTextHeight(textToDraw, this.textPaint, this.getWidth(), this.textSize);
        this.textPaint.getTextBounds(textToDraw, 0, textToDraw.length(), this.textBounds);
        int textWidth = this.textBounds.width();
        int xOffset = (this.getWidth() - textWidth) / 2;
        if (textToDraw.equals("1")) {
            xOffset -= 5;
        }
        int yOffset = (this.getHeight() + textHeight) / 2 + this.textBounds.top / 2;
        canvas.drawText(textToDraw, (float)xOffset, (float)yOffset, (Paint)this.textPaint);
        if (this.isStartCountdown) {
            MediaPlayer mp = MediaPlayer.create((Context)this.context, (int)R.raw.beep_android);
            try {
                Thread.sleep(1000L);
                --this.countDownValue;
                this.countDownValue = this.countDownValue < this.endInteger ? this.endInteger : this.countDownValue;
                AudioManager am = (AudioManager)this.context.getSystemService("audio");
                switch (am.getRingerMode()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!CameraManagerController.countDownSound) break;
                        mp.start();
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.invalidate();
        }
    }
}

