/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.Result;
import com.topimagesystems.Common;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.controllers.imageanalyze.PeriodicAutoFocusCallback;
import com.topimagesystems.controllers.imageanalyze.ProcessStillImageThread;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.Date;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = Logger.makeLogTag("PreviewCallback");
    private CameraConfigurationManager configManager;
    private MobiCHECKOCR mobiCHECKOCR;
    private Mat matYuv;
    private Mat matRgba;
    private Mat passMat;
    private Mat croppedVideoMat;
    public Bitmap boxBitmap;
    public static boolean processingVideo = false;
    private CameraController activity;
    boolean isFront;
    private long lastFocusRequestTime = 0L;
    private boolean isFocus;
    private byte[] buffer;
    private BarcodeReader barcodeReader;
    Bundle messageBundle = new Bundle();
    BoundingBoxResult boundingBoxResult = null;
    GenericBoundingBoxResult genericBoundingBoxResult = null;
    int orientation = 0;
    OCRCommon.ErrorCode errorCode = null;

    PreviewCallback(CameraConfigurationManager configManager) {
        this.configManager = configManager;
        processingVideo = false;
        if (CameraController.getInstance() != null && CameraManagerController.enableBarcodeDetection) {
            CheckBoundaries cb = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getBarcodeBoundariesRectDisp();
            Rect rect = cb.getValidationRect();
            this.barcodeReader = new BarcodeReader(CameraManagerController.barcodeTypes, rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void verifyMats(int width, int height) {
        if (this.matYuv == null) {
            this.matYuv = new Mat(height + height / 2, width, CvType.CV_8UC1);
        }
        if (this.matRgba == null) {
            this.matRgba = new Mat();
        }
    }

    public void setActivity(CameraController cameraController, MobiCHECKOCR mobiCHECKOCR, byte[] buffer, int bufferSize) {
        this.mobiCHECKOCR = mobiCHECKOCR;
        this.activity = cameraController;
        this.verifyMats(CameraConfigurationManager.getCameraPreviewResolution().x, CameraConfigurationManager.getCameraPreviewResolution().y);
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        final Point cameraResolution = CameraConfigurationManager.getCameraPreviewResolution();
        final byte[] imgData = data;
        final Camera c = camera;
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (imgData != null && imgData.length > 0 && !CameraController.backPressed) {
                    PreviewCallback.this.processFrame(imgData, c, cameraResolution.x, cameraResolution.y, null);
                }
            }
        };
        thread.start();
        data = null;
    }

    public void processMat(final byte[] data, final Camera camera, final int width, final int height, final Mat image) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if ((data != null && data.length > 0 || image != null) && !CameraController.backPressed) {
                    PreviewCallback.this.processFrame(data, camera, width, height, image);
                }
            }
        };
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void processFrame(byte[] data, final Camera camera, int width, int height, Mat incomingMat) {
        block87: {
            PreviewCallback.processingVideo = true;
            if (this.activity == null) {
                this.activity = CameraController.getInstance();
            }
            if (data == null && incomingMat == null || this.activity == null) {
                return;
            }
            this.errorCode = null;
            try {
                if (!this.activity.isValidOrientation()) {
                    CameraController.getInstance().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CameraController.getInstance().showRedIndicatorForVideo();
                        }
                    });
                    this.sendNotValidMessage(CameraTypes.HintIndicator.Align, this.errorCode, null, this.orientation, null);
                    return;
                }
                if (!(PeriodicAutoFocusCallback.getLastAutoFocusResult() <= 0 || PeriodicAutoFocusCallback.getLastAutoFocusResult() >= 2 || CameraManagerController.isStillMode || FileUtils.isSamsungS5() || CameraManagerController.useCameraAPI2)) {
                    CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                    this.sendNotValidMessage(CameraTypes.HintIndicator.Blur, this.errorCode, null, this.orientation, null);
                    return;
                }
                if (incomingMat == null) {
                    this.verifyMats(width, height);
                    this.matYuv.put(0, 0, data);
                    Imgproc.cvtColor((Mat)this.matYuv, (Mat)this.matRgba, (int)92, (int)4);
                } else {
                    this.matRgba = incomingMat;
                }
                if (this.matRgba == null || this.matRgba.height() == 0 || this.matRgba.width() == 0) {
                    CameraController.getInstance().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CameraController.getInstance().showRedIndicatorForVideo();
                        }
                    });
                    this.sendNotValidMessage(CameraTypes.HintIndicator.Align, OCRCommon.ErrorCode.errorNoValidBoundingBox, null, this.orientation, null);
                    return;
                }
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                    this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
                }
                if (CameraManagerController.deviceName.equals("LGE Nexus 5X") && this.matRgba != null) {
                    this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
                    this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
                    data = FileUtils.convertJpgMatToByte(this.matRgba);
                    if (this.matRgba == null) {
                        return;
                    }
                    if (!CameraManagerController.useCameraAPI2 && !CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession) {
                        try {
                            Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)4, (int)4);
                        }
                        catch (Exception e) {
                            Logger.e(PreviewCallback.TAG, Log.getStackTraceString((Throwable)e));
                            PreviewCallback.processingVideo = false;
                            return;
                        }
                    }
                } else if (!CameraManagerController.isStillMode) {
                    Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)4, (int)4);
                }
                if (this.matRgba == null || this.matRgba.width() == 0 || this.matRgba.height() == 0) {
                    this.sendNotValidMessage(null, OCRCommon.ErrorCode.notValidBoundaries, null, this.orientation, null);
                    return;
                }
                originalVideoMat = this.matRgba;
                if (this.mobiCHECKOCR == null) {
                    this.mobiCHECKOCR = CameraController.getInstance().mobiCHECKOCR;
                }
                if (this.mobiCHECKOCR == null) {
                    Logger.e(PreviewCallback.TAG, "mobichecOCR is null !!");
                    this.sendNotValidMessage(null, OCRCommon.ErrorCode.errorInializeOCR, null, this.orientation, null);
                    if (camera != null) {
                        camera.addCallbackBuffer(this.buffer);
                    }
                    return;
                }
                if (this.matRgba == null || this.matRgba.rows() == 0 || this.matRgba.cols() == 0) {
                    Logger.e(PreviewCallback.TAG, "process frame, couldn't create Mat");
                    this.sendNotValidMessage(null, OCRCommon.ErrorCode.emptyImage, null, this.orientation, null);
                    return;
                }
                isValidContrast = this.mobiCHECKOCR.isValidContrast(this.matRgba);
                if (!isValidContrast) {
                    this.sendNotValidMessage(CameraTypes.HintIndicator.NoLight, this.errorCode, null, this.orientation, null);
                    return;
                }
                if (this.mobiCHECKOCR != null) {
                    v0 = this.isFront = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).captureMode == CameraTypes.CaptureMode.FRONT;
                    if (CameraManagerController.isDynamicCapture) {
                        this.croppedVideoMat = new Mat();
                        this.genericBoundingBoxResult = this.mobiCHECKOCR.findGenericBoundingBox(this.matRgba, this.croppedVideoMat);
                        CameraSessionManager.getInstance().currCroppedVideoMat = this.croppedVideoMat;
                        if (this.genericBoundingBoxResult.errorCodeId != -1 || this.genericBoundingBoxResult.width == 0) {
                            this.errorCode = this.genericBoundingBoxResult.getErrorCode();
                        } else {
                            this.errorCode = OCRCommon.ErrorCode.ok;
                            this.boundingBoxResult = new BoundingBoxResult();
                            this.boundingBoxResult.setRect(this.genericBoundingBoxResult.x, this.genericBoundingBoxResult.y, this.genericBoundingBoxResult.width, this.genericBoundingBoxResult.height);
                            this.boundingBoxResult.setRect(this.genericBoundingBoxResult.x, this.genericBoundingBoxResult.y, this.genericBoundingBoxResult.width, this.genericBoundingBoxResult.height);
                        }
                        if (this.genericBoundingBoxResult.bottomLeftX != 0.0f && this.genericBoundingBoxResult.bottomLeftY != 0.0f && this.genericBoundingBoxResult.topLeftX != 0.0f && this.genericBoundingBoxResult.topLeftY != 0.0f) {
                            this.boundingBoxResult.bottomLeft[0] = this.genericBoundingBoxResult.bottomLeftX;
                            this.boundingBoxResult.bottomLeft[1] = this.genericBoundingBoxResult.bottomLeftY;
                            this.boundingBoxResult.bottomRight[0] = this.genericBoundingBoxResult.bottomRightX;
                            this.boundingBoxResult.bottomRight[1] = this.genericBoundingBoxResult.bottomRightY;
                            this.boundingBoxResult.topLeft[0] = this.genericBoundingBoxResult.topLeftX;
                            this.boundingBoxResult.topLeft[1] = this.genericBoundingBoxResult.topLeftY;
                            this.boundingBoxResult.topRight[0] = this.genericBoundingBoxResult.topRightX;
                            this.boundingBoxResult.topRight[1] = this.genericBoundingBoxResult.topRightY;
                            this.messageBundle.putBundle("checkRect", OCRHelper.rectToBundle(this.boundingBoxResult.getRect(), this.boundingBoxResult.bottomLeft, this.boundingBoxResult.bottomRight, this.boundingBoxResult.topLeft, this.boundingBoxResult.topRight));
                        }
                    } else if (CameraManagerController.imageType != CaptureIntent.TISDocumentType.PASSPORT) {
                        this.boundingBoxResult = this.mobiCHECKOCR.findCheckBoundingBox(this.matRgba, this.isFront, true);
                        if (this.boundingBoxResult == null) {
                            Logger.e(PreviewCallback.TAG, "locateBorderUsingApproximateKmeans returned null boundingBoxResult");
                            CameraController.getInstance().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CameraController.getInstance().showRedIndicatorForVideo();
                                }
                            });
                            this.sendNotValidMessage(null, OCRCommon.ErrorCode.notValidBoundaries, null, this.orientation, null);
                        }
                        this.errorCode = this.boundingBoxResult.getErrorCode();
                    } else {
                        screenRect = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getCheckBoundariesDisp().getValidationRect();
                        deltaX = 0;
                        deltaY = 0;
                        if (CameraConfigurationManager.adjustedPreviewSize) {
                            deltaX = (CameraConfigurationManager.screenResolution.x - CameraConfigurationManager.adjustedScreenResolution.x) / 2;
                            deltaY = (CameraConfigurationManager.screenResolution.y - CameraConfigurationManager.adjustedScreenResolution.y) / 2;
                        }
                        this.boundingBoxResult = new BoundingBoxResult();
                        this.boundingBoxResult.setRect(screenRect.x - deltaX, screenRect.y - deltaY, screenRect.width, screenRect.height);
                    }
                }
                if (this.errorCode != null && this.errorCode != OCRCommon.ErrorCode.ok) {
                    if (this.errorCode == OCRCommon.ErrorCode.detectableColor) {
                        this.sendNotValidMessage(CameraTypes.HintIndicator.NoLight, this.errorCode, null, this.orientation, null);
                    } else {
                        this.sendNotValidMessage(null, this.errorCode, null, this.orientation, null);
                    }
                }
                if (CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession && this.barcodeReader != null) {
                    if (CameraManagerController.BarcodeDetectionTries > CameraManagerController.maxBarcodeTries) {
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession = false;
                        this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                    }
                    v1 = detectBarcode = CameraManagerController.isDynamicCapture != false ? this.croppedVideoMat : this.matRgba;
                    if (CameraManagerController.useCameraAPI2 && !CameraManagerController.isDynamicCapture) {
                        finalData = data;
                        thread = new Thread(){

                            @Override
                            public void run() {
                                processingVideo = true;
                                if (!PreviewCallback.this.readBarcode(camera, finalData, detectBarcode)) {
                                    PreviewCallback.this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                                    ++CameraManagerController.BarcodeDetectionTries;
                                    processingVideo = false;
                                } else {
                                    PreviewCallback.this.sendValidMessage(PreviewCallback.this.messageBundle, 0.0, 20);
                                    processingVideo = false;
                                }
                            }
                        };
                        thread.start();
                    } else if (!this.readBarcode(camera, data, detectBarcode)) {
                        this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                        ++CameraManagerController.BarcodeDetectionTries;
                    } else {
                        this.sendValidMessage(this.messageBundle, 0.0, 20);
                    }
                    break block87;
                }
                if (this.boundingBoxResult == null || this.boundingBoxResult.getRect() == null) {
                    CameraController.getInstance().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CameraController.getInstance().showRedIndicatorForVideo();
                        }
                    });
                    this.sendNotValidMessage(null, OCRCommon.ErrorCode.notValidBoundaries, null, this.orientation, null);
                    return;
                }
                checkRect = this.boundingBoxResult.getRect();
                checkInPlace = new CameraSessionManager.CheckInPLaceResult();
                if (CameraManagerController.isDynamicCapture) {
                    currentBoxAR = (double)checkRect.height / (double)checkRect.width;
                    Logger.e(PreviewCallback.TAG, "Rect height " + checkRect.height + "Rect Wdith " + checkRect.width);
                    if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT && CameraManagerController.ocrAnalyzeSession.maxRatioHW > 1.0f && CameraManagerController.ocrAnalyzeSession.minRatioHW > 1.0f && CameraManagerController.ocrAnalyzeSession.maxRatioHW > CameraManagerController.ocrAnalyzeSession.minRatioHW && checkRect.width > checkRect.height) {
                        checkInPlace.isInPlace = false;
                        checkInPlace.hintIndicator = CameraTypes.HintIndicator.invalidRotatation;
                        this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                        return;
                    }
                    if (CameraManagerController.ocrAnalyzeSession.maxRatioHW > 0.0f && CameraManagerController.ocrAnalyzeSession.minRatioHW > 0.0f && currentBoxAR > (double)CameraManagerController.ocrAnalyzeSession.maxRatioHW * 1.1 || currentBoxAR < (double)CameraManagerController.ocrAnalyzeSession.minRatioHW * 0.9) {
                        checkInPlace.isInPlace = false;
                        checkInPlace.hintIndicator = CameraTypes.HintIndicator.None;
                    } else {
                        CameraSessionManager.getInstance();
                        checkInPlace.hintIndicator = CameraSessionManager.validateImageOreintation(this.boundingBoxResult.bottomLeft, this.boundingBoxResult.topLeft, this.boundingBoxResult.bottomRight, this.boundingBoxResult.topRight, 6.0f);
                        if (checkInPlace.hintIndicator != CameraTypes.HintIndicator.Hold) {
                            checkInPlace.isInPlace = false;
                            CameraSessionManager.getInstance().resetRectComapreCounter();
                        } else {
                            checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, this.boundingBoxResult.sizeIndicator, width, height);
                        }
                    }
                } else {
                    checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, this.boundingBoxResult.sizeIndicator, width, height);
                }
                if (!checkInPlace.isInPlace && CameraManagerController.imageType != CaptureIntent.TISDocumentType.PASSPORT) ** GOTO lbl217
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).timestamp = timestamp = Math.abs((int)new Date().getTime() / 1000);
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoMat(originalVideoMat);
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoBoundingBox(checkRect);
                this.orientation = UserInterfaceUtils.getScreenOrientation((Context)this.activity);
                CameraController.frameWasGreen = true;
                path = PreviewCallback.getImagePath(this.isFront);
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).checkRect = checkRect;
                if (this.isFront) {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setFrontImagePath(path);
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setFrontImageTIFFPath(path.replace(".jpg", ".tiff"));
                } else {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setBackImagePath(path);
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setBackImageTIFFPath(path.replace(".jpg", ".tiff"));
                }
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT) {
                    this.readPassport();
                    return;
                }
                try {
                    CameraSessionManager.getInstance().currCroppedVideoMat = this.croppedVideoMat = originalVideoMat.submat(checkRect);
                }
                catch (Exception e) {
                    checkInPlace.hintIndicator = CameraTypes.HintIndicator.Align;
                    this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                }
                if (CameraManagerController.falseRecognitionVideoFrames >= CameraManagerController.maxVideoFramesToProcess) {
                    CameraManagerController.isStillMode = true;
                }
                if (FileUtils.isSamsungS5() && this.isFront && CameraManagerController.ocrType == Common.OCRType.OFF && CameraManagerController.imageType == CaptureIntent.TISDocumentType.PAYMENT && (isBlur = this.mobiCHECKOCR.detectBlur(this.croppedVideoMat, CameraManagerController.isDebug, CameraManagerController.imageType.ordinal(), CameraConfigurationManager.captureResolutionHeight * CameraConfigurationManager.captureResolutionWidth, this.isFront))) {
                    currentTime = System.currentTimeMillis();
                    estimatedTime = currentTime - this.lastFocusRequestTime;
                    checkInPlace.hintIndicator = CameraTypes.HintIndicator.Blur;
                    this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                    if (!FileUtils.isSamsungS5() && CameraManagerController.imageType != CaptureIntent.TISDocumentType.CHECK) {
                        ++CameraManagerController.falseRecognitionVideoFrames;
                    }
                    if (estimatedTime >= 3000L) {
                        CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                        this.lastFocusRequestTime = System.currentTimeMillis();
                        return;
                    }
                    return;
                }
                if (CameraManagerController.isStillMode) {
                    this.sendValidMessage(this.messageBundle, this.orientation, 7);
                    break block87;
                }
                CameraController.getInstance().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CameraController.getInstance().showGreenIndicatorForVideo();
                    }
                });
                Imgproc.cvtColor((Mat)originalVideoMat, (Mat)originalVideoMat, (int)0, (int)4);
                try {
                    if (this.isFront) {
                        SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(originalVideoMat);
                    } else {
                        SessionResultParams.originalBack = FileUtils.convertJpgMatToByte(originalVideoMat);
                    }
                }
                catch (Exception e) {
                    this.sendNotValidMessage(CameraTypes.HintIndicator.Align, this.errorCode, this.messageBundle, this.orientation, null);
                }
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setImagePath(path);
                handler = CameraManagerController.isDynamicCapture == false ? CameraController.getInstance().handler : DynamicCaptureCameraController.getInstance().getHandler();
                if (handler == null || this.mobiCHECKOCR == null) {
                    return;
                }
                this.mobiCHECKOCR.setHandler(handler);
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT && CameraManagerController.getOcrAnalyzeSession((Context)this.activity).captureMode == CameraTypes.CaptureMode.FRONT) {
                    this.readPassport();
                    return;
                }
                try {
                    processStillImageThread = new ProcessStillImageThread((Context)this.activity, handler, this.mobiCHECKOCR, true, timestamp);
                    processStillImageThread.start();
                    break block87;
lbl217:
                    // 1 sources

                    if (!CameraManagerController.isStillMode && !CameraManagerController.isDynamicCapture) {
                        CameraController.getInstance().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CameraController.getInstance().showRedIndicatorForVideo();
                                CameraController.getInstance().cameraOverlayView.invalidate();
                            }
                        });
                    }
                    if (this.activity != null && this.activity.isDebug()) {
                        timestamp = Math.abs((int)new Date().getTime() / 1000);
                        FileUtils.addToLogFile(String.valueOf(timestamp) + " | video invalid rect:" + checkRect.toString(), (Context)this.activity);
                    }
                    this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                }
                catch (Exception e) {
                    this.matRgba = null;
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile(PreviewCallback.TAG, Log.getStackTraceString((Throwable)e), (Context)this.activity);
                    }
                    this.sendNotValidMessage(CameraTypes.HintIndicator.None, OCRCommon.ErrorCode.error_deviceMemory, null, 1.0, Log.getStackTraceString((Throwable)e));
                }
            }
            finally {
                PreviewCallback.processingVideo = false;
            }
        }
    }

    private void checkForFocusBeforeCapture() {
        CameraController.getInstance().cameraSessionManager.requestAutoFocus(null, 0);
    }

    public void release() {
        if (this.activity != null) {
            this.activity = null;
        }
        if (this.mobiCHECKOCR != null) {
            this.mobiCHECKOCR = null;
        }
        if (this.matYuv != null) {
            this.matYuv.release();
            this.matYuv = null;
        }
        if (this.matRgba != null) {
            this.matRgba.release();
            this.matRgba = null;
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
    }

    private void readPassport() {
        Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)0, (int)4);
        Rect PassRect = CameraConfigurationManager.videoResolutionHeight >= 1080 || CameraConfigurationManager.videoResolutionWidth >= 1080 ? new Rect(0, (int)((double)this.matRgba.rows() * 0.7), this.matRgba.cols(), (int)((double)this.matRgba.rows() * 0.25) - 1) : new Rect(0, (int)((double)this.matRgba.rows() * 0.6), this.matRgba.cols(), (int)((double)this.matRgba.rows() * 0.3) - 1);
        this.passMat = new Mat(this.matRgba, PassRect);
        OCRResult PassRes = this.mobiCHECKOCR.readPassport(this.passMat);
        this.errorCode = PassRes.getErrorCode();
        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoMat(this.matRgba);
        Logger.i(TAG, "pass res " + PassRes.ocrRawResult + "delimeter " + PassRes.ocrResultWithDelimiter);
        if (PassRes.errorCodeId == -1 && PassRes.ocrRawResult.length() > 1) {
            this.messageBundle.putString("PASSPORT_OCR_RESULT", PassRes.ocrRawResult);
            this.messageBundle.putString("PASSPORT_OCR_RESULT_WITH_DELIMETER", PassRes.ocrResultWithDelimiter);
            this.messageBundle.putInt("PASSPORT_OCR_RESULT_LENGTH", PassRes.digitalRowLength);
            Logger.i(TAG, "found pass " + PassRes.ocrRawResult);
            Logger.i(TAG, "found pass  delemetere " + PassRes.ocrResultWithDelimiter);
            Rect boundingBoxRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(this.boundingBoxResult.getRect(), 3);
            int[] boundingBox = new int[]{boundingBoxRect.x, boundingBoxRect.y, boundingBoxRect.width, boundingBoxRect.height};
            this.messageBundle.putIntArray("INTENT_BOUNDING_BOX_RESULT", boundingBox);
            this.sendValidMessage(this.messageBundle, this.orientation, 22);
            processingVideo = false;
            return;
        }
        long currentTime = System.currentTimeMillis();
        long estimatedTime = currentTime - this.lastFocusRequestTime;
        if (estimatedTime >= 3000L) {
            CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
            this.lastFocusRequestTime = System.currentTimeMillis();
        }
        this.sendNotValidMessage(CameraTypes.HintIndicator.HoldFlat, OCRCommon.ErrorCode.errorPassportNotFound, null, this.orientation, null);
        processingVideo = false;
    }

    private boolean readBarcode(Camera camera, byte[] data, Mat img) {
        if (CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession && this.barcodeReader != null) {
            this.orientation = UserInterfaceUtils.getScreenOrientation((Context)this.activity);
            Result result = this.barcodeReader.scanImage(data, CameraConfigurationManager.videoResolutionWidth, CameraConfigurationManager.videoResolutionHeight, this.orientation, img);
            if (result != null && this.barcodeReader.getFormats().contains(result.getBarcodeFormat())) {
                CameraManagerController.BarcodeDetectionTries = 0;
                this.boundingBoxResult = new BoundingBoxResult();
                this.messageBundle.putString("barCodeType", result.getBarcodeFormat().toString());
                this.messageBundle.putString("barCodeData", result.getText());
                this.messageBundle.putBoolean("proceedWithProcessing", true);
                int[] boundingBox = new int[]{this.boundingBoxResult.x, this.boundingBoxResult.y, this.boundingBoxResult.width, this.boundingBoxResult.height};
                this.messageBundle.putIntArray("INTENT_BOUNDING_BOX_RESULT", boundingBox);
                return true;
            }
            long currentTime = System.currentTimeMillis();
            long estimatedTime = currentTime - this.lastFocusRequestTime;
            if (estimatedTime >= 3000L) {
                CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                this.lastFocusRequestTime = System.currentTimeMillis();
            }
            if (CameraManagerController.BarcodeDetectionTries >= CameraManagerController.maxBarcodeTries) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession = false;
            }
        }
        return false;
    }

    private void sendValidMessage(Bundle messageBundle, double orientation, int messageToHandle) {
        if (CameraManagerController.isDebug) {
            Logger.i(TAG, "got valid message " + messageToHandle + " " + messageBundle.toString());
        }
        if (this.activity == null) {
            this.activity = CameraController.getInstance();
        }
        this.activity.getHandler().removeAllMessages();
        Message message = Message.obtain((Handler)this.activity.getHandler(), (int)messageToHandle);
        if (message != null) {
            message.obj = true;
            messageBundle.putDouble("orientation", orientation);
            messageBundle.putBoolean("proceedWithProcessing", false);
            message.setData(messageBundle);
            message.sendToTarget();
        }
        this.activity = null;
    }

    private void sendNotValidMessage(CameraTypes.HintIndicator hintIndicator, OCRCommon.ErrorCode errorCode, Bundle messageBundle, double orientation, String exception) {
        if (CameraManagerController.isDebug && errorCode != null) {
            Logger.i(TAG, "got invalid message  " + errorCode.toString());
        }
        if (this.activity == null) {
            this.activity = CameraController.getInstance();
        }
        if (CameraController.getInstance().getHandler() == null) {
            return;
        }
        Message message = Message.obtain((Handler)CameraController.getInstance().getHandler(), (int)6);
        if (this.activity.getHandler() != null) {
            this.activity.getHandler().removeAllPreviewProcessingMessages();
        }
        if (message != null) {
            if (messageBundle == null) {
                messageBundle = new Bundle();
            }
            message.obj = false;
            if (hintIndicator != null) {
                messageBundle.putString("hintName", hintIndicator.name());
            }
            if (errorCode != null) {
                messageBundle.putString("analyzeErrorCode", errorCode.name());
            }
            if (exception != null) {
                messageBundle.putString("exceptionError", exception);
            }
            messageBundle.putDouble("orientation", orientation);
            message.setData(messageBundle);
            if (this.activity != null && message != null) {
                if (this.activity.getHandler() == null) {
                    this.activity.handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
                }
                this.activity.getHandler().sendMessage(message);
            }
        }
        this.activity = null;
    }

    public static String getImagePath(boolean isFront) {
        String basePath = String.valueOf(CameraController.activity.getFilesDir().getAbsolutePath()) + "/" + FileUtils.tempPath + "/";
        String currentDateAndTime = FileUtils.getCurrentTime();
        String path = isFront ? String.valueOf(basePath) + "FRONT" + "_" + currentDateAndTime + "_" + ".jpg" : String.valueOf(basePath) + "BACK" + "_" + currentDateAndTime + "_" + ".jpg";
        return path;
    }
}

