/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import com.topimagesystems.Common;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.OCRAnalyzeResult;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.android.Utils;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

public class OCRAnalyzeSession {
    public CameraTypes.OCRAnalyzeErrorCode analyzeErrorCode;
    public OCRCommon.ErrorCode ocrErrorCode;
    public String ocrErrorMessage;
    public CameraTypes.CaptureMode captureMode;
    public Rect checkRect;
    private Rect videoBoundingBoxRect;
    public double orientation;
    public Rect frontImageRect;
    public boolean isFrontSuccessfull = false;
    public boolean isBackSuccessfull = false;
    private static String TAG = "OCRAnalyzeSession";
    private CheckBoundaries checkBoundariesRect;
    private CheckBoundaries checkBoundariesRectDisp;
    private int ocrErrorCounter;
    public int maxNumberOfRetries;
    public int frontRetries = -1;
    public int backRetries = -1;
    public Common.OCRType currentMICRType;
    public float minRatioHW;
    public float maxRatioHW;
    public boolean isSendImageAsIs = false;
    public boolean isManualCapture = false;
    public boolean isTorchOn = false;
    public boolean isUseCustomAlgorithmOnBack;
    public boolean isBinarizeBakSameAsFront;
    public float outputHeightInInch;
    public float outputWidthInInch;
    public float minRatioHWBack;
    public float maxRatioHWBack;
    public int txtValidFrom;
    public int txtValidTo;
    public boolean isIQAEnabled;
    public boolean isAutoCaptureFront;
    public boolean isAutoCaptureBack;
    public boolean isIQAPassedFront;
    public boolean isIQAPassedBack;
    public String fontJpegAfterBinarizationPath;
    public String backJpegAfterBinarizationPath;
    public boolean isBluredEnabled;
    private Mat videoMat;
    private OCRAnalyzeResult ocrAnalyzeResult;
    private BarcodeReader.BarcodeResult barcodeResult;
    public int timestamp = 0;
    public IQASettingsIntent iqaSettings;
    public boolean isBinarizeBackSameAsFront;
    public boolean isBarcodeSession;
    private CheckBoundaries barcodeBoundariesRectDisp;

    public OCRAnalyzeSession(Context context, Common.OCRType micrType, int maxNumberOfRetries, float minimumRatioHeightWidth, float maxRatioHeightWidth, boolean isManualCapture, boolean isUseCustomAlgorithmOnBack, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack, float maxRatioHWBack, int txtValidFrom, int txtValidTo, boolean isIQAEnabled, IQASettingsIntent iqaSettings, Camera camera, boolean isBluredEnabled) {
        Point point = null;
        try {
            Camera _camera;
            boolean isCameraOpen = false;
            if (camera == null) {
                _camera = Camera.open();
                isCameraOpen = true;
            } else {
                _camera = camera;
            }
            point = UserInterfaceUtils.getCameraPreviewResolution(context, _camera.getParameters());
            if (isCameraOpen) {
                _camera.release();
            }
            this.currentMICRType = micrType;
            this.maxNumberOfRetries = maxNumberOfRetries;
            this.minRatioHW = minimumRatioHeightWidth;
            this.maxRatioHW = maxRatioHeightWidth;
            this.captureMode = CameraTypes.CaptureMode.FRONT;
            this.checkBoundariesRect = new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, point.x, point.y, this.minRatioHW, this.maxRatioHW, minRatioHWBack, maxRatioHWBack);
            Point pointDisp = UserInterfaceUtils.getDisplayDimensions(context);
            if (CameraConfigurationManager.adjustedPreviewSize) {
                boolean isPortrait = CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT;
                Rect surfaceRect = UserInterfaceUtils.getFitRectangle(pointDisp.x, pointDisp.y, isPortrait ? point.y : point.x, isPortrait ? point.x : point.y);
                Point adjustedDisp = new Point(surfaceRect.width, surfaceRect.height);
                this.checkBoundariesRectDisp = new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, adjustedDisp.x, adjustedDisp.y, this.minRatioHW, this.maxRatioHW, minRatioHWBack, maxRatioHWBack);
                this.checkBoundariesRectDisp.getValidationRect().x += (pointDisp.x - adjustedDisp.x) / 2;
                this.checkBoundariesRectDisp.getValidationRect().y += (pointDisp.y - adjustedDisp.y) / 2;
                this.barcodeBoundariesRectDisp = CameraManagerController.useQRFrameForBarcode ? new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, adjustedDisp.x, adjustedDisp.y, 0.9f, 1.1f, minRatioHWBack, maxRatioHWBack, 0.7f) : new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, adjustedDisp.x, adjustedDisp.y, 0.225f, 0.275f, minRatioHWBack, maxRatioHWBack, 0.7f);
                this.barcodeBoundariesRectDisp.getValidationRect().x += (pointDisp.x - adjustedDisp.x) / 2;
                this.barcodeBoundariesRectDisp.getValidationRect().y += (pointDisp.y - adjustedDisp.y) / 2;
            } else {
                this.checkBoundariesRectDisp = new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, pointDisp.x, pointDisp.y, this.minRatioHW, this.maxRatioHW, minRatioHWBack, maxRatioHWBack);
                this.barcodeBoundariesRectDisp = CameraManagerController.useQRFrameForBarcode ? new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, pointDisp.x, pointDisp.y, 0.9f, 1.1f, minRatioHWBack, maxRatioHWBack, 0.7f) : new CheckBoundaries(context, this.captureMode, isUseCustomAlgorithmOnBack, pointDisp.x, pointDisp.y, 0.225f, 0.275f, minRatioHWBack, maxRatioHWBack, 0.7f);
            }
            this.ocrErrorCounter = 0;
            this.ocrErrorCode = null;
            this.ocrErrorMessage = null;
            this.analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
            this.ocrAnalyzeResult = new OCRAnalyzeResult();
            this.barcodeResult = new BarcodeReader.BarcodeResult();
            this.isManualCapture = isManualCapture;
            this.isUseCustomAlgorithmOnBack = isUseCustomAlgorithmOnBack;
            this.isBinarizeBakSameAsFront = isBinarizeBakSameAsFront;
            this.minRatioHWBack = minRatioHWBack;
            this.maxRatioHWBack = maxRatioHWBack;
            this.outputHeightInInch = outputHeightInInch;
            this.outputWidthInInch = outputWidthInInch;
            this.txtValidFrom = txtValidFrom;
            this.txtValidTo = txtValidTo;
            this.isIQAEnabled = isIQAEnabled;
            this.isBluredEnabled = isBluredEnabled;
            this.iqaSettings = iqaSettings;
            this.isAutoCaptureFront = !isManualCapture;
            this.isAutoCaptureBack = !isManualCapture;
            this.isIQAPassedFront = true;
            this.isIQAPassedBack = true;
        }
        catch (Exception e) {
            Logger.e("OCRAnalyzeSession", "failed to open Camera, camera could be open");
        }
    }

    public void setVideoMat(Mat video) {
        this.videoMat = video;
    }

    public Mat getVideoMat() {
        return this.videoMat;
    }

    public Rect getVideoBoundingBox() {
        return this.videoBoundingBoxRect;
    }

    public void setVideoBoundingBox(Rect videoBoundingRect) {
        this.videoBoundingBoxRect = new Rect(videoBoundingRect.x, videoBoundingRect.y, videoBoundingRect.width, videoBoundingRect.height);
    }

    public CheckBoundaries getCheckBoundaries() {
        if (this.checkBoundariesRect == null) {
            return null;
        }
        this.checkBoundariesRect.setCaptureMode(this.captureMode);
        return this.checkBoundariesRect;
    }

    public CheckBoundaries getCheckBoundariesDisp() {
        this.checkBoundariesRectDisp.setCaptureMode(this.captureMode);
        return this.checkBoundariesRectDisp;
    }

    public CheckBoundaries getBarcodeBoundariesRectDisp() {
        this.barcodeBoundariesRectDisp.setCaptureMode(this.captureMode);
        return this.barcodeBoundariesRectDisp;
    }

    public Mat getCurrentMat(Context context) {
        Bitmap bitmap = null;
        Mat currentMat = null;
        try {
            String imagePath;
            String string2 = imagePath = this.captureMode == CameraTypes.CaptureMode.FRONT ? this.ocrAnalyzeResult.getFrontImagePath() : this.ocrAnalyzeResult.getBackImagePath();
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                Mat mat = currentMat = Highgui.imread((String)imagePath);
                return mat;
            }
            if (!CameraManagerController.isStillMode) {
                Mat mat = CameraManagerController.getOcrAnalyzeSession(context).getVideoMat();
                return mat;
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])(this.captureMode == CameraTypes.CaptureMode.FRONT ? SessionResultParams.originalFront : SessionResultParams.originalBack), (int)0, (int)(this.captureMode == CameraTypes.CaptureMode.FRONT ? SessionResultParams.originalFront.length : SessionResultParams.originalBack.length));
            currentMat = new Mat();
            Mat bitmapMat = new Mat(CameraConfigurationManager.captureResolutionWidth, CameraConfigurationManager.captureResolutionHeight, CvType.CV_8UC1);
            Utils.bitmapToMat((Bitmap)bitmap, (Mat)bitmapMat);
            Imgproc.cvtColor((Mat)bitmapMat, (Mat)currentMat, (int)1);
            if (CameraManagerController.deviceName.equals("LGE Nexus 5X") && CameraManagerController.isStillMode) {
                currentMat = FileUtils.rotateMat(currentMat, 90);
                currentMat = FileUtils.rotateMat(currentMat, 90);
                Mat tmp = new Mat();
                Imgproc.cvtColor((Mat)currentMat, (Mat)tmp, (int)4);
                if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
                    SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(tmp, 1.0f);
                } else {
                    SessionResultParams.originalBack = FileUtils.convertJpgMatToByte(tmp, 1.0f);
                }
            }
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT && CameraManagerController.isStillMode) {
                Mat rotated = new Mat();
                Imgproc.cvtColor((Mat)currentMat, (Mat)rotated, (int)4);
                currentMat = rotated = FileUtils.rotateMat(rotated, 90);
                if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
                    SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(currentMat);
                } else {
                    SessionResultParams.originalBack = FileUtils.convertJpgMatToByte(currentMat);
                }
            }
            Mat mat = currentMat;
            this.recycleBitmap(bitmap);
            return mat;
        }
        catch (Exception e) {
            Intent data = new Intent();
            return null;
        }
        finally {
            this.recycleBitmap(bitmap);
        }
    }

    public void clear() {
        this.ocrAnalyzeResult = new OCRAnalyzeResult();
        this.ocrErrorCode = null;
        this.ocrErrorMessage = null;
        this.analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
        this.checkRect = null;
        this.orientation = 0.0;
        this.ocrErrorCounter = 0;
        this.frontImageRect = null;
        this.isFrontSuccessfull = false;
        this.isBackSuccessfull = false;
        this.barcodeResult = new BarcodeReader.BarcodeResult();
    }

    public void clearErrorCode() {
        this.ocrErrorCode = null;
        this.ocrErrorMessage = null;
        this.analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
    }

    public OCRAnalyzeResult getOCRAnalyzeResult() {
        return this.ocrAnalyzeResult;
    }

    public boolean isErrorCountExeedsMaximum() {
        return this.ocrErrorCounter > this.maxNumberOfRetries;
    }

    public int getFaliureAttempsNumberFront() {
        return this.frontRetries;
    }

    public int getFaliureAttempsNumberBack() {
        return this.backRetries;
    }

    public void initOcrErrorCounter() {
        this.ocrErrorCounter = 0;
    }

    public int getOcrErrorCounter() {
        return this.ocrErrorCounter;
    }

    public void AddToErrorCounter() {
        ++this.ocrErrorCounter;
    }

    public void setImagePath(String imagePath) {
        if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
            this.ocrAnalyzeResult.setFrontImagePath(imagePath);
        } else if (this.captureMode == CameraTypes.CaptureMode.BACK) {
            this.ocrAnalyzeResult.setBackImagePath(imagePath);
        }
    }

    public OCRResult getOcrResult() {
        return this.ocrAnalyzeResult.getOcrResult();
    }

    public BarcodeReader.BarcodeResult getBarcodeResult() {
        return this.barcodeResult;
    }

    public void setOcrResult(OCRResult ocrResult) {
        this.ocrAnalyzeResult.setOcrResult(ocrResult);
    }

    public String getFrontImagePath() {
        return this.ocrAnalyzeResult.getFrontImagePath();
    }

    public void setFrontImagePath(String frontImagePath) {
        this.ocrAnalyzeResult.setFrontImagePath(frontImagePath);
    }

    public String getBackImagePath() {
        return this.ocrAnalyzeResult.getBackImagePath();
    }

    public void setBackImagePath(String backImagePath) {
        this.ocrAnalyzeResult.setBackImagePath(backImagePath);
    }

    public String getFrontImageTIFFPath() {
        return this.ocrAnalyzeResult.getFrontImagePathAsTiff();
    }

    public void resetBackupCheckBoudries() {
    }

    public void setFrontImageTIFFPath(String frontImagePathAsTiff) {
        this.ocrAnalyzeResult.setFrontImagePathAsTiff(frontImagePathAsTiff);
    }

    public String getBackImageTIFFPath() {
        return this.ocrAnalyzeResult.getBackImagePathAsTiff();
    }

    public void setBackImageTIFFPath(String backImagePathAsTiff) {
        this.ocrAnalyzeResult.setBackImagePathAsTiff(backImagePathAsTiff);
    }

    public void setFrontBarcodeType(String barcodeType) {
        this.barcodeResult.setBarcodeTypeFront(barcodeType);
    }

    public void setBackBarcodeType(String barcodeType) {
        this.barcodeResult.setBarcodeTypeBack(barcodeType);
    }

    public void setFrontBarcodeData(String barcodeData) {
        this.barcodeResult.setBarcodeDataFront(barcodeData);
    }

    public void setBackBarcodeData(String barcodeData) {
        this.barcodeResult.setBarcodeDataBack(barcodeData);
    }

    private void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
    }

    public OCRAnalyzeSession(Bundle bundle) {
        Bundle barcodeResultBundle;
        Bundle ocrAnalyzeResultBundle;
        String errorCodeName;
        String analyzeErrorCodeName = bundle.getString("analyzeErrorCode");
        if (!StringUtils.isEmptyOrNull(analyzeErrorCodeName)) {
            this.analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.valueOf(analyzeErrorCodeName);
        }
        if (!StringUtils.isEmptyOrNull(errorCodeName = bundle.getString("ocrErrorCode"))) {
            this.ocrErrorCode = OCRCommon.ErrorCode.valueOf(errorCodeName);
        }
        this.ocrErrorMessage = bundle.getString("ocrErrorMessage");
        String captureModeName = bundle.getString("captureMode");
        if (!StringUtils.isEmptyOrNull(captureModeName)) {
            this.captureMode = CameraTypes.CaptureMode.valueOf(captureModeName);
        }
        this.checkRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("checkRect"));
        this.orientation = bundle.getDouble("orientation");
        this.frontImageRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("frontImageRect"));
        this.isFrontSuccessfull = bundle.getBoolean("isFrontSuccessfull");
        this.isBackSuccessfull = bundle.getBoolean("isBackSuccessfull");
        this.ocrErrorCounter = bundle.getInt("ocrErrorCounter");
        this.maxNumberOfRetries = bundle.getInt("maxNumberOfRetries");
        String micrTypeName = bundle.getString("currentMICRType");
        if (!StringUtils.isEmptyOrNull(micrTypeName)) {
            this.currentMICRType = Common.OCRType.valueOf(micrTypeName);
        }
        this.minRatioHW = bundle.getFloat("OCRValidationMinimumRatioHeightWidth");
        this.maxRatioHW = bundle.getFloat("OCRValidationMaximumRatioHeightWidth");
        this.txtValidFrom = bundle.getInt("digitalRowScopeFrom");
        this.txtValidTo = bundle.getInt("digitalRowScopeTo");
        this.isIQAEnabled = bundle.getBoolean("IQAEnabled");
        this.isSendImageAsIs = bundle.getBoolean("isSendImageAsIs");
        this.isManualCapture = bundle.getBoolean("isManualCapture");
        this.isTorchOn = bundle.getBoolean("isTorchOn");
        Bundle checkBoundariesBundle = bundle.getBundle("checkBoundariesRect");
        if (checkBoundariesBundle != null) {
            this.checkBoundariesRect = new CheckBoundaries(checkBoundariesBundle);
        }
        if ((ocrAnalyzeResultBundle = bundle.getBundle("ocrAnalyzeResult")) != null) {
            this.ocrAnalyzeResult = new OCRAnalyzeResult(ocrAnalyzeResultBundle);
        }
        if ((barcodeResultBundle = bundle.getBundle("barcodeResult")) != null) {
            this.barcodeResult = new BarcodeReader.BarcodeResult(ocrAnalyzeResultBundle);
        }
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.analyzeErrorCode != null) {
            bundle.putString("analyzeErrorCode", this.analyzeErrorCode.name());
        }
        if (this.ocrErrorCode != null) {
            bundle.putString("ocrErrorCode", this.ocrErrorCode.name());
        }
        bundle.putString("ocrErrorMessage", this.ocrErrorMessage);
        if (this.captureMode != null) {
            bundle.putString("captureMode", this.captureMode.name());
        }
        bundle.putBundle("checkRect", UserInterfaceUtils.rectToBundle(this.checkRect));
        bundle.putDouble("orientation", this.orientation);
        bundle.putBundle("frontImageRect", UserInterfaceUtils.rectToBundle(this.frontImageRect));
        bundle.putBoolean("isFrontSuccessfull", this.isFrontSuccessfull);
        bundle.putBoolean("isBackSuccessfull", this.isBackSuccessfull);
        bundle.putInt("ocrErrorCounter", this.ocrErrorCounter);
        bundle.putInt("maxNumberOfRetries", this.maxNumberOfRetries);
        if (this.currentMICRType != null) {
            bundle.putString("currentMICRType", this.currentMICRType.name());
        }
        bundle.putFloat("OCRValidationMinimumRatioHeightWidth", this.minRatioHW);
        bundle.putFloat("OCRValidationMaximumRatioHeightWidth", this.maxRatioHW);
        bundle.putInt("digitalRowScopeFrom", this.txtValidFrom);
        bundle.putInt("digitalRowScopeTo", this.txtValidTo);
        bundle.putBoolean("IQAEnabled", this.isIQAEnabled);
        bundle.putBoolean("isSendImageAsIs", this.isSendImageAsIs);
        bundle.putBoolean("isManualCapture", this.isManualCapture);
        bundle.putBoolean("isTorchOn", this.isTorchOn);
        if (this.checkBoundariesRect != null) {
            bundle.putBundle("checkBoundariesRect", this.checkBoundariesRect.toBundle());
        }
        if (this.ocrAnalyzeResult != null) {
            bundle.putBundle("ocrAnalyzeResult", this.ocrAnalyzeResult.toBundle());
        }
        if (this.barcodeResult != null) {
            bundle.putBundle("barcodeResult", this.barcodeResult.toBundle());
        }
        return bundle;
    }
}

