/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.DynamicCameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.OCRAnalyzeSession;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import java.io.IOException;
import java.util.Locale;
import org.opencv.core.Rect;

public class DynamicCaptureCameraController
extends CameraController
implements CaptureIntent.callbackReturnMessage {
    static double M_PI = Math.PI;

    @Override
    protected void initUI() {
        RelativeLayout.LayoutParams previewSurfaceParams;
        this.layoutRoot = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(-1, -1);
        this.layoutRoot.setLayoutParams((ViewGroup.LayoutParams)rlp);
        if (CameraConfigurationManager.adjustedPreviewSize) {
            boolean isPortrait = CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT;
            Rect surfaceRect = UserInterfaceUtils.getFitRectangle(CameraConfigurationManager.screenResolution.x, CameraConfigurationManager.screenResolution.y, isPortrait ? CameraConfigurationManager.videoResolutionHeight : CameraConfigurationManager.videoResolutionWidth, isPortrait ? CameraConfigurationManager.videoResolutionWidth : CameraConfigurationManager.videoResolutionHeight);
            previewSurfaceParams = new RelativeLayout.LayoutParams(surfaceRect.width, surfaceRect.height);
            previewSurfaceParams.addRule(13, -1);
        } else {
            previewSurfaceParams = new RelativeLayout.LayoutParams(-1, -1);
        }
        this.surfaceView = new SurfaceView(this.getApplicationContext());
        this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)previewSurfaceParams);
        this.layoutRoot.addView((View)this.surfaceView);
        Logger.i(TAG, "surfaceView added");
        activity = this;
        this.dynamicCameraOverlayView = (DynamicCameraOverlayLayout)this.getLayoutInflater().inflate(R.layout.dynmaic_capture_overlay, null);
        this.dynamicCameraOverlayView.setActionClickListener(new CameraController.ActionClickListenerImpl(this));
        this.dynamicCameraOverlayView.setWillNotDraw(false);
        if (CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isBarcodeSession) {
            this.dynamicCameraOverlayView.invalidate();
        }
        videoImageTaken = false;
        this.layoutRoot.addView((View)this.dynamicCameraOverlayView);
        this.setContentView((View)this.layoutRoot);
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.handler = null;
        this.isSurfaceCreated = false;
        if (this.getIntent() != null) {
            this.isBinarizeCurrentImageAsIs = this.getIntent().getBooleanExtra("INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS", false);
        }
    }

    @Override
    protected void proceedSuccessfullFront(String dialogTitleMessage) {
        if (!CameraController.useCustomAlert) {
            this.showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString((Context)this, "TISFlowPleaseCaptureCheckBack"), CameraTypes.NEXT_ACTION.CAPTURE_BACK);
        } else {
            this.openCameraForBackCapture(false);
        }
    }

    @Override
    protected void initCamera(SurfaceHolder surfaceHolder, boolean isTorchOn) {
        try {
            Logger.i(TAG, "isSurfaceCreated  init camera");
            if ((CameraManagerController.deviceName.equals("LGE Nexus 5X") || CameraManagerController.invertedCamera) && !CameraManagerController.useCameraAPI2) {
                this.cameraSessionManager.openDriver(surfaceHolder);
            } else if (CameraManagerController.useCameraAPI2) {
                this.cameraSessionManager.openCamera2Api(isTorchOn);
            } else {
                this.cameraSessionManager.openCamera(surfaceHolder, isTorchOn);
            }
            this.handleFlashSupport();
            if (this.handler == null) {
                this.handler = new DynamicCameraActivityHandler(this, true);
            }
            this.mobiCHECKOCR.setHandler(this.handler);
            this.handleProcessPreviouslyCapturedImage();
        }
        catch (IOException ioe) {
            Logger.w(TAG, "IOException", ioe);
        }
        catch (RuntimeException e) {
            Logger.w(TAG, "Unexpected error initializating camera", e);
        }
    }

    public static class DynamicCameraActivityHandler
    extends CameraController.CameraActivityHandler {
        final CameraController cameraController;

        public DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {
            super(cameraController, startPreview);
            this.cameraController = (CameraController)this.looperActivity.get();
        }

        @Override
        public void handleMessage(Message message) {
            try {
                Bundle messageData = message.getData();
                if (this.cameraController == null) {
                    Logger.e(TAG, "handleMessage cameraController reference is null");
                    return;
                }
                Logger.i(TAG, "handler processing message:" + message.what);
                switch (message.what) {
                    case 11: {
                        Logger.i(TAG, "MESSAGE_SHOW_COUNTER");
                        int elapsedTime = message.arg1;
                        if (CameraManagerController.isDebug && this.cameraController != null && this.cameraController.getBaseContext() != null) {
                            FileUtils.addToLogFile("MESSAGE_SHOW_COUNTER", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 13: {
                        if (CameraManagerController.isDebug && this.cameraController != null && this.cameraController.getBaseContext() != null) {
                            FileUtils.addToLogFile("MESSAGE_HIDE_HINT_INDICATOR", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 12: {
                        Logger.i(TAG, "MESSAGE_SHOW_PROCESSING_LABEL");
                        this.cameraController.onSentUIEventMessage(CameraTypes.TISFlowUIMessages.BEFORE_PROCESSING);
                        this.cameraController.dynamicCameraOverlayView.switchToProcessingView(false);
                        this.cameraController.dynamicCameraOverlayView.invalidate();
                        String text = (String)message.obj;
                        if (!CameraManagerController.isStillMode && text.toLowerCase(Locale.getDefault()).contains("processing")) {
                            Logger.d(TAG, "debug");
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_SHOW_PROCESSING_LABEL", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 14: {
                        Logger.i(TAG, "MESSAGE_HIDE_BOUNDARIES_RECT");
                        if (!this.cameraController.isDebug) {
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_HIDE_BOUNDARIES_RECT", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 15: {
                        Logger.i(TAG, "MESSAGE_HIDE_ERROR_MESSAGE");
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_HIDE_ERROR_MESSAGE", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 3: {
                        Logger.i(TAG, "MESSAGE_AUTO_FOCUS");
                        if (this.cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                            this.cameraController.cameraSessionManager.requestAutoFocus(this, 3);
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_AUTO_FOCUS", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 4: {
                        Logger.i(TAG, "MESSAGE_RESTART_PREVIEW");
                        Logger.d(TAG, "Got restart preview message");
                        this.restartPreviewAndDecode();
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_RESTART_PREVIEW", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 6: {
                        OCRCommon.ErrorCode errorCode;
                        CameraTypes.HintIndicator hintIndicator;
                        String hintName = messageData.getString("hintName");
                        String errorCodeName = messageData.getString("analyzeErrorCode");
                        Bundle checkRectBundle = messageData.getBundle("checkRect");
                        double orientation = messageData.getDouble("orientation", 0.0);
                        Logger.i("MESSAGE_PROCESS_NOT_VALID", "MESSAGE_PROCESS_NOT_VALID");
                        if (!StringUtils.isEmptyOrNull(hintName)) {
                            hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            this.checkNextFrameDelay(hintIndicator);
                            this.cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
                        }
                        hintIndicator = CameraTypes.HintIndicator.None;
                        if (checkRectBundle != null && checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT") != null) {
                            if (!StringUtils.isEmptyOrNull(hintName)) {
                                hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            }
                            this.cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
                            Log.i((String)"checkRectBundle != null", (String)"checkRectBundle != null");
                            this.cameraController.dynamicCameraOverlayView.isValidRect = false;
                            boolean drawRect = true;
                            if (hintIndicator == CameraTypes.HintIndicator.AspectRatioFailed) {
                                hintIndicator = CameraTypes.HintIndicator.None;
                                drawRect = false;
                            }
                            this.cameraController.dynamicCameraOverlayView.isRectFound = drawRect;
                            this.cameraController.dynamicCameraOverlayView.bottomLeft = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT");
                            this.cameraController.dynamicCameraOverlayView.bottomRight = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT");
                            this.cameraController.dynamicCameraOverlayView.topRight = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT");
                            this.cameraController.dynamicCameraOverlayView.topLeft = checkRectBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_LEFT");
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundle);
                        } else {
                            this.cameraController.dynamicCameraOverlayView.isRectFound = false;
                        }
                        this.cameraController.dynamicCameraOverlayView.invalidate();
                        if (!StringUtils.isEmptyOrNull(hintName)) {
                            hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                            this.checkNextFrameDelay(hintIndicator);
                        }
                        if (!StringUtils.isEmptyOrNull(errorCodeName) && (errorCode = OCRCommon.ErrorCode.valueOf(errorCodeName)) == OCRCommon.ErrorCode.error_deviceMemory) {
                            String exception = messageData.getString("exceptionError");
                            Intent data = new Intent();
                            data.putExtra("MOBIFLOW_ERROR_DETAILS", exception);
                            ((CameraController)this.looperActivity.get()).setResult(119, data);
                            ((CameraController)this.looperActivity.get()).finish();
                            return;
                        }
                        if ((this.cameraController.isDebug || drawFoundedRectangle) && checkRectBundle != null) {
                            Rect rect = OCRHelper.bundleToRect(checkRectBundle);
                            this.dispatchHintIndicator(messageData);
                            this.sendEmptyMessageDelayed(14, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
                        }
                        this.proceedWithProcessing();
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 25: {
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("ID_CARD_RESULT", this.cameraController.getBaseContext());
                        }
                        this.cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.ID_CARD_OCR_RESULT;
                        this.cameraController.currentError = null;
                        Object[] idResult = new String[4];
                        OCRResult result = (OCRResult)message.obj;
                        idResult[0] = String.valueOf(result.digitalRowLength);
                        idResult[1] = result.ocrResultWithDelimiter;
                        idResult[2] = result.ocrRawResult;
                        idResult[3] = result.scoreResult;
                        if (!CameraManagerController.isStillMode) {
                            if (listener != null) {
                                listener.onMobiFlowGeneralMessageReceived(this.cameraController.currentCallBack, idResult, ((CameraController)this.looperActivity.get()).dynamicCameraOverlayView.getContext());
                                break;
                            }
                            this.cameraController.onMessageReturn(CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW);
                            break;
                        }
                        if (listener != null) {
                            this.cameraController.activityResultFinish(result.isValidRead);
                        }
                        break;
                    }
                    case 7: {
                        Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");
                        this.initProceedingToNextFrameDelay();
                        if (this.cameraController.isFinishing()) {
                            return;
                        }
                        Bundle bundleCaptureStillImage = messageData;
                        if (this.cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                            Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle("checkRect");
                            Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                            this.cameraController.dynamicCameraOverlayView.bottomLeft = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT");
                            this.cameraController.dynamicCameraOverlayView.bottomRight = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT");
                            this.cameraController.dynamicCameraOverlayView.topRight = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT");
                            this.cameraController.dynamicCameraOverlayView.topLeft = checkRectCaptureBundle.getFloatArray("INTENT_CHECK_QUADS_TOP_LEFT");
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                            this.cameraController.dynamicCameraOverlayView.isValidRect = true;
                            this.cameraController.dynamicCameraOverlayView.isRectFound = true;
                            CameraTypes.HintIndicator hintIndicator = CameraTypes.HintIndicator.Hold;
                            this.cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
                            this.cameraController.dynamicCameraOverlayView.invalidate();
                            if (this.cameraController.cameraSessionManager.getMatchRectsCounter() >= CameraManagerController.identicalRectanglesToCapture) {
                                CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).orientation = bundleCaptureStillImage.getDouble("orientation");
                                this.removeAllMessages();
                                this.captureStillImage();
                            } else {
                                this.proceedWithProcessing();
                            }
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 20: {
                        Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
                        if (this.cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                            OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.cameraController.getApplicationContext());
                            String barcodeType = messageData.getString("barCodeType");
                            String barcodeData = messageData.getString("barCodeData");
                            if (ocrAnalyzeSession.captureMode == CameraTypes.CaptureMode.FRONT) {
                                ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
                                ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
                            } else {
                                ocrAnalyzeSession.setBackBarcodeType(barcodeType);
                                ocrAnalyzeSession.setBackBarcodeData(barcodeData);
                            }
                            Handler handler = new Handler(this.cameraController.getApplicationContext().getMainLooper());
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    DynamicCameraActivityHandler.this.cameraController.dynamicCameraOverlayView.clearBoundariesRect();
                                    DynamicCameraActivityHandler.this.proceedWithProcessing();
                                }
                            }, 1000L);
                            ocrAnalyzeSession.isBarcodeSession = false;
                            break;
                        }
                        this.proceedWithProcessing();
                        break;
                    }
                    case 18: {
                        Logger.i(TAG, "MESSAGE_ERROR");
                        if (!CameraManagerController.isStillMode) {
                            this.proceedWithProcessing();
                        } else {
                            try {
                                String errorMessage = (String)message.obj;
                                Intent data = new Intent();
                                data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
                                activity.setResult(119, data);
                                activity.finish();
                                break;
                            }
                            catch (Exception errorMessage) {
                                // empty catch block
                            }
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_ERROR", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 9: {
                        Logger.i(TAG, "MESSAGE_PROCESS_PRE_CAPTURED_IMAGE");
                        if (CameraManagerController.isStillMode) {
                            this.stopPreview();
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_PROCESS_PRE_CAPTURED_IMAGE", this.cameraController.getBaseContext());
                        }
                        break;
                    }
                    case 8: {
                        Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");
                        this.cameraController.dynamicCameraOverlayView.isRectFound = false;
                        this.cameraController.dynamicCameraOverlayView.invalidate();
                        if (CameraManagerController.isStillMode) {
                            this.cameraController.cameraSessionManager.stopPreviewOnly();
                        }
                        this.cameraController.dynamicCameraOverlayView.showProcessImg();
                        String imagePath = (String)message.obj;
                        if (CameraManagerController.isStillMode) {
                            this.removeAllMessages();
                        }
                        if (CameraManagerController.scanBackOnly) {
                            this.cameraController.processCapturedImage(imagePath);
                            CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).frontImageRect = FileUtils.arrayToRect(this.getFrontImageArrayValues());
                            break;
                        }
                        this.cameraController.processCapturedImage(imagePath);
                        break;
                    }
                    case 24: {
                        this.cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.CHECK_OCR_RESULT;
                        this.cameraController.currentError = null;
                        Object[] ocrResult = new String[4];
                        OCRResult result = (OCRResult)message.obj;
                        ocrResult[0] = String.valueOf(result.digitalRowLength);
                        ocrResult[1] = result.ocrResultWithDelimiter;
                        ocrResult[2] = result.ocrRawResult;
                        ocrResult[3] = result.scoreResult;
                        if (!CameraManagerController.isStillMode) {
                            if (listener != null) {
                                listener.onMobiFlowGeneralMessageReceived(this.cameraController.currentCallBack, ocrResult, ((CameraController)this.looperActivity.get()).dynamicCameraOverlayView.getContext());
                                break;
                            }
                            this.cameraController.onMessageReturn(CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW);
                            break;
                        }
                        this.cameraController.activityResultFinish(result.isValidRead);
                        break;
                    }
                    case 23: {
                        this.cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.PAN_CARD_OCR_RESULT;
                        this.cameraController.currentError = null;
                        Object[] panResult = new String[4];
                        OCRResult result = (OCRResult)message.obj;
                        panResult[0] = String.valueOf(result.digitalRowLength);
                        panResult[1] = result.ocrResultWithDelimiter;
                        panResult[2] = result.ocrRawResult;
                        panResult[3] = result.scoreResult;
                        if (!CameraManagerController.isStillMode) {
                            if (OcrValidationUtils.validationPanCard(result.ocrResultWithDelimiter)) {
                                if (listener != null) {
                                    listener.onMobiFlowGeneralMessageReceived(this.cameraController.currentCallBack, panResult, ((CameraController)this.looperActivity.get()).dynamicCameraOverlayView.getContext());
                                    break;
                                }
                                this.cameraController.onMessageReturn(CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW);
                                break;
                            }
                            this.cameraController.cameraSessionManager.requestAutoFocus(this, 3);
                            this.proceedWithProcessing();
                            break;
                        }
                        this.cameraController.activityResultFinish(result.isValidRead);
                        break;
                    }
                    case 10: {
                        Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT");
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT", this.cameraController.getBaseContext());
                        }
                        OCRResult result = (OCRResult)message.obj;
                        if (!CameraManagerController.isStillMode) {
                            if (result != null && result.isValidRead) {
                                this.cameraController.activityResultFinish(result.isValidRead);
                                break;
                            }
                            if (this.cameraController.continueVideoModeOrShowAlert()) {
                                this.proceedWithProcessing();
                                break;
                            }
                            this.cameraController.activityResultFinish(result != null && result.isValidRead);
                            break;
                        }
                        this.cameraController.activityResultFinish(result != null && result.isValidRead);
                        break;
                    }
                    case 19: {
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_CONTINUE_ANYWAY", this.cameraController.getBaseContext());
                        }
                        this.cameraController.activityResultFinish(true);
                        break;
                    }
                    case 16: {
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_TOGGLE_TORCH", this.cameraController.getBaseContext());
                        }
                        CameraManagerController.getOcrAnalyzeSession((Context)this.cameraController.getApplicationContext()).isTorchOn = (Boolean)message.obj;
                        this.restartPreview();
                        this.cameraController.dynamicCameraOverlayView.enableTorchButton(true);
                    }
                }
            }
            catch (Exception e) {
                activity.setResult(119);
                activity.finish();
            }
        }

        double calAngleBetweenPoints(float[] first, float[] second) {
            float heigth1 = second[1] - first[1];
            float width1 = second[0] - first[0];
            float rads = (float)Math.atan2(heigth1, width1);
            return 180.0 * (double)rads / M_PI;
        }

        private int[] getFrontImageArrayValues() {
            if (CameraManagerController.frontImageRectArray == null) {
                CameraManagerController.frontImageRectArray = new int[4];
                CameraManagerController.frontImageRectArray[0] = 0;
                CameraManagerController.frontImageRectArray[1] = 0;
                CameraManagerController.frontImageRectArray[2] = 1200;
                CameraManagerController.frontImageRectArray[3] = 600;
            }
            return CameraManagerController.frontImageRectArray;
        }

        private void dispatchHintIndicator(Bundle messageData) {
            String hintIndicatorName;
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "dispatchHintIndicator cameraController reference is null");
                return;
            }
            if (messageData != null && !StringUtils.isEmptyOrNull(hintIndicatorName = messageData.getString("hintName"))) {
                CameraTypes.HintIndicator hintIndicator = CameraTypes.HintIndicator.valueOf(hintIndicatorName);
            }
        }

        private void proceedWithProcessing() {
            final CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "proceedWithProcessing cameraController reference is null");
                return;
            }
            if (cameraController.isFinishing()) {
                return;
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    cameraController.cameraSessionManager.requestPreviewFrame(activity, cameraController.mobiCHECKOCR);
                }
            }, this.proceedingToNextFrameDelay);
        }

        private void captureStillImage() {
            Logger.i(TAG, "captureStillImage");
            final CameraController cameraController = (CameraController)this.looperActivity.get();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    cameraController.cameraSessionManager.requestCaptureStillImage(DynamicCaptureCameraController.activity.handler, 8, CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).captureMode);
                }
            }, 100L);
        }

        private void restartPreview() {
            this.stopPreview();
            this.startPreview();
        }

        @Override
        protected void startPreview() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "startPreview cameraController reference is null");
                return;
            }
            cameraController.cameraSessionManager.startPreview(CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).isTorchOn);
            this.restartPreviewAndDecode();
        }

        @Override
        public void stopPreview() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "stopPreview cameraController reference is null");
                return;
            }
            cameraController.cameraSessionManager.setState(CameraSessionManager.State.DONE);
            cameraController.cameraSessionManager.stopPreview();
        }

        @Override
        public void quitSynchronously() {
            this.stopPreview();
            this.removeAllMessages();
        }

        @Override
        public void removeAllMessages() {
            this.removeMessages(2);
            this.removeMessages(3);
            this.removeMessages(4);
            this.removeMessages(6);
            this.removeMessages(7);
            this.removeMessages(8);
            this.removeMessages(10);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
            this.removeMessages(16);
            this.removeMessages(17);
            this.removeMessages(18);
            this.removeMessages(20);
            this.removeMessages(21);
        }

        @Override
        public void removeAllPreviewProcessingMessages() {
            this.removeMessages(4);
            this.removeMessages(6);
            this.removeMessages(7);
            this.removeMessages(8);
            this.removeMessages(10);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
            this.removeMessages(17);
            this.removeMessages(18);
            this.removeMessages(20);
            this.removeMessages(21);
        }

        private void restartPreviewAndDecode() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "restartPreviewAndDecode cameraController reference is null");
                return;
            }
            if (cameraController.cameraSessionManager.getState() == CameraSessionManager.State.NONE || cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW || cameraController.cameraSessionManager.getState() == CameraSessionManager.State.SUCCESS) {
                cameraController.restartInfoScreen();
                if (!CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).isManualCapture) {
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DynamicCameraActivityHandler.this.proceedWithProcessing();
                        }
                    }, 500L);
                }
                cameraController.cameraSessionManager.requestAutoFocus(this, 3);
            }
        }

        @Override
        public void removeLowPriorityMessages() {
            this.removeMessages(3);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
        }
    }
}

