/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.topimagesystems.R;
import com.topimagesystems.camera2.AutoFitTextureView;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.ui.OneUnitLeveler;
import com.topimagesystems.ui.ScaleLeveler;
import com.topimagesystems.ui.TwoUnitsLeveler;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class DynamicCameraOverlayLayout
extends CameraOverlayLayout {
    private boolean isPortrait;
    private Rect surfaceRect;
    private Context context;
    private boolean grid = true;
    private int heightGridLineNumber = 12;
    private int widthGridLineNumber = 12;
    public float[] topLeft;
    public float[] topRight;
    public float[] bottomLeft;
    public float[] bottomRight;
    public boolean isValidRect;
    public boolean isRectFound;
    private Path path;
    Paint validRectPaintStroke;
    Paint validRectPaintFill;
    Paint inValidRectPaint;
    Paint gridPaint;
    Paint extraBordersPaint;
    private Button btnCancel;
    private ImageView sucessImg;
    private View viewTouchFocus;
    private CameraController.ActionClickListener actionClickListener;
    private Matrix scaleMatrix = null;
    private String TAG = "DynamicCameraOverlayLayout";
    private final int transitionDuration = 250;
    private long transitionStartTime;
    private float[] animTopLeft;
    private float[] animTopRight;
    private float[] animBottomLeft;
    private float[] animBottomRight;
    private float[] animTopLeftStart;
    private float[] animTopRightStart;
    private float[] animBottomLeftStart;
    private float[] animBottomRightStart;
    private float[] animTopLeftEnd;
    private float[] animTopRightEnd;
    private float[] animBottomLeftEnd;
    private float[] animBottomRightEnd;

    public DynamicCameraOverlayLayout(Context _context) {
        super(_context);
        this.context = _context;
        this.path = new Path();
        this.isPortrait = CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT;
    }

    public DynamicCameraOverlayLayout(Context _context, AttributeSet attributeSet) {
        super(_context, attributeSet);
        this.context = _context;
        this.path = new Path();
        this.isPortrait = CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT;
    }

    @Override
    public void ensureUI() {
        if (!UserInterfaceUtils.hasHardwareAcceleration(DynamicCaptureCameraController.getInstance())) {
            AutoFitTextureView mTextureView = (AutoFitTextureView)this.findViewById(R.id.texture);
            mTextureView.setVisibility(8);
        }
        this.btnCancel = (Button)this.findViewById(R.id.dynamicBtnCancel);
        this.sucessImg = (ImageView)this.findViewById(R.id.succssesImg);
        this.sucessImg.setVisibility(8);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerHorizontal);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerVertical);
        this.oneUnitLeveler = (OneUnitLeveler)this.findViewById(R.id.dynamicOneUnitLeveler);
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerPortrait);
        this.spinner = (ProgressBar)this.findViewById(R.id.dynamicLayoutProgressBar);
        this.textIndicator = (TextView)this.findViewById(R.id.DynamicTxtIndicator);
        this.textHoldIndicator = (TextView)this.findViewById(R.id.DynamicHoldIndicator);
        this.imgLogoWaterMark = (ImageView)this.findViewById(R.id.dynamicImgLogoWaterMark);
        this.shouldDisplayLogo = this.imgLogoWaterMark.getVisibility() == 0;
        this.btnTorch = (ToggleButton)this.findViewById(R.id.dynamicBtnTorch);
        this.viewTouchFocus = this.findViewById(R.id.dynamicTouchFocusView);
        if (CameraManagerController.tapToFocus) {
            this.viewTouchFocus.setOnTouchListener(this.tapToFocusListener);
        }
        this.fadeOut = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.view_fade_out);
        this.isOneUnitLeveler = this.oneUnitLeveler.getVisibility() == 0;
        this.fadeOut = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.view_fade_out);
        this.btnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!CameraManagerController.isStillMode && CameraController.processStart) {
                    return;
                }
                DynamicCameraOverlayLayout.this.actionClickListener.quit();
            }
        });
        this.btnTorch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                buttonView.setEnabled(false);
                Message message = CameraController.getInstance().getHandler().obtainMessage(16);
                message.obj = isChecked;
                CameraController.getInstance().getHandler().sendMessage(message);
            }
        });
        if (this.oneUnitLeveler != null) {
            this.initOneUnitLeveler();
        }
        this.initLeveler();
        this.setAnimationListener();
        if (this.checkBoundariesRect != null) {
            this.initcheckBounderiesView(this.checkBoundariesRect);
        }
        this.btnTorch.setVisibility(CameraController.isCameraFlashSupported ? 0 : 4);
    }

    @Override
    public void onClick(View v) {
    }

    @Override
    public void showCheckBoundyRect(boolean isShow, Rect rect) {
    }

    @Override
    public void setActionClickListener(CameraController.ActionClickListener actionClickListener) {
        this.actionClickListener = actionClickListener;
    }

    @Override
    public void setCaptureCaption(CameraTypes.CaptureMode captureMode) {
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        if (CameraManagerController.enableTransitionBetweenRectangles && this.animTopLeftStart == null) {
            this.initTransitionLogic();
        }
        int screenWidth = CameraConfigurationManager.screenResolution.x;
        int screenHeight = CameraConfigurationManager.screenResolution.y;
        if (this.surfaceRect == null) {
            this.surfaceRect = CameraConfigurationManager.adjustedPreviewSize ? UserInterfaceUtils.getFitRectangle(screenWidth, screenHeight, this.isPortrait ? CameraConfigurationManager.videoResolutionHeight : CameraConfigurationManager.videoResolutionWidth, this.isPortrait ? CameraConfigurationManager.videoResolutionWidth : CameraConfigurationManager.videoResolutionHeight) : new Rect(0, 0, screenWidth, screenHeight);
        }
        double widthSize = screenWidth / this.widthGridLineNumber;
        double heightSize = screenHeight / this.heightGridLineNumber;
        boolean animate = false;
        if (this.textHoldIndicator.getVisibility() == 0) {
            this.isValidRect = true;
        }
        if (this.grid) {
            if (this.gridPaint == null) {
                this.gridPaint = new Paint();
                this.gridPaint.setAntiAlias(true);
                this.gridPaint.setStrokeWidth(3.0f);
                this.gridPaint.setStyle(Paint.Style.STROKE);
                this.gridPaint.setColor(this.getResources().getColor(R.color.grid_line_color));
            }
            int i = (int)widthSize;
            while ((double)i < (double)screenWidth + widthSize) {
                canvas.drawLine((float)i, 0.0f, (float)i, (float)screenHeight, this.gridPaint);
                i = (int)((double)i + widthSize);
            }
            i = (int)heightSize;
            while ((double)i < (double)screenHeight + heightSize) {
                canvas.drawLine(0.0f, (float)i, (float)screenWidth, (float)i, this.gridPaint);
                i = (int)((double)i + heightSize);
            }
        }
        if (CameraConfigurationManager.adjustedPreviewSize) {
            if (this.extraBordersPaint == null) {
                this.extraBordersPaint = new Paint();
                this.extraBordersPaint.setColor(-16777216);
                this.extraBordersPaint.setStyle(Paint.Style.FILL);
            }
            if (this.surfaceRect.width < screenWidth) {
                canvas.drawRect(new android.graphics.Rect(0, 0, this.surfaceRect.x, screenHeight), this.extraBordersPaint);
                canvas.drawRect(new android.graphics.Rect((int)this.surfaceRect.br().x, 0, screenWidth, screenHeight), this.extraBordersPaint);
            }
            if (this.surfaceRect.height < screenHeight) {
                canvas.drawRect(new android.graphics.Rect(0, 0, screenWidth, this.surfaceRect.y), this.extraBordersPaint);
                canvas.drawRect(new android.graphics.Rect(0, (int)this.surfaceRect.br().y, screenWidth, screenHeight), this.extraBordersPaint);
            }
        }
        if (this.validRectPaintStroke == null) {
            this.validRectPaintStroke = new Paint();
            this.validRectPaintStroke.setAntiAlias(true);
            this.validRectPaintStroke.setStrokeWidth(10.0f);
            this.validRectPaintStroke.setColor(this.getResources().getColor(R.color.validRectStrokeColor));
            this.validRectPaintStroke.setStyle(Paint.Style.STROKE);
        }
        if (this.validRectPaintFill == null) {
            this.validRectPaintFill = new Paint();
            this.validRectPaintFill.setAntiAlias(true);
            this.validRectPaintFill.setStrokeWidth(10.0f);
            this.validRectPaintFill.setColor(this.getResources().getColor(R.color.validRectFillColor));
            this.validRectPaintFill.setStyle(Paint.Style.FILL);
        }
        if (this.inValidRectPaint == null) {
            this.inValidRectPaint = new Paint();
            this.inValidRectPaint.setAntiAlias(true);
            this.inValidRectPaint.setStrokeWidth(8.0f);
            this.inValidRectPaint.setStyle(Paint.Style.STROKE);
            this.inValidRectPaint.setColor(this.getResources().getColor(R.color.invalidRectStrokeColor));
        }
        if (!this.isRectFound) {
            this.path.reset();
            canvas.drawPath(this.path, this.validRectPaintStroke);
            return;
        }
        if (this.bottomLeft != null && this.topLeft[0] != 0.0f) {
            this.path.reset();
            if (this.isRectFound) {
                if (this.scaleMatrix == null) {
                    RectF nativeResRect;
                    RectF previewRect;
                    int previewSmallRes;
                    int previewBigRes;
                    int videoSmallRes;
                    int videoBigRes;
                    this.scaleMatrix = new Matrix();
                    if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight) {
                        videoBigRes = CameraConfigurationManager.videoResolutionWidth;
                        videoSmallRes = CameraConfigurationManager.videoResolutionHeight;
                    } else {
                        videoSmallRes = CameraConfigurationManager.videoResolutionWidth;
                        videoBigRes = CameraConfigurationManager.videoResolutionHeight;
                    }
                    if (this.surfaceRect.width > this.surfaceRect.height) {
                        previewBigRes = this.surfaceRect.width;
                        previewSmallRes = this.surfaceRect.height;
                    } else {
                        previewBigRes = this.surfaceRect.height;
                        previewSmallRes = this.surfaceRect.width;
                    }
                    if (!this.isPortrait) {
                        previewRect = new RectF(0.0f, 0.0f, (float)previewBigRes, (float)previewSmallRes);
                        nativeResRect = new RectF(0.0f, 0.0f, (float)videoBigRes, (float)videoSmallRes);
                    } else {
                        previewRect = new RectF(0.0f, 0.0f, (float)previewSmallRes, (float)previewBigRes);
                        nativeResRect = new RectF(0.0f, 0.0f, (float)videoSmallRes, (float)videoBigRes);
                    }
                    this.scaleMatrix.setRectToRect(nativeResRect, previewRect, Matrix.ScaleToFit.FILL);
                    if (CameraConfigurationManager.adjustedPreviewSize) {
                        this.scaleMatrix.setTranslate((float)this.surfaceRect.x, (float)this.surfaceRect.y);
                    }
                }
                if (CameraManagerController.enableTransitionBetweenRectangles) {
                    this.drawRectangleWithTransition();
                    animate = true;
                } else {
                    this.path.moveTo(this.topLeft[0], this.topLeft[1]);
                    this.path.quadTo(this.topLeft[0], this.topLeft[1], this.topRight[0], this.topRight[1]);
                    this.path.quadTo(this.topRight[0], this.topRight[1], this.bottomRight[0], this.bottomRight[1]);
                    this.path.quadTo(this.bottomRight[0], this.bottomRight[1], this.bottomLeft[0], this.bottomLeft[1]);
                    this.path.quadTo(this.bottomLeft[0], this.bottomLeft[1], this.topLeft[0], this.topLeft[1]);
                }
                this.path.transform(this.scaleMatrix);
                if (this.isValidRect) {
                    canvas.drawPath(this.path, this.validRectPaintStroke);
                    canvas.drawPath(this.path, this.validRectPaintFill);
                    CameraController.frameWasGreen = true;
                } else {
                    canvas.drawPath(this.path, this.inValidRectPaint);
                }
            }
        }
        if (animate) {
            this.invalidate();
        }
    }

    private void initTransitionLogic() {
        if (this.topLeft != null && this.animTopLeft == null) {
            DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
            this.animTopLeftStart = new float[]{0.0f, 0.0f};
            this.animTopRightStart = new float[]{metrics.widthPixels, 0.0f};
            this.animBottomLeftStart = new float[]{0.0f, metrics.heightPixels};
            this.animBottomRightStart = new float[]{metrics.widthPixels, metrics.heightPixels};
            this.animTopLeftEnd = new float[]{this.topLeft[0], this.topLeft[1]};
            this.animTopRightEnd = new float[]{this.topRight[0], this.topRight[1]};
            this.animBottomLeftEnd = new float[]{this.bottomLeft[0], this.bottomLeft[1]};
            this.animBottomRightEnd = new float[]{this.bottomRight[0], this.bottomRight[1]};
            this.animTopLeft = new float[]{0.0f, 0.0f};
            this.animTopRight = new float[]{0.0f, 0.0f};
            this.animBottomLeft = new float[]{0.0f, 0.0f};
            this.animBottomRight = new float[]{0.0f, 0.0f};
            this.transitionStartTime = System.currentTimeMillis();
        }
    }

    private void drawRectangleWithTransition() {
        long time = System.currentTimeMillis() - this.transitionStartTime;
        if (time > 250L) {
            this.transitionStartTime = System.currentTimeMillis();
            time = 0L;
            this.animTopLeftStart = this.animTopLeftEnd;
            this.animTopRightStart = this.animTopRightEnd;
            this.animBottomLeftStart = this.animBottomLeftEnd;
            this.animBottomRightStart = this.animBottomRightEnd;
            this.animTopLeftEnd = new float[]{this.topLeft[0], this.topLeft[1]};
            this.animTopRightEnd = new float[]{this.topRight[0], this.topRight[1]};
            this.animBottomLeftEnd = new float[]{this.bottomLeft[0], this.bottomLeft[1]};
            this.animBottomRightEnd = new float[]{this.bottomRight[0], this.bottomRight[1]};
        }
        this.findNewAnimationPoint(this.animTopLeftStart, this.animTopLeftEnd, this.animTopLeft, time);
        this.findNewAnimationPoint(this.animTopRightStart, this.animTopRightEnd, this.animTopRight, time);
        this.findNewAnimationPoint(this.animBottomLeftStart, this.animBottomLeftEnd, this.animBottomLeft, time);
        this.findNewAnimationPoint(this.animBottomRightStart, this.animBottomRightEnd, this.animBottomRight, time);
        this.path.moveTo(this.animTopLeft[0], this.animTopLeft[1]);
        this.path.quadTo(this.animTopLeft[0], this.animTopLeft[1], this.animTopRight[0], this.animTopRight[1]);
        this.path.quadTo(this.animTopRight[0], this.animTopRight[1], this.animBottomRight[0], this.animBottomRight[1]);
        this.path.quadTo(this.animBottomRight[0], this.animBottomRight[1], this.animBottomLeft[0], this.animBottomLeft[1]);
        this.path.quadTo(this.animBottomLeft[0], this.animBottomLeft[1], this.animTopLeft[0], this.animTopLeft[1]);
    }

    private float easeIn(double t, float b, float c, double d) {
        return (float)((double)c * (t /= d) * t + (double)b);
    }

    private void findNewAnimationPoint(float[] startArr, float[] rectangleArr, float[] animArr, long time) {
        animArr[0] = this.easeIn(time, startArr[0], rectangleArr[0] - startArr[0], 250.0);
        animArr[1] = this.easeIn(time, startArr[1], rectangleArr[1] - startArr[1], 250.0);
    }

    @Override
    protected void initcheckBounderiesView(CheckBoundaries checkBoundariesRect) {
        this.isCheckBounderiesViewInit = true;
        Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(this.getContext());
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerHorizontal);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerPortrait);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerVertical);
    }

    public void showProcessImg() {
        this.spinner.setVisibility(0);
        this.btnCancel.setVisibility(8);
        this.oneUnitLeveler.setVisibility(8);
    }

    @Override
    public void finishCapture() {
        this.btnCancel.setVisibility(0);
    }

    @Override
    public void switchToProcessingView(boolean showBoundries) {
        this.btnCancel.setVisibility(8);
        this.textHoldIndicator.setVisibility(8);
    }

    public void removeCaptureElements() {
        if (this.sucessImg != null) {
            this.sucessImg.setVisibility(8);
        }
        if (this.spinner != null) {
            this.spinner.setVisibility(8);
        }
        if (this.btnCancel != null) {
            this.btnCancel.setVisibility(0);
        }
    }
}

