/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.topimagesystems.Config;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.StabilityDetection;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.ui.CheckBounderiesView;
import com.topimagesystems.ui.Counter;
import com.topimagesystems.ui.DebugRectView;
import com.topimagesystems.ui.OneUnitLeveler;
import com.topimagesystems.ui.ScaleLeveler;
import com.topimagesystems.ui.TwoUnitsLeveler;
import com.topimagesystems.util.AccessibilityUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class CameraOverlayLayout
extends RelativeLayout
implements SensorEventListener,
View.OnClickListener {
    private static final String TAG = Logger.makeLogTag("CameraOverlay");
    protected ToggleButton btnTorch;
    private Button btnCancel;
    private Button btnCapture;
    private View viewTouchFocus;
    private DebugRectView checkRectBounderies;
    protected CheckBounderiesView checkBounderiesView;
    private TextView txtCapture;
    private TextView txtX;
    private TextView txtY;
    private TextView txtZ;
    public TextView textIndicator;
    public TextView textHoldIndicator;
    private TextView textStaticIndicator;
    private Counter counter;
    protected OneUnitLeveler oneUnitLeveler;
    protected TwoUnitsLeveler horizontalLeveler;
    protected TwoUnitsLeveler verticalLeveler;
    protected ScaleLeveler horizontalScaleLeveler;
    protected ScaleLeveler verticalScaleLeveler;
    private View processingOverlay;
    private RelativeLayout captureOverlay;
    protected ImageView imgLogoWaterMark;
    protected boolean shouldDisplayLogo;
    private boolean isCustomView = true;
    private CameraTypes.HintIndicator currentHintIndicator;
    private Context context;
    private boolean captureFrameInicator = false;
    private CameraController.ActionClickListener actionClickListener;
    private boolean isShowingHint;
    private boolean isValidX;
    private boolean isValidY;
    private boolean isValidZ;
    private boolean isValid;
    private long lastTimeIndicatorWasDisplayed = 0L;
    private long lastTimeIndicatorWasAnnounced = 0L;
    private long lastTimeInstructionWasAnnounced = 0L;
    private long lastTimeShowOrientation = 0L;
    protected CheckBoundaries checkBoundariesRect;
    protected Animation fadeOut;
    protected boolean isCheckBounderiesViewInit = false;
    protected boolean isOneUnitLeveler = true;
    protected boolean isHorizontalUnitLeveler = false;
    protected boolean isVerticalUnitLeveler = false;
    protected boolean isHorizontalScaleLeveler = false;
    protected boolean isVerticalScaleLeveler = false;
    private boolean isValidOrientation;
    private boolean isFadeOutAnimation = false;
    private boolean isFadeOutBoundariesAnimation = false;
    protected ProgressBar spinner;
    float orientationY;
    float orientationX;
    float orientationZ;
    float azimutLocation;
    float pitchLocation;
    float rollLocation;
    float[] geoMagnetic;
    float[] gravity;
    private final StabilityDetection.StableSampleQueue sampleQueue = new StabilityDetection.StableSampleQueue();
    protected View.OnTouchListener tapToFocusListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    CameraController.getInstance().handleTouchForFocus(true);
                    break;
                }
                case 1: 
                case 3: {
                    CameraController.getInstance().handleTouchForFocus(false);
                }
            }
            return true;
        }
    };

    public CameraOverlayLayout(Context _context) {
        super(_context);
        this.context = _context;
    }

    public CameraOverlayLayout(Context _context, AttributeSet attributeSet) {
        super(_context, attributeSet);
        this.context = _context;
    }

    public CameraOverlayLayout(Context _context, AttributeSet attributeSet, int defStyle) {
        super(_context, attributeSet, defStyle);
        this.context = _context;
    }

    protected void onFinishInflate() {
        this.ensureUI();
    }

    public void onAccuracyChanged(Sensor paramSensor, int paramInt) {
    }

    public void onClick(View v) {
        Message message = CameraController.getInstance().getHandler().obtainMessage(3);
        CameraController.getInstance().getHandler().sendMessage(message);
    }

    public void onSensorChanged(SensorEvent event) {
        try {
            if (event.sensor.getType() == 1) {
                this.gravity = (float[])event.values.clone();
                if (CameraController.getInstance().isPreviewing()) {
                    this.orientationY = event.values[1];
                    this.orientationZ = event.values[2];
                    this.orientationX = event.values[0];
                    this.isValidOrientation = this.calcIsValidOrientation(this.orientationX, this.orientationY, this.orientationZ);
                }
            } else if (event.sensor.getType() == 2 && CameraController.getInstance().isPreviewing()) {
                long currentTimeInMillsec = System.currentTimeMillis();
                long delta = currentTimeInMillsec - this.lastTimeShowOrientation;
                if (delta > 0L) {
                    this.lastTimeShowOrientation = currentTimeInMillsec;
                    this.geoMagnetic = (float[])event.values.clone();
                    if (this.geoMagnetic != null & this.gravity != null) {
                        float[] R2 = new float[9];
                        float[] I = new float[9];
                        boolean success = SensorManager.getRotationMatrix((float[])R2, (float[])I, (float[])this.gravity, (float[])this.geoMagnetic);
                        boolean remapped = SensorManager.remapCoordinateSystem((float[])I, (int)2, (int)129, (float[])I);
                        if (success) {
                            float[] orientation = new float[3];
                            SensorManager.getOrientation((float[])R2, (float[])orientation);
                            this.azimutLocation = 57.29578f * orientation[0];
                            this.pitchLocation = 57.29578f * orientation[1];
                            this.rollLocation = 57.29578f * orientation[2];
                            float f = Math.abs((float)((double)1.4f * Math.tan((double)this.pitchLocation * Math.PI / 180.0)));
                        }
                    }
                    if (CameraManagerController.deviceName.contains("ASUS Transformer Pad")) {
                        float tmp = this.pitchLocation;
                        this.pitchLocation = this.rollLocation;
                        this.rollLocation = tmp;
                    }
                    event.values[0] = this.azimutLocation;
                    event.values[1] = this.pitchLocation;
                    event.values[2] = this.rollLocation;
                    this.showBounderies(this.isValidOrientation, event.values);
                    if (!this.isValidOrientation) {
                        this.showIndicator(CameraTypes.HintIndicator.HoldFlat, true);
                    }
                }
                if (CameraController.getInstance() != null) {
                    CameraController.getInstance().setIsValidOrientation(this.isValidOrientation);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isAccelerating(SensorEvent event) {
        float ax = event.values[0];
        float ay = event.values[1];
        float az = event.values[2];
        double magnitude = Math.sqrt(ax * ax + ay * ay + az * az);
        return magnitude > 10.5;
    }

    public boolean calcIsValidOrientation(double orientationX, double orientationY, double orientationZ) {
        Config.ACCELERATION_X_THRESHOLD = 1.5f;
        Config.ACCELERATION_BASIC_THRESHOLD = 1.5f;
        if (CameraManagerController.enableSoftCaptureAndImageAligment) {
            Config.ACCELERATION_X_THRESHOLD *= 2.3f + CameraManagerController.softCaptureThreshold * 2.0f;
            Config.ACCELERATION_BASIC_THRESHOLD *= 1.1f + CameraManagerController.softCaptureThreshold * 0.15f;
        }
        this.isValidX = Math.abs(orientationX - 0.0) < (double)Config.ACCELERATION_X_THRESHOLD;
        this.isValidY = Math.abs(orientationY - 0.0) < (double)Config.ACCELERATION_BASIC_THRESHOLD;
        boolean bl = this.isValidZ = Math.abs(orientationZ - 10.0) < (double)Config.ACCELERATION_BASIC_THRESHOLD;
        if (this.isHorizontalUnitLeveler && !this.isVerticalUnitLeveler) {
            this.isValidX = true;
        }
        if (!this.isHorizontalUnitLeveler && this.isVerticalUnitLeveler) {
            this.isValidY = true;
        }
        return this.isValidX && this.isValidY && this.isValidZ;
    }

    public boolean getCaptureFrameIndicator() {
        return this.captureFrameInicator;
    }

    protected void initOneUnitLeveler() {
        if (this.oneUnitLeveler != null) {
            boolean bl = this.isOneUnitLeveler = this.oneUnitLeveler.getVisibility() == 0 || CameraManagerController.levlerType != null && CameraManagerController.levlerType == CaptureIntent.LevelerType.ONE_UNIT;
            if (this.isOneUnitLeveler) {
                this.oneUnitLeveler.showLeveler();
                if (this.oneUnitLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= 11) {
                    this.oneUnitLeveler.setOnTouchListener(new View.OnTouchListener(){
                        PointF levelerTouched = new PointF();
                        PointF levelerStartDrag = new PointF();

                        @SuppressLint(value={"NewApi"})
                        public boolean onTouch(View v, MotionEvent event) {
                            int eid = event.getAction();
                            switch (eid) {
                                case 2: {
                                    PointF mv = new PointF(event.getX() - this.levelerTouched.x, event.getY() - this.levelerTouched.y);
                                    CameraOverlayLayout.this.oneUnitLeveler.setX((int)(this.levelerStartDrag.x + mv.x));
                                    CameraOverlayLayout.this.oneUnitLeveler.setY((int)(this.levelerStartDrag.y + mv.y));
                                    this.levelerStartDrag = new PointF(CameraOverlayLayout.this.oneUnitLeveler.getX(), CameraOverlayLayout.this.oneUnitLeveler.getY());
                                    break;
                                }
                                case 0: {
                                    this.levelerTouched.x = event.getX();
                                    this.levelerTouched.y = event.getY();
                                    this.levelerStartDrag = new PointF(CameraOverlayLayout.this.oneUnitLeveler.getX(), CameraOverlayLayout.this.oneUnitLeveler.getY());
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            return true;
                        }
                    });
                }
            }
        }
    }

    public void ensureUI() {
        this.isCustomView = CameraManagerController.isCustomView;
        if (this.isInEditMode()) {
            return;
        }
        boolean isDebug = CameraManagerController.isDebug;
        this.checkRectBounderies = (DebugRectView)this.findViewById(this.isCustomView ? R.id.customCheckRectBounderies : R.id.checkRectBounderies);
        this.processingOverlay = this.findViewById(this.isCustomView ? R.id.customProcessingOverlay : R.id.processingOverlay);
        this.captureOverlay = (RelativeLayout)this.findViewById(this.isCustomView ? R.id.customCaptureOverlay : R.id.captureOverlay);
        this.imgLogoWaterMark = (ImageView)this.findViewById(this.isCustomView ? R.id.customImgLogoWaterMark : R.id.imgLogoWaterMark);
        this.shouldDisplayLogo = this.imgLogoWaterMark.getVisibility() == 0;
        this.spinner = (ProgressBar)this.findViewById(this.isCustomView ? R.id.customProgressBarMainView : R.id.progressBarMainView);
        this.counter = (Counter)this.findViewById(this.isCustomView ? R.id.customCounter : R.id.counter);
        this.oneUnitLeveler = (OneUnitLeveler)this.findViewById(this.isCustomView ? R.id.customLeveler : R.id.leveler);
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(this.isCustomView ? R.id.customLevelerHorizontal : R.id.levelerHorizontal);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(this.isCustomView ? R.id.customScaleLevelerHorizontal : R.id.scaleLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(this.isCustomView ? R.id.customLevelerPortrait : R.id.levelerPortrait);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(this.isCustomView ? R.id.customScaleLevelerVertical : R.id.scaleLevelerVertical);
        if (this.oneUnitLeveler != null) {
            this.initOneUnitLeveler();
        }
        this.initLeveler();
        if (this.checkBoundariesRect != null) {
            this.initcheckBounderiesView(this.checkBoundariesRect);
        }
        this.textIndicator = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtIndicator : R.id.txtIndicator);
        this.textIndicator.setVisibility(8);
        this.textHoldIndicator = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtHoldIndicator : R.id.txtHoldIndicator);
        if (CameraManagerController.isCustomView) {
            this.textStaticIndicator = (TextView)this.findViewById(R.id.customStaticTxtIndicator);
            this.textStaticIndicator.setVisibility(0);
        }
        this.textHoldIndicator.setVisibility(8);
        LinearLayout debugBox = (LinearLayout)this.findViewById(this.isCustomView ? R.id.customDebugBox : R.id.debugBox);
        debugBox.setVisibility(isDebug ? 0 : 8);
        this.txtCapture = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtCapture : R.id.txtCapture);
        this.txtCapture.setText((CharSequence)"");
        this.txtX = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtX : R.id.txtX);
        this.txtY = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtY : R.id.txtY);
        this.txtZ = (TextView)this.findViewById(this.isCustomView ? R.id.customTxtZ : R.id.txtZ);
        this.fadeOut = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.view_fade_out);
        this.setAnimationListener();
        this.btnTorch = (ToggleButton)this.findViewById(this.isCustomView ? R.id.customBtnTorch : R.id.btnTorch);
        this.btnCancel = (Button)this.findViewById(this.isCustomView ? R.id.customBtnCancel : R.id.btnCancel);
        this.btnCapture = (Button)this.findViewById(this.isCustomView ? R.id.customBtnCapture : R.id.btnCapture);
        this.viewTouchFocus = this.findViewById(this.isCustomView ? R.id.customTouchFocusView : R.id.touchFocusView);
        if (CameraManagerController.tapToFocus) {
            this.viewTouchFocus.setOnTouchListener(this.tapToFocusListener);
        }
        this.btnCapture.setText((CharSequence)StringUtils.dynamicString(this.context, "next"));
        OnClickListenerIMpl onClickListenerIMpl = new OnClickListenerIMpl();
        this.btnCancel.setOnClickListener((View.OnClickListener)onClickListenerIMpl);
        this.btnCapture.setOnClickListener((View.OnClickListener)onClickListenerIMpl);
        this.btnTorch.setOnClickListener((View.OnClickListener)onClickListenerIMpl);
        if (CameraController.getInstance() != null) {
            CameraController.getInstance().onSentUIEventMessage(CameraTypes.TISFlowUIMessages.INIT_LAYOUT);
        }
        this.setCaptureCaption(CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).captureMode);
        this.btnTorch.setVisibility(CameraController.isCameraFlashSupported ? 0 : 4);
    }

    protected void handleCameraFlashSupport() {
        if (this.btnTorch != null) {
            this.btnTorch.setVisibility(CameraController.isCameraFlashSupported ? 0 : 4);
        }
    }

    public void setIsTorchOn(boolean isTorchOn) {
        this.btnTorch.setOnClickListener(null);
        this.btnTorch.setChecked(isTorchOn);
        this.btnTorch.setOnClickListener((View.OnClickListener)new OnClickListenerIMpl());
    }

    public void enableTorchButton(boolean isEnable) {
        this.btnTorch.setEnabled(isEnable);
    }

    public void setCaptureCaption(CameraTypes.CaptureMode captureMode) {
        String caption = null;
        block0 : switch (captureMode) {
            case FRONT: {
                switch (CameraManagerController.imageType) {
                    case CHECK: {
                        caption = StringUtils.dynamicString(this.getContext(), "TISFlowPleaseCaptureCheckFront");
                        break block0;
                    }
                }
                caption = StringUtils.dynamicString(this.getContext(), "TISFlowPleaseCaptureImageFront");
                break;
            }
            case BACK: {
                switch (CameraManagerController.imageType) {
                    case CHECK: {
                        caption = StringUtils.dynamicString(this.getContext(), "TISFlowPleaseCaptureCheckBack");
                        break block0;
                    }
                }
                caption = StringUtils.dynamicString(this.getContext(), "TISFlowPleaseCaptureImageBack");
            }
        }
        if (CameraManagerController.getOcrAnalyzeSession((Context)this.getContext()).isBarcodeSession) {
            caption = StringUtils.dynamicString(this.getContext(), "TISFlowPleaseCaptureTheBarcode");
        }
        if (caption != null) {
            long currentTimeInMillsec = System.currentTimeMillis();
            boolean shouldSendAnnouncement = !this.txtCapture.getText().toString().equals(caption) || currentTimeInMillsec - this.lastTimeInstructionWasAnnounced >= 6000L;
            this.txtCapture.setText((CharSequence)caption);
            this.txtCapture.setContentDescription((CharSequence)caption);
            if (shouldSendAnnouncement) {
                CameraController.getInstance().onSentUIEventMessage(CameraTypes.TISFlowUIMessages.INSTRUCTION_CHANGED);
                AccessibilityUtils.sendAnnouncement(this.getContext(), this.txtCapture, ((Object)((Object)this)).getClass().getName());
                this.lastTimeInstructionWasAnnounced = this.lastTimeInstructionWasAnnounced == 0L ? 1L : currentTimeInMillsec;
            }
        }
    }

    private void showCounter(int from) {
        this.showCounter(true, from);
    }

    public void finishCapture() {
        this.counter.setVisibility(8);
        this.txtCapture.setVisibility(0);
        this.btnTorch.setVisibility(0);
        if (this.shouldDisplayLogo) {
            this.imgLogoWaterMark.setVisibility(0);
        }
        this.checkBounderiesView.showBounderies(false, true);
        this.textHoldIndicator.setVisibility(8);
        this.textIndicator.setVisibility(0);
        this.btnCancel.setVisibility(0);
        this.currentHintIndicator = CameraTypes.HintIndicator.None;
        if (CameraManagerController.isCustomView) {
            this.textStaticIndicator.setVisibility(0);
        }
        if (this.isOneUnitLeveler) {
            this.oneUnitLeveler.setVisibility(0);
        }
        if (this.isVerticalUnitLeveler) {
            this.verticalLeveler.setVisibility(0);
        }
        if (this.isHorizontalUnitLeveler) {
            this.horizontalLeveler.setVisibility(0);
        }
        if (this.isHorizontalScaleLeveler) {
            this.horizontalScaleLeveler.setVisibility(0);
        }
        if (this.isVerticalScaleLeveler) {
            this.verticalScaleLeveler.setVisibility(0);
        }
        this.spinner.setVisibility(8);
        this.checkBounderiesView.invalidate();
    }

    public void switchToProcessingView(boolean showBoundries) {
        if (!showBoundries) {
            this.textHoldIndicator.setVisibility(8);
            this.textIndicator.setVisibility(8);
            this.checkBounderiesView.showBounderies(false, false);
        }
        this.textHoldIndicator.setVisibility(8);
        this.spinner.setVisibility(0);
        this.counter.setVisibility(8);
        this.btnTorch.setVisibility(8);
        this.imgLogoWaterMark.setVisibility(8);
        this.btnCancel.setVisibility(8);
        this.txtCapture.setVisibility(8);
        this.currentHintIndicator = CameraTypes.HintIndicator.None;
        if (CameraManagerController.isCustomView) {
            this.textStaticIndicator.setVisibility(8);
        }
        if (this.isOneUnitLeveler) {
            this.oneUnitLeveler.setVisibility(8);
        }
        if (this.isVerticalUnitLeveler) {
            this.verticalLeveler.setVisibility(8);
        }
        if (this.isHorizontalUnitLeveler) {
            this.horizontalLeveler.setVisibility(8);
        }
        if (this.isHorizontalScaleLeveler) {
            this.horizontalScaleLeveler.setVisibility(8);
        }
        if (this.isVerticalScaleLeveler) {
            this.verticalScaleLeveler.setVisibility(8);
        }
    }

    public void showCounter(boolean isShow, long elapsedTime) {
        if (isShow) {
            this.btnCancel.setVisibility(8);
            if (this.oneUnitLeveler.getVisibility() == 0) {
                this.oneUnitLeveler.setVisibility(8);
            }
            if (this.verticalLeveler.getVisibility() == 0) {
                this.verticalLeveler.setVisibility(8);
            }
            if (this.horizontalLeveler.getVisibility() == 0) {
                this.horizontalLeveler.setVisibility(8);
            }
            if (CameraManagerController.isCustomView) {
                this.textStaticIndicator.setVisibility(8);
            }
            this.counter.startCountdown((int)elapsedTime);
        } else {
            this.btnCancel.setVisibility(0);
            this.counter.stopCountdown();
        }
    }

    public void showBounderies(boolean isValid, float[] values) {
        boolean isPortrait;
        boolean bl = isPortrait = CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT;
        if (!CameraManagerController.isDynamicCapture) {
            try {
                if (this.txtX != null && this.txtY != null && this.txtZ != null) {
                    this.txtX.setText((CharSequence)("x:" + String.format("%.02f", Float.valueOf(values[2]))));
                    this.txtY.setText((CharSequence)("y:" + String.format("%.02f", Float.valueOf(values[1]))));
                    this.txtZ.setText((CharSequence)("Z:" + String.format("%.02f", Float.valueOf(values[0]))));
                    this.txtX.setTextColor(this.getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
                    this.txtY.setTextColor(this.getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
                    this.txtZ.setTextColor(this.getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
                }
            }
            catch (Exception e) {
                Logger.e(TAG, Log.getStackTraceString((Throwable)e));
            }
        }
        if (this.isOneUnitLeveler) {
            if (this.oneUnitLeveler.isFadeAnimationEnable()) {
                if (!isValid) {
                    if (this.oneUnitLeveler.getVisibility() != 0) {
                        if (this.isFadeOutAnimation) {
                            this.oneUnitLeveler.clearAnimation();
                            this.oneUnitLeveler.setVisibility(0);
                            Logger.e(TAG, "cancel animation");
                        } else if (!this.isFadeOutAnimation) {
                            this.oneUnitLeveler.setVisibility(0);
                        }
                    }
                } else if (this.oneUnitLeveler.getVisibility() == 0 && !this.isFadeOutAnimation) {
                    Handler handler = new Handler(this.context.getMainLooper());
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (CameraOverlayLayout.this.isValidOrientation) {
                                CameraOverlayLayout.this.oneUnitLeveler.startAnimation(CameraOverlayLayout.this.fadeOut);
                            }
                        }
                    }, 1000L);
                }
            }
            this.oneUnitLeveler.updateLevelerLocation(values, isValid, isPortrait);
        }
        if (this.isHorizontalUnitLeveler) {
            this.horizontalLeveler.updateLevelerLocation(values, this.isValidY, this.isValidZ, isPortrait);
            this.handleAnimation(this.horizontalLeveler, isValid);
        }
        if (this.isVerticalUnitLeveler) {
            this.verticalLeveler.updateLevelerLocation(values, this.isValidY, this.isValidZ, isPortrait);
            this.handleAnimation(this.verticalLeveler, isValid);
        }
        if (this.isHorizontalScaleLeveler) {
            this.horizontalScaleLeveler.updateLevelerLocation(values, this.isValidY, this.isValidZ, isPortrait);
            this.handleAnimation(this.horizontalScaleLeveler, isValid);
        }
        if (this.isVerticalScaleLeveler) {
            this.verticalScaleLeveler.updateLevelerLocation(values, this.isValidY, this.isValidZ, isPortrait);
            this.handleAnimation(this.verticalScaleLeveler, isValid);
        }
    }

    protected void handleAnimation(final TwoUnitsLeveler leveler, boolean isValid) {
        if (leveler.isFadeAnimationEnable()) {
            if (!isValid) {
                if (leveler.getVisibility() != 0) {
                    if (!this.isFadeOutAnimation) {
                        leveler.clearAnimation();
                        leveler.setVisibility(0);
                    } else {
                        Handler handler = new Handler(this.context.getMainLooper());
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (CameraOverlayLayout.this.isValidOrientation) {
                                    leveler.startAnimation(CameraOverlayLayout.this.fadeOut);
                                }
                            }
                        }, 1500L);
                    }
                }
            } else if (leveler.getVisibility() == 0 && !this.isFadeOutAnimation) {
                Handler handler = new Handler(this.context.getMainLooper());
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (CameraOverlayLayout.this.isValidOrientation) {
                            leveler.startAnimation(CameraOverlayLayout.this.fadeOut);
                        }
                    }
                }, 1500L);
            }
        }
    }

    private void handleAnimation(final ScaleLeveler leveler, boolean isValid) {
        if (leveler.isFadeAnimationEnable()) {
            if (!isValid) {
                if (leveler.getVisibility() != 0) {
                    if (!this.isFadeOutAnimation) {
                        leveler.clearAnimation();
                        leveler.setVisibility(0);
                    } else {
                        Handler handler = new Handler(this.context.getMainLooper());
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (CameraOverlayLayout.this.isValidOrientation) {
                                    leveler.startAnimation(CameraOverlayLayout.this.fadeOut);
                                }
                            }
                        }, 1500L);
                    }
                }
            } else if (leveler.getVisibility() == 0 && !this.isFadeOutAnimation) {
                Handler handler = new Handler(this.context.getMainLooper());
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (CameraOverlayLayout.this.isValidOrientation) {
                            leveler.startAnimation(CameraOverlayLayout.this.fadeOut);
                        }
                    }
                }, 1500L);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showIndicator(CameraTypes.HintIndicator hintIndicator, boolean isShow) {
        block10: {
            block9: {
                try {
                    if (!isShow) return this.hideIndicator();
                    if (this.currentHintIndicator == CameraTypes.HintIndicator.Hold && CameraManagerController.isStillMode && !CameraManagerController.isDynamicCapture) {
                        Logger.i(TAG, "not showing other indicators while in hold");
                        return this.isShowingHint;
                    }
                    if (CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()) == null || !CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).isBarcodeSession) break block9;
                    hintIndicator = CameraTypes.HintIndicator.MoveToBARCODE;
                    this.isShowingHint = isShow;
                    this.textIndicator.setText((CharSequence)hintIndicator.getText());
                    this.textIndicator.setContentDescription((CharSequence)hintIndicator.getText());
                    this.textIndicator.setVisibility(0);
                    return true;
                }
                catch (Exception e) {
                    return this.hideIndicator();
                }
            }
            if (CameraManagerController.showGuidelinesIndicators && hintIndicator == CameraTypes.HintIndicator.None) {
                return this.hideIndicator();
            }
            if (CameraController.getInstance().getHandler() != null) break block10;
            return false;
        }
        long currentTimeInMillsec = System.currentTimeMillis();
        if (hintIndicator == CameraTypes.HintIndicator.Hold) {
            this.lastTimeIndicatorWasDisplayed = currentTimeInMillsec;
            this.currentHintIndicator = hintIndicator;
            this.textIndicator.setVisibility(8);
            this.textHoldIndicator.setVisibility(0);
            this.textHoldIndicator.setText((CharSequence)hintIndicator.getText());
            AccessibilityUtils.sendAnnouncement(this.getContext(), this.textHoldIndicator, ((Object)((Object)this)).getClass().getName());
            this.isShowingHint = isShow;
            return this.isShowingHint;
        } else {
            long delta = currentTimeInMillsec - this.lastTimeIndicatorWasDisplayed;
            if (delta < 2000L) return this.isShowingHint;
            CameraController.getInstance().getHandler().sendEmptyMessageDelayed(13, 2000L);
            this.lastTimeIndicatorWasDisplayed = currentTimeInMillsec;
            this.currentHintIndicator = hintIndicator;
            if (!CameraManagerController.showGuidelinesIndicators) {
                hintIndicator = CameraTypes.HintIndicator.Align;
            }
            this.textHoldIndicator.setVisibility(8);
            String t = hintIndicator.getText();
            boolean shouldSendAnnouncement = !this.textIndicator.getText().toString().equals(t) || currentTimeInMillsec - this.lastTimeIndicatorWasAnnounced >= 6000L;
            this.textIndicator.setText((CharSequence)hintIndicator.getText());
            this.textIndicator.setContentDescription((CharSequence)hintIndicator.getText());
            this.textIndicator.setVisibility(0);
            this.isShowingHint = isShow;
            if (!shouldSendAnnouncement) return this.isShowingHint;
            CameraController.getInstance().onSentUIEventMessage(CameraTypes.TISFlowUIMessages.HINT_CHANGED);
            AccessibilityUtils.sendAnnouncement(this.getContext(), this.textIndicator, ((Object)((Object)this)).getClass().getName());
            this.lastTimeIndicatorWasAnnounced = currentTimeInMillsec;
        }
        return this.isShowingHint;
    }

    private boolean hideIndicator() {
        this.textIndicator.setVisibility(8);
        this.isShowingHint = false;
        return this.isShowingHint;
    }

    public void hideErrorMessage() {
        this.showErrorMessage(false, null);
    }

    public void showErrorMessage(OCRCommon.ErrorCode errorCode) {
        this.showErrorMessage(true, errorCode);
    }

    private void showErrorMessage(boolean isShowError, OCRCommon.ErrorCode errorCode) {
    }

    public void showCheckBoundyRect(boolean isShow, Rect rect) {
        if (isShow) {
            this.checkRectBounderies.drawCheckRect(rect);
        } else {
            this.checkRectBounderies.clearCheckRect();
        }
    }

    public void setActionClickListener(CameraController.ActionClickListener actionClickListener) {
        this.actionClickListener = actionClickListener;
    }

    public void setIsManualCapture(boolean isManualCapture) {
        if (isManualCapture) {
            this.btnCapture.setVisibility(0);
        } else {
            this.btnCapture.setVisibility(8);
        }
    }

    public void setCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
        this.checkBoundariesRect = checkBoundariesRect;
        if (!this.isCheckBounderiesViewInit) {
            this.initcheckBounderiesView(checkBoundariesRect);
        }
    }

    public void clearBoundariesRect() {
        if (this.checkBounderiesView != null) {
            this.checkBounderiesView.clearView();
        }
    }

    public void startFadeoutAnimationForBoundaries() {
    }

    public void animateToCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
        this.checkBounderiesView.animateToCheckBoundaries(checkBoundariesRect, CameraController.getInstance().getHandler(), 21);
    }

    public void animateToCheckBoundariesRect(CheckBoundaries checkBoundariesRect, Rect[] rectangles) {
        this.checkBounderiesView.animateRectanglesSeries(checkBoundariesRect, CameraController.getInstance().getHandler(), 21, rectangles);
    }

    public void forceNewCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
        this.checkBoundariesRect = checkBoundariesRect;
        this.initcheckBounderiesView(checkBoundariesRect);
    }

    protected void initLeveler() {
        this.isHorizontalUnitLeveler = this.horizontalLeveler.getVisibility() == 0 || CameraManagerController.levlerType != null && CameraManagerController.levlerType == CaptureIntent.LevelerType.TWO_UNITS;
        Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(this.getContext());
        Rect levelerAreaRect = new Rect(0, 0, displayDimensions.x, displayDimensions.y);
        if (this.isHorizontalUnitLeveler) {
            this.horizontalLeveler.setFrame(levelerAreaRect);
            this.horizontalLeveler.showLeveler();
        }
        boolean bl = this.isHorizontalScaleLeveler = this.horizontalScaleLeveler.getVisibility() == 0 || CameraManagerController.levlerType != null && CameraManagerController.levlerType == CaptureIntent.LevelerType.SCALE;
        if (this.isHorizontalScaleLeveler) {
            this.horizontalScaleLeveler.setFrame(levelerAreaRect);
            this.horizontalScaleLeveler.showLeveler();
        }
        boolean bl2 = this.isVerticalUnitLeveler = this.verticalLeveler.getVisibility() == 0 || CameraManagerController.levlerType != null && CameraManagerController.levlerType == CaptureIntent.LevelerType.TWO_UNITS;
        if (this.isVerticalUnitLeveler) {
            this.verticalLeveler.setFrame(levelerAreaRect);
            this.verticalLeveler.showLeveler();
        }
        boolean bl3 = this.isVerticalScaleLeveler = this.verticalScaleLeveler.getVisibility() == 0 || CameraManagerController.levlerType != null && CameraManagerController.levlerType == CaptureIntent.LevelerType.SCALE;
        if (this.isVerticalScaleLeveler) {
            Point screenResolution = UserInterfaceUtils.getDisplayDimensions(this.context);
            this.verticalScaleLeveler.setFrame(levelerAreaRect);
            this.verticalScaleLeveler.showLeveler();
        }
        if (this.horizontalLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= 11 && this.isHorizontalUnitLeveler) {
            this.horizontalLeveler.setOnTouchListener(new View.OnTouchListener(){
                PointF levelerTouched = new PointF();
                PointF levelerStartDrag = new PointF();

                @SuppressLint(value={"NewApi"})
                public boolean onTouch(View v, MotionEvent event) {
                    int eid = event.getAction();
                    switch (eid) {
                        case 2: {
                            PointF mv = new PointF(event.getX() - this.levelerTouched.x, event.getY() - this.levelerTouched.y);
                            CameraOverlayLayout.this.horizontalLeveler.setX((int)(this.levelerStartDrag.x + mv.x));
                            CameraOverlayLayout.this.horizontalLeveler.setY((int)(this.levelerStartDrag.y + mv.y));
                            this.levelerStartDrag = new PointF(CameraOverlayLayout.this.horizontalLeveler.getX(), CameraOverlayLayout.this.horizontalLeveler.getY());
                            break;
                        }
                        case 0: {
                            this.levelerTouched.x = event.getX();
                            this.levelerTouched.y = event.getY();
                            this.levelerStartDrag = new PointF(CameraOverlayLayout.this.horizontalLeveler.getX(), CameraOverlayLayout.this.horizontalLeveler.getY());
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    return true;
                }
            });
        }
        if (this.verticalLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= 11 && this.isVerticalUnitLeveler) {
            this.verticalLeveler.setOnTouchListener(new View.OnTouchListener(){
                PointF levelerTouched = new PointF();
                PointF levelerStartDrag = new PointF();

                @SuppressLint(value={"NewApi"})
                public boolean onTouch(View v, MotionEvent event) {
                    int eid = event.getAction();
                    switch (eid) {
                        case 2: {
                            PointF mv = new PointF(event.getX() - this.levelerTouched.x, event.getY() - this.levelerTouched.y);
                            CameraOverlayLayout.this.verticalLeveler.setX((int)(this.levelerStartDrag.x + mv.x));
                            CameraOverlayLayout.this.verticalLeveler.setY((int)(this.levelerStartDrag.y + mv.y));
                            this.levelerStartDrag = new PointF(CameraOverlayLayout.this.verticalLeveler.getX(), CameraOverlayLayout.this.verticalLeveler.getY());
                            break;
                        }
                        case 0: {
                            this.levelerTouched.x = event.getX();
                            this.levelerTouched.y = event.getY();
                            this.levelerStartDrag = new PointF(CameraOverlayLayout.this.verticalLeveler.getX(), CameraOverlayLayout.this.verticalLeveler.getY());
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    return true;
                }
            });
        }
    }

    protected void initcheckBounderiesView(CheckBoundaries checkBoundariesRect) {
        this.isCheckBounderiesViewInit = true;
        Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(this.getContext());
        this.checkBounderiesView = (CheckBounderiesView)this.findViewById(this.isCustomView ? R.id.customCheckBounderiesView : R.id.checkBounderiesView);
        this.checkBounderiesView.setCheckBounderies(displayDimensions, checkBoundariesRect);
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(this.isCustomView ? R.id.customLevelerHorizontal : R.id.levelerHorizontal);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(this.isCustomView ? R.id.customScaleLevelerHorizontal : R.id.scaleLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(this.isCustomView ? R.id.customLevelerPortrait : R.id.levelerPortrait);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(this.isCustomView ? R.id.customScaleLevelerVertical : R.id.scaleLevelerVertical);
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT) {
            ImageView mrzLine = new ImageView(this.context);
            mrzLine.setImageResource(R.drawable.passport_overlay);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(checkBoundariesRect.getValidationBoundariesRectByCaptureMode().width - 20, -2);
            lp.addRule(12, R.id.checkBounderiesView);
            lp.addRule(9, R.id.checkBounderiesView);
            lp.leftMargin = checkBoundariesRect.getValidationBoundariesRectByCaptureMode().x + 10;
            lp.bottomMargin = 120;
            this.captureOverlay.addView((View)mrzLine, (ViewGroup.LayoutParams)lp);
        }
    }

    public void showProcessingOverlay(boolean isShown) {
        this.processingOverlay.setVisibility(isShown ? 0 : 8);
        this.captureOverlay.setVisibility(isShown ? 8 : 0);
    }

    public void setConfirmationIndicators() {
        this.captureFrameInicator = true;
        this.checkBounderiesView.showBounderies(this.getCaptureFrameIndicator(), true);
        this.showIndicator(CameraTypes.HintIndicator.Hold, true);
        this.isShowingHint = true;
        this.checkBounderiesView.invalidate();
    }

    public void setNonConfirmationIndicators() {
        this.captureFrameInicator = false;
        this.checkBounderiesView.showBounderies(this.getCaptureFrameIndicator(), true);
        this.showIndicator(CameraTypes.HintIndicator.None, true);
        this.checkBounderiesView.invalidate();
    }

    public void prepareForStillCapture() {
        if (CameraManagerController.showCountDown) {
            this.showCounter(this.counter.getCountDownStartNumber());
        }
        this.showIndicator(CameraTypes.HintIndicator.Hold, true);
    }

    @SuppressLint(value={"NewApi"})
    private boolean dragImage(View v, MotionEvent event) {
        int eid = event.getAction();
        PointF DownPT = new PointF();
        PointF StartPT = new PointF();
        switch (eid) {
            case 2: {
                PointF mv = new PointF(event.getX() - DownPT.x, event.getY() - DownPT.y);
                v.setX((float)((int)(StartPT.x + mv.x)));
                v.setY((float)((int)(StartPT.y + mv.y)));
                StartPT = new PointF(v.getX(), this.oneUnitLeveler.getY());
                break;
            }
            case 0: {
                DownPT.x = event.getX();
                DownPT.y = event.getY();
                StartPT = new PointF(v.getX(), v.getY());
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }

    public void setAnimationListener() {
        this.fadeOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation arg0) {
                if (!CameraOverlayLayout.this.isFadeOutBoundariesAnimation) {
                    CameraOverlayLayout.this.isFadeOutAnimation = true;
                }
            }

            public void onAnimationRepeat(Animation arg0) {
            }

            public void onAnimationEnd(Animation arg0) {
                if (!CameraOverlayLayout.this.isFadeOutBoundariesAnimation) {
                    CameraOverlayLayout.this.isFadeOutAnimation = false;
                    if (CameraOverlayLayout.this.horizontalLeveler.getVisibility() == 0 && CameraOverlayLayout.this.isHorizontalUnitLeveler && CameraOverlayLayout.this.horizontalLeveler.isFadeAnimationEnable()) {
                        CameraOverlayLayout.this.horizontalLeveler.setVisibility(8);
                    }
                    if (CameraOverlayLayout.this.verticalLeveler.getVisibility() == 0 && CameraOverlayLayout.this.isVerticalUnitLeveler && CameraOverlayLayout.this.verticalLeveler.isFadeAnimationEnable()) {
                        CameraOverlayLayout.this.verticalLeveler.setVisibility(8);
                    }
                    if (CameraOverlayLayout.this.oneUnitLeveler.getVisibility() == 0 && CameraOverlayLayout.this.isOneUnitLeveler && CameraOverlayLayout.this.oneUnitLeveler.isFadeAnimationEnable()) {
                        CameraOverlayLayout.this.oneUnitLeveler.setVisibility(8);
                    }
                } else {
                    CameraOverlayLayout.this.isFadeOutBoundariesAnimation = false;
                }
            }
        });
    }

    public void updateLevelerSize() {
        if (this.horizontalLeveler.getUpperMainRectSize() != null) {
            this.horizontalLeveler.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)this.horizontalLeveler.getUpperMainRectSize()[0], (int)this.horizontalLeveler.getUpperMainRectSize()[1]));
            this.verticalLeveler.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)this.verticalLeveler.getLeftRightRectSize()[0], (int)this.verticalLeveler.getLeftRightRectSize()[1]));
        }
    }

    public void resetCameraOverlay(CameraTypes.CaptureMode captureMode) {
        this.hideIndicator();
        this.showCounter(false, -1L);
        this.hideErrorMessage();
        this.showProcessingOverlay(false);
        this.setCaptureCaption(captureMode);
    }

    class OnClickListenerIMpl
    implements View.OnClickListener {
        OnClickListenerIMpl() {
        }

        public void onClick(View v) {
            if (v == CameraOverlayLayout.this.btnTorch) {
                if (CameraController.processStart || CameraController.frameWasGreen && CameraManagerController.deviceName.equals("LGE Nexus 5X")) {
                    return;
                }
                if (CameraController.getInstance().getHandler() != null) {
                    CameraOverlayLayout.this.btnTorch.setEnabled(false);
                    Message message = CameraController.getInstance().getHandler().obtainMessage(16);
                    message.obj = CameraOverlayLayout.this.btnTorch.isChecked();
                    CameraController.getInstance().getHandler().sendMessage(message);
                    if (CameraOverlayLayout.this.btnTorch.isChecked()) {
                        CameraOverlayLayout.this.btnTorch.setBackgroundResource(R.drawable.btn_torch_selected);
                    } else {
                        CameraOverlayLayout.this.btnTorch.setBackgroundResource(R.drawable.btn_torch);
                    }
                }
            } else if (v == CameraOverlayLayout.this.btnCancel) {
                if (!CameraManagerController.isStillMode && CameraController.processStart) {
                    return;
                }
                CameraController.getInstance().quitActivity(false);
            } else if (v == CameraOverlayLayout.this.btnCapture) {
                CameraOverlayLayout.this.actionClickListener.capture();
            }
        }
    }
}

