/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.opencv.core.Rect;

public class BarcodeReader {
    private android.graphics.Rect mFramingRectInPreview;
    private android.graphics.Rect mBoundariesRect;
    private MultiFormatReader mMultiFormatReader;
    public static final List<BarcodeFormat> ALL_FORMATS = new ArrayList<BarcodeFormat>();
    private static List<BarcodeFormat> mFormats;
    private static List<CameraTypes.TISBarcodeType> mTISFormats;

    static {
        if (CameraManagerController.useQRFrameForBarcode) {
            ALL_FORMATS.add(BarcodeFormat.UPC_A);
            ALL_FORMATS.add(BarcodeFormat.UPC_E);
            ALL_FORMATS.add(BarcodeFormat.EAN_13);
            ALL_FORMATS.add(BarcodeFormat.EAN_8);
            ALL_FORMATS.add(BarcodeFormat.RSS_14);
            ALL_FORMATS.add(BarcodeFormat.CODE_39);
            ALL_FORMATS.add(BarcodeFormat.CODE_93);
            ALL_FORMATS.add(BarcodeFormat.CODE_128);
            ALL_FORMATS.add(BarcodeFormat.ITF);
            ALL_FORMATS.add(BarcodeFormat.CODABAR);
            ALL_FORMATS.add(BarcodeFormat.QR_CODE);
        }
        ALL_FORMATS.add(BarcodeFormat.DATA_MATRIX);
        ALL_FORMATS.add(BarcodeFormat.PDF_417);
    }

    BarcodeReader(ArrayList<CameraTypes.TISBarcodeType> barcodeTypes, int x, int y, int width, int height) {
        if (barcodeTypes != null) {
            mTISFormats = new ArrayList<CameraTypes.TISBarcodeType>();
            mTISFormats.addAll(barcodeTypes);
            mFormats = BarcodeReader.translateTISBarcodeToZxingArray(mTISFormats);
            this.initMultiFormatReader();
            this.mBoundariesRect = new android.graphics.Rect(x, y, x + width, y + height);
        }
    }

    void setTisBarcodeFormats(List<CameraTypes.TISBarcodeType> formats) {
        if (formats != null) {
            mTISFormats = new ArrayList<CameraTypes.TISBarcodeType>();
            mTISFormats.addAll(formats);
            mFormats = BarcodeReader.translateTISBarcodeToZxingArray(mTISFormats);
            this.initMultiFormatReader();
        }
    }

    void setBarcodeBoundaries(int x, int y, int width, int height) {
        this.mBoundariesRect = new android.graphics.Rect(x, y, x + width, y + height);
    }

    private void initMultiFormatReader() {
        EnumMap<DecodeHintType, Collection<BarcodeFormat>> hints = new EnumMap<DecodeHintType, Collection<BarcodeFormat>>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, this.getFormats());
        this.mMultiFormatReader = new MultiFormatReader();
        this.mMultiFormatReader.setHints(hints);
    }

    public Collection<BarcodeFormat> getFormats() {
        return mFormats == null ? ALL_FORMATS : mFormats;
    }

    protected static ArrayList<CameraTypes.TISBarcodeType> getAllTISBarcodeTypes() {
        ArrayList<CameraTypes.TISBarcodeType> barcodeTypes = new ArrayList<CameraTypes.TISBarcodeType>();
        barcodeTypes.add(CameraTypes.TISBarcodeType.QR_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.AZTEC_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.DATA_MATRIX_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.UPCE_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.CODE_39_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.CODE_39_MOD_43_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.EAN_13_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.EAN_8_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.CODE_93_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.CODE_128_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.PDF_417_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.INTERLEAVED_2_OF_5_CODE);
        barcodeTypes.add(CameraTypes.TISBarcodeType.ITF_14_CODE);
        return barcodeTypes;
    }

    private static int findDesiredDimensionInRange(float ratio, int resolution, int hardMin, int hardMax) {
        int dim = (int)(ratio * (float)resolution);
        return dim < hardMin ? hardMin : (dim > hardMax ? hardMax : dim);
    }

    public synchronized android.graphics.Rect getFramingRectInPreview(int previewWidth, int previewHeight, int orientation) {
        if (this.mFramingRectInPreview == null) {
            android.graphics.Rect rect;
            Rect openCVFrame = CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getCheckBoundaries().getValidationRect();
            android.graphics.Rect framingRect = new android.graphics.Rect(openCVFrame.x, openCVFrame.y, openCVFrame.width, openCVFrame.height);
            int viewFinderViewWidth = CameraConfigurationManager.screenResolution.x;
            int viewFinderViewHeight = CameraConfigurationManager.screenResolution.y;
            if (framingRect == null || viewFinderViewWidth == 0 || viewFinderViewHeight == 0) {
                return null;
            }
            this.mFramingRectInPreview = rect = new android.graphics.Rect(framingRect);
        }
        return this.mFramingRectInPreview;
    }

    /*
     * Loose catch block
     */
    Result scanImage(byte[] data, int width, int height, int orientation, Mat image) {
        if (orientation == 1) {
            byte[] rotatedData = new byte[data.length];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    rotatedData[x * height + height - y - 1] = data[x + y * width];
                    ++x;
                }
                ++y;
            }
            int tmp = width;
            width = height;
            height = tmp;
            data = rotatedData;
        }
        Result rawResult = null;
        Object rawResultOnRgb = null;
        PlanarYUVLuminanceSource source = null;
        RGBLuminanceSource RgbSource = null;
        boolean useRgbImage = true;
        if (!(CameraManagerController.useCameraAPI2 || CameraManagerController.deviceName.equals("LGE Nexus 5X") || CameraManagerController.isDynamicCapture || CameraManagerController.BarcodeDetectionTries >= CameraManagerController.maxBarcodeTries / 2)) {
            useRgbImage = false;
        }
        if (!useRgbImage) {
            source = this.buildLuminanceSource(data, width, height, orientation, image);
        } else {
            if (image == null || image.empty()) {
                return null;
            }
            if (!CameraManagerController.isDynamicCapture) {
                Rect openCVFrame = CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getCheckBoundaries().getValidationRect();
                image = new Mat(image, openCVFrame);
            }
            Bitmap bmp = Bitmap.createBitmap((int)image.cols(), (int)image.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap((Mat)image, (Bitmap)bmp);
            int[] pixels = new int[bmp.getHeight() * bmp.getWidth()];
            bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());
            RgbSource = new RGBLuminanceSource(bmp.getWidth(), bmp.getHeight(), pixels);
        }
        if (source != null || RgbSource != null) {
            BinaryBitmap bitmap = !useRgbImage ? new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source)) : new BinaryBitmap((Binarizer)new HybridBinarizer(RgbSource));
            try {
                try {
                    rawResult = this.mMultiFormatReader.decodeWithState(bitmap);
                    Logger.e("BarCode Read", rawResult.getText());
                }
                catch (ReaderException re) {
                    Logger.e("BarCode Read", Log.getStackTraceString((Throwable)re));
                    this.mMultiFormatReader.reset();
                }
                catch (NullPointerException npe) {
                    Logger.e("BarCode Read", Log.getStackTraceString((Throwable)npe));
                    this.mMultiFormatReader.reset();
                }
                catch (ArrayIndexOutOfBoundsException aoe) {
                    Logger.e("BarCode Read", Log.getStackTraceString((Throwable)aoe));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    this.mMultiFormatReader.reset();
                }
            }
            finally {
                this.mMultiFormatReader.reset();
            }
        }
        return rawResult;
    }

    private static CameraTypes.TISBarcodeType convertZxingToTISBarcodeType(String type) {
        CameraTypes.TISBarcodeType tisBarcodeType;
        BarcodeFormat barcodeType = BarcodeFormat.valueOf((String)type);
        switch (barcodeType) {
            case UPC_E: {
                tisBarcodeType = CameraTypes.TISBarcodeType.UPCE_CODE;
                break;
            }
            case CODE_39: {
                if (mTISFormats.contains((Object)CameraTypes.TISBarcodeType.CODE_39_MOD_43_CODE)) {
                    tisBarcodeType = CameraTypes.TISBarcodeType.CODE_39_MOD_43_CODE;
                    break;
                }
                tisBarcodeType = CameraTypes.TISBarcodeType.CODE_39_CODE;
                break;
            }
            case EAN_13: {
                tisBarcodeType = CameraTypes.TISBarcodeType.EAN_13_CODE;
                break;
            }
            case EAN_8: {
                tisBarcodeType = CameraTypes.TISBarcodeType.EAN_8_CODE;
                break;
            }
            case CODE_93: {
                tisBarcodeType = CameraTypes.TISBarcodeType.CODE_93_CODE;
                break;
            }
            case CODE_128: {
                tisBarcodeType = CameraTypes.TISBarcodeType.CODE_128_CODE;
                break;
            }
            case PDF_417: {
                tisBarcodeType = CameraTypes.TISBarcodeType.PDF_417_CODE;
                break;
            }
            case QR_CODE: {
                tisBarcodeType = CameraTypes.TISBarcodeType.QR_CODE;
                break;
            }
            case AZTEC: {
                tisBarcodeType = CameraTypes.TISBarcodeType.AZTEC_CODE;
                break;
            }
            case ITF: {
                if (mTISFormats.contains((Object)CameraTypes.TISBarcodeType.INTERLEAVED_2_OF_5_CODE)) {
                    tisBarcodeType = CameraTypes.TISBarcodeType.INTERLEAVED_2_OF_5_CODE;
                    break;
                }
                tisBarcodeType = CameraTypes.TISBarcodeType.ITF_14_CODE;
                break;
            }
            case DATA_MATRIX: {
                tisBarcodeType = CameraTypes.TISBarcodeType.DATA_MATRIX_CODE;
                break;
            }
            default: {
                return null;
            }
        }
        return tisBarcodeType;
    }

    private static List<BarcodeFormat> translateTISBarcodeToZxingArray(List<CameraTypes.TISBarcodeType> tisBarcodeList) {
        ArrayList<BarcodeFormat> barcodeTypes = new ArrayList<BarcodeFormat>();
        for (CameraTypes.TISBarcodeType tisBarcodeType : tisBarcodeList) {
            switch (tisBarcodeType) {
                case UPCE_CODE: {
                    barcodeTypes.add(BarcodeFormat.UPC_E);
                    break;
                }
                case CODE_39_CODE: 
                case CODE_39_MOD_43_CODE: {
                    barcodeTypes.add(BarcodeFormat.CODE_39);
                    break;
                }
                case EAN_13_CODE: {
                    barcodeTypes.add(BarcodeFormat.EAN_13);
                    barcodeTypes.add(BarcodeFormat.UPC_A);
                    break;
                }
                case EAN_8_CODE: {
                    barcodeTypes.add(BarcodeFormat.EAN_8);
                    break;
                }
                case CODE_93_CODE: {
                    barcodeTypes.add(BarcodeFormat.CODE_93);
                    break;
                }
                case CODE_128_CODE: {
                    barcodeTypes.add(BarcodeFormat.CODE_128);
                    break;
                }
                case PDF_417_CODE: {
                    barcodeTypes.add(BarcodeFormat.PDF_417);
                    break;
                }
                case QR_CODE: {
                    barcodeTypes.add(BarcodeFormat.QR_CODE);
                    break;
                }
                case AZTEC_CODE: {
                    barcodeTypes.add(BarcodeFormat.AZTEC);
                    break;
                }
                case INTERLEAVED_2_OF_5_CODE: 
                case ITF_14_CODE: {
                    barcodeTypes.add(BarcodeFormat.ITF);
                    break;
                }
                case DATA_MATRIX_CODE: {
                    barcodeTypes.add(BarcodeFormat.DATA_MATRIX);
                }
            }
        }
        return barcodeTypes;
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height, int orientation, Mat image) {
        android.graphics.Rect rect = this.getFramingRectInPreview(width, height, orientation);
        if (rect == null) {
            return null;
        }
        PlanarYUVLuminanceSource source = null;
        Object rgbSource = null;
        Rect openCVFrame = CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).getCheckBoundaries().getValidationRect();
        image = new Mat(image, openCVFrame);
        try {
            source = new PlanarYUVLuminanceSource(data, width, height, openCVFrame.x, openCVFrame.y, openCVFrame.width, openCVFrame.height, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }

    public PlanarYUVLuminanceSource getFramingRectInPreview(byte[] data, int width, int height, int orientation) {
        android.graphics.Rect rect = this.getFramingRectInPreview(width, height, orientation);
        if (rect == null) {
            return null;
        }
        PlanarYUVLuminanceSource source = null;
        try {
            source = new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }

    public static class BarcodeResult {
        private static String BARCODE_TYPE_FRONT = "barcodeTypeFront";
        private static String BARCODE_TYPE_BACK = "barcodeTypeBack";
        private static String BARCODE_DATA_FRONT = "barcodeDataFront";
        private static String BARCODE_DATA_BACK = "barcodeDataBack";
        private static String BARCODE_PARSED_DATA_FRONT = "barcodeParsedDataFront";
        private static String BARCODE_PARSED_DATA_BACK = "barcodeParsedDataBack";
        private CameraTypes.TISBarcodeType barcodeTypeFront = null;
        private CameraTypes.TISBarcodeType barcodeTypeBack = null;
        private String barcodeDataFront = null;
        private String barcodeDataBack = null;
        private HashMap<String, String> barcodeParsedDataFront = null;
        private HashMap<String, String> barcodeParsedDataBack = null;

        protected BarcodeResult() {
        }

        public BarcodeResult(String[] barcodeResultArray) {
            if (barcodeResultArray == null || barcodeResultArray.length != 4) {
                return;
            }
            this.barcodeTypeFront = CameraTypes.TISBarcodeType.getEnum(Integer.parseInt(barcodeResultArray[0]));
            this.barcodeTypeBack = CameraTypes.TISBarcodeType.getEnum(Integer.parseInt(barcodeResultArray[2]));
            this.barcodeDataFront = barcodeResultArray[1];
            this.barcodeDataBack = barcodeResultArray[3];
        }

        protected BarcodeResult(Bundle bundle) {
            if (bundle != null) {
                this.barcodeTypeFront = CameraTypes.TISBarcodeType.getEnum(bundle.getInt(BARCODE_TYPE_FRONT));
                this.barcodeTypeBack = CameraTypes.TISBarcodeType.getEnum(bundle.getInt(BARCODE_TYPE_BACK));
                this.barcodeDataFront = bundle.getString(BARCODE_DATA_FRONT);
                this.barcodeDataBack = bundle.getString(BARCODE_DATA_BACK);
                this.barcodeParsedDataFront = (HashMap)bundle.getSerializable(BARCODE_PARSED_DATA_FRONT);
                this.barcodeParsedDataBack = (HashMap)bundle.getSerializable(BARCODE_PARSED_DATA_BACK);
            }
        }

        protected Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(BARCODE_TYPE_FRONT, this.barcodeTypeFront == null ? -1 : this.barcodeTypeFront.getValue());
            bundle.putInt(BARCODE_TYPE_BACK, this.barcodeTypeBack == null ? -1 : this.barcodeTypeBack.getValue());
            bundle.putString(BARCODE_DATA_FRONT, this.barcodeDataFront);
            bundle.putString(BARCODE_DATA_BACK, this.barcodeDataBack);
            bundle.putSerializable(BARCODE_PARSED_DATA_FRONT, this.barcodeParsedDataFront);
            bundle.putSerializable(BARCODE_PARSED_DATA_BACK, this.barcodeParsedDataBack);
            return bundle;
        }

        public boolean isEmpty() {
            return this.barcodeDataFront == null && this.barcodeDataBack == null;
        }

        public void parse() {
            this.barcodeParsedDataFront = this.barcodeTypeFront == CameraTypes.TISBarcodeType.PDF_417_CODE ? OcrValidationUtils.DLBarcodeParser.parseDLBarcode(this.barcodeDataFront) : new HashMap();
            this.barcodeParsedDataBack = this.barcodeTypeBack == CameraTypes.TISBarcodeType.PDF_417_CODE ? OcrValidationUtils.DLBarcodeParser.parseDLBarcode(this.barcodeDataBack) : new HashMap();
        }

        protected void setBarcodeTypeFront(String zxingBarcodeType) {
            this.barcodeTypeFront = BarcodeReader.convertZxingToTISBarcodeType(zxingBarcodeType);
        }

        protected void setBarcodeTypeBack(String zxingBarcodeType) {
            this.barcodeTypeBack = BarcodeReader.convertZxingToTISBarcodeType(zxingBarcodeType);
        }

        public CameraTypes.TISBarcodeType getBarcodeTypeFront() {
            return this.barcodeTypeFront;
        }

        public CameraTypes.TISBarcodeType getBarcodeTypeBack() {
            return this.barcodeTypeBack;
        }

        public int getBarcodeTypeFrontForBundle() {
            return this.barcodeTypeFront == null ? -1 : this.barcodeTypeFront.getValue();
        }

        public int getBarcodeTypeBackForBundle() {
            return this.barcodeTypeBack == null ? -1 : this.barcodeTypeBack.getValue();
        }

        public String getBarcodeDataFront() {
            return this.barcodeDataFront;
        }

        protected void setBarcodeDataFront(String data) {
            this.barcodeDataFront = data;
        }

        public String getBarcodeDataBack() {
            return this.barcodeDataBack;
        }

        protected void setBarcodeDataBack(String data) {
            this.barcodeDataBack = data;
        }

        public String toString() {
            return "BarcodeResult barcodeTypeFront(" + (Object)((Object)this.barcodeTypeFront) + ") barcodeTypeBack(" + (Object)((Object)this.barcodeTypeBack) + ") barcodeDataFront(" + this.barcodeDataFront + ") barcodeDataBack(" + this.barcodeDataBack + ")";
        }
    }
}

