/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import com.topimagesystems.camera.CameraConfigurationUtils;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.util.Logger;
import org.opencv.core.Rect;

public class UserInterfaceUtils {
    private static final String tag = Logger.makeLogTag("UIUtils");
    private static String STUB = "payment";
    private static String CHECK = "check";

    public static Point getDisplayDimensions(Context context) {
        Point size = new Point();
        WindowManager wm = context != null ? (WindowManager)context.getSystemService("window") : (WindowManager)CameraController.getInstance().getSystemService("window");
        if (Build.VERSION.SDK_INT >= 11) {
            UserInterfaceUtils.getSizeAboveAPI13(size, wm);
        } else {
            UserInterfaceUtils.getSizePriorApi13(size, wm);
        }
        return size;
    }

    public static boolean hasHardwareAcceleration(Activity activity) {
        try {
            Window window = activity.getWindow();
            if (window != null && (window.getAttributes().flags & 0x1000000) != 0) {
                return true;
            }
            try {
                ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 0);
                if ((info.flags & 0x200) != 0) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)"hasHardwareAcceleration", (String)"getActivityInfo(self) should not fail");
            }
            return false;
        }
        catch (Exception e) {
            Logger.e("hasHardwareAcceleration", Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static Point getCameraPreviewResolution(Context context, Camera.Parameters parameters) {
        if (CameraManagerController.invertedCamera) {
            return CameraConfigurationUtils.findBestPreviewSizeValue(parameters, UserInterfaceUtils.getDisplayDimensions(context));
        }
        return CameraConfigurationManager.getCameraPreviewResolution(parameters, UserInterfaceUtils.getDisplayDimensions(context), context);
    }

    public static String getVersionName(Context context) {
        String app_ver = "unknown";
        try {
            app_ver = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.v(tag, e.getMessage());
        }
        return app_ver;
    }

    private static void getSizePriorApi13(Point size, WindowManager wm) {
        Display d = wm.getDefaultDisplay();
        size.x = d.getWidth();
        size.y = d.getHeight();
    }

    @TargetApi(value=13)
    private static void getSizeAboveAPI13(Point size, WindowManager wm) {
        wm.getDefaultDisplay().getSize(size);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

    public static int getAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    public static Bundle rectToBundle(Rect rect) {
        Bundle bundle = new Bundle();
        if (rect != null) {
            bundle.putInt("x", rect.x);
            bundle.putInt("y", rect.y);
            bundle.putInt("width", rect.width);
            bundle.putInt("height", rect.height);
        }
        return bundle;
    }

    public static Rect bundleToRect(Bundle bundle) {
        Rect rect = new Rect();
        if (bundle != null) {
            rect.x = bundle.getInt("x");
            rect.y = bundle.getInt("y");
            rect.width = bundle.getInt("width");
            rect.height = bundle.getInt("height");
        }
        return rect;
    }

    public static int getScreenOrientation(Context context) {
        WindowManager wm = (WindowManager)CameraController.getInstance().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int orientation = 0;
        orientation = display.getWidth() == display.getHeight() ? 3 : (display.getWidth() < display.getHeight() ? 1 : 2);
        return orientation;
    }
}

