/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.util.Log;

public class Logger {
    public static final int NO_LOG = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final String LOG_PREFIX = "mobicheck.";
    private static final int LOG_PREFIX_LENGTH = "mobicheck.".length();
    private static final int MAX_LOG_TAG_LENGTH = 23;
    private static int debugLevel = 2;
    private static boolean isDebugMode = true;

    public static String makeLogTag(String str) {
        return str;
    }

    public static void setMinLogLevel(int _debugLevel) {
        if (isDebugMode) {
            _debugLevel = 2;
        } else {
            debugLevel = _debugLevel;
        }
    }

    public static void setIsDebugMode(boolean _debugMode) {
        isDebugMode = _debugMode;
    }

    private static boolean isDebugMode() {
        return isDebugMode;
    }

    public static void d(String tag, String message) {
        if (Logger.isDebugMode() && debugLevel >= 3) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.d((String)tag, (String)clean);
        }
    }

    public static void d(String tag, String message, Throwable cause) {
        if (Logger.isDebugMode() && debugLevel >= 3) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.d((String)tag, (String)clean, (Throwable)cause);
        }
    }

    public static void v(String tag, String message) {
        if (Logger.isDebugMode() && debugLevel >= 2) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.d((String)tag, (String)clean);
        }
    }

    public static void v(String tag, String message, Throwable cause) {
        if (Logger.isDebugMode() && debugLevel >= 2) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.d((String)tag, (String)clean, (Throwable)cause);
        }
    }

    public static void i(String tag, String message) {
        if (debugLevel <= 4) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.i((String)tag, (String)clean);
        }
    }

    public static void i(String tag, String message, Throwable cause) {
        if (Logger.isDebugMode() && debugLevel >= 4) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.i((String)tag, (String)clean, (Throwable)cause);
        }
    }

    public static void w(String tag, String message) {
        if (Logger.isDebugMode() && debugLevel >= 5) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.w((String)tag, (String)clean);
        }
    }

    public static void w(String tag, String message, Throwable cause) {
        if (Logger.isDebugMode() && debugLevel >= 5) {
            String clean = message.replace('\n', '_').replace('\r', '_');
            Log.w((String)tag, (String)clean, (Throwable)cause);
        }
    }

    public static void e(String tag, String message) {
        String clean = message.replace('\n', '_').replace('\r', '_');
        Log.e((String)tag, (String)clean);
    }

    public static void e(String tag, String message, Throwable cause) {
        String clean = message.replace('\n', '_').replace('\r', '_');
        Log.e((String)tag, (String)clean, (Throwable)cause);
    }

    private Logger() {
    }
}

