/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.topimagesystems.R;
import org.opencv.core.Rect;

public class TwoUnitsLeveler
extends ImageView {
    private boolean isValidOrintation = false;
    private int strokeWidthContainer = 5;
    private int strokeWidthInner = 5;
    private Paint circlePaint;
    private Paint rectanglePaintContainer;
    private Paint rectanglePaintInner;
    private float levelerTrashold = 0.047f;
    private float levelerTrasholdSide = 0.036f;
    private float levelerTrasholdSideVertical = 0.02f;
    private float convertPixelsToAccelerometerUpper;
    private float convertPixelsToAccelerometerSide;
    private boolean validOrientationX;
    private boolean validOrientationY;
    private RectF mainRectangleUpper;
    private RectF validationRectangleUpper;
    private RectF mainRectangleSide;
    private RectF validationRectangleSide;
    private float levelerWidth = 25.0f;
    private boolean isHorizontalLevel;
    private int colorOrientationPassContainer;
    private int colorOrientationFailContainer;
    private int colorOrientationPassInner;
    private int colorOrientationFailInner;
    private int colorOrientationPassCircle;
    private int colorOrientationFailCircle;
    private float defaultPaddingLeftAndRight;
    private float defaultPaddingTopAndBottom;
    private int location;
    private boolean isFadeAnimationEnable;
    private boolean isDraggingEnable;
    private Context context;
    private float xValue = 0.0f;
    private float yValue = 0.0f;
    private boolean isLandscapeMode = true;
    private float validationRectTopBottomTrashHold = 0.6f;
    private float validationRectLeftRightTrashHold = 0.3f;
    private Rect frame;
    private Location levelerLocation;

    @SuppressLint(value={"Recycle"})
    public TwoUnitsLeveler(Context context, AttributeSet attrs) {
        super(context, attrs);
        int defaultVal;
        this.context = context;
        TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
        TypedArray twoLevelerData = context.obtainStyledAttributes(attrs, R.styleable.TwoUnitsLeveler);
        int n = defaultVal = this.isHorizontalLevel ? 0 : 2;
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.colorOrientationPassContainer = -16711936;
        this.colorOrientationFailContainer = -65536;
        this.colorOrientationPassInner = -16711936;
        this.colorOrientationFailInner = -65536;
        this.colorOrientationPassCircle = -16711936;
        this.colorOrientationFailCircle = -65536;
        this.defaultPaddingLeftAndRight = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingLeftAndRight, 0.0f);
        this.defaultPaddingTopAndBottom = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingTopAndBottom, 0.0f);
        this.location = twoLevelerData.getInteger(R.styleable.TwoUnitsLeveler_levelerLocation, 0);
        this.setDefaultValues(this.defaultPaddingLeftAndRight, this.defaultPaddingTopAndBottom);
        this.isHorizontalLevel = false;
        if (this.levelerLocation == Location.TOP || this.levelerLocation == Location.BOTTOM) {
            this.isHorizontalLevel = true;
        }
        this.isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
        this.isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);
        this.isHorizontalLevel = false;
        if (this.location == 0 || this.location == 1) {
            this.isHorizontalLevel = true;
        }
        if (!this.isHorizontalLevel && (double)this.defaultPaddingTopAndBottom > 140.0) {
            this.validationRectLeftRightTrashHold = 0.15f;
        } else if (this.isHorizontalLevel && (double)this.defaultPaddingTopAndBottom > 250.0) {
            this.validationRectTopBottomTrashHold = 0.3f;
        }
        oneLevelerData.recycle();
        twoLevelerData.recycle();
        this.init();
    }

    public boolean isDraggingEnable() {
        return this.isDraggingEnable;
    }

    public boolean isFadeAnimationEnable() {
        return this.isFadeAnimationEnable;
    }

    public TwoUnitsLeveler(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    public void setFrame(Rect ValidationRect) {
        this.frame = ValidationRect;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.circlePaint = new Paint();
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setColor(this.context.getResources().getColor(R.color.counter_background));
        this.rectanglePaintContainer = new Paint();
        this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
        this.rectanglePaintContainer.setStyle(Paint.Style.STROKE);
        this.rectanglePaintContainer.setStrokeWidth((float)this.strokeWidthContainer);
        this.rectanglePaintInner = new Paint();
        this.rectanglePaintInner.setColor(this.colorOrientationFailInner);
        this.rectanglePaintInner.setStyle(Paint.Style.STROKE);
        this.rectanglePaintInner.setStrokeWidth((float)this.strokeWidthContainer);
    }

    public float[] getUpperMainRectSize() {
        float[] res = new float[]{this.mainRectangleUpper.width(), this.mainRectangleUpper.height()};
        return res;
    }

    public float[] getLeftRightRectSize() {
        float[] res = new float[]{this.mainRectangleSide.width(), this.mainRectangleSide.height()};
        return res;
    }

    public void showLeveler() {
        this.setVisibility(0);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isHorizontalLevel) {
            this.drawHorizontalLeveler(canvas);
        } else {
            this.drawVerticalLeveler(canvas);
        }
    }

    private void setDefaultValues(float left, float top) {
        switch (this.location) {
            case 0: {
                this.levelerLocation = Location.TOP;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 45.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 18.0f : top;
                break;
            }
            case 1: {
                this.levelerLocation = Location.BOTTOM;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 30.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 45.0f : top;
                break;
            }
            case 2: {
                this.levelerLocation = Location.LEFT;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 18.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 25.0f : top;
                break;
            }
            case 3: {
                this.levelerLocation = Location.RIGHT;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 45.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 15.0f : top;
            }
        }
    }

    private void drawHorizontalLeveler(Canvas canvas) {
        boolean validOrintation;
        if (this.mainRectangleUpper == null) {
            this.drawRectInLocation();
        }
        boolean bl = validOrintation = this.isLandscapeMode ? this.validOrientationX : this.validOrientationY;
        if (validOrintation) {
            this.rectanglePaintContainer.setColor(this.colorOrientationPassContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationPassInner);
            this.circlePaint.setColor(this.colorOrientationPassCircle);
        } else {
            this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationFailInner);
            this.circlePaint.setColor(this.colorOrientationFailCircle);
        }
        canvas.drawRoundRect(this.mainRectangleUpper, 15.0f, 15.0f, this.rectanglePaintContainer);
        canvas.drawRoundRect(this.validationRectangleUpper, 15.0f, 15.0f, this.rectanglePaintInner);
        this.convertPixelsToAccelerometerUpper = this.levelerTrashold * this.validationRectangleUpper.width() * (float)(this.frame.width / 974);
        float circleRadiosUpper = (this.mainRectangleUpper.bottom - this.mainRectangleUpper.top) * 0.6f;
        float circleX = this.validationRectangleUpper.centerX();
        float circleXLocation = this.checkCircleLocationX(circleX + this.xValue * this.convertPixelsToAccelerometerUpper, this.mainRectangleUpper, circleRadiosUpper);
        canvas.drawCircle(circleXLocation, this.validationRectangleUpper.centerY(), circleRadiosUpper, this.circlePaint);
    }

    private void drawVerticalLeveler(Canvas canvas) {
        boolean validOrientation;
        boolean bl = validOrientation = this.isLandscapeMode ? this.validOrientationY : this.validOrientationX;
        if (this.mainRectangleSide == null) {
            this.drawRectInLocation();
        }
        if (validOrientation) {
            this.rectanglePaintContainer.setColor(this.colorOrientationPassContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationPassInner);
            this.circlePaint.setColor(this.colorOrientationPassCircle);
        } else {
            this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
            this.rectanglePaintInner.setColor(this.colorOrientationFailInner);
            this.circlePaint.setColor(this.colorOrientationFailCircle);
        }
        canvas.drawRoundRect(this.mainRectangleSide, 15.0f, 15.0f, this.rectanglePaintContainer);
        canvas.drawRoundRect(this.validationRectangleSide, 15.0f, 15.0f, this.rectanglePaintInner);
        float trahHoldLeveler = this.isLandscapeMode ? this.levelerTrasholdSide : this.levelerTrasholdSideVertical;
        this.convertPixelsToAccelerometerSide = trahHoldLeveler * this.mainRectangleSide.height() * (float)(this.frame.height / 487);
        float circleY = this.validationRectangleSide.centerY();
        float circleRadiosSide = (this.mainRectangleSide.right - this.mainRectangleSide.left) * 0.6f;
        float circleYLocation = this.checkCircleLocationY(circleY - this.yValue * this.convertPixelsToAccelerometerSide, this.mainRectangleSide, circleRadiosSide);
        canvas.drawCircle(this.validationRectangleSide.centerX(), circleYLocation, circleRadiosSide, this.circlePaint);
    }

    private float checkCircleLocationX(float location, RectF mainRectangle, float radios) {
        float locationResult = location;
        if (location < mainRectangle.left) {
            locationResult = mainRectangle.left + radios;
        }
        if (location > mainRectangle.right) {
            locationResult = mainRectangle.right - radios;
        }
        return locationResult;
    }

    private float checkCircleLocationY(float location, RectF mainRectangle, float radios) {
        float locationResult = location;
        if (location < this.mainRectangleSide.top) {
            locationResult = this.mainRectangleSide.top + radios;
        }
        if (location > this.mainRectangleSide.bottom) {
            locationResult = this.mainRectangleSide.bottom - radios;
        }
        return locationResult;
    }

    public void updateLevelerLocation(float[] values, boolean isValidX, boolean isValidY, boolean isVertical) {
        this.isValidOrintation = isValidX && isValidY;
        this.validOrientationX = isValidX;
        this.validOrientationY = isValidY;
        this.yValue = values[2];
        this.xValue = values[1];
        if (isVertical) {
            this.xValue = values[2];
            this.yValue = values[1];
            this.isLandscapeMode = false;
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpec = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpec = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private void drawRectInLocation() {
        switch (this.levelerLocation) {
            case TOP: {
                int top = (int)((float)this.frame.y + this.defaultPaddingTopAndBottom);
                this.mainRectangleUpper = new RectF((float)this.frame.x + this.defaultPaddingLeftAndRight, (float)top, (float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight, (float)top + this.levelerWidth);
                this.validationRectangleUpper = new RectF(this.mainRectangleUpper.left * (1.0f + this.validationRectTopBottomTrashHold), this.mainRectangleUpper.top, this.mainRectangleUpper.right - this.mainRectangleUpper.left * this.validationRectTopBottomTrashHold, this.mainRectangleUpper.bottom);
                break;
            }
            case BOTTOM: {
                int top = (int)((float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.mainRectangleUpper = new RectF((float)this.frame.x + this.defaultPaddingLeftAndRight, (float)top, (float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight, (float)top + this.levelerWidth);
                this.validationRectangleUpper = new RectF(this.mainRectangleUpper.left * (1.0f + this.validationRectTopBottomTrashHold), this.mainRectangleUpper.top, this.mainRectangleUpper.right - this.mainRectangleUpper.left * this.validationRectTopBottomTrashHold, this.mainRectangleUpper.bottom);
                break;
            }
            case LEFT: {
                int left = (int)((float)this.frame.x + this.defaultPaddingLeftAndRight);
                this.mainRectangleSide = new RectF((float)left, (float)this.frame.y + this.defaultPaddingTopAndBottom, (float)left + this.levelerWidth, (float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.validationRectangleSide = new RectF(this.mainRectangleSide.left, this.mainRectangleSide.top * (1.0f + this.validationRectLeftRightTrashHold), this.mainRectangleSide.right, this.mainRectangleSide.bottom - this.mainRectangleSide.top * this.validationRectLeftRightTrashHold);
                break;
            }
            case RIGHT: {
                int left = (int)((float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight);
                this.mainRectangleSide = new RectF((float)left, (float)this.frame.y + this.defaultPaddingTopAndBottom, (float)left + this.levelerWidth, (float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.validationRectangleSide = new RectF(this.mainRectangleSide.left, this.mainRectangleSide.top * (1.0f + this.validationRectLeftRightTrashHold), this.mainRectangleSide.right, this.mainRectangleSide.bottom - this.mainRectangleSide.top * this.validationRectLeftRightTrashHold);
            }
        }
    }

    private static enum Location {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

