/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.topimagesystems.R;
import org.opencv.core.Rect;

public class ScaleLeveler
extends View {
    private final float MIN_SCALE_UNIT_GAP = 20.0f;
    private final float MAX_SCALE_UNIT_GAP = 400.0f;
    private boolean isValidOrintation = false;
    private int strokeWidthContainer = 5;
    private int strokeWidthInner = 5;
    private Paint arrowPaint;
    private Paint rectanglePaintContainer;
    private float levelerTrashold = 0.047f;
    private float levelerTrasholdSide = 0.036f;
    private float levelerTrasholdSidePortrait = 0.02f;
    private float convertPixelsToAccelerometerUpper;
    private float convertPixelsToAccelerometerSide;
    private boolean validOrientationX;
    private boolean validOrientationY;
    private RectF mainRectangleUpper;
    private RectF validationRectangleUpper;
    private RectF mainRectangleSide;
    private RectF validationRectangleSide;
    private float levelerWidth = 100.0f;
    private boolean isHorizontalLevel;
    private int colorOrientationPassContainer;
    private int colorOrientationFailContainer;
    private int colorOrientationPassArrow;
    private int colorOrientationFailArrow;
    private float defaultPaddingLeftAndRight;
    private float defaultPaddingTopAndBottom;
    private int location;
    private boolean isFadeAnimationEnable;
    private boolean isDraggingEnable;
    private Context context;
    private float xValue = 0.0f;
    private float yValue = 0.0f;
    private boolean isLandscapeMode = true;
    private float validationRectTopBottomTrashHold = 0.6f;
    private float validationRectLeftRightTrashHold = 0.3f;
    private Rect frame;
    private float scaleUnitGap;
    private boolean isWithColoreRange;
    private int[] scaleUnitsColorArray;
    private Location levelerLocation;

    @SuppressLint(value={"Recycle"})
    public ScaleLeveler(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
        TypedArray twoLevelerData = context.obtainStyledAttributes(attrs, R.styleable.TwoUnitsLeveler);
        TypedArray scaleLevelerData = context.obtainStyledAttributes(attrs, R.styleable.ScaleLeveler);
        int defaultVal = this.isHorizontalLevel ? 0 : 2;
        this.colorOrientationPassContainer = 0x33000000;
        this.colorOrientationFailContainer = 0x33000000;
        this.colorOrientationPassArrow = -1;
        this.colorOrientationFailArrow = -65536;
        this.defaultPaddingLeftAndRight = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingLeftAndRight, 0.0f);
        this.defaultPaddingTopAndBottom = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingTopAndBottom, 0.0f);
        this.location = twoLevelerData.getInteger(R.styleable.TwoUnitsLeveler_levelerLocation, 0);
        this.setDefaultValues(this.defaultPaddingLeftAndRight, this.defaultPaddingTopAndBottom);
        this.isHorizontalLevel = false;
        if (this.levelerLocation == Location.TOP || this.levelerLocation == Location.BOTTOM) {
            this.isHorizontalLevel = true;
        }
        this.isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
        this.isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);
        this.isHorizontalLevel = false;
        if (this.location == 0 || this.location == 1) {
            this.isHorizontalLevel = true;
        }
        if (!this.isHorizontalLevel && (double)this.defaultPaddingTopAndBottom > 140.0) {
            this.validationRectLeftRightTrashHold = 0.15f;
        } else if (this.isHorizontalLevel && (double)this.defaultPaddingTopAndBottom > 250.0) {
            this.validationRectTopBottomTrashHold = 0.3f;
        }
        this.scaleUnitGap = scaleLevelerData.getDimension(R.styleable.ScaleLeveler_scaleUnitGap, 200.0f);
        this.scaleUnitGap = Math.min(this.scaleUnitGap, 400.0f);
        this.scaleUnitGap = Math.max(this.scaleUnitGap, 20.0f);
        this.isWithColoreRange = scaleLevelerData.getBoolean(R.styleable.ScaleLeveler_userColorsInScale, false);
        int redColor = -1036984;
        int orangeColor = -551906;
        int greenColor = -7485633;
        this.scaleUnitsColorArray = this.isWithColoreRange ? new int[]{redColor, orangeColor, greenColor, orangeColor, redColor} : new int[]{-1};
        oneLevelerData.recycle();
        twoLevelerData.recycle();
        scaleLevelerData.recycle();
        this.init();
    }

    public boolean isDraggingEnable() {
        return this.isDraggingEnable;
    }

    public boolean isFadeAnimationEnable() {
        return this.isFadeAnimationEnable;
    }

    public ScaleLeveler(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    public void setFrame(Rect ValidationRect) {
        this.frame = ValidationRect;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.arrowPaint = new Paint();
        this.arrowPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.arrowPaint.setAntiAlias(true);
        this.arrowPaint.setColor(this.context.getResources().getColor(R.color.counter_background));
        this.rectanglePaintContainer = new Paint();
        this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
        this.rectanglePaintContainer.setStyle(Paint.Style.FILL_AND_STROKE);
        this.rectanglePaintContainer.setStrokeWidth((float)this.strokeWidthContainer);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    public float[] getUpperMainRectSize() {
        float[] res = new float[]{this.mainRectangleUpper.width(), this.mainRectangleUpper.height()};
        return res;
    }

    public float[] getLeftRightRectSize() {
        float[] res = new float[]{this.mainRectangleSide.width(), this.mainRectangleSide.height()};
        return res;
    }

    public void showLeveler() {
        this.setVisibility(0);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isHorizontalLevel) {
            this.drawHorizontalLeveler(canvas);
        } else {
            this.drawVerticalLeveler(canvas);
        }
    }

    private void setDefaultValues(float left, float top) {
        switch (this.location) {
            case 0: {
                this.levelerLocation = Location.TOP;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 45.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 18.0f : top;
                break;
            }
            case 1: {
                this.levelerLocation = Location.BOTTOM;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 30.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 45.0f : top;
                break;
            }
            case 2: {
                this.levelerLocation = Location.LEFT;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 18.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 25.0f : top;
                break;
            }
            case 3: {
                this.levelerLocation = Location.RIGHT;
                this.defaultPaddingLeftAndRight = left == 0.0f ? 45.0f : left;
                this.defaultPaddingTopAndBottom = top == 0.0f ? 15.0f : top;
            }
        }
    }

    private void drawHorizontalLeveler(Canvas canvas) {
        boolean validOrintation;
        if (this.mainRectangleUpper == null) {
            this.drawRectInLocation();
            canvas.drawRoundRect(this.mainRectangleUpper, 15.0f, 15.0f, this.rectanglePaintContainer);
            int numberOfHorizontalScaleUnits = (int)Math.floor(this.mainRectangleUpper.width() / this.scaleUnitGap);
            if (numberOfHorizontalScaleUnits % 2 == 0) {
                ++numberOfHorizontalScaleUnits;
            }
            float originHorizontalGap = (this.mainRectangleUpper.width() - (float)(numberOfHorizontalScaleUnits - 1) * this.scaleUnitGap) / 2.0f;
            for (int i = 0; i < numberOfHorizontalScaleUnits; ++i) {
                this.drawScaleUnit(this.mainRectangleUpper.left + originHorizontalGap + this.scaleUnitGap * (float)i, canvas, true);
            }
        }
        boolean bl = validOrintation = this.isLandscapeMode ? this.validOrientationX : this.validOrientationY;
        if (validOrintation) {
            this.rectanglePaintContainer.setColor(this.colorOrientationPassContainer);
            this.arrowPaint.setColor(this.colorOrientationPassArrow);
        } else {
            this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
            this.arrowPaint.setColor(this.colorOrientationFailArrow);
        }
        this.convertPixelsToAccelerometerUpper = this.levelerTrashold * this.validationRectangleUpper.width() * (float)(this.frame.width / 974);
        float arrowWidth = (this.mainRectangleUpper.bottom - this.mainRectangleUpper.top) * 0.5f;
        float arrowX = this.validationRectangleUpper.centerX();
        float circleXLocation = this.checkArrowLocationX(arrowX + this.xValue * this.convertPixelsToAccelerometerUpper, this.mainRectangleUpper);
        if (this.isWithColoreRange) {
            this.arrowPaint.setColor(this.getScaleColorWithPosition(circleXLocation, true));
        }
        int[] verticesColors = new int[]{this.arrowPaint.getColor(), this.arrowPaint.getColor(), this.arrowPaint.getColor(), -16777216, -16777216, -16777216};
        float[] verts = new float[]{circleXLocation, this.validationRectangleUpper.centerY(), circleXLocation + arrowWidth / 2.0f, this.levelerLocation == Location.TOP ? this.validationRectangleUpper.bottom : this.validationRectangleUpper.top, circleXLocation - arrowWidth / 2.0f, this.levelerLocation == Location.TOP ? this.validationRectangleUpper.bottom : this.validationRectangleUpper.top};
        canvas.drawVertices(Canvas.VertexMode.TRIANGLES, verts.length, verts, 0, null, 0, verticesColors, 0, null, 0, 0, this.arrowPaint);
    }

    private void drawScaleUnit(float scalePosition, Canvas canvas, boolean isHorizontal) {
        float startX;
        int scaleUnitColor = this.getScaleColorWithPosition(scalePosition, isHorizontal);
        Paint scaleUnitPaint = new Paint();
        scaleUnitPaint.setStyle(Paint.Style.STROKE);
        scaleUnitPaint.setAntiAlias(true);
        scaleUnitPaint.setColor(scaleUnitColor);
        float f = isHorizontal ? scalePosition : (startX = this.levelerLocation == Location.LEFT ? this.mainRectangleSide.left + 2.0f : this.mainRectangleSide.left + this.mainRectangleSide.width() - 2.0f);
        float startY = isHorizontal ? (this.levelerLocation == Location.TOP ? this.mainRectangleUpper.top + 2.0f : this.mainRectangleUpper.top + this.mainRectangleSide.height() - 2.0f) : scalePosition;
        float stopX = isHorizontal ? scalePosition : this.mainRectangleSide.left + this.mainRectangleSide.width() / 2.0f;
        float stopY = isHorizontal ? this.mainRectangleUpper.top + this.mainRectangleUpper.height() / 2.0f : scalePosition;
        canvas.drawLine(startX, startY, stopX, stopY, scaleUnitPaint);
    }

    private int getScaleColorWithPosition(float position, boolean isHorizontal) {
        float colorUnitSize = (isHorizontal ? this.mainRectangleUpper.width() : this.mainRectangleSide.height()) / (float)this.scaleUnitsColorArray.length;
        int colorUnit = (int)Math.floor((position - (isHorizontal ? this.mainRectangleUpper.left : this.mainRectangleSide.top) - 1.0f) / colorUnitSize);
        colorUnit = Math.max(colorUnit, 0);
        colorUnit = Math.min(colorUnit, this.scaleUnitsColorArray.length - 1);
        return this.scaleUnitsColorArray[colorUnit];
    }

    private void drawVerticalLeveler(Canvas canvas) {
        boolean validOrintation;
        boolean bl = validOrintation = this.isLandscapeMode ? this.validOrientationY : this.validOrientationX;
        if (this.mainRectangleSide == null) {
            this.drawRectInLocation();
        }
        if (validOrintation) {
            this.rectanglePaintContainer.setColor(this.colorOrientationPassContainer);
            this.arrowPaint.setColor(this.colorOrientationPassArrow);
        } else {
            this.rectanglePaintContainer.setColor(this.colorOrientationFailContainer);
            this.arrowPaint.setColor(this.colorOrientationFailArrow);
        }
        canvas.drawRoundRect(this.mainRectangleSide, 15.0f, 15.0f, this.rectanglePaintContainer);
        float trahHoldLeveler = this.isLandscapeMode ? this.levelerTrasholdSide : this.levelerTrasholdSidePortrait;
        this.convertPixelsToAccelerometerSide = trahHoldLeveler * this.mainRectangleSide.height() * (float)(this.frame.height / 487);
        float arrowY = this.validationRectangleSide.centerY();
        float arrowWidth = (this.mainRectangleSide.right - this.mainRectangleSide.left) * 0.5f;
        float circleYLocation = this.checkArrowLocationY(arrowY - this.yValue * this.convertPixelsToAccelerometerSide, this.mainRectangleSide);
        if (this.isWithColoreRange) {
            this.arrowPaint.setColor(this.getScaleColorWithPosition(circleYLocation, false));
        }
        int[] verticesColors = new int[]{this.arrowPaint.getColor(), this.arrowPaint.getColor(), this.arrowPaint.getColor(), -16777216, -16777216, -16777216};
        int numberOfVerticalScaleUnits = (int)Math.floor(this.mainRectangleSide.height() / this.scaleUnitGap);
        if (numberOfVerticalScaleUnits % 2 == 0) {
            ++numberOfVerticalScaleUnits;
        }
        float originVerticalGap = (this.mainRectangleSide.height() - (float)(numberOfVerticalScaleUnits - 1) * this.scaleUnitGap) / 2.0f;
        for (int i = 0; i < numberOfVerticalScaleUnits; ++i) {
            this.drawScaleUnit(this.mainRectangleSide.top + originVerticalGap + this.scaleUnitGap * (float)i, canvas, false);
        }
        float[] verts = new float[]{this.validationRectangleSide.centerX(), circleYLocation, this.levelerLocation == Location.LEFT ? this.validationRectangleSide.right : this.validationRectangleSide.left, circleYLocation + arrowWidth / 2.0f, this.levelerLocation == Location.LEFT ? this.validationRectangleSide.right : this.validationRectangleSide.left, circleYLocation - arrowWidth / 2.0f};
        canvas.drawVertices(Canvas.VertexMode.TRIANGLES, verts.length, verts, 0, null, 0, verticesColors, 0, null, 0, 0, this.arrowPaint);
    }

    private float checkArrowLocationX(float location, RectF mainRectangle) {
        float locationResult = location;
        if (location < mainRectangle.left) {
            locationResult = mainRectangle.left;
        }
        if (location > mainRectangle.right) {
            locationResult = mainRectangle.right;
        }
        return locationResult;
    }

    private float checkArrowLocationY(float location, RectF mainRectangle) {
        float locationResult = location;
        if (location < this.mainRectangleSide.top) {
            locationResult = this.mainRectangleSide.top;
        }
        if (location > this.mainRectangleSide.bottom) {
            locationResult = this.mainRectangleSide.bottom;
        }
        return locationResult;
    }

    public void updateLevelerLocation(float[] values, boolean isValidX, boolean isValidY, boolean isPortrait) {
        this.isValidOrintation = isValidX && isValidY;
        this.validOrientationX = isValidX;
        this.validOrientationY = isValidY;
        this.yValue = values[2];
        this.xValue = values[1];
        if (isPortrait) {
            this.xValue = values[2];
            this.yValue = values[1];
            this.isLandscapeMode = false;
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpec = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpec = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private void drawRectInLocation() {
        if (this.frame == null) {
            return;
        }
        switch (this.levelerLocation) {
            case TOP: {
                int top = (int)((float)this.frame.y + this.defaultPaddingTopAndBottom);
                this.mainRectangleUpper = new RectF((float)this.frame.x + this.defaultPaddingLeftAndRight, (float)top, (float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight, (float)top + this.levelerWidth);
                this.validationRectangleUpper = new RectF(this.mainRectangleUpper.left * (1.0f + this.validationRectTopBottomTrashHold), this.mainRectangleUpper.top, this.mainRectangleUpper.right - this.mainRectangleUpper.left * this.validationRectTopBottomTrashHold, this.mainRectangleUpper.bottom);
                break;
            }
            case BOTTOM: {
                int top = (int)((float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.mainRectangleUpper = new RectF((float)this.frame.x + this.defaultPaddingLeftAndRight, (float)top, (float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight, (float)top + this.levelerWidth);
                this.validationRectangleUpper = new RectF(this.mainRectangleUpper.left * (1.0f + this.validationRectTopBottomTrashHold), this.mainRectangleUpper.top, this.mainRectangleUpper.right - this.mainRectangleUpper.left * this.validationRectTopBottomTrashHold, this.mainRectangleUpper.bottom);
                break;
            }
            case LEFT: {
                int left = (int)((float)this.frame.x + this.defaultPaddingLeftAndRight);
                this.mainRectangleSide = new RectF((float)left, (float)this.frame.y + this.defaultPaddingTopAndBottom, (float)left + this.levelerWidth, (float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.validationRectangleSide = new RectF(this.mainRectangleSide.left, this.mainRectangleSide.top * (1.0f + this.validationRectLeftRightTrashHold), this.mainRectangleSide.right, this.mainRectangleSide.bottom - this.mainRectangleSide.top * this.validationRectLeftRightTrashHold);
                break;
            }
            case RIGHT: {
                int left = (int)((float)(this.frame.x + this.frame.width) - this.defaultPaddingLeftAndRight);
                this.mainRectangleSide = new RectF((float)left, (float)this.frame.y + this.defaultPaddingTopAndBottom, (float)left + this.levelerWidth, (float)(this.frame.y + this.frame.height) - this.defaultPaddingTopAndBottom);
                this.validationRectangleSide = new RectF(this.mainRectangleSide.left, this.mainRectangleSide.top * (1.0f + this.validationRectLeftRightTrashHold), this.mainRectangleSide.right, this.mainRectangleSide.bottom - this.mainRectangleSide.top * this.validationRectLeftRightTrashHold);
            }
        }
    }

    private static enum Location {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

