/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import org.opencv.core.Rect;

public class DebugRectView
extends View {
    private Rect rect;
    private Paint rectPaint;

    public DebugRectView(Context context) {
        super(context);
        this.init();
    }

    public DebugRectView(Context arg0, AttributeSet arg1) {
        super(arg0, arg1);
        TypedArray a = arg0.obtainStyledAttributes(arg1, R.styleable.captureOverlay);
        CameraController.drawFoundedRectangle = a.getBoolean(R.styleable.captureOverlay_showCurrentRectangleFound, false);
        a.recycle();
        this.init();
    }

    public DebugRectView(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.rectPaint = new Paint();
        this.rectPaint.setColor(-7829368);
        this.rectPaint.setStyle(Paint.Style.STROKE);
        this.rectPaint.setStrokeWidth(3.0f);
        if (CameraController.drawFoundedRectangle && !CameraManagerController.isDebug) {
            this.rectPaint.setColor(-65536);
            CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY = 200L;
            this.rectPaint.setStrokeWidth(4.0f);
        }
    }

    @Deprecated
    public void setRect(Rect rect) {
        this.drawCheckRect(rect);
    }

    public Rect getRect() {
        return this.rect;
    }

    public void drawCheckRect(Rect rect) {
        this.rect = rect;
        this.invalidate();
    }

    public void clearCheckRect() {
        this.rect = null;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.rect != null) {
            canvas.drawRect((float)this.rect.x, (float)this.rect.y, (float)(this.rect.x + this.rect.width), (float)(this.rect.y + this.rect.height), this.rectPaint);
        }
    }
}

