/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.graphics.Matrix;
import android.graphics.Point;
import android.os.Bundle;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.intent.CaptureIntent;
import org.opencv.core.Mat;
import org.opencv.core.Rect;

public class OCRHelper {
    private static final int VIRTUAL_WIDTH = 480;
    private static final int VIRTUAL_HEIGHT = 320;
    private static final float videoAR = (float)CameraConfigurationManager.videoResolutionWidth / (float)CameraConfigurationManager.videoResolutionHeight;
    public static float scaleWidth;
    public static float scaleHeight;
    private static Matrix tranMatrix;

    public static Bundle rectToBundle(Rect rect, float[] bottomLeft, float[] bottomRight, float[] topLeft, float[] topRight) {
        if (rect == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        rect.x = (int)((float)rect.x * CameraConfigurationManager.screenAndVideoRatioWidth);
        bundle.putInt("x", rect.x);
        rect.y = (int)((float)rect.y * CameraConfigurationManager.screenAndVideoRatioHeight);
        bundle.putInt("y", rect.y);
        rect.width = (int)((float)rect.width * CameraConfigurationManager.screenAndVideoRatioWidth);
        bundle.putInt("width", rect.width);
        bundle.putFloatArray("INTENT_CHECK_QUADS_BOTTOM_LEFT", bottomLeft);
        bundle.putFloatArray("INTENT_CHECK_QUADS_BOTTOM_RIGHT", bottomRight);
        bundle.putFloatArray("INTENT_CHECK_QUADS_TOP_LEFT", topLeft);
        bundle.putFloatArray("INTENT_CHECK_QUADS_TOP_RIGHT", topRight);
        return bundle;
    }

    public static Point resizeImageForImageView() {
        int originalWidth = CameraConfigurationManager.videoResolutionWidth;
        int originalHeight = CameraConfigurationManager.videoResolutionHeight;
        int newWidth = -1;
        int newHeight = -1;
        float multFactor = -1.0f;
        if (originalHeight > originalWidth) {
            newHeight = CameraConfigurationManager.screenResolution.y = (int)((float)CameraConfigurationManager.screenResolution.y * CameraConfigurationManager.screenAndVideoRatioHeight);
            multFactor = (float)originalWidth / (float)originalHeight;
            newWidth = (int)((float)newHeight * multFactor);
        } else if (originalWidth > originalHeight) {
            newWidth = CameraConfigurationManager.screenResolution.x = (int)((float)CameraConfigurationManager.screenResolution.x * CameraConfigurationManager.screenAndVideoRatioWidth);
            multFactor = (float)originalHeight / (float)originalWidth;
            newHeight = (int)((float)newWidth * multFactor);
        } else if (originalHeight == originalWidth) {
            newHeight = CameraConfigurationManager.screenResolution.y;
            newWidth = CameraConfigurationManager.screenResolution.x;
        }
        return new Point(newWidth / CameraConfigurationManager.screenResolution.x, newHeight / CameraConfigurationManager.screenResolution.y);
    }

    public static Rect bundleToRect(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Rect rect = new Rect(bundle.getInt("x"), bundle.getInt("y"), bundle.getInt("width"), bundle.getInt("height"));
        return rect;
    }

    public static Matrix getTransformationMatris() {
        return tranMatrix;
    }

    public static Rect calculateVideoStillMatRatio(Rect checkRect, Mat currentMat, int displayWidth, Mat videoMat) {
        if (checkRect == null || currentMat == null) {
            return null;
        }
        Rect result = new Rect();
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight) {
                    int tmp = CameraConfigurationManager.videoResolutionHeight;
                    CameraConfigurationManager.videoResolutionHeight = CameraConfigurationManager.videoResolutionWidth;
                    CameraConfigurationManager.videoResolutionWidth = tmp;
                }
                scaleHeight = (float)currentMat.height() * 1.0f / (float)CameraConfigurationManager.videoResolutionHeight * 1.0f;
                scaleWidth = (float)currentMat.width() * 1.0f / (float)CameraConfigurationManager.videoResolutionWidth * 1.0f;
                float scale = (float)currentMat.width() / ((float)displayWidth * 1.0f);
                result.x = (int)((float)checkRect.x * scale);
                result.y = (int)((float)checkRect.y * scale);
                result.width = (int)((float)checkRect.width * scale);
                result.height = (int)((float)checkRect.height * scale);
            } else {
                scaleWidth = (float)(currentMat.width() / CameraConfigurationManager.videoResolutionHeight) * 1.0f;
                scaleHeight = (float)(currentMat.height() / CameraConfigurationManager.videoResolutionWidth) * 1.0f;
            }
        } else {
            scaleWidth = (float)currentMat.width() / ((float)videoMat.width() * 1.0f);
            scaleHeight = (float)currentMat.height() / ((float)videoMat.height() * 1.0f);
            return checkRect;
        }
        return result;
    }
}

