/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import com.topimagesystems.util.Logger;

public class ErrorCallback
implements Camera.ErrorCallback {
    static final String TAG = Logger.makeLogTag("ErrorCallback");
    private Handler errorHandler;
    private int errorMessage;

    void setHandler(Handler errorHandler, int errorMessage) {
        this.errorHandler = errorHandler;
        this.errorMessage = errorMessage;
    }

    public void onError(int paramInt, Camera paramCamera) {
        Logger.d(TAG, "onError, paramInt:" + paramInt + " paramCamera:" + paramCamera);
        if (this.errorHandler != null) {
            Message message = this.errorHandler.obtainMessage(this.errorMessage);
            message.arg1 = paramInt;
            this.errorHandler.sendMessage(message);
            this.errorHandler = null;
        } else {
            Logger.d(TAG, "Error callback, no handler for it");
        }
    }
}

