/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.util.Size;
import com.topimagesystems.Common;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.FlashlightManager;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.Arrays;
import java.util.List;
import org.opencv.core.Rect;

@SuppressLint(value={"NewApi"})
public final class CameraConfigurationManager {
    private static final String TAG = Logger.makeLogTag("CameraConfigurationManager");
    private static final int TEN_DESIRED_ZOOM = 27;
    public static final long SHOW_ORIENTATION_VALUES_DELAY = 0L;
    public static long AUTOFOCUS_INTERVAL = 1700L;
    public static long SHOW_CHECK_RECT_BOUNDERIES_DELAY = 1000L;
    public static final long SHOW_HINT_INDICATOR_DELAY = 2000L;
    public static final long ANNOUNCE_HINT_INDICATOR_DELAY = 6000L;
    public static long TAKE_PICTURE_INTERVAL = 650L;
    private final Activity context;
    public static Point screenResolution;
    public static Point cameraPreviewResolution;
    public static Point cameraCaptureResolution;
    private int previewFormat;
    private static int CAMERAPIXELS;
    private String previewFormatString;
    private static final double minimumCameraPixels = 3.5;
    public static int normalImageWidth;
    public static int normalImageHeight;
    public static float screenAndVideoRatioWidth;
    public static float screenAndVideoRatioHeight;
    public static int videoResolutionWidth;
    public static int videoResolutionHeight;
    public static float screenAspectRatio;
    public static float videoAspectRatio;
    public static int videoHeightRes;
    public static int videoWidthRes;
    public static int stillHeightRes;
    public static int stillWidthRes;
    public static int captureResolutionWidth;
    public static int captureResolutionHeight;
    public static int minHeightForVideoCapture;
    public static int minWidthForVideoCapture;
    private static String[] exceptionDevices;
    private static Point maxResolutionWithAR;
    private String[] focusMode;

    CameraConfigurationManager(Activity context) {
        this.context = context;
        screenResolution = UserInterfaceUtils.getDisplayDimensions((Context)context);
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        this.context.getPackageManager();
        videoHeightRes = this.context.getResources().getInteger(R.integer.videoHeightResolution);
        videoWidthRes = this.context.getResources().getInteger(R.integer.videoWidthResolution);
        stillWidthRes = this.context.getResources().getInteger(R.integer.stillWidthResolution);
        stillHeightRes = this.context.getResources().getInteger(R.integer.stillHeightResolution);
        minWidthForVideoCapture = this.context.getResources().getInteger(R.integer.minimumWidthForVideoCapture);
        minHeightForVideoCapture = this.context.getResources().getInteger(R.integer.minimumHeightForVideoCapture);
        this.previewFormat = parameters.getPreviewFormat();
        this.previewFormatString = parameters.get("preview-format");
        Logger.d(TAG, "Default preview format: " + this.previewFormat + '/' + this.previewFormatString);
        screenResolution = UserInterfaceUtils.getDisplayDimensions((Context)this.context);
        cameraPreviewResolution = CameraConfigurationManager.getCameraPreviewResolution(parameters, screenResolution, (Context)this.context);
        cameraCaptureResolution = CameraConfigurationManager.getCameraCaptureResolution(parameters, screenResolution, (Context)this.context);
        CameraConfigurationManager.setCameraDisplayOrientation(this.context, 1, camera);
        Logger.i(TAG, "Camera preview resolution: " + cameraPreviewResolution + " | cameraCaptureResolution:" + cameraCaptureResolution);
        if (CameraManagerController.isDebug) {
            String deviceDetails = "device type is " + FileUtils.getDeviceName() + "device model is " + FileUtils.getDeviceModel() + "device brand is " + FileUtils.getDeviceBrand();
            FileUtils.addToLogFile("deviceDetails ", deviceDetails, this.context.getApplicationContext());
            FileUtils.addToLogFile("Camera Preview resolution ", CameraConfigurationManager.cameraPreviewResolution.x + " * " + CameraConfigurationManager.cameraPreviewResolution.y, this.context.getApplicationContext());
            FileUtils.addToLogFile("Camera Capture resolution ", CameraConfigurationManager.cameraCaptureResolution.x + " * " + CameraConfigurationManager.cameraCaptureResolution.y, this.context.getApplicationContext());
        }
        screenAspectRatio = (float)CameraConfigurationManager.screenResolution.x / (float)CameraConfigurationManager.screenResolution.y;
        videoAspectRatio = (float)CameraConfigurationManager.cameraPreviewResolution.x / (float)CameraConfigurationManager.cameraPreviewResolution.y;
    }

    void setDesiredCameraParameters(Camera camera, boolean isTorchOn) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPreviewSize(CameraConfigurationManager.cameraPreviewResolution.x, CameraConfigurationManager.cameraPreviewResolution.y);
        parameters.setPictureSize(CameraConfigurationManager.cameraCaptureResolution.x, CameraConfigurationManager.cameraCaptureResolution.y);
        this.setFlash(parameters, isTorchOn);
        CameraConfigurationManager.setCameraDisplayOrientation(this.context, 1, camera);
        int result = CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT ? 90 : 0;
        camera.setDisplayOrientation(result);
        this.setZoom(parameters);
        this.setFocusMode(parameters);
        camera.setParameters(parameters);
    }

    private void setFocusMode(Camera.Parameters parameters) {
        List FocusModes = parameters.getSupportedFocusModes();
        if (this.checkExceptionDeviceFocus(parameters, FocusModes)) {
            return;
        }
        if (FocusModes.contains("auto")) {
            parameters.setFocusMode("auto");
        } else if (FocusModes.contains("continuous-picture")) {
            parameters.setFocusMode("continuous-picture");
        } else if (FocusModes.contains("macro")) {
            parameters.setFocusMode("macro");
        }
    }

    private boolean checkExceptionDeviceFocus(Camera.Parameters parameters, List<String> FocusModes) {
        return false;
    }

    public static Rect getVideoRect() {
        Rect videoRect = new Rect(0, 0, 1920, 1080);
        return videoRect;
    }

    public static Rect getScreenRect() {
        Rect videoRect = new Rect(0, 0, CameraConfigurationManager.screenResolution.x, CameraConfigurationManager.screenResolution.y);
        return videoRect;
    }

    public static Point getCameraPreviewResolution() {
        return cameraPreviewResolution;
    }

    public static Point getCameraCaptureResolution() {
        return cameraCaptureResolution;
    }

    public Point getScreenResolution() {
        return screenResolution;
    }

    public void setScreenResolution(Point screenResolutionVal) {
        screenResolution = screenResolutionVal;
    }

    int getPreviewFormat() {
        return this.previewFormat;
    }

    String getPreviewFormatString() {
        return this.previewFormatString;
    }

    public static Point getCameraPreviewResolution(Camera.Parameters parameters, Point screenResolution, Context c) {
        long startTime = System.currentTimeMillis();
        boolean defaultVideoResFound = false;
        List sizes = parameters.getSupportedPreviewSizes();
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile("Screen resolution ", screenResolution.x + " * " + screenResolution.y, c);
        }
        if (screenResolution.y > screenResolution.x) {
            int tmp = screenResolution.x;
            screenResolution.x = screenResolution.y;
            screenResolution.y = tmp;
        }
        int frameWidth = screenResolution.x;
        int frameHeight = screenResolution.y;
        int max = 0;
        if (videoWidthRes != 0 && videoHeightRes != 0) {
            videoResolutionWidth = videoWidthRes;
            videoResolutionHeight = videoHeightRes;
            return new Point(videoResolutionWidth, videoResolutionHeight);
        }
        for (Camera.Size size : sizes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("Preview size ", size.width + " * " + size.height, c);
            }
            if (size.height == minHeightForVideoCapture && size.width == minWidthForVideoCapture) {
                defaultVideoResFound = true;
            }
            if (size.height * size.width <= max) continue;
            max = size.height * size.width;
            videoResolutionWidth = size.width;
            videoResolutionHeight = size.height;
        }
        if (videoResolutionHeight >= minHeightForVideoCapture && videoResolutionWidth >= minWidthForVideoCapture && defaultVideoResFound) {
            videoResolutionWidth = minWidthForVideoCapture;
            videoResolutionHeight = minHeightForVideoCapture;
        }
        screenAndVideoRatioWidth = (float)frameWidth / (float)videoResolutionWidth;
        screenAndVideoRatioHeight = (float)frameHeight / (float)videoResolutionHeight;
        if (screenAndVideoRatioWidth == 0.0f) {
            screenAndVideoRatioWidth = 1.0f;
        }
        if (screenAndVideoRatioHeight == 0.0f) {
            screenAndVideoRatioHeight = 1.0f;
        }
        if (CameraManagerController.deviceModal.contains("XT10") && CameraManagerController.deviceBrand.equals("Motorola")) {
            videoResolutionWidth = 1280;
            videoResolutionHeight = 720;
        }
        if (CameraManagerController.deviceName.equals("Samsung SM-T710")) {
            videoResolutionWidth = 1440;
            videoResolutionHeight = 1080;
        }
        if (CameraManagerController.deviceName.equals("WIKO RAINBOW UP 4G")) {
            videoResolutionWidth = 1920;
            videoResolutionHeight = 1088;
        }
        long endTime = System.currentTimeMillis();
        Logger.i(TAG, "getCameraPreviewResolution time is" + String.valueOf(startTime - endTime));
        return new Point(videoResolutionWidth, videoResolutionHeight);
    }

    public static boolean isVideoModeSupported(Context c) {
        if (videoResolutionHeight < minHeightForVideoCapture || videoResolutionWidth < minWidthForVideoCapture) {
            return false;
        }
        return !CameraConfigurationManager.checkForExceptionDevices(c);
    }

    public static boolean checkForExceptionDevices(Context c) {
        try {
            exceptionDevices = c.getResources().getStringArray(R.array.exception_devices_name_stills_only);
            if (exceptionDevices == null || exceptionDevices.length == 0) {
                return false;
            }
            if (CameraManagerController.deviceName == "Samsung GT-I9500" && CameraManagerController.ocrType == Common.OCRType.CMC7) {
                return false;
            }
            for (int i = 0; i < exceptionDevices.length; ++i) {
                CameraConfigurationManager.exceptionDevices[i] = exceptionDevices[i].trim().toLowerCase();
            }
            return Arrays.asList(exceptionDevices).contains(CameraManagerController.deviceName.trim().toLowerCase());
        }
        catch (Exception e) {
            Logger.e(TAG, Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static void setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int result = 0;
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
    }

    public static boolean isCameraMegaPixelsSupported() {
        Camera camera = Camera.open();
        Camera.Parameters params = camera.getParameters();
        Point maxMegaPixels = CameraConfigurationManager.getMaximumMegaPixels(params);
        CAMERAPIXELS = maxMegaPixels.x * maxMegaPixels.y;
        camera.release();
        return (double)CAMERAPIXELS > 3500000.0;
    }

    public static Point chooseCaptureResolution(Size[] supportedSizes, Context c) {
        boolean foundLowImageRes = false;
        boolean foundMediumDefaultRes = false;
        boolean foundHighDefaultRes = false;
        Point maxMegaPixels = CameraConfigurationManager.getMaxSize(supportedSizes);
        captureResolutionWidth = maxMegaPixels.x;
        captureResolutionHeight = maxMegaPixels.y;
        int currMediumCaptureWidth = captureResolutionWidth;
        int currMediumCaptureHeight = captureResolutionHeight;
        int currHighCaptureWidth = captureResolutionWidth;
        int currHighCaptureHeight = captureResolutionHeight;
        for (Size size : supportedSizes) {
            double stillsResolutionRatio;
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("Stills size ", size.getWidth() + " * " + size.getWidth(), c);
            }
            if (size.getWidth() == normalImageWidth && size.getHeight() == normalImageHeight) {
                foundLowImageRes = true;
            }
            double videoResolutionRatio = (double)videoResolutionWidth / (double)videoResolutionHeight;
            if (size.getWidth() * size.getHeight() > 2300000 && Math.abs((stillsResolutionRatio = (double)size.getWidth() / (double)size.getHeight()) - videoResolutionRatio) < 0.1) {
                if ((CameraManagerController.useMaxResolutionStills || CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) && CameraConfigurationManager.maxResolutionWithAR.x * CameraConfigurationManager.maxResolutionWithAR.y < size.getWidth() * size.getHeight()) {
                    CameraConfigurationManager.maxResolutionWithAR.x = size.getWidth();
                    CameraConfigurationManager.maxResolutionWithAR.y = size.getHeight();
                }
                if (size.getWidth() * size.getHeight() < currMediumCaptureWidth * currMediumCaptureHeight) {
                    currMediumCaptureWidth = size.getWidth();
                    currMediumCaptureHeight = size.getHeight();
                    foundMediumDefaultRes = true;
                }
            }
            if (size.getWidth() < 2500 || size.getWidth() >= 2600 || size.getHeight() <= 1900 || size.getHeight() >= 2000) continue;
            foundHighDefaultRes = true;
            currHighCaptureWidth = size.getWidth();
            currHighCaptureHeight = size.getHeight();
        }
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.useMaxResolutionStills) {
            if (CameraManagerController.isDynamicCapture) {
                return new Point(captureResolutionWidth, captureResolutionHeight);
            }
            captureResolutionWidth = CameraConfigurationManager.maxResolutionWithAR.x;
            captureResolutionHeight = CameraConfigurationManager.maxResolutionWithAR.y;
            return maxResolutionWithAR;
        }
        if (FileUtils.getDeviceName().equals("Motorola XT1052")) {
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.getDeviceName().equals("Motorola XT1254")) {
            return new Point(2592, 1458);
        }
        if (stillWidthRes != 0 && stillHeightRes != 0) {
            captureResolutionWidth = stillWidthRes;
            captureResolutionHeight = stillHeightRes;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.isSamsungS4() || CameraManagerController.deviceName.equals("HTC One X+")) {
            captureResolutionWidth = normalImageWidth;
            captureResolutionHeight = normalImageHeight;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.isSamsungS5()) {
            captureResolutionWidth = 3264;
            captureResolutionHeight = 1836;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (foundLowImageRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose default resolution ", normalImageWidth + "* " + normalImageHeight, c);
            }
            captureResolutionWidth = normalImageWidth;
            captureResolutionHeight = normalImageHeight;
            return new Point(normalImageWidth, normalImageHeight);
        }
        if (foundMediumDefaultRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose medium resolution ", currMediumCaptureWidth + "* " + currMediumCaptureHeight, c);
            }
            captureResolutionWidth = currMediumCaptureWidth;
            captureResolutionHeight = currMediumCaptureHeight;
            return new Point(currMediumCaptureWidth, currMediumCaptureHeight);
        }
        if (foundHighDefaultRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose high resolution ", currHighCaptureWidth + "* " + currHighCaptureHeight, c);
            }
            captureResolutionWidth = currHighCaptureWidth;
            captureResolutionHeight = currHighCaptureHeight;
            return new Point(currHighCaptureWidth, currHighCaptureHeight);
        }
        return new Point(captureResolutionWidth, captureResolutionHeight);
    }

    public static Point getCameraCaptureResolution(Camera.Parameters parameters, Point screenResolution, Context c) {
        List supportedSizes = parameters.getSupportedPictureSizes();
        boolean foundLowImageRes = false;
        boolean foundMediumDefaultRes = false;
        boolean foundHighDefaultRes = false;
        Point maxMegaPixels = CameraConfigurationManager.getMaximumMegaPixels(parameters);
        captureResolutionWidth = maxMegaPixels.x;
        captureResolutionHeight = maxMegaPixels.y;
        int currMediumCaptureWidth = captureResolutionWidth;
        int currMediumCaptureHeight = captureResolutionHeight;
        int currHighCaptureWidth = captureResolutionWidth;
        int currHighCaptureHeight = captureResolutionHeight;
        for (Camera.Size size : supportedSizes) {
            double stillsResolutionRatio;
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("Stills size ", size.width + " * " + size.height, c);
            }
            if (size.width == normalImageWidth && size.height == normalImageHeight) {
                foundLowImageRes = true;
            }
            double videoResolutionRatio = (double)videoResolutionWidth / (double)videoResolutionHeight;
            if (size.width * size.height > 2300000 && Math.abs((stillsResolutionRatio = (double)size.width / (double)size.height) - videoResolutionRatio) < 0.1) {
                if ((CameraManagerController.useMaxResolutionStills || CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) && CameraConfigurationManager.maxResolutionWithAR.x * CameraConfigurationManager.maxResolutionWithAR.y < size.width * size.height) {
                    CameraConfigurationManager.maxResolutionWithAR.x = size.width;
                    CameraConfigurationManager.maxResolutionWithAR.y = size.height;
                }
                if (size.width * size.height < currMediumCaptureWidth * currMediumCaptureHeight) {
                    currMediumCaptureWidth = size.width;
                    currMediumCaptureHeight = size.height;
                    foundMediumDefaultRes = true;
                }
            }
            if (size.width < 2500 || size.width >= 2600 || size.height <= 1900 || size.height >= 2000) continue;
            foundHighDefaultRes = true;
            currHighCaptureWidth = size.width;
            currHighCaptureHeight = size.height;
        }
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.useMaxResolutionStills) {
            captureResolutionWidth = CameraConfigurationManager.maxResolutionWithAR.x;
            captureResolutionHeight = CameraConfigurationManager.maxResolutionWithAR.y;
            return maxResolutionWithAR;
        }
        if (FileUtils.getDeviceName().equals("Motorola XT1052")) {
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.getDeviceName().equals("Motorola XT1254")) {
            return new Point(2592, 1458);
        }
        if (stillWidthRes != 0 && stillHeightRes != 0) {
            captureResolutionWidth = stillWidthRes;
            captureResolutionHeight = stillHeightRes;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.isSamsungS4() || CameraManagerController.deviceName.equals("HTC One X+")) {
            captureResolutionWidth = normalImageWidth;
            captureResolutionHeight = normalImageHeight;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (FileUtils.isSamsungS5()) {
            captureResolutionWidth = 3264;
            captureResolutionHeight = 1836;
            return new Point(captureResolutionWidth, captureResolutionHeight);
        }
        if (foundLowImageRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose default resolution ", normalImageWidth + "* " + normalImageHeight, c);
            }
            captureResolutionWidth = normalImageWidth;
            captureResolutionHeight = normalImageHeight;
            return new Point(normalImageWidth, normalImageHeight);
        }
        if (foundMediumDefaultRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose medium resolution ", currMediumCaptureWidth + "* " + currMediumCaptureHeight, c);
            }
            captureResolutionWidth = currMediumCaptureWidth;
            captureResolutionHeight = currMediumCaptureHeight;
            return new Point(currMediumCaptureWidth, currMediumCaptureHeight);
        }
        if (foundHighDefaultRes) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("choose high resolution ", currHighCaptureWidth + "* " + currHighCaptureHeight, c);
            }
            captureResolutionWidth = currHighCaptureWidth;
            captureResolutionHeight = currHighCaptureHeight;
            return new Point(currHighCaptureWidth, currHighCaptureHeight);
        }
        return new Point(captureResolutionWidth, captureResolutionHeight);
    }

    private static Point getMaximumMegaPixels(Camera.Parameters parameters) {
        List supportedSizes = parameters.getSupportedPictureSizes();
        int max = 0;
        int width = 0;
        int height = 0;
        for (Camera.Size size : supportedSizes) {
            if (size.width * size.height <= max) continue;
            max = size.width * size.height;
            width = size.width;
            height = size.height;
        }
        return new Point(width, height);
    }

    private static Point getMaxSize(Size[] cameraSizes) {
        int max = 0;
        int width = 0;
        int height = 0;
        for (Size size : cameraSizes) {
            if (size.getWidth() * size.getHeight() <= max) continue;
            max = size.getWidth() * size.getHeight();
            width = size.getWidth();
            height = size.getHeight();
        }
        return new Point(width, height);
    }

    private void setFlash(Camera.Parameters parameters, boolean isTorchOn) {
        if (isTorchOn) {
            parameters.setFlashMode("torch");
            FlashlightManager.enableFlashlight();
        } else {
            parameters.setFlashMode("off");
            parameters.set("flash-value", 2);
            parameters.set("flash-mode", "off");
            FlashlightManager.disableFlashlight();
        }
    }

    private void setZoom(Camera.Parameters parameters) {
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 27;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.w(TAG, "Bad max-zoom: " + maxZoomString);
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.w(TAG, "Bad taking-picture-zoom-max: " + takingPictureZoomMaxString);
            }
        }
        if (maxZoomString != null) {
            parameters.set("zoom", String.valueOf((double)tenDesiredZoom / 10.0));
        }
        if (takingPictureZoomMaxString != null) {
            parameters.set("taking-picture-zoom", tenDesiredZoom);
        }
    }

    static {
        CAMERAPIXELS = 0;
        normalImageWidth = 2048;
        normalImageHeight = 1152;
        videoHeightRes = 0;
        videoWidthRes = 0;
        stillHeightRes = 0;
        stillWidthRes = 0;
        minHeightForVideoCapture = 1080;
        minWidthForVideoCapture = 1920;
        maxResolutionWithAR = new Point(0, 0);
    }
}

