/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.util.Logger;
import org.opencv.core.Rect;

public class CheckBounderiesView
extends View {
    private Paint paint;
    private Bitmap bounderyTop;
    private Bitmap bounderyTopV;
    private Bitmap bounderyBottom;
    private Bitmap bounderyBottomV;
    private Bitmap bounderyBottomRight;
    private Bitmap bounderyBottomVRight;
    private Bitmap bounderyTopRight;
    private Bitmap bounderyTopVRight;
    private Bitmap cmc7Line;
    private boolean isValid = false;
    private float tlOffset;
    private float ttOffset;
    private float blOffset;
    private float bbOffset;
    private float tlOffsetRight;
    private float ttOffsetRight;
    private float blOffsetRight;
    private float bbOffsetRight;
    public static Rect validationBoundariesRect;
    private Point displayDimensions;
    private boolean drawGreenRect = false;
    private boolean showBoundries = true;
    private boolean isAnimating = false;
    private BoundariesAnimationHelper animationHelper;
    private SeriesAnimationHelper seriesAnimationHelper;

    public CheckBounderiesView(Context context) {
        super(context);
        this.init();
    }

    public CheckBounderiesView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.captureOverlay);
        this.drawGreenRect = a.getBoolean(R.styleable.captureOverlay_drawGreenRectangle, false);
        this.init();
    }

    public CheckBounderiesView(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.init();
    }

    private void init() {
        if (!this.isInEditMode()) {
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            this.bounderyBottom = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_bottom)).getBitmap();
            this.bounderyBottomV = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_bottom_v)).getBitmap();
            this.bounderyTop = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_top)).getBitmap();
            this.bounderyTopV = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_top_v)).getBitmap();
            this.bounderyBottomRight = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_bottom_lr)).getBitmap();
            this.bounderyBottomVRight = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_bottom_v_rl)).getBitmap();
            this.bounderyTopRight = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_top_rt)).getBitmap();
            this.bounderyTopVRight = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.ic_boundary_top_v_rt)).getBitmap();
            this.cmc7Line = ((BitmapDrawable)this.getResources().getDrawable(R.drawable.cmc7_overlay)).getBitmap();
        }
    }

    public void clearView() {
        validationBoundariesRect = null;
    }

    public void setCheckBounderies(Point displayDimensions, CheckBoundaries checkBoundariesRect) {
        this.seriesAnimationHelper = null;
        validationBoundariesRect = checkBoundariesRect.getValidationBoundariesRectByCaptureMode();
        this.displayDimensions = displayDimensions;
        this.updateOffsets();
    }

    private void updateOffsets() {
        this.tlOffset = CheckBounderiesView.validationBoundariesRect.x - 3;
        this.ttOffset = CheckBounderiesView.validationBoundariesRect.y - 3;
        this.blOffset = CheckBounderiesView.validationBoundariesRect.x + CheckBounderiesView.validationBoundariesRect.width - this.bounderyBottom.getWidth() + 3;
        this.bbOffset = CheckBounderiesView.validationBoundariesRect.y + CheckBounderiesView.validationBoundariesRect.height - this.bounderyBottom.getHeight() + 3;
        this.blOffsetRight = CheckBounderiesView.validationBoundariesRect.x - 3;
        this.bbOffsetRight = this.bbOffset;
        this.tlOffsetRight = this.blOffset + 4.0f;
        this.ttOffsetRight = this.ttOffset;
    }

    public void animateToCheckBoundaries(CheckBoundaries checkBoundariesRect) {
        this.animateToCheckBoundaries(checkBoundariesRect, null, 0);
    }

    public void animateRectanglesSeries(CheckBoundaries checkBoundariesRect, Handler handler, int messageCode, Rect[] rectangles) {
        this.isAnimating = true;
        this.isValid = false;
        this.showBoundries = true;
        this.seriesAnimationHelper = null;
        if (rectangles != null && rectangles.length > 0) {
            this.seriesAnimationHelper = new SeriesAnimationHelper();
            this.seriesAnimationHelper.rectangles = rectangles;
            this.seriesAnimationHelper.finalCheckBoundaries = checkBoundariesRect;
            this.seriesAnimationHelper.finalHandler = handler;
            this.seriesAnimationHelper.finalMessageCode = messageCode;
            this.seriesAnimationHelper.rectanglesCounter = 0;
            Rect newBoundariesRect = rectangles[0];
            this.updateAnimationHelper(newBoundariesRect);
            this.invalidate();
        }
    }

    private void updateAnimationHelper(Rect rect) {
        this.animationHelper = new BoundariesAnimationHelper();
        this.animationHelper.counter = 0;
        this.animationHelper.left = (rect.x - CheckBounderiesView.validationBoundariesRect.x) / this.animationHelper.numberOfFrames;
        this.animationHelper.top = (rect.y - CheckBounderiesView.validationBoundariesRect.y) / this.animationHelper.numberOfFrames;
        this.animationHelper.width = (rect.width - CheckBounderiesView.validationBoundariesRect.width) / this.animationHelper.numberOfFrames;
        this.animationHelper.height = (rect.height - CheckBounderiesView.validationBoundariesRect.height) / this.animationHelper.numberOfFrames;
        this.animationHelper.newCheckBoundariesRect = null;
        this.animationHelper.newRect = rect;
        this.animationHelper.handler = null;
        this.animationHelper.endAnimationMessageCode = 0;
    }

    private void updateAnimationHelper(CheckBoundaries checkBoundariesRect, Handler handler, int messageCode) {
        Rect newBoundariesRect = checkBoundariesRect.getValidationBoundariesRectByCaptureMode();
        this.animationHelper = new BoundariesAnimationHelper();
        this.animationHelper.counter = 0;
        this.animationHelper.left = (newBoundariesRect.x - CheckBounderiesView.validationBoundariesRect.x) / this.animationHelper.numberOfFrames;
        this.animationHelper.top = (newBoundariesRect.y - CheckBounderiesView.validationBoundariesRect.y) / this.animationHelper.numberOfFrames;
        this.animationHelper.width = (newBoundariesRect.width - CheckBounderiesView.validationBoundariesRect.width) / this.animationHelper.numberOfFrames;
        this.animationHelper.height = (newBoundariesRect.height - CheckBounderiesView.validationBoundariesRect.height) / this.animationHelper.numberOfFrames;
        this.animationHelper.newCheckBoundariesRect = checkBoundariesRect;
        this.animationHelper.newRect = newBoundariesRect;
        this.animationHelper.handler = handler;
        this.animationHelper.endAnimationMessageCode = messageCode;
    }

    public void animateToCheckBoundaries(CheckBoundaries checkBoundariesRect, Handler handler, int messageCode) {
        this.isAnimating = true;
        this.isValid = false;
        this.showBoundries = true;
        this.seriesAnimationHelper = null;
        this.updateAnimationHelper(checkBoundariesRect, handler, messageCode);
        this.invalidate();
    }

    public void showBounderies(boolean isValid, boolean isVisible) {
        if (this.isAnimating) {
            return;
        }
        this.isValid = isValid;
        this.showBoundries = isVisible;
    }

    public Rect getValidationRect() {
        return validationBoundariesRect;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isInEditMode() && validationBoundariesRect != null && !CameraManagerController.isDynamicCapture) {
            if (this.paint == null) {
                this.paint = new Paint();
            }
            this.paint.setColor(this.getResources().getColor(R.color.camera_overlay_color));
            canvas.drawRect(0.0f, 0.0f, (float)this.displayDimensions.x, (float)CheckBounderiesView.validationBoundariesRect.y, this.paint);
            canvas.drawRect(0.0f, (float)CheckBounderiesView.validationBoundariesRect.y, (float)CheckBounderiesView.validationBoundariesRect.x, (float)(CheckBounderiesView.validationBoundariesRect.y + CheckBounderiesView.validationBoundariesRect.height + 1), this.paint);
            canvas.drawRect((float)(CheckBounderiesView.validationBoundariesRect.x + CheckBounderiesView.validationBoundariesRect.width + 1), (float)CheckBounderiesView.validationBoundariesRect.y, (float)this.displayDimensions.x, (float)(CheckBounderiesView.validationBoundariesRect.y + CheckBounderiesView.validationBoundariesRect.height + 1), this.paint);
            canvas.drawRect(0.0f, (float)(CheckBounderiesView.validationBoundariesRect.y + CheckBounderiesView.validationBoundariesRect.height + 1), (float)this.displayDimensions.x, (float)this.displayDimensions.y, this.paint);
            Bitmap topD = this.isValid || this.isAnimating ? this.bounderyTopV : this.bounderyTop;
            Bitmap bottomD = this.isValid || this.isAnimating ? this.bounderyBottomV : this.bounderyBottom;
            Bitmap topR = this.isValid || this.isAnimating ? this.bounderyTopVRight : this.bounderyTopRight;
            Bitmap bottomR = this.isValid || this.isAnimating ? this.bounderyBottomVRight : this.bounderyBottomRight;
            this.paint.setColor(this.isValid ? Color.argb((int)255, (int)0, (int)255, (int)0) : Color.argb((int)255, (int)255, (int)0, (int)0));
            this.paint.setAntiAlias(true);
            if (this.showBoundries) {
                if (!this.isValid || !this.drawGreenRect || !CameraManagerController.isStillMode || this.isAnimating) {
                    canvas.drawBitmap(topD, this.tlOffset, this.ttOffset, this.paint);
                    canvas.drawBitmap(bottomD, this.blOffset, this.bbOffset, this.paint);
                    canvas.drawBitmap(topR, this.tlOffsetRight, this.ttOffsetRight, this.paint);
                    canvas.drawBitmap(bottomR, this.blOffsetRight, this.bbOffsetRight, this.paint);
                    try {
                        if (CameraManagerController.showMicrOverlay && CameraController.getInstance() != null && CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()) != null && CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).captureMode != null && CameraManagerController.getOcrAnalyzeSession((Context)CameraController.getInstance()).captureMode == CameraTypes.CaptureMode.FRONT) {
                            canvas.drawBitmap(this.cmc7Line, this.blOffsetRight + 100.0f, this.bbOffsetRight + 30.0f, this.paint);
                        }
                    }
                    catch (Exception e) {
                        Logger.e("overlay", Log.getStackTraceString((Throwable)e));
                    }
                } else {
                    Paint rectanglePaintContainer = new Paint();
                    rectanglePaintContainer.setColor(-16711936);
                    rectanglePaintContainer.setStyle(Paint.Style.STROKE);
                    rectanglePaintContainer.setStrokeWidth(9.0f);
                    RectF validationRect = new RectF((float)CheckBounderiesView.validationBoundariesRect.x, (float)CheckBounderiesView.validationBoundariesRect.y, (float)(CheckBounderiesView.validationBoundariesRect.x + CheckBounderiesView.validationBoundariesRect.width), (float)(CheckBounderiesView.validationBoundariesRect.y + CheckBounderiesView.validationBoundariesRect.height));
                    canvas.drawRoundRect(validationRect, 15.0f, 15.0f, rectanglePaintContainer);
                }
            }
            if (this.isAnimating) {
                if (this.animationHelper.counter == this.animationHelper.numberOfFrames) {
                    this.handleFinishAnimation();
                } else {
                    ++this.animationHelper.counter;
                    int diff = this.animationHelper.numberOfFrames - this.animationHelper.counter;
                    CheckBounderiesView.validationBoundariesRect.x = (int)((double)this.animationHelper.newRect.x - this.animationHelper.left * (double)diff);
                    CheckBounderiesView.validationBoundariesRect.y = (int)((double)this.animationHelper.newRect.y - this.animationHelper.top * (double)diff);
                    CheckBounderiesView.validationBoundariesRect.width = (int)((double)this.animationHelper.newRect.width - this.animationHelper.width * (double)diff);
                    CheckBounderiesView.validationBoundariesRect.height = (int)((double)this.animationHelper.newRect.height - this.animationHelper.height * (double)diff);
                    this.updateOffsets();
                    this.invalidate();
                }
            }
        }
    }

    private void handleFinishAnimation() {
        if (this.animationHelper.newCheckBoundariesRect != null) {
            this.isAnimating = false;
            this.setCheckBounderies(this.displayDimensions, this.animationHelper.newCheckBoundariesRect);
            if (this.animationHelper.handler != null) {
                Message message = this.animationHelper.handler.obtainMessage(this.animationHelper.endAnimationMessageCode);
                message.sendToTarget();
            }
            this.animationHelper = null;
            this.invalidate();
        } else if (this.seriesAnimationHelper != null) {
            CheckBounderiesView.validationBoundariesRect.x = this.animationHelper.newRect.x;
            CheckBounderiesView.validationBoundariesRect.y = this.animationHelper.newRect.y;
            CheckBounderiesView.validationBoundariesRect.width = this.animationHelper.newRect.width;
            CheckBounderiesView.validationBoundariesRect.height = this.animationHelper.newRect.height;
            this.updateOffsets();
            this.invalidate();
            ++this.seriesAnimationHelper.rectanglesCounter;
            if (this.seriesAnimationHelper.rectanglesCounter >= this.seriesAnimationHelper.rectangles.length) {
                this.updateAnimationHelper(this.seriesAnimationHelper.finalCheckBoundaries, this.seriesAnimationHelper.finalHandler, this.seriesAnimationHelper.finalMessageCode);
            } else {
                this.updateAnimationHelper(this.seriesAnimationHelper.rectangles[this.seriesAnimationHelper.rectanglesCounter]);
            }
            this.invalidate();
        } else {
            this.isAnimating = false;
        }
    }

    private static class SeriesAnimationHelper {
        public Rect[] rectangles;
        public CheckBoundaries finalCheckBoundaries;
        public int rectanglesCounter = 0;
        public Handler finalHandler;
        public int finalMessageCode;

        private SeriesAnimationHelper() {
        }
    }

    private static class BoundariesAnimationHelper {
        public int counter = 0;
        public double left = 0.0;
        public double top = 0.0;
        public double width = 0.0;
        public double height = 0.0;
        public int numberOfFrames = 30;
        public CheckBoundaries newCheckBoundariesRect;
        public Rect newRect;
        public Handler handler;
        public int endAnimationMessageCode;

        private BoundariesAnimationHelper() {
        }
    }
}

