/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.micr;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import com.topimagesystems.Common;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.ImageSessionResult;
import com.topimagesystems.micr.JavaNotifier;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.micr.TIFFResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public class MobiCHECKOCR {
    private static String tag = Logger.makeLogTag("MobiCHECKOCR");
    private long mNativeObj = 0L;
    private Context context;
    private String digitsFileE13BPath;
    private String signsFileE13BPath;
    private String digitsFileCMC7Path;
    private String signsFileCMC7Path;
    private String ocrMaskNumbersPath;
    private String blurResources;
    private String passportDigits;
    private String panCardDigits;
    private String ocrADigits;
    private String passportABC;
    private String passportDigitsABC;
    private CameraController.CameraActivityHandler handler;
    private JavaNotifier javaNotifier;
    private AssetManager assetManager;
    public static int counter_r = 0;

    public MobiCHECKOCR(Context context, boolean isDebug, float minRatioHW, float maxRatioHW, int micrType, boolean isUseCustomAlgorithmOnBack, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack, float maxRatioHWBack, boolean isIQAEnabled, IQASettingsIntent iqaSettings, boolean isBlurEnabled) throws Throwable {
        try {
            this.context = context;
            this.digitsFileE13BPath = FileUtils.readRawResource(context, R.raw.digits_masks, "digits_masks.csv");
            this.signsFileE13BPath = FileUtils.readRawResource(context, R.raw.signs_masks, "signs_masks.csv");
            this.digitsFileCMC7Path = FileUtils.readRawResource(context, R.raw.barcode_digits_masks, "barcode_digits_masks.csv");
            this.signsFileCMC7Path = FileUtils.readRawResource(context, R.raw.barcode_signs_masks, "barcode_signs_masks.csv");
            this.ocrMaskNumbersPath = FileUtils.readOCRMaskRawResources(context, "ocrMaskNumbers");
            this.passportDigits = FileUtils.readOCRMRZRawResources(context, "ocrMrzNumbers");
            this.panCardDigits = FileUtils.readOCRPanRawResources(context, "ocrPanLetters");
            this.ocrADigits = FileUtils.readRawResource(context, R.raw.ocra_masks, "ocra_digits_masks.csv");
            this.blurResources = CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE ? FileUtils.readRawResource(context, R.raw.blur_detect, "blur_detect_full.yml") : FileUtils.readRawResource(context, R.raw.blur_detect, "blur_detect.yml");
            float maxImageWidth = 8.75f;
            float minImageWidth = 5.5f;
            float maxImageHeight = 4.5f;
            float minImageHeight = 2.25f;
            String digitalRowDelimiter = "-";
            if (CameraManagerController.imageType != CaptureIntent.TISDocumentType.PAYMENT) {
                isBlurEnabled = false;
            }
            String loggerPath = FileUtils.internalStorageLocation + "/.mobiflow/";
            Rect ResultRect = MobiCHECKOCR.convertRectToCorrectAspectRatio(CameraSessionManager.getInstance().getCheckBoundariesRect().getValidationRect(), 3);
            maxRatioHW = (float)((double)((float)ResultRect.height / (float)ResultRect.width) * 1.1);
            minRatioHW = (float)((double)((float)ResultRect.height / (float)ResultRect.width) * 0.9);
            this.mNativeObj = MobiCHECKOCR.nativeCreateObject(isDebug, CameraManagerController.ocrType.getId(), this.digitsFileE13BPath, this.signsFileE13BPath, this.digitsFileCMC7Path, this.signsFileCMC7Path, this.ocrMaskNumbersPath, digitalRowDelimiter, this.blurResources, minRatioHW, maxRatioHW, maxImageWidth, minImageWidth, maxImageHeight, minImageHeight, isUseCustomAlgorithmOnBack, isBinarizeBakSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, isIQAEnabled, iqaSettings, isBlurEnabled, CameraManagerController.getDocumentAsInt(CameraManagerController.imageType), loggerPath);
            if (micrType != Common.OCRType.OFF.getId() && micrType != Common.OCRType.UNKNOWN.getId()) {
                this.initOcrManager(this.ocrMaskNumbersPath, this.digitsFileE13BPath, this.signsFileE13BPath, this.digitsFileCMC7Path, this.signsFileCMC7Path, this.ocrADigits, this.passportDigits, this.panCardDigits, micrType);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new NoSuchFieldException();
        }
    }

    public void setHandler(CameraController.CameraActivityHandler handler) {
        this.handler = handler;
        this.javaNotifier = new JavaNotifier(handler, this.context);
    }

    public void setValidationCheckRect(Rect validCheckBoundaries, Rect minCheckBoundaries, Rect validCheckBoundariesBack, Rect minCheckBoundariesBack) {
        int[] validCheckBoundariesArray = new int[]{0, 0, CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth};
        int[] minCheckBoundariesArray = new int[]{120, 157, 480, 765};
        int[] validCheckBoundariesBackArray = new int[]{0, 0, CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth};
        int[] minCheckBoundariesBackArray = new int[]{120, 157, 480, 765};
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
            Point screenResolution = UserInterfaceUtils.getDisplayDimensions(this.context);
            double heightInPixels = (double)screenResolution.x > (double)screenResolution.y ? (double)screenResolution.x : (double)screenResolution.y;
            double aspectRatio = (double)CameraConfigurationManager.videoResolutionWidth / heightInPixels;
            int[] portraitRect = new int[]{(int)((double)validCheckBoundaries.x * aspectRatio), (int)((double)validCheckBoundaries.y * aspectRatio), (int)((double)validCheckBoundaries.width * aspectRatio), (int)((double)validCheckBoundaries.height * aspectRatio)};
            validCheckBoundariesArray = portraitRect;
            Rect validationRect = new Rect(portraitRect[0], portraitRect[1], portraitRect[2], portraitRect[3]);
            CameraSessionManager.getInstance().setCheckBoundariesRect(validationRect);
        }
        if (CameraManagerController.imageType != CaptureIntent.TISDocumentType.FULL_PAGE && CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT) {
            if (validCheckBoundaries != null) {
                validCheckBoundariesArray = this.rectToArray(validCheckBoundaries);
            }
            if (minCheckBoundaries != null) {
                minCheckBoundariesArray = this.rectToArray(minCheckBoundaries);
            }
            if (validCheckBoundariesBack != null) {
                validCheckBoundariesBackArray = this.rectToArray(validCheckBoundariesBack);
            }
            if (minCheckBoundariesBack != null) {
                minCheckBoundariesBackArray = this.rectToArray(minCheckBoundariesBack);
            }
        }
        MobiCHECKOCR.setValidationCheckRect(this.mNativeObj, validCheckBoundariesArray, minCheckBoundariesArray, validCheckBoundariesBackArray, minCheckBoundariesBackArray);
    }

    public static Rect convertRectToCorrectAspectRatio(Rect rectToValidate, int convertFromScreenToVideo) {
        RectF stillsResolution;
        RectF videoResolution;
        RectF screenResolution;
        int screenSmallRes;
        int screenBigRes;
        int stillsSmallRes;
        int stillsBigRes;
        int videoSmallRes;
        int videoBigRes;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix = new Matrix();
        if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight) {
            videoBigRes = CameraConfigurationManager.videoResolutionWidth;
            videoSmallRes = CameraConfigurationManager.videoResolutionHeight;
            stillsBigRes = CameraConfigurationManager.captureResolutionWidth;
            stillsSmallRes = CameraConfigurationManager.captureResolutionHeight;
        } else {
            videoSmallRes = CameraConfigurationManager.videoResolutionWidth;
            videoBigRes = CameraConfigurationManager.videoResolutionHeight;
            stillsSmallRes = CameraConfigurationManager.captureResolutionWidth;
            stillsBigRes = CameraConfigurationManager.captureResolutionHeight;
        }
        if (CameraConfigurationManager.screenResolution.x > CameraConfigurationManager.screenResolution.y) {
            screenBigRes = CameraConfigurationManager.screenResolution.x;
            screenSmallRes = CameraConfigurationManager.screenResolution.y;
        } else {
            screenBigRes = CameraConfigurationManager.screenResolution.y;
            screenSmallRes = CameraConfigurationManager.screenResolution.x;
        }
        if (CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT) {
            screenResolution = new RectF(0.0f, 0.0f, (float)screenBigRes, (float)screenSmallRes);
            videoResolution = new RectF(0.0f, 0.0f, (float)videoBigRes, (float)videoSmallRes);
            stillsResolution = new RectF(0.0f, 0.0f, (float)stillsBigRes, (float)stillsSmallRes);
        } else {
            screenResolution = new RectF(0.0f, 0.0f, (float)screenSmallRes, (float)screenBigRes);
            videoResolution = new RectF(0.0f, 0.0f, (float)videoSmallRes, (float)videoBigRes);
            stillsResolution = new RectF(0.0f, 0.0f, (float)stillsSmallRes, (float)stillsBigRes);
        }
        if (convertFromScreenToVideo == 1) {
            scaleMatrix.setRectToRect(videoResolution, screenResolution, Matrix.ScaleToFit.FILL);
        } else if (convertFromScreenToVideo == 2) {
            scaleMatrix.setRectToRect(videoResolution, stillsResolution, Matrix.ScaleToFit.FILL);
        } else {
            scaleMatrix.setRectToRect(screenResolution, videoResolution, Matrix.ScaleToFit.FILL);
        }
        float[] rectValues = new float[4];
        float[] srcValues = new float[]{rectToValidate.x, rectToValidate.y, rectToValidate.width, rectToValidate.height};
        scaleMatrix.mapPoints(rectValues, srcValues);
        Rect resultRect = new Rect();
        resultRect.x = (int)rectValues[0];
        resultRect.y = (int)rectValues[1];
        resultRect.width = (int)rectValues[2];
        resultRect.height = (int)rectValues[3];
        return resultRect;
    }

    public boolean initOcrManager(String ocrMaskNumbersPath, String digitsFileE13BPath, String signsFileE13BPath, String digitsFileCMC7Path, String signsFileCMC7Path, String ocrADigits, String mrzFilesLocation, String panDigits, int micrType) {
        if (micrType != Common.OCRType.OFF.getId() && micrType != Common.OCRType.UNKNOWN.getId()) {
            return this.initReadManager(ocrMaskNumbersPath, digitsFileE13BPath, signsFileE13BPath, digitsFileCMC7Path, signsFileCMC7Path, ocrADigits, mrzFilesLocation, panDigits, micrType);
        }
        return false;
    }

    public OCRResult readOCRData(Mat img, Mat binImg, Rect checkBounds, Rect videoRect, Rect BoundingBoxVideo, int micr, boolean readOcrFromFullImage) {
        block11: {
            try {
                int[] checkBoundsArray = new int[]{};
                int[] videoRectArray = new int[]{};
                int[] BoundingBoxVideoArray = new int[]{};
                if (checkBounds != null) {
                    checkBoundsArray = this.rectToArray(checkBounds);
                }
                if (videoRect != null) {
                    videoRectArray = this.rectToArray(videoRect);
                }
                if (BoundingBoxVideo != null) {
                    BoundingBoxVideoArray = this.rectToArray(BoundingBoxVideo);
                }
                long binImage = binImg == null ? -1L : binImg.getNativeObjAddr();
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CARD && CameraManagerController.ocrType == Common.OCRType.PAN) {
                    img = new Mat(img, checkBounds);
                    return MobiCHECKOCR.readPanCard(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), binImage, BoundingBoxVideoArray, videoRectArray, micr);
                }
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CARD && CameraManagerController.ocrType == Common.OCRType.MRZ) {
                    img = new Mat(img, checkBounds);
                    Mat croppedGray = new Mat();
                    Imgproc.cvtColor((Mat)img, (Mat)croppedGray, (int)7);
                    Rect MrzStripRect = new Rect(0, (int)((double)img.rows() * 0.6), img.cols(), (int)((double)img.rows() * 0.35));
                    croppedGray = new Mat(croppedGray, MrzStripRect);
                    return this.readMRZ(img, croppedGray);
                }
                if (!readOcrFromFullImage) {
                    try {
                        if (img != null && !img.empty()) {
                            return MobiCHECKOCR.readOCRData(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), binImage, BoundingBoxVideoArray, videoRectArray, micr);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        Logger.e(tag, "OCR data read failed ");
                        return null;
                    }
                }
                return MobiCHECKOCR.readOCRDataFromFullImage(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), checkBoundsArray, videoRectArray);
            }
            catch (Exception e) {
                Logger.e(tag, "OCR data read failed ");
                return null;
            }
        }
        return null;
    }

    public BoundingBoxResult findCheckBoundingBox(Mat img, boolean isFront, boolean scaleImageToMinimumSize) {
        return MobiCHECKOCR.findCheckBoundingBox(this.mNativeObj, this.javaNotifier, isFront, img.getNativeObjAddr(), scaleImageToMinimumSize);
    }

    public GenericBoundingBoxResult findGenericBoundingBox(Mat img, Mat croppedImageResult) {
        return MobiCHECKOCR.findGenericBoundingBox(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), croppedImageResult.getNativeObjAddr(), 0);
    }

    public OCRResult readPassport(Mat colorImg) {
        return MobiCHECKOCR.readPassport(this.mNativeObj, this.javaNotifier, colorImg.getNativeObjAddr());
    }

    public OCRResult readMRZ(Mat colorImg, Mat grayStrip) {
        return MobiCHECKOCR.readMRZ(this.mNativeObj, this.javaNotifier, colorImg.getNativeObjAddr(), grayStrip.getNativeObjAddr());
    }

    public boolean initReadManager(String ocrMaskNumbersPath, String digitsFileE13B, String signsFileE13B, String digitsFileCMC7, String signsFileCMC7, String OCRADigits, String mrzFilesLocation, String panCardFileLocation, int micr) {
        return MobiCHECKOCR.initReadManager(this.mNativeObj, this.javaNotifier, ocrMaskNumbersPath, digitsFileE13B, signsFileE13B, digitsFileCMC7, signsFileCMC7, OCRADigits, mrzFilesLocation, panCardFileLocation, micr);
    }

    public boolean detectBlur(Mat croppedImg, boolean isDebug, int imageType, int pixelsNumber, boolean isFront) {
        return MobiCHECKOCR.detectBlur(this.mNativeObj, croppedImg.getNativeObjAddr(), isDebug, !CameraManagerController.isStillMode, isFront, imageType, pixelsNumber);
    }

    public boolean BredlyBinarization(Mat croppedImg, Mat outputImg, String inputPath, String outputPath, String model, String make) {
        return MobiCHECKOCR.BredlyBinarization(this.mNativeObj, this.javaNotifier, croppedImg.getNativeObjAddr(), outputImg.getNativeObjAddr(), inputPath, outputPath, model, make);
    }

    public void binarizeWithoutSearchingBoundingBox(Mat incomingImage, Mat grayImage, Mat binResultImg, String pathToSave, int[] array2, boolean isFront) {
        MobiCHECKOCR.binarizeWithoutSearchingBoundingBox(this.mNativeObj, this.javaNotifier, incomingImage.getNativeObjAddr(), grayImage.getNativeObjAddr(), binResultImg.getNativeObjAddr(), pathToSave, array2, isFront);
    }

    public BoundingBoxResult findCheckBoundingBoxHighResImage(Mat img, long aspectRatio, Rect videoRect, Rect checkRect, Rect frontImageRect, double VideoStillAspectW, double VideoStillAspectH) {
        int[] videoArray = this.rectToArray(videoRect);
        int[] checkArray = this.rectToArray(checkRect);
        int[] frontImageArray = this.rectToArray(frontImageRect);
        return MobiCHECKOCR.findCheckBoundingBoxHighResImage(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), aspectRatio, videoArray, checkArray, frontImageArray, VideoStillAspectW, VideoStillAspectH);
    }

    public BoundingBoxResult findCheckBoundingBoxContinueAnyway(Mat img, long aspectRatio) {
        return MobiCHECKOCR.findCheckBoundingBoxAnyway(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), aspectRatio);
    }

    public boolean createAssetAudioPlayer(AssetManager assetManager, String filename) {
        return MobiCHECKOCR.createAssetAudioPlayer(this.mNativeObj, assetManager, filename);
    }

    public boolean isValidContrast(Mat img) {
        return MobiCHECKOCR.isValidContrast(this.mNativeObj, img.getNativeObjAddr());
    }

    public ImageSessionResult prepareCurrentImageForSending(Mat img, Mat outputCroppedImg, int timestamp, String inputImagePath, Rect videoRect, Rect checkRect, double orientation, boolean isFront, Rect frontImageSize, boolean isSendImageAsIs, int meanDigitHeight, boolean doOcr, int imageType, int originalImageSize, boolean imageAligment, boolean filterByAspect, String model, String make) {
        int[] videoArray = this.rectToArray(videoRect);
        int[] checkArray = this.rectToArray(checkRect);
        int[] frontImageArray = this.rectToArray(frontImageSize);
        CameraController.processStart = true;
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) {
            int tmp;
            if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight) {
                tmp = CameraConfigurationManager.videoResolutionWidth;
                CameraConfigurationManager.videoResolutionWidth = CameraConfigurationManager.videoResolutionHeight;
                CameraConfigurationManager.videoResolutionHeight = tmp;
            }
            if (CameraConfigurationManager.captureResolutionWidth > CameraConfigurationManager.captureResolutionHeight) {
                tmp = CameraConfigurationManager.captureResolutionWidth;
                CameraConfigurationManager.captureResolutionWidth = CameraConfigurationManager.captureResolutionHeight;
                CameraConfigurationManager.captureResolutionHeight = tmp;
            }
        }
        OCRHelper.scaleWidth = (float)CameraConfigurationManager.captureResolutionWidth / (float)CameraConfigurationManager.videoResolutionWidth;
        OCRHelper.scaleHeight = (float)CameraConfigurationManager.captureResolutionHeight / (float)CameraConfigurationManager.videoResolutionHeight;
        if (!CameraManagerController.isStillMode) {
            OCRHelper.scaleHeight = 1.0f;
            OCRHelper.scaleWidth = 1.0f;
        }
        if (!isFront) {
            CameraManagerController.binarizationType = 0;
        }
        String outputImagePath = inputImagePath.replace(".jpg", ".tiff");
        Imgproc.cvtColor((Mat)img, (Mat)img, (int)2);
        ImageSessionResult result = MobiCHECKOCR.prepareCurrentImageForSending(this.mNativeObj, this.javaNotifier, img.getNativeObjAddr(), outputCroppedImg.getNativeObjAddr(), timestamp, inputImagePath, outputImagePath, videoArray, checkArray, orientation, isFront, frontImageArray, isSendImageAsIs, meanDigitHeight, OCRHelper.scaleWidth, OCRHelper.scaleHeight, doOcr, imageType, originalImageSize, imageAligment, filterByAspect, CameraManagerController.binarizationType, CameraManagerController.binarizationThreshold, model, make);
        if (result.width == 0) {
            Logger.e(tag, "result.width == 0");
        }
        if (isFront) {
            SessionResultParams.tiffFront = FileUtils.getByteArray(outputImagePath);
            SessionResultParams.jpegBWFront = FileUtils.getByteArray(inputImagePath);
        } else {
            SessionResultParams.tiffBack = FileUtils.getByteArray(outputImagePath);
            SessionResultParams.jpegBWBack = FileUtils.getByteArray(inputImagePath);
        }
        FileUtils.deleteFile(outputImagePath);
        FileUtils.deleteFile(inputImagePath);
        if (result != null) {
            result.errorCodeId = result.errorCodeId;
            result.errorMessage = result.errorMessage;
        }
        result.mat = img;
        Logger.d(tag, "end time_" + FileUtils.getCurrentTime());
        return result;
    }

    public TIFFResult jpegToTiff(String inputPath) {
        String outputPath = inputPath.replace(".jpg", ".tiff");
        TIFFResult result = MobiCHECKOCR.jpegToTiff(this.mNativeObj, inputPath, outputPath);
        TIFFResult imageResult = new TIFFResult();
        if (result != null) {
            imageResult.errorCodeId = result.errorCodeId;
            imageResult.errorMessage = result.errorMessage;
        }
        imageResult.data = FileUtils.getByteArray(outputPath);
        imageResult.filePath = outputPath;
        return imageResult;
    }

    public String tiffToJpeg(byte[] data) {
        String result = MobiCHECKOCR.tiffToJpeg(this.mNativeObj, data);
        return result;
    }

    private int[] rectToArray(Rect rect) {
        if (rect == null) {
            return new int[0];
        }
        return new int[]{rect.x, rect.y, rect.width, rect.height};
    }

    private int[] replaceWidthAndHeight(Rect rect) {
        if (rect == null) {
            return new int[0];
        }
        return new int[]{rect.y, rect.x, rect.height, rect.width};
    }

    public void release() {
        try {
            MobiCHECKOCR.nativeDestroyObject(this.mNativeObj);
        }
        catch (Exception e) {
            Logger.e(tag, e.getMessage());
        }
        this.mNativeObj = 0L;
    }

    public void abort() {
        Logger.e(tag, "abort is called !");
    }

    void nativeCrashed() {
        new RuntimeException("crashed here (native trace should follow after the Java trace)").printStackTrace();
    }

    String getStackTrace(Throwable t) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(b, true));
        return b.toString();
    }

    public void prepareImages() {
    }

    native void crashMeHarder();

    private static native long nativeCreateObject(boolean var0, int var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, float var9, float var10, float var11, float var12, float var13, float var14, boolean var15, boolean var16, float var17, float var18, float var19, float var20, boolean var21, IQASettingsIntent var22, boolean var23, int var24, String var25);

    private static native boolean nativeDestroyObject(long var0);

    private static native void setValidationCheckRect(long var0, int[] var2, int[] var3, int[] var4, int[] var5);

    private static native BoundingBoxResult findCheckBoundingBox(long var0, JavaNotifier var2, boolean var3, long var4, boolean var6);

    private static native GenericBoundingBoxResult findGenericBoundingBox(long var0, JavaNotifier var2, long var3, long var5, int var7);

    private static native BoundingBoxResult findCheckBoundingBoxHighResImage(long var0, JavaNotifier var2, long var3, long var5, int[] var7, int[] var8, int[] var9, double var10, double var12);

    private static native BoundingBoxResult findCheckBoundingBoxAnyway(long var0, JavaNotifier var2, long var3, long var5);

    private static native boolean createAssetAudioPlayer(long var0, AssetManager var2, String var3);

    private static native OCRResult readPassport(long var0, JavaNotifier var2, long var3);

    private static native OCRResult readMRZ(long var0, JavaNotifier var2, long var3, long var5);

    private static native OCRResult readPanCard(long var0, JavaNotifier var2, long var3, long var5, int[] var7, int[] var8, int var9);

    private static native boolean detectBlur(long var0, long var2, boolean var4, boolean var5, boolean var6, int var7, int var8);

    private static native boolean initReadManager(long var0, JavaNotifier var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, int var11);

    private static native boolean BredlyBinarization(long var0, JavaNotifier var2, long var3, long var5, String var7, String var8, String var9, String var10);

    private static native OCRResult readOCRData(long var0, JavaNotifier var2, long var3, long var5, int[] var7, int[] var8, int var9);

    private static native OCRResult readOCRDataFromFullImage(long var0, JavaNotifier var2, long var3, int[] var5, int[] var6);

    private static native void binarizeWithoutSearchingBoundingBox(long var0, JavaNotifier var2, long var3, long var5, long var7, String var9, int[] var10, boolean var11);

    private static native boolean isValidContrast(long var0, long var2);

    private static native ImageSessionResult prepareCurrentImageForSending(long var0, JavaNotifier var2, long var3, long var5, int var7, String var8, String var9, int[] var10, int[] var11, double var12, boolean var14, int[] var15, boolean var16, int var17, double var18, double var20, boolean var22, int var23, int var24, boolean var25, boolean var26, int var27, float var28, String var29, String var30);

    private static native TIFFResult jpegToTiff(long var0, String var2, String var3);

    private static native String tiffToJpeg(long var0, byte[] var2);
}

