/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.intent;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.widget.Toast;
import com.topimagesystems.Common;
import com.topimagesystems.MobiFlowException;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.data.TISLicenseParameters;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class CaptureIntent {
    public static final int MOBI_FLOW_REQUEST_CODE = 1024;
    private static final String ACTION_CAPTURE = "com.topimagesystems.CAPTURE";
    public static final String INTENT_IS_DEBUG = "IS_DEBUG";
    public static final String INTENT_OCR_TYPE = "MICR_TYPE";
    public static final String INTENT_MAX_NUMBER_OF_RETRIES = "INTENT_MAX_NUMBER_OF_RETRIES";
    public static final String INTENT_MIN_RATIO_HEIGHT_WIDTH = "INTENT_MIN_RATIO_HEIGHT_WIDTH";
    public static final String INTENT_MAX_RATIO_HEIGHT_WIDTH = "INTENT_MAX_RATIO_HEIGHT_WIDTH";
    public static final String INTENT_IS_MANUAL_CAPTURE = "INTENT_IS_MANUAL_CAPTURE";
    public static final String INTENT_TXT_VALID_FROM = "INTENT_TXT_VALID_FROM";
    public static final String INTENT_TXT_VALID_TO = "INTENT_TXT_VALID_TO";
    public static final String INTENT_SHOW_MICR_OVERALY = "INTENT_SHOW_MICR_OVERALY";
    public static final String INTENT_ISAUTO_FRONT = "INTENT_ISAUTO_FRONT";
    public static final String INTENT_ISAUTO_BACK = "INTENT_ISAUTO_BACK";
    public static final String INTENT_ISIQA_PASSED_FRONT = "INTENT_ISIQA_PASSED_FRONT";
    public static final String INTENT_ISIQA_PASSED_BACK = "INTENT_ISIQA_PASSED_BACK";
    public static final String TAKE = "INTENT_ISIQA_PASSED_BACK";
    public static final String INTENT_IQA_ENABLED = "INTENT_IQA_ENABLED";
    public static final String INTENT_IQA_SETTINGS = "INTENT_IQA_SETTINGS";
    public static final String IS_CUSTOM_VIEW = "IS_CUSTOM_VIEW";
    public static final String CURRENT_SESSION_PARAMS = "SESSION_PARAMETERS";
    public static final String CURRENT_INPUT_SESSION_PARAMS = "CURRENT_INPUT_SESSION_PARAMS";
    public static final String SCAN_FRONT_ONLY = "SCAN_FRONT_ONLY";
    public static final String SCAN_BACK_ONLY = "SCAN_BACK_ONLY";
    public static final String INFO_SCREEN_ENABLED = "INFO_SCREEN_ENABLED";
    public static final String INFO_SCREEN_INTERVAL = "INFO_SCREEN_INTERVAL";
    public static final String GUIDLINES_INDICATOR = "GUIDLINES_INDICATOR";
    public static final String IS_BLUR_ENABLED = "IS_BLUR_ENABLED";
    public static final String IS_BLUR_ENABLED_ON_BACK_SIDE = "IS_BLUR_ENABLED_ON_BACK_SIDE";
    public static final String MAX_VIDEO_FRAMES_TO_CAPTURE = "MAX_VIDEO_FRAMES_TO_CAPTURE";
    public static final String FOLDER_LOCATION = "FOLDER_LOCATION";
    public static final String GRAY_SCALE = "GRAY_SCALE";
    public static final String OUTPUT_ORIGINAL_IMAGE = "SAVE_ORIGINAL_IMAGE";
    public static final String OUTPUT_COLORED_IMAGE = "OUTPUT_COLORED_IMAGE";
    public static final String OUTPUT_BW_IMAGE = "OUTPUT_BW_IMAGE";
    public static final String ENABLE_PROCESSING_VIEW = "ENABLE_PROCESSING_VIEW";
    public static final String IS_PORTRIT_MODE = "IS_PORTRIT_MODE";
    public static final String FRONT_IMAGE_RECT = "FRONT_IMAGE_RECT_ARRAY";
    public static final String GRAY_SCALE_SIZE = "GRAY_SCALE_SIZE";
    public static final String ENABLE_COUNTDOWN_SOUND = "ENABLE_COUNTDOWN_SOUND";
    public static final String ENABLE_VIDEO_MODE = "ENABLE_VIDEO_MODE";
    public static final String ENABLE_MULTI_CAPTURE = "ENABLE_MULTI_CAPTURE";
    public static final String ENABLE_DYNAMIC_CAPTURE = "ENABLE_DYNAMIC_CAPTURE";
    public static final String SHOW_COUNT_DOWN = "SHOW_COUNT_DOWN";
    public static final String MOBIFLOW_ERROR_DETAILS = "MOBIFLOW_ERROR_DETAILS";
    public static final String SCAN_BARCODE_LOCATION = "SCAN_BARCODE_LOCATION";
    public static final String BARCODE_TYPES = "BARCODE_TYPES";
    public static final String IS_BINARIZE_BACK_SAME_AS_FRONT = "IS_BINARIZE_BACK_SAME_AS_FRONT";
    public static final String BINARIZATION_TYPE = "BINARIZATION_TYPE";
    public static final String ENABLE_SOFT_CAPTURE = "ENABLE_SOFT_CAPTURE";
    public static final String BINARIZATION_TRASHOLD = "BINARIZATION_TRASHOLD";
    public static final String COLOR_IMAGE_COMPRESSION = "COLOR_IMAGE_COMPRESSION";
    public static final String GRAY_SCALE_IMAGE_COMPRESSION = "GRAY_SCALE_IMAGE_COMPRESSION";
    public static final String USE_MAX_RESOLUTION_STILLS = "USE_MAX_RESOLUTION_STILLS";
    public static final String USE_CAMERA_API2 = "USE_CAMERA_API2";
    public static final String TAP_TO_FOCUS = "TAP_TO_FOCUS";
    public static final String TIS_LICENSE_CLASS = "TIS_LICENSE_CLASS";
    public static final String INVALID_LISENSE_KEY = "Invalid License Key";
    public static final String VALID_LISENSE_KEY = "Valid License Key";
    public static final String INVALID_LISENSE = "Invalid license";
    public static final String INVALID_SDK_VERSION = "Invalid sdk version";
    public static final String INVALID_EXPERATION_DATE = "License has expired";
    public static final String TIS_SOFT_CAPTURE_THRESHOLD = "TIS_SOFT_CAPTURE_THRESHOLD";
    public static final String ENABLE_TRANSIATION_BETWEEN_ANIMATION = "ENABLE_TRANSIATION_BETWEEN_ANIMATION";
    public static TISDocumentType currentImageType;
    public static String INTENT_OCR_DIGITAL_ROW_LENGTH;
    public static String INTENT_OCR_RESULT;
    public static String INTENT_OCR_RAW_RESULT;
    public static String INTENT_OCR_SCORE_RESULT;
    public static String INTENT_OCR_FRONT_IMAGE_TIFF_PATH;
    public static String INTENT_OCR_BACK_IMAGE_TIFF_PATH;
    public static String INTENT_OCR_FRONT_IMAGE_PATH;
    public static String INTENT_OCR_BACK_IMAGE_PATH;
    private final Activity activity;
    private final Object fragment;

    private boolean isUsingFragment() {
        return this.fragment != null;
    }

    public CaptureIntent(Activity activity) {
        this.activity = activity;
        this.fragment = null;
    }

    public CaptureIntent(Object fragment) throws MobiFlowException {
        if (fragment instanceof Activity) {
            this.activity = (Activity)fragment;
            this.fragment = null;
            return;
        }
        Activity _activity = null;
        try {
            Class<?> clz = fragment.getClass();
            Method _getActivity_Method = clz.getMethod("getActivity", null);
            Class[] cArg = new Class[]{Intent.class, Integer.TYPE};
            Method _startActivity_Method = clz.getMethod("startActivityForResult", cArg);
            _activity = (Activity)_getActivity_Method.invoke(fragment, new Object[0]);
        }
        catch (Exception roe) {
            throw new MobiFlowException("Not a valid fragment");
        }
        this.fragment = fragment;
        this.activity = _activity;
    }

    @TargetApi(value=11)
    public boolean captureDocument(baseCaptureParams input) {
        Intent intentCapture = new Intent((Context)this.activity, CameraManagerController.class);
        intentCapture.setAction(ACTION_CAPTURE);
        intentCapture.addFlags(0x4000000);
        intentCapture.addFlags(524288);
        intentCapture.putExtra(INTENT_MAX_NUMBER_OF_RETRIES, 1000);
        intentCapture.putExtra(INTENT_MIN_RATIO_HEIGHT_WIDTH, input.minHeightWidthAspectRatio);
        intentCapture.putExtra(INTENT_MAX_RATIO_HEIGHT_WIDTH, input.maxHeightWidthAspectRatio);
        intentCapture.putExtra(INTENT_IS_MANUAL_CAPTURE, false);
        intentCapture.putExtra(INTENT_IS_DEBUG, input.debugMode);
        intentCapture.putExtra(INFO_SCREEN_ENABLED, input.showInfoScreen);
        intentCapture.putExtra(SCAN_FRONT_ONLY, input.scanFrontOnly);
        intentCapture.putExtra(SCAN_BACK_ONLY, input.scanBackOnly);
        intentCapture.putExtra(SHOW_COUNT_DOWN, input.showCountDown);
        if (input.license == null) {
            Toast.makeText((Context)this.activity, (CharSequence)"Please init TISLicenseParameters Class", (int)0).show();
            return false;
        }
        intentCapture.putExtra(TIS_LICENSE_CLASS, (Parcelable)input.license);
        if (input.softCaptureThreshold > 1.0f) {
            input.softCaptureThreshold = 1.0f;
        }
        intentCapture.putExtra(TIS_SOFT_CAPTURE_THRESHOLD, input.softCaptureThreshold);
        intentCapture.putExtra(IS_BLUR_ENABLED, input.enableBlurDetection);
        intentCapture.putExtra(IS_BLUR_ENABLED_ON_BACK_SIDE, input.enableBlurDetectionOnBackSide);
        intentCapture.putExtra(MAX_VIDEO_FRAMES_TO_CAPTURE, input.maxVideoFramesToCapture);
        intentCapture.putExtra(GUIDLINES_INDICATOR, input.showGuidelinesIndicators);
        intentCapture.putExtra(ENABLE_COUNTDOWN_SOUND, input.enableCountdownSound);
        intentCapture.putExtra(ENABLE_VIDEO_MODE, input.videoFeedProcessing);
        intentCapture.putExtra(INTENT_IQA_ENABLED, input.enableIQA);
        intentCapture.putExtra(GRAY_SCALE, input.outputGrayscaleImage);
        intentCapture.putExtra(OUTPUT_ORIGINAL_IMAGE, input.outputOriginalImage);
        intentCapture.putExtra(OUTPUT_COLORED_IMAGE, input.outputColorImage);
        intentCapture.putExtra(OUTPUT_BW_IMAGE, input.outputBinarizedImage);
        intentCapture.putExtra(IS_CUSTOM_VIEW, input.customView);
        intentCapture.putExtra(ENABLE_PROCESSING_VIEW, input.showDefaultProcessingView);
        intentCapture.putExtra(ENABLE_MULTI_CAPTURE, input.multiPageCapture);
        intentCapture.putExtra(SCAN_BARCODE_LOCATION, input.scanBarcodeLocation.getValue());
        intentCapture.putExtra(BARCODE_TYPES, CameraTypes.TISBarcodeType.getIntegerArrayListFromEnumList(input.barcodeTypes));
        intentCapture.putExtra(INTENT_IQA_SETTINGS, input.IQASettings.toBundle());
        intentCapture.putExtra(FRONT_IMAGE_RECT, input.frontImageSize);
        intentCapture.putExtra(SHOW_COUNT_DOWN, input.showCountDown);
        intentCapture.putExtra(ENABLE_SOFT_CAPTURE, input.enableSoftCapture);
        intentCapture.putExtra(INFO_SCREEN_INTERVAL, input.infoScreenInterval);
        intentCapture.putExtra(COLOR_IMAGE_COMPRESSION, input.colorImageCompression);
        intentCapture.putExtra(GRAY_SCALE_IMAGE_COMPRESSION, input.grayscaleImageCompression);
        intentCapture.putExtra(USE_MAX_RESOLUTION_STILLS, input.useMaxResolution);
        intentCapture.putExtra(USE_CAMERA_API2, input.useCameraAPI2);
        intentCapture.putExtra(TAP_TO_FOCUS, input.tapToFocus);
        intentCapture.putExtra(ENABLE_TRANSIATION_BETWEEN_ANIMATION, input.animateTransitionInLivePreview);
        if (input.uxType == TISFlowUXType.LIVE) {
            intentCapture.putExtra(ENABLE_DYNAMIC_CAPTURE, true);
        } else {
            intentCapture.putExtra(ENABLE_DYNAMIC_CAPTURE, false);
        }
        intentCapture.putExtra(FOLDER_LOCATION, FileUtils.getTestImagePath((Context)this.activity));
        CameraManagerController.imageType = currentImageType;
        CameraManagerController.dynamicStrings = null;
        if (input.dynamicStrings != null) {
            CameraManagerController.dynamicStrings = input.dynamicStrings;
        }
        switch (input.binarizationType) {
            case TIS_GENERAL_BINARIZATION: {
                intentCapture.putExtra(BINARIZATION_TYPE, 0);
                break;
            }
            case TIS_CHECK_BINARIZATION: {
                intentCapture.putExtra(BINARIZATION_TYPE, 1);
            }
        }
        intentCapture.putExtra(BINARIZATION_TRASHOLD, input.binarizationThreshold);
        intentCapture.putExtra(INTENT_OCR_TYPE, input.ocrType.name());
        switch (currentImageType) {
            case CHECK: {
                checkCaptureParams checkParams = (checkCaptureParams)input;
                intentCapture.putExtra(INTENT_TXT_VALID_FROM, checkParams.minMICRLength);
                intentCapture.putExtra(INTENT_TXT_VALID_TO, checkParams.maxMICRLength);
                break;
            }
            case CUSTOM: {
                customCaptureParams customParams = (customCaptureParams)input;
                intentCapture.putExtra(IS_PORTRIT_MODE, customParams.portraitCapture);
                if (!customParams.portraitCapture) break;
                CameraManagerController.sessionType = SessionType.PORTRAIT;
                break;
            }
        }
        if (this.isUsingFragment()) {
            try {
                this.tryReflectionStartActivity(intentCapture);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            this.activity.startActivityForResult(intentCapture, 1024);
        }
        return true;
    }

    private void tryReflectionStartActivity(Intent intentCapture) throws Exception {
        Class<?> clz = this.fragment.getClass();
        Method m2 = null;
        Class[] cArg = new Class[]{Intent.class, Integer.TYPE};
        m2 = clz.getMethod("startActivityForResult", cArg);
        m2.invoke(this.fragment, intentCapture, 1024);
    }

    public baseCaptureParams getCaptureParams(TISDocumentType imageType) {
        currentImageType = imageType == null ? TISDocumentType.PAYMENT : imageType;
        switch (currentImageType) {
            case CHECK: {
                return new checkCaptureParams();
            }
            case PAYMENT: {
                return new paymentCaptureParams();
            }
            case CUSTOM: {
                return new customCaptureParams();
            }
            case FULL_PAGE: {
                return new FullPageCaptureParams();
            }
            case PASSPORT: {
                return new passportParams();
            }
            case CARD: {
                return new CardParams();
            }
        }
        return new baseCaptureParams();
    }

    public static SessionResultParams parseActivityResult(int requestCode, int resultCode, Intent intent) {
        SessionResultParams currentSessionParams = (SessionResultParams)intent.getParcelableExtra(CURRENT_SESSION_PARAMS);
        return currentSessionParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    static {
        INTENT_OCR_DIGITAL_ROW_LENGTH = "OCR_DIGITAL_ROW_LENGTH";
        INTENT_OCR_RESULT = "OCR_RESULT";
        INTENT_OCR_RAW_RESULT = "OCR_RAW_RESULT";
        INTENT_OCR_SCORE_RESULT = "OCR_SCORE_RESULT";
        INTENT_OCR_FRONT_IMAGE_TIFF_PATH = "OCR_FRONT_IMAGE_TIFF_PATH";
        INTENT_OCR_BACK_IMAGE_TIFF_PATH = "OCR_BACK_IMAGE_TIFF_PATH";
        INTENT_OCR_FRONT_IMAGE_PATH = "OCR_FRONT_IMAGE_PATH";
        INTENT_OCR_BACK_IMAGE_PATH = "OCR_BACK_IMAGE_PATH";
    }

    public static interface callbackReturnMessage {
        public void onMessageReturn(CameraTypes.TISFlowInputMessages var1);

        public void onMessageReturnFailed();
    }

    public class customCaptureParams
    extends baseCaptureParams {
        public boolean portraitCapture;

        public customCaptureParams() {
            this.portraitCapture = false;
            this.enableBlurDetection = true;
        }
    }

    public class CardParams
    extends baseCaptureParams {
        public CardParams() {
            this.enableBlurDetection = false;
            this.maxHeightWidthAspectRatio = 0.7752f;
            this.minHeightWidthAspectRatio = 0.6342f;
            this.documnetType = TISDocumentType.CARD;
        }
    }

    public class passportParams
    extends baseCaptureParams {
        public passportParams() {
            this.enableBlurDetection = true;
            this.maxHeightWidthAspectRatio = 0.65f;
            this.minHeightWidthAspectRatio = 0.8f;
            this.documnetType = TISDocumentType.PASSPORT;
            this.ocrType = Common.OCRType.MRZ;
        }
    }

    public class paymentCaptureParams
    extends baseCaptureParams {
        public paymentCaptureParams() {
            this.enableBlurDetection = true;
            this.maxHeightWidthAspectRatio = 0.52f;
            this.minHeightWidthAspectRatio = 0.35f;
            this.documnetType = TISDocumentType.PAYMENT;
        }
    }

    public class FullPageCaptureParams
    extends baseCaptureParams {
        public FullPageCaptureParams() {
            this.enableBlurDetection = true;
            this.minHeightWidthAspectRatio = 1.35f;
            this.maxHeightWidthAspectRatio = 1.45f;
            this.enableIQA = false;
            this.documnetType = TISDocumentType.FULL_PAGE;
            CameraManagerController.sessionType = SessionType.PORTRAIT;
        }
    }

    public class checkCaptureParams
    extends baseCaptureParams {
        public int minMICRLength;
        public int maxMICRLength;

        public checkCaptureParams() {
            this.minMICRLength = 15;
            this.maxMICRLength = 50;
            this.ocrType = Common.OCRType.E_138B;
            this.enableBlurDetection = false;
            this.videoFeedProcessing = true;
            this.documnetType = TISDocumentType.CHECK;
            this.binarizationType = TISBinarizationType.TIS_CHECK_BINARIZATION;
        }
    }

    public class baseCaptureParams {
        public float maxHeightWidthAspectRatio = 0.52f;
        public float minHeightWidthAspectRatio = 0.35f;
        public TISDocumentType documnetType = TISDocumentType.PAYMENT;
        public boolean debugMode = false;
        public boolean scanFrontOnly = false;
        public boolean scanBackOnly = false;
        public boolean showInfoScreen = true;
        public long infoScreenInterval = 10000L;
        public IQASettingsIntent IQASettings = new IQASettingsIntent();
        public boolean enableIQA = false;
        public boolean showGuidelinesIndicators = true;
        public boolean enableBlurDetection = false;
        public boolean enableBlurDetectionOnBackSide = false;
        public boolean outputGrayscaleImage = true;
        public boolean outputOriginalImage = true;
        public boolean outputColorImage = true;
        public boolean outputBinarizedImage = true;
        public boolean enableCountdownSound = false;
        public boolean customView = false;
        public boolean showDefaultProcessingView = true;
        public boolean multiPageCapture = false;
        public TISScanBarcodeLocation scanBarcodeLocation = TISScanBarcodeLocation.BARCODE_NONE;
        public ArrayList<CameraTypes.TISBarcodeType> barcodeTypes = null;
        public HashMap<String, String> dynamicStrings = null;
        public int[] grayScaleSize = null;
        public Common.OCRType ocrType = Common.OCRType.OFF;
        public boolean videoFeedProcessing = false;
        public boolean showCountDown = false;
        public int[] frontImageSize = null;
        public int maxVideoFramesToCapture = 7;
        public boolean binarizeBackSameAsFront;
        public TISFlowUXType uxType = TISFlowUXType.LIVE;
        public TISBinarizationType binarizationType = TISBinarizationType.TIS_GENERAL_BINARIZATION;
        public float binarizationThreshold;
        public boolean enableSoftCapture;
        public float colorImageCompression = 1.0f;
        public float grayscaleImageCompression = 1.0f;
        public boolean useMaxResolution = false;
        public boolean useCameraAPI2 = false;
        public boolean tapToFocus = true;
        public TISLicenseParameters license;
        public float softCaptureThreshold;
        public boolean animateTransitionInLivePreview = true;
    }

    public static class IntentBoolFlags {
        public boolean isAutoCaptureFront;
        public boolean isAutoCaptureBack;
        public boolean isIQAPassedFront;
        public boolean isIQAPassedBack;

        IntentBoolFlags(Intent intent) {
            this.isAutoCaptureFront = intent.getBooleanExtra(CaptureIntent.INTENT_ISAUTO_FRONT, true);
            this.isAutoCaptureBack = intent.getBooleanExtra(CaptureIntent.INTENT_ISAUTO_BACK, true);
            this.isIQAPassedFront = intent.getBooleanExtra(CaptureIntent.INTENT_ISIQA_PASSED_FRONT, true);
            this.isIQAPassedBack = intent.getBooleanExtra("INTENT_ISIQA_PASSED_BACK", true);
        }
    }

    public static enum TISScanBarcodeLocation {
        BARCODE_FRONT(0),
        BARCODE_BACK(1),
        BARCODE_FRONT_AND_BACK(2),
        BARCODE_NONE(3);

        private int type;

        private TISScanBarcodeLocation(int i) {
            this.type = i;
        }

        public int getValue() {
            return this.type;
        }

        public static TISScanBarcodeLocation getEnum(int value) {
            switch (value) {
                case 0: {
                    return BARCODE_FRONT;
                }
                case 1: {
                    return BARCODE_BACK;
                }
                case 2: {
                    return BARCODE_FRONT_AND_BACK;
                }
                case 3: {
                    return BARCODE_NONE;
                }
            }
            return BARCODE_NONE;
        }
    }

    public static enum LevelerType {
        NONE(0),
        ONE_UNIT(1),
        TWO_UNITS(2),
        SCALE(3);

        private int type;

        private LevelerType(int i) {
            this.type = i;
        }

        public int getValue() {
            return this.type;
        }

        public static LevelerType getEnum(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 2: {
                    return TWO_UNITS;
                }
                case 3: {
                    return SCALE;
                }
            }
            return ONE_UNIT;
        }
    }

    public static enum TISBinarizationType {
        TIS_GENERAL_BINARIZATION(0),
        TIS_CHECK_BINARIZATION(1);

        private int id;

        private TISBinarizationType(int id2) {
            this.id = id2;
        }

        public int getId() {
            return this.id;
        }

        public static TISBinarizationType getEnum(int value) {
            switch (value) {
                case 0: {
                    return TIS_GENERAL_BINARIZATION;
                }
                case 1: {
                    return TIS_CHECK_BINARIZATION;
                }
            }
            return TIS_GENERAL_BINARIZATION;
        }
    }

    public static enum SessionType {
        NORMAL,
        TEST,
        PORTRAIT;

    }

    public static enum TISFlowUXType {
        STATIC(0),
        LIVE(1);

        private int id;

        private TISFlowUXType(int id2) {
            this.id = id2;
        }

        public int getId() {
            return this.id;
        }

        public static TISFlowUXType getEnum(int value) {
            switch (value) {
                case 0: {
                    return STATIC;
                }
                case 1: {
                    return LIVE;
                }
            }
            return STATIC;
        }
    }

    public static enum TISDocumentType {
        CHECK(0),
        PAYMENT(1),
        FULL_PAGE(2),
        PASSPORT(3),
        CARD(4),
        CUSTOM(5);

        private int id;

        private TISDocumentType(int id2) {
            this.id = id2;
        }

        public int getId() {
            return this.id;
        }

        public static TISDocumentType getEnum(int value) {
            switch (value) {
                case 0: {
                    return CHECK;
                }
                case 1: {
                    return PAYMENT;
                }
                case 2: {
                    return FULL_PAGE;
                }
                case 3: {
                    return PASSPORT;
                }
                case 4: {
                    return CARD;
                }
                case 5: {
                    return CUSTOM;
                }
            }
            return CUSTOM;
        }
    }

    public static class IQAIntentKeys {
        public static final String IS_IQA_MODE = "IS_IQA_MODE";
        public static final String CORNERDATA_FRONT_KEY = "CORNERDATA_FRONT_KEY";
        public static final String CORNERDATA_BACK_KEY = "CORNERDATA_BACK_KEY";
        public static final String EDGE_KEY = "EDGE_KEY";
        public static final String CORNERDATA_FRONT_TL_W_KEY = "CORNERDATA_FRONT_TL_W_KEY";
        public static final String CORNERDATA_FRONT_TL_H_KEY = "CORNERDATA_FRONT_TL_H_KEY";
        public static final String CORNERDATA_FRONT_TL_A_KEY = "CORNERDATA_FRONT_TL_A_KEY";
        public static final String CORNERDATA_FRONT_TR_W_KEY = "CORNERDATA_FRONT_TR_W_KEY";
        public static final String CORNERDATA_FRONT_TR_H_KEY = "CORNERDATA_FRONT_TR_H_KEY";
        public static final String CORNERDATA_FRONT_TR_A_KEY = "CORNERDATA_FRONT_TR_A_KEY";
        public static final String CORNERDATA_FRONT_BL_W_KEY = "CORNERDATA_FRONT_BL_W_KEY";
        public static final String CORNERDATA_FRONT_BL_H_KEY = "CORNERDATA_FRONT_BL_H_KEY";
        public static final String CORNERDATA_FRONT_BL_A_KEY = "CORNERDATA_FRONT_BL_A_KEY";
        public static final String CORNERDATA_FRONT_BR_W_KEY = "CORNERDATA_FRONT_BR_W_KEY";
        public static final String CORNERDATA_FRONT_BR_H_KEY = "CORNERDATA_FRONT_BR_H_KEY";
        public static final String CORNERDATA_FRONT_BR_A_KEY = "CORNERDATA_FRONT_BR_A_KEY";
        public static final String CORNERDATA_BACK_TL_W_KEY = "CORNERDATA_BACK_TL_W_KEY";
        public static final String CORNERDATA_BACK_TL_H_KEY = "CORNERDATA_BACK_TL_H_KEY";
        public static final String CORNERDATA_BACK_TL_A_KEY = "CORNERDATA_BACK_TL_A_KEY";
        public static final String CORNERDATA_BACK_TR_W_KEY = "CORNERDATA_BACK_TR_W_KEY";
        public static final String CORNERDATA_BACK_TR_H_KEY = "CORNERDATA_BACK_TR_H_KEY";
        public static final String CORNERDATA_BACK_TR_A_KEY = "CORNERDATA_BACK_TR_A_KEY";
        public static final String CORNERDATA_BACK_BL_W_KEY = "CORNERDATA_BACK_BL_W_KEY";
        public static final String CORNERDATA_BACK_BL_H_KEY = "CORNERDATA_BACK_BL_H_KEY";
        public static final String CORNERDATA_BACK_BL_A_KEY = "CORNERDATA_BACK_BL_A_KEY";
        public static final String CORNERDATA_BACK_BR_W_KEY = "CORNERDATA_BACK_BR_W_KEY";
        public static final String CORNERDATA_BACK_BR_H_KEY = "CORNERDATA_BACK_BR_H_KEY";
        public static final String CORNERDATA_BACK_BR_A_KEY = "CORNERDATA_BACK_BR_A_KEY";
        public static final String EDGE_DATA_T_W_KEY = "EDGE_DATA_T_W_KEY";
        public static final String EDGE_DATA_T_H_KEY = "EDGE_DATA_T_H_KEY";
        public static final String EDGE_DATA_T_A_KEY = "EDGE_DATA_T_A_KEY";
        public static final String EDGE_DATA_B_W_KEY = "EDGE_DATA_B_W_KEY";
        public static final String EDGE_DATA_B_H_KEY = "EDGE_DATA_B_H_KEY";
        public static final String EDGE_DATA_B_A_KEY = "EDGE_DATA_B_A_KEY";
        public static final String EDGE_DATA_L_W_KEY = "EDGE_DATA_L_W_KEY";
        public static final String EDGE_DATA_L_H_KEY = "EDGE_DATA_L_H_KEY";
        public static final String EDGE_DATA_L_A_KEY = "EDGE_DATA_L_A_KEY";
        public static final String EDGE_DATA_R_W_KEY = "EDGE_DATA_R_W_KEY";
        public static final String EDGE_DATA_R_H_KEY = "EDGE_DATA_R_H_KEY";
        public static final String EDGE_DATA_R_A_KEY = "EDGE_DATA_R_A_KEY";
        public static final String MAX_SKEW_KEY = "MAX_SKEW_KEY";
        public static final String MAX_DARNESS_FRONT_KEY = "MAX_DARNESS_FRONT_KEY";
        public static final String MIN_DARNESS_FRONT_KEY = "MIN_DARNESS_FRONT_KEY";
        public static final String MAX_DARNESS_BACK_KEY = "MAX_DARNESS_BACK_KEY";
        public static final String MIN_DARNESS_BACK_KEY = "MIN_DARNESS_BACK_KEY";
        public static final String MAX_SPOTS_FRONT_KEY = "MAX_SPOTS_FRONT_KEY";
        public static final String MAX_SPOTS_BACK_KEY = "MAX_SPOTS_BACK_KEY";
        public static final String MIN_IMAGE_SIZE_FRONT_KEY = "MIN_IMAGE_SIZE_FRONT";
        public static final String MAX_IMAGE_SIZE_FRONT_KEY = "MAX_IMAGE_SIZE_FRONT";
        public static final String MIN_IMAGE_SIZE_BACK_KEY = "MIN_IMAGE_SIZE_BACK";
        public static final String MAX_IMAGE_SIZE_BACK_KEY = "MAX_IMAGE_SIZE_BACK";
        public static final String HORIZONTAL_STREAK_SUM_BLACK_PIXELS = "HORIZONTAL_STREAK_SUM_BLACK_PIXELS";
        public static final String HORIZONTAL_STREAK_LINE_WIDTH = "HORIZONTAL_STREAK_LINE_WIDTH";
        public static final String HORIZONTAL_STREAK_NUM_LINES = "HORIZONTAL_STREAK_NUM_LINES";
        public static final String CARBON_STRIP_SUM_BLACK_PIXELS = "CARBON_STRIP_SUM_BLACK_PIXELS";
        public static final String CARBON_STRIP_LINE_WIDTH = "CARBON_STRIP_LINE_WIDTH";
        public static final String CARBON_STRIP_NUM_LINES = "CARBON_STRIP_NUM_LINES";
        public static final String PIGGY_BACK_WIDTH_THRESHOLD = "PIGGY_BACK_WIDTH_THRESHOLD";
        public static final String PIGGY_BACK_LOCATION_THRESHOLD = "PIGGY_BACK_LOCATION_THRESHOLD";
    }
}

