/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader;

public class SessionResultParams
implements Parcelable {
    private String[] ocrParams;
    private String[] barcodeParams;
    private int[] frontImageRect;
    public static int DIGITAL_ROW_LENGTH = 0;
    public static int OCR_RESULT_WITH_DELIMETER = 1;
    public static int OCR_RAW_RESULT = 2;
    public static int SCORE_RESULT = 3;
    public static byte[] tiffFront;
    public static byte[] jpegBWFront;
    public static byte[] grayscaleFront;
    public static byte[] colorFront;
    public static byte[] originalFront;
    public static byte[] tiffBack;
    public static byte[] jpegBWBack;
    public static byte[] grayscaleBack;
    public static byte[] colorBack;
    public static byte[] originalBack;
    public static final Parcelable.Creator<SessionResultParams> CREATOR;

    public SessionResultParams() {
    }

    public String[] getOcrParams() {
        return this.ocrParams;
    }

    public void setOcrParams(String[] ocrParams) {
        this.ocrParams = ocrParams;
    }

    public BarcodeReader.BarcodeResult getBarcodeResult() {
        BarcodeReader.BarcodeResult barcodeResult = new BarcodeReader.BarcodeResult(this.barcodeParams);
        barcodeResult.parse();
        return barcodeResult;
    }

    public String[] getBarcodeParams() {
        return this.barcodeParams;
    }

    public void setBarcodeParams(String[] barcodeParams) {
        this.barcodeParams = barcodeParams;
    }

    public int[] getFrontImageRectArray() {
        return this.frontImageRect;
    }

    public SessionResultParams(String[] _ocrParams, int[] frontRect, int retriesNumberFront, int retriesNumberBack, String[] _barcodeParams) {
        if (_ocrParams != null) {
            this.ocrParams = _ocrParams;
        }
        if (_barcodeParams != null) {
            this.barcodeParams = _barcodeParams;
        }
        if (frontRect != null) {
            this.frontImageRect = frontRect;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(this.ocrParams);
        dest.writeIntArray(this.frontImageRect);
        dest.writeStringArray(this.barcodeParams);
    }

    public static Parcelable.Creator<SessionResultParams> getCreator() {
        return CREATOR;
    }

    public SessionResultParams(Parcel in) {
        this.readFromParcel(in);
    }

    private void readFromParcel(Parcel in) {
        this.ocrParams = in.createStringArray();
        this.frontImageRect = in.createIntArray();
        this.barcodeParams = in.createStringArray();
    }

    public int describeContents() {
        return 0;
    }

    static {
        CREATOR = new Parcelable.Creator<SessionResultParams>(){

            public SessionResultParams createFromParcel(Parcel in) {
                return new SessionResultParams(in);
            }

            public SessionResultParams[] newArray(int size) {
                return new SessionResultParams[size];
            }
        };
    }
}

