/*
 * 
 */
package com.topimagesystems.util;

import android.content.Context;

import com.topimagesystems.controllers.imageanalyze.CameraManagerController;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Formatter;
import java.util.regex.Pattern;

// TODO: Auto-generated Javadoc
/**
 * The Class StringUtils.
 */
public class StringUtils {
    
    /**
     * Minutes to hours.
     *
     * @param minutes the minutes
     * @return the string
     */
    public static String minutesToHours(int minutes) {
	String result = String.valueOf(minutes);
	Formatter formatter = null;
	try {
	    formatter = new Formatter();
	    Formatter format = formatter.format("%.1f", minutes / 60.0f);
	    result = format.toString();
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    if (formatter != null) {
		formatter.close();
		formatter = null;
	    }
	}
	return result;
    }
    
    /**
     * Checks if is empty or null.
     *
     * @param value the value
     * @return true, if is empty or null
     */
    public static boolean isEmptyOrNull(String value) {
	return (value == null || "".equals(value));
    }

    /**
     * Removes the astrix.
     *
     * @param text the text
     * @return the string
     */
    public static String removeAstrix(String text) {
	if (text == null) {
	    return "";
	}
	String res = text;
	if (text.contains("*")) {
	    res = text.toString().replace("*", "");
	}
	return res;

    }

    /**
     * Check empty or null string.
     *
     * @param txt the txt
     * @return the string
     */
    public static String checkEmptyOrNullString(String txt) {
	if (txt == null) {
	    return "";
	}
	return txt;

    }

    /**
     * Gets the usa date format.
     *
     * @param date the date
     * @return the usa date format
     */
    public static String getUsaDateFormat(String date) {
	String res;
	String[] splitDate = date.split("/");
	res = splitDate[1] + "/" + splitDate[0] + "/" + splitDate[2];
	return res;
    }

    /**
     * Check date format.
     *
     * @param date the date
     * @return the string
     */
    public static String checkDateFormat(String date) {
	if (date == null) {
	    return date;
	}
	if (date.length() == 1) {
	    date = "0" + date;
	}
	return date;
    }

    /**
     * Checks if is json field empty or null.
     *
     * @param item the item
     * @param fieldToSearch the field to search
     * @return the string
     */
    public static String isJsonFieldEmptyOrNull(final JSONObject item, String fieldToSearch) {
	String jsonResult = null;
	try {
	    if (item.getString(fieldToSearch) != null) {
		jsonResult = item.getString(fieldToSearch);
	    }
	} catch (JSONException e) {
	    return null;
	}
	return jsonResult;
    }
    
    /**
     * Dynamic string.
     *
     * @param context the context
     * @param key the key
     * @return the string
     */
    public static String dynamicString(Context context, String key) {
		try{
		if (CameraManagerController.dynamicStrings == null) {
			return getStringResourceByName(context, key);
		}
		if (CameraManagerController.dynamicStrings.get(key) != null) {
			return CameraManagerController.dynamicStrings.get(key); // get dynamic String
		}
		return getStringResourceByName(context, key);
	}catch(Exception e){
		return "";
	}
    }
    

    /**
     * Gets the string resource by name.
     *
     * @param context the context
     * @param aString the a string
     * @return the string resource by name
     */
    public static String getStringResourceByName(Context context,String aString) {	
	    String packageName = context.getPackageName();
	    int resId = context.getResources()
	            .getIdentifier(aString, "string", packageName);
	    if (resId == 0) {
	        return aString;
	    } else {
	        return context.getResources().getString(resId);
	    }
	}


	public static String trimStringByChar(String text, char trimBy) {
		int start = 0;
		int end = text.length();

		while (start < end && text.charAt(start) == trimBy)
			start++;

		while (start < end && text.charAt(end - 1) == trimBy)
			end--;

		return text.substring(start, end);
	}

	private static Pattern whiteSpaceTrim = Pattern.compile("^[\\s]+|[\\s]+$");
	public static String trimAllWhiteSpace(String text) {
		return whiteSpaceTrim.matcher(text).replaceAll("");
	}



}