/*
 * 
 */
package com.topimagesystems.util;

import android.util.Log;

// TODO: Auto-generated Javadoc
/**
 * Helper methods that make logging more consistent throughout the application.
 */
public class Logger {

	/** The Constant NO_LOG. */
	public static final int NO_LOG = 1;

	/** The Constant VERBOSE. */
	public static final int VERBOSE = 2;

	/** Priority constant for the println method; use Log.d. */
	public static final int DEBUG = 3;

	/** Priority constant for the println method; use Log.i. */
	public static final int INFO = 4;

	/** Priority constant for the println method; use Log.w. */
	public static final int WARN = 5;

	/** Priority constant for the println method; use Log.e. */
	public static final int ERROR = 6;

	/** Priority constant for the println method. */
	public static final int ASSERT = 7;

	/** Don't print any log. */

	private static final String LOG_PREFIX = "mobicheck.";

	/** The Constant LOG_PREFIX_LENGTH. */
	private static final int LOG_PREFIX_LENGTH = LOG_PREFIX.length();

	/** The Constant MAX_LOG_TAG_LENGTH. */
	private static final int MAX_LOG_TAG_LENGTH = 23;

	/** The debug level. */
	private static int debugLevel = VERBOSE;

	/** The is debug mode. */
	private static boolean isDebugMode = true;

	// private static org.slf4j.Logger logger;

	/**
	 * Make log tag.
	 *
	 * @param str
	 *            the str
	 * @return the string
	 */
	public static String makeLogTag(String str) {
		return str;
	}

	/**
	 * Sets the min log level.
	 *
	 * @param _debugLevel
	 *            the new min log level
	 */
	public static void setMinLogLevel(int _debugLevel) {
		if (isDebugMode) {
			_debugLevel = VERBOSE;
		} else {
			debugLevel = _debugLevel;
		}
	}

	/**
	 * Sets the checks if is debug mode.
	 *
	 * @param _debugMode
	 *            the new checks if is debug mode
	 */
	public static void setIsDebugMode(boolean _debugMode) {
		isDebugMode = _debugMode;
	}

	/**
	 * Checks if is debug mode.
	 *
	 * @return true, if is debug mode
	 */
	private static boolean isDebugMode() {
		return isDebugMode;
	}

	/**
	 * D.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 */
	public static void d(final String tag, String message) {
		if (isDebugMode() && debugLevel >= DEBUG) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.d(tag, clean);
		}
	}

	/**
	 * D.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public static void d(final String tag, String message, Throwable cause) {
		if (isDebugMode() && debugLevel >= DEBUG) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.d(tag, clean, cause);
		}
	}

	/**
	 * V.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 */
	public static void v(final String tag, String message) {
		if (isDebugMode() && debugLevel >= VERBOSE) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.d(tag, clean);
		}
	}

	/**
	 * V.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public static void v(final String tag, String message, Throwable cause) {
		if (isDebugMode() && debugLevel >= VERBOSE) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.d(tag, clean, cause);
		}
	}

	/**
	 * I.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 */
	public static void i(final String tag, String message) {
		if (debugLevel <= INFO) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.i(tag, clean);

		}
	}

	/**
	 * I.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public static void i(final String tag, String message, Throwable cause) {
		if (isDebugMode() && debugLevel >= INFO) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.i(tag, clean, cause);
		}
	}

	/**
	 * W.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 */
	public static void w(final String tag, String message) {
		if (isDebugMode() && debugLevel >= WARN) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.w(tag, clean);
		}
	}

	/**
	 * W.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public static void w(final String tag, String message, Throwable cause) {
		if (isDebugMode() && debugLevel >= WARN) {
			String clean = message.replace('\n', '_').replace('\r', '_');
			Log.w(tag, clean, cause);
		}
	}

	/**
	 * E.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 */
	public static void e(final String tag, String message) {
		String clean = message.replace('\n', '_').replace('\r', '_');
		Log.e(tag, clean);
	}

	/**
	 * E.
	 *
	 * @param tag
	 *            the tag
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public static void e(final String tag, String message, Throwable cause) {
		String clean = message.replace('\n', '_').replace('\r', '_');
		Log.e(tag, clean, cause);
	}

	/**
	 * Instantiates a new logger.
	 */
	private Logger() {
	}
}