/*
 * 
 */
package com.topimagesystems.util;

import java.io.ByteArrayInputStream;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.util.Base64;

// TODO: Auto-generated Javadoc
/**
 * The Class ImageUtils.
 */
public class ImageUtils {

    /** The Constant tag. */
    private static final String tag = Logger.makeLogTag("ImageUtils");

    /**
     * Convert image to64 string.
     *
     * @param imagePath the image path
     * @return the string
     */
    public static String convertImageTo64String(String imagePath) {
	String encodedImage = "";
	if (!StringUtils.isEmptyOrNull(imagePath)) {
	    final byte[] data = FileUtils.getByteArray(imagePath);
	    encodedImage = Base64.encodeToString(data, Base64.DEFAULT);
	}
	return encodedImage;
    }

    /**
     * Convert64 string to image.
     *
     * @param context the context
     * @param content the content
     * @param requiredWidth the required width
     * @param requiredHeight the required height
     * @param isDataEncrypted the is data encrypted
     * @return the bitmap
     */
    public static Bitmap convert64StringToImage(Context context, String content, int requiredWidth, int requiredHeight,boolean isDataEncrypted) {
	Bitmap result = null;
	if (!StringUtils.isEmptyOrNull(content)) {
		
	    byte[] data = Base64.decode(content, Base64.DEFAULT);
	    if (isDataEncrypted){
	    	

	    }
	    result = decodeScaledByteArray(data, requiredWidth, requiredHeight);
	}
	return result;
    }

    /**
     * Decode byte array.
     *
     * @param data the data
     * @return the bitmap
     */
    public static Bitmap decodeByteArray(byte[] data) {
	Bitmap image = null;
	try {
	    image = BitmapFactory.decodeByteArray(data, 0, data.length);
	} catch (Exception e) {
	    Logger.e(tag, e.getMessage());
	}
	return image;
    }

    /**
     * Gets the scalled image from file.
     *
     * @param context the context
     * @param imagePath the image path
     * @param requiredWidth the required width
     * @param requiredHeight the required height
     * @return the scalled image from file
     */
    public static Bitmap getScalledImageFromFile(Context context, String imagePath, int requiredWidth, int requiredHeight) {
	final byte[] data = FileUtils.getByteArray(imagePath);
	if (data == null) {
	    return null;
	}
	Bitmap bitmap = ImageUtils.decodeScaledByteArray(data, requiredWidth, requiredHeight);
	return bitmap;
    }

    /**
     * Decode scaled byte array.
     *
     * @param data the data
     * @param requiredWidth the required width
     * @param requiredHeight the required height
     * @return the bitmap
     */
    public static Bitmap decodeScaledByteArray(byte[] data, int requiredWidth, int requiredHeight) {
	// Decode image size
	BitmapFactory.Options o = new BitmapFactory.Options();
	o.inJustDecodeBounds = true;
	BitmapFactory.decodeStream(new ByteArrayInputStream(data), null, o);

	// Find the correct scale value. It should be the power of 2.
	int scale = 1;
	while (o.outWidth / scale / 2 >= requiredWidth && o.outHeight / scale / 2 >= requiredHeight)
	    scale *= 2;

	// Decode with inSampleSize
	BitmapFactory.Options o2 = new BitmapFactory.Options();
	o2.inPreferredConfig = Config.RGB_565;
	o2.inSampleSize = scale;
	return BitmapFactory.decodeStream(new ByteArrayInputStream(data), null, o2);
    }

}