package com.topimagesystems.ui;


import com.topimagesystems.R;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

public class ScaleLeveler extends View {
	private final float MIN_SCALE_UNIT_GAP = 20.0f;
	private final float MAX_SCALE_UNIT_GAP = 400.0f;
	
    /** The is valid orintation. */
    private boolean isValidOrintation = false;
    
    /** The stroke width container. */
    private int strokeWidthContainer = 5;
    
    /** The stroke width inner. */
    private int strokeWidthInner = 5;
    
    /** The circle paint. */
    private Paint arrowPaint;
    
    /** The rectangle paint container. */
    private Paint rectanglePaintContainer;
    
    /** The leveler trashold. */
    private float levelerTrashold = 0.0470f;
    
    /** The leveler trashold side. */
    private float levelerTrasholdSide = 0.036f;
    
    /** The leveler trashold side portrait. */
    private float levelerTrasholdSidePortrait = 0.02f;
    
    /** The convert pixels to accelerometer upper. */
    private float convertPixelsToAccelerometerUpper;
    
    /** The convert pixels to accelerometer side. */
    private float convertPixelsToAccelerometerSide;
    
    /** The valid orientation x. */
    private boolean validOrientationX;
    
    /** The valid orientation y. */
    private boolean validOrientationY;
    
    /** The main rectangle upper. */
    private RectF mainRectangleUpper;
    
    /** The validation rectangle upper. */
    private RectF validationRectangleUpper;
    
    /** The main rectangle side. */
    private RectF mainRectangleSide;
    
    /** The validation rectangle side. */
    private RectF validationRectangleSide;
    
    /** The leveler width. */
    private float levelerWidth = 100f; // width of the main rect.
    
    /** The is horizontal level. */
    private boolean isHorizontalLevel;
    
    /** The color orientation pass container. */
    private int colorOrientationPassContainer;
    
    /** The color orientation fail container. */
    private int colorOrientationFailContainer;

    /** The color orientation pass arrow. */
    private int colorOrientationPassArrow;
    
    /** The color orientation fail arrow. */
    private int colorOrientationFailArrow;
    
    /** The default padding left and right. */
    private float defaultPaddingLeftAndRight; // default main rect padding for left and right
    
    /** The default padding top and bottom. */
    private float defaultPaddingTopAndBottom;
    
    /** The location. */
    private int location;
    
    /** The is fade animation enable. */
    private boolean isFadeAnimationEnable;
    
    /** The is dragging enable. */
    private boolean isDraggingEnable;
    
    /** The context. */
    private Context context;
    
    /** The x value. */
    private float xValue = 0;
    
    /** The y value. */
    private float yValue = 0;
    
    /** The is landscape mode. */
    private boolean isLandscapeMode = true;
    
    /** The validation rect top bottom trash hold. */
    private  float validationRectTopBottomTrashHold = 0.6f; // validation rects ratio.
    
    /** The validation rect left right trash hold. */
    private  float validationRectLeftRightTrashHold = 0.3f;
    
    /** The frame. */
    private org.opencv.core.Rect frame;
    
    /** The gap between the scale units. */
    private float scaleUnitGap;

    /** Is the scale units with color range */
    private boolean isWithColoreRange;

    /** The color range of the scale units */
    private int scaleUnitsColorArray[];

    /**
     * The Enum Location.
     */
    private enum Location {
	
	/** The top. */
	TOP, 
 /** The bottom. */
 BOTTOM, 
 /** The left. */
 LEFT, 
 /** The right. */
 RIGHT
    };

    /** The leveler location. */
    private Location levelerLocation;

    /**
     * Instantiates a new two units leveler.
     *
     * @param context the context
     * @param attrs the attrs
     */
    @SuppressLint("Recycle")
    public ScaleLeveler(Context context, AttributeSet attrs) {
	super(context, attrs);
	this.context = context;
	TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
	TypedArray twoLevelerData = context.obtainStyledAttributes(attrs, R.styleable.TwoUnitsLeveler);
	TypedArray scaleLevelerData = context.obtainStyledAttributes(attrs, R.styleable.ScaleLeveler);
	int defaultVal = isHorizontalLevel ? 0 : 2; // default value for horizontal leveler is top for vertical is left
	//LevelerLocation = twoLevelerData.getInteger(R.styleable.OneUnitsLeveler_padding, defaultVal);	

	colorOrientationPassContainer = 0x33000000;
	colorOrientationFailContainer = 0x33000000;
	colorOrientationPassArrow = Color.WHITE;
	colorOrientationFailArrow = Color.RED;
	
	defaultPaddingLeftAndRight = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingLeftAndRight, 0);
	defaultPaddingTopAndBottom = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingTopAndBottom, 0);
	
	location = twoLevelerData.getInteger(R.styleable.TwoUnitsLeveler_levelerLocation, 0);
	setDefaultValues(defaultPaddingLeftAndRight, defaultPaddingTopAndBottom);

	isHorizontalLevel = false;
	if (levelerLocation == Location.TOP || levelerLocation == Location.BOTTOM) {
	    isHorizontalLevel = true;
	}

	isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
	isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);	

	isHorizontalLevel = false;
	if (location == 0 || location == 1) {
	    isHorizontalLevel = true;
	}
	if (!isHorizontalLevel && defaultPaddingTopAndBottom > 140.0) {

	    validationRectLeftRightTrashHold = 0.15f;
	}
	else if(isHorizontalLevel && defaultPaddingTopAndBottom > 250.0){
	    validationRectTopBottomTrashHold = 0.3f;
	}
	
	scaleUnitGap = scaleLevelerData.getDimension(R.styleable.ScaleLeveler_scaleUnitGap, 200f);
	scaleUnitGap = Math.min(scaleUnitGap, MAX_SCALE_UNIT_GAP);
	scaleUnitGap = Math.max(scaleUnitGap, MIN_SCALE_UNIT_GAP);
	
	isWithColoreRange = scaleLevelerData.getBoolean(R.styleable.ScaleLeveler_userColorsInScale, false);
			
	int redColor = 0xFFF02D48;
	int orangeColor = 0xFFF7941E;
	int greenColor = 0xFF8DC73F;
	
	if (isWithColoreRange)
		scaleUnitsColorArray = new int[] {redColor, orangeColor, greenColor,  orangeColor, redColor};
    else
    	scaleUnitsColorArray = new int[] {Color.WHITE};
	
	oneLevelerData.recycle();
	twoLevelerData.recycle();
	scaleLevelerData.recycle();
	init();
    }

    /**
     * Checks if is dragging enable.
     *
     * @return true, if is dragging enable
     */
    public boolean isDraggingEnable() {
	return isDraggingEnable;
    }

    /**
     * Checks if is fade animation enable.
     *
     * @return true, if is fade animation enable
     */
    public boolean isFadeAnimationEnable() {
	return isFadeAnimationEnable;
    }

    /**
     * Instantiates a new two units leveler.
     *
     * @param context the context
     * @param attrs the attrs
     * @param defStyle the def style
     */
    public ScaleLeveler(Context context, AttributeSet attrs, int defStyle) {
	super(context, attrs, defStyle);
	this.context = context;

	init();
    }

    /**
     * Sets the frame.
     *
     * @param ValidationRect the new frame
     */
    public void setFrame(org.opencv.core.Rect ValidationRect) {
	frame = ValidationRect;

    }

    /**
     * Inits the.
     */
    private void init() {
	if (isInEditMode()) {
	    return;
	}

	arrowPaint = new Paint();
	arrowPaint.setStyle(Paint.Style.FILL_AND_STROKE);
	arrowPaint.setAntiAlias(true);
	arrowPaint.setColor(context.getResources().getColor(R.color.counter_background));

	rectanglePaintContainer = new Paint();
	rectanglePaintContainer.setColor(colorOrientationFailContainer);
	rectanglePaintContainer.setStyle(Paint.Style.FILL_AND_STROKE);
	rectanglePaintContainer.setStrokeWidth(strokeWidthContainer);
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
			this.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
		}

    }

    /**
     * Gets the upper main rect size.
     *
     * @return the upper main rect size
     */
    public float[] getUpperMainRectSize() {
	float[] res = { mainRectangleUpper.width(), mainRectangleUpper.height() };
	return res;

    }

    /**
     * Gets the left right rect size.
     *
     * @return the left right rect size
     */
    public float[] getLeftRightRectSize() {

	float[] res = { mainRectangleSide.width(), mainRectangleSide.height() };
	return res;
    }

    /**
     * Show leveler.
     */
    public void showLeveler() {
	setVisibility(View.VISIBLE);
	invalidate();
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {

	if (isHorizontalLevel) {
	    drawHorizontalLeveler(canvas);
	} else {
	    drawVerticalLeveler(canvas);
	}

    }

    /**
     *  set default location values for each possible location.
     *
     * @param left the left
     * @param top the top
     */
    private void setDefaultValues(float left, float top) {
	switch (location) {
	case 0:
	    levelerLocation = Location.TOP;
	    defaultPaddingLeftAndRight = (left == 0) ? 45 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 18 : top;
	    break;
	case 1:
	    levelerLocation = Location.BOTTOM;
	    defaultPaddingLeftAndRight = (left == 0) ? 30 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 45 : top;
	    break;
	case 2:
	    levelerLocation = Location.LEFT;
	    defaultPaddingLeftAndRight = (left == 0) ? 18 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 25 : top;
	    break;
	case 3:
	    levelerLocation = Location.RIGHT;
	    defaultPaddingLeftAndRight = (left == 0) ? 45 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 15 : top;
	    break;
	}

    }

    /**
     * Draw horizontal leveler.
     *
     * @param canvas the canvas
     */
    private void drawHorizontalLeveler(Canvas canvas) {
	if (mainRectangleUpper == null) {
	    drawRectInLocation();
	    canvas.drawRoundRect(mainRectangleUpper, 15f, 15f, rectanglePaintContainer);
		int numberOfHorizontalScaleUnits = (int) Math.floor(mainRectangleUpper.width()/scaleUnitGap);
	    if (numberOfHorizontalScaleUnits%2 == 0) {
	        numberOfHorizontalScaleUnits++;
	    }
	    float originHorizontalGap = (mainRectangleUpper.width() - ((numberOfHorizontalScaleUnits - 1) * scaleUnitGap))/2.0f;
	    for (int i = 0; i < numberOfHorizontalScaleUnits; i++) {
	        drawScaleUnit(mainRectangleUpper.left + originHorizontalGap + (scaleUnitGap*i) , canvas ,true);
	    }
	}
	boolean validOrintation = isLandscapeMode ? validOrientationX : validOrientationY;

	if (validOrintation) {
	    rectanglePaintContainer.setColor(colorOrientationPassContainer);
	    arrowPaint.setColor(colorOrientationPassArrow);
	} else {
	    rectanglePaintContainer.setColor(colorOrientationFailContainer);
	    arrowPaint.setColor(colorOrientationFailArrow);
	}
	
	convertPixelsToAccelerometerUpper = levelerTrashold * validationRectangleUpper.width() * (frame.width / 974); // 974 is the base line rectangle for calculation.
	
	float arrowWidth = (mainRectangleUpper.bottom - mainRectangleUpper.top) * 0.5f;
	
	float arrowX = validationRectangleUpper.centerX();// - (arrowWidth / 2);
	
	float circleXLocation = checkArrowLocationX(arrowX + (xValue * convertPixelsToAccelerometerUpper), mainRectangleUpper);
	
	if (isWithColoreRange)
		arrowPaint.setColor(getScaleColorWithPosition(circleXLocation, true));
	
	final int verticesColors[] = {
	    arrowPaint.getColor(), arrowPaint.getColor(), arrowPaint.getColor(), 0xFF000000, 0xFF000000, 0xFF000000
	};
	


	float verts[] = {
			circleXLocation, validationRectangleUpper.centerY(), 
			circleXLocation + (arrowWidth / 2), (levelerLocation == Location.TOP)? validationRectangleUpper.bottom: validationRectangleUpper.top, 
			circleXLocation - (arrowWidth / 2), (levelerLocation == Location.TOP)? validationRectangleUpper.bottom: validationRectangleUpper.top
	};
	canvas.drawVertices(Canvas.VertexMode.TRIANGLES, verts.length, verts, 0, null, 0, verticesColors,   0, null, 0, 0, arrowPaint);//new Paint());
    }

    
    private void drawScaleUnit(float scalePosition,  Canvas canvas, boolean isHorizontal){
    int scaleUnitColor = getScaleColorWithPosition(scalePosition,isHorizontal);
    
	Paint scaleUnitPaint = new Paint();
	scaleUnitPaint.setStyle(Paint.Style.STROKE);
	scaleUnitPaint.setAntiAlias(true);
	scaleUnitPaint.setColor(scaleUnitColor);
    
	float startX = isHorizontal ?
            		scalePosition :
            		(levelerLocation == Location.LEFT) ? 
            			mainRectangleSide.left + 2.0f : 
            			mainRectangleSide.left + mainRectangleSide.width() - 2.0f;
	
	float startY = isHorizontal ?
					(levelerLocation == Location.TOP) ? 
						mainRectangleUpper.top + 2.0f : 
						mainRectangleUpper.top + mainRectangleSide.height() - 2.0f :
					scalePosition;
						
	float stopX = isHorizontal ? scalePosition : mainRectangleSide.left + mainRectangleSide.width()/2;
			
	float stopY = isHorizontal ? mainRectangleUpper.top + mainRectangleUpper.height()/2 : scalePosition;				

    canvas.drawLine(startX, startY, stopX, stopY, scaleUnitPaint);
    }
    
    

	private int getScaleColorWithPosition(float position, boolean isHorizontal) {
	float colorUnitSize = (isHorizontal ? mainRectangleUpper.width() : mainRectangleSide.height()) / scaleUnitsColorArray.length;
	int colorUnit = (int) Math.floor((position - (isHorizontal ? mainRectangleUpper.left : mainRectangleSide.top) - 1) / colorUnitSize);
	colorUnit = Math.max(colorUnit, 0);
	colorUnit = Math.min(colorUnit, scaleUnitsColorArray.length - 1);
	
	return scaleUnitsColorArray[colorUnit];
	}
    
    /**
     * Draw portrait leveler.
     *
     * @param canvas the canvas
     */
    private void drawVerticalLeveler(Canvas canvas) {
	boolean validOrintation = isLandscapeMode ? validOrientationY : validOrientationX;

	if (mainRectangleSide == null) {
	    drawRectInLocation();
	}
	if (validOrintation) {
	    rectanglePaintContainer.setColor(colorOrientationPassContainer);
	    arrowPaint.setColor(colorOrientationPassArrow);
	} else {
	    rectanglePaintContainer.setColor(colorOrientationFailContainer);
	    arrowPaint.setColor(colorOrientationFailArrow);
	}

	canvas.drawRoundRect(mainRectangleSide, 15f, 15f, rectanglePaintContainer);

	float trahHoldLeveler = isLandscapeMode ? levelerTrasholdSide : levelerTrasholdSidePortrait;
	convertPixelsToAccelerometerSide = trahHoldLeveler * mainRectangleSide.height() * (frame.height / 487);
	// border

	float arrowY = validationRectangleSide.centerY();

	float arrowWidth = (mainRectangleSide.right - mainRectangleSide.left) * 0.5f;

	float circleYLocation = checkArrowLocationY(arrowY - (yValue * convertPixelsToAccelerometerSide), mainRectangleSide);
	
	if (isWithColoreRange)
		arrowPaint.setColor(getScaleColorWithPosition(circleYLocation, false));
	
	final int verticesColors[] = {
	    arrowPaint.getColor(), arrowPaint.getColor(), arrowPaint.getColor(), 0xFF000000, 0xFF000000, 0xFF000000
	};
	
    int numberOfVerticalScaleUnits = (int) Math.floor(mainRectangleSide.height()/scaleUnitGap);
    if (numberOfVerticalScaleUnits%2 == 0)
        numberOfVerticalScaleUnits++;
    float originVerticalGap = (mainRectangleSide.height() - ((numberOfVerticalScaleUnits - 1) * scaleUnitGap))/2.0f;
    for (int i = 0; i < numberOfVerticalScaleUnits; i++) {
        drawScaleUnit(mainRectangleSide.top + originVerticalGap + (scaleUnitGap*i), canvas, false);
    }

	
	float verts[] = {
			validationRectangleSide.centerX(), circleYLocation, 
			(levelerLocation == Location.LEFT)? validationRectangleSide.right: validationRectangleSide.left,  circleYLocation + (arrowWidth / 2), 
			(levelerLocation == Location.LEFT)? validationRectangleSide.right: validationRectangleSide.left, circleYLocation - (arrowWidth / 2)
	};
	canvas.drawVertices(Canvas.VertexMode.TRIANGLES, verts.length, verts, 0, null, 0, verticesColors,   0, null, 0, 0, arrowPaint);//new Paint());
    }

    /**
     * Check arrow location x.
     *
     * @param location the location
     * @param mainRectangle the main rectangle
     * @param radios the radios
     * @return the float
     */
    private float checkArrowLocationX(float location, RectF mainRectangle) {
	float locationResult = location;

	if (location < mainRectangle.left) {
	    locationResult = mainRectangle.left;
	}
	if (location > mainRectangle.right) {

	    locationResult = mainRectangle.right;
	}

	return locationResult;
    }

    /**
     * Check circle location y.
     *
     * @param location the location
     * @param mainRectangle the main rectangle
     * @param radios the radios
     * @return the float
     */
    private float checkArrowLocationY(float location, RectF mainRectangle) {
	float locationResult = location;

	if (location < mainRectangleSide.top) {
	    locationResult = mainRectangleSide.top;
	}
	if (location > mainRectangleSide.bottom) {

	    locationResult = mainRectangleSide.bottom;
	}

	return locationResult;
    }

    /**
     * Update leveler location.
     *
     * @param values the values
     * @param isValidX the is valid x
     * @param isValidY the is valid y
     * @param isPortrait the is portrait
     */
    public void updateLevelerLocation(float[] values, boolean isValidX, boolean isValidY, boolean isPortrait) {
	// TODO Auto-generated method stub
	isValidOrintation = isValidX && isValidY;
	validOrientationX = isValidX;
	validOrientationY = isValidY;
	yValue = values[2];
	xValue = values[1];
	if (isPortrait) {
	    xValue = values[2];
	    yValue = values[1];
	    isLandscapeMode = false;
	}
		invalidate();
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onMeasure(int, int)
     */
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	// TODO Auto-generated method stub
	super.onMeasure(widthMeasureSpec, heightMeasureSpec);
	int widthSpec = MeasureSpec.getMode(widthMeasureSpec);
	int width = MeasureSpec.getSize(widthMeasureSpec);
	int heightSpec = MeasureSpec.getMode(heightMeasureSpec);
	int height = MeasureSpec.getSize(heightMeasureSpec);

	setMeasuredDimension(width, height);

    }

    /**
     * Draw rect in location.
     */
    private void drawRectInLocation() {
	int top;
	int left;
	float validationLeft;
	if (frame == null){
		return;
	}
	switch (levelerLocation) {
	case TOP:
	    top = (int) (frame.y + defaultPaddingTopAndBottom);
	    mainRectangleUpper = new RectF(frame.x + defaultPaddingLeftAndRight, top, frame.x + frame.width - defaultPaddingLeftAndRight, top + levelerWidth);
	    // validationLeft = mainRectangleUpper.left + validationRectTopBottomTrashHold * mainRectangleUpper.left;
	    validationRectangleUpper = new RectF(mainRectangleUpper.left * (1 + validationRectTopBottomTrashHold), mainRectangleUpper.top, mainRectangleUpper.right
		    - mainRectangleUpper.left * validationRectTopBottomTrashHold, mainRectangleUpper.bottom);
	    break;
	case BOTTOM:
	    top = (int) (frame.y + frame.height - defaultPaddingTopAndBottom);
	    mainRectangleUpper = new RectF(frame.x + defaultPaddingLeftAndRight, top, frame.x + frame.width - defaultPaddingLeftAndRight, top + levelerWidth);
	    validationRectangleUpper = new RectF(mainRectangleUpper.left * (1 + validationRectTopBottomTrashHold), mainRectangleUpper.top, mainRectangleUpper.right
		    - mainRectangleUpper.left * validationRectTopBottomTrashHold, mainRectangleUpper.bottom);
	    break;

	case LEFT:
	    left = (int) (frame.x + defaultPaddingLeftAndRight);
	    mainRectangleSide = new RectF(left, frame.y + defaultPaddingTopAndBottom, left + levelerWidth, frame.y + frame.height - defaultPaddingTopAndBottom);
	    validationRectangleSide = new RectF(mainRectangleSide.left, mainRectangleSide.top * (1 + validationRectLeftRightTrashHold), mainRectangleSide.right,
		    mainRectangleSide.bottom - mainRectangleSide.top * validationRectLeftRightTrashHold);
	    break;
	case RIGHT:
	    left = (int) (frame.x + frame.width - defaultPaddingLeftAndRight);
	    mainRectangleSide = new RectF(left, frame.y + defaultPaddingTopAndBottom, left + levelerWidth, frame.y + frame.height - defaultPaddingTopAndBottom);
	    validationRectangleSide = new RectF(mainRectangleSide.left, mainRectangleSide.top * (1 + validationRectLeftRightTrashHold), mainRectangleSide.right,
		    mainRectangleSide.bottom - mainRectangleSide.top * validationRectLeftRightTrashHold);
	    break;

	}

    }
};