/*
 * 
 */
package com.topimagesystems.ui;

import com.topimagesystems.R;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

// TODO: Auto-generated Javadoc
/**
 * The Class OneUnitLeveler.
 */
public class OneUnitLeveler extends ImageView {

    /** The is valid orintation. */
    private boolean isValidOrintation = false;

    /** The circle paint. */
    private Paint circlePaint;

    /** The rectangle paint container. */
    private Paint rectanglePaintContainer;
    
    /** The rectangle paint inner. */
    private Paint rectanglePaintInner;

    /** The leveler trashold. */
    private float levelerTrashold = 0.01389f;
    
    /** The convert pixels to accelerometer values. */
    private float convertPixelsToAccelerometerValues;
    
    /** The main rectangle. */
    private RectF mainRectangle;
    
    /** The validation rectangle. */
    private RectF validationRectangle;
    
    /** The context. */
    private Context context;
    
    /** The x value. */
    private float xValue = 0;
    
    /** The y value. */
    private float yValue = 0;
    
    /** The is fade animation enable. */
    private boolean isFadeAnimationEnable = false;

    /** The is dragging enable. */
    private boolean isDraggingEnable = false;
    
    /** The color orientation pass container. */
    private int colorOrientationPassContainer;
    
    /** The color orientation fail container. */
    private int colorOrientationFailContainer;

    /** The color orientation pass inner. */
    private int colorOrientationPassInner;
    
    /** The color orientation fail inner. */
    private int colorOrientationFailInner;

    /** The color orientation pass circle. */
    private int colorOrientationPassCircle;
    
    /** The color orientation fail circle. */
    private int colorOrientationFailCircle;
    
    /** The stroke width container. */
    private int strokeWidthContainer = 7;
    
    /** The stroke width inner. */
    private int strokeWidthInner = 7;

    /**
     * Instantiates a new one unit leveler.
     *
     * @param context the context
     * @param attrs the attrs
     */
    public OneUnitLeveler(Context context, AttributeSet attrs) {
	super(context, attrs);
	this.context = context;
	TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
	/*colorOrientationPassContainer = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_validColorContainer, Color.GREEN);
	colorOrientationFailContainer = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_uvalidColorContainer, Color.RED);

	colorOrientationPassInner = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_validColorInner, Color.GREEN);
	colorOrientationFailInner = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_unvalidColorInner, Color.RED);

	colorOrientationPassCircle = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_validColorCircle, Color.GREEN);
	colorOrientationFailCircle = oneLevelerData.getColor(R.styleable.OneUnitsLeveler_unvalidColorCircle, Color.RED);*/
	
	colorOrientationPassContainer = Color.GREEN;
	colorOrientationFailContainer = Color.RED;
	colorOrientationPassInner = Color.GREEN;
	colorOrientationFailInner = Color.RED;
	colorOrientationPassCircle = Color.GREEN;
	colorOrientationFailCircle = Color.RED;
	strokeWidthContainer = oneLevelerData.getInteger(R.styleable.OneUnitsLeveler_levelerThickness, strokeWidthContainer);
	strokeWidthInner = strokeWidthContainer;//oneLevelerData.getInteger(R.styleable.OneUnitsLeveler_levelerThicknessInner, strokeWidthInner);

	isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
	isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);
	/*if (Build.VERSION.SDK_INT != Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1) {
	    this.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
	}*/
	oneLevelerData.recycle();
	
	init();
    }

    /**
     * Instantiates a new one unit leveler.
     *
     * @param context the context
     * @param attrs the attrs
     * @param defStyle the def style
     */
    public OneUnitLeveler(Context context, AttributeSet attrs, int defStyle) {
	super(context, attrs, defStyle);
	this.context = context;
	init();
    }

    /**
     * Checks if is fade animation enable.
     *
     * @return true, if is fade animation enable
     */
    public boolean isFadeAnimationEnable() {
	return isFadeAnimationEnable;
    }

    /**
     * Checks if is dragging enable.
     *
     * @return true, if is dragging enable
     */
    public boolean isDraggingEnable() {
	return isDraggingEnable;
    }

    /**
     * Inits the.
     */
    private void init() {
	if (isInEditMode()) {
	    return;
	}
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
			this.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
		}

	circlePaint = new Paint();
	circlePaint.setStyle(Style.FILL);
	circlePaint.setAntiAlias(true);
	circlePaint.setColor(colorOrientationFailCircle);

	rectanglePaintContainer = new Paint();
	rectanglePaintContainer.setColor(colorOrientationFailContainer);
	rectanglePaintContainer.setStyle(Paint.Style.STROKE);
	rectanglePaintContainer.setStrokeWidth(strokeWidthContainer);

	rectanglePaintInner = new Paint();
	rectanglePaintInner.setColor(colorOrientationFailInner);
	rectanglePaintInner.setStyle(Paint.Style.STROKE);
	rectanglePaintInner.setStrokeWidth(strokeWidthInner);

    }

    /**
     * Show leveler.
     */
    public void showLeveler() {
	setVisibility(View.VISIBLE);
	invalidate();
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {

	if (mainRectangle == null || validationRectangle == null) {
	    final int imageWidth = getWidth();
	    final int imageHeight = getHeight();
	    mainRectangle = new RectF(strokeWidthContainer, strokeWidthContainer, imageWidth-strokeWidthContainer, imageHeight-strokeWidthContainer);
	    validationRectangle = new RectF(imageWidth / 5, imageHeight / 5, imageWidth * 4 / 5, imageHeight * 4 / 5);
	}
	if (isValidOrintation) {

	    rectanglePaintContainer.setColor(colorOrientationPassContainer);
	    rectanglePaintInner.setColor(colorOrientationPassInner);
	    circlePaint.setColor(colorOrientationPassCircle);
	} else {

	    rectanglePaintContainer.setColor(colorOrientationFailContainer);
	    rectanglePaintInner.setColor(colorOrientationFailInner);
	    circlePaint.setColor(colorOrientationFailCircle);
	}

	canvas.drawRoundRect(mainRectangle, 20f, 20f, rectanglePaintContainer);
	canvas.drawRoundRect(validationRectangle, 20f, 20f, rectanglePaintInner);

	convertPixelsToAccelerometerValues = mainRectangle.bottom * levelerTrashold;

	float circleX = validationRectangle.height();
	float circleRadios = circleX / 4;// circle size

	float circleXLocation = checkCircleSize(validationRectangle.centerX() + xValue * convertPixelsToAccelerometerValues, true, mainRectangle, circleRadios);
	float circleYLocation = checkCircleSize(validationRectangle.centerY() - yValue * convertPixelsToAccelerometerValues, false, mainRectangle, circleRadios);
	canvas.drawCircle(circleXLocation, circleYLocation, circleRadios, circlePaint);

    }

    /**
     * Check circle size.
     *
     * @param location the location
     * @param isXVal the is x val
     * @param mainRectangle the main rectangle
     * @param radios the radios
     * @return the float
     */
    private float checkCircleSize(float location, boolean isXVal, RectF mainRectangle, float radios) {
	float locationResult = location;

	if (location < mainRectangle.left+radios) {
	    locationResult = 0 + radios ;
	}
	if (location > mainRectangle.bottom- radios) {
	    locationResult = mainRectangle.bottom-radios;
	}

	return locationResult;

    }

    /**
     * Update leveler location.
     *
     * @param values the values
     * @param _isValidOrientation the _is valid orientation
     * @param isPortrait the is portrait
     */
    public void updateLevelerLocation(float[] values, boolean _isValidOrientation, boolean isPortrait) {
	// TODO Auto-generated method stub
	isValidOrintation = _isValidOrientation;
	yValue = values[2];
	xValue = values[1];
	if (isPortrait) {
	    xValue = values[2];
	    yValue = values[1];
	}
		invalidate();

    }

};