/*
 * 
 */
package com.topimagesystems.ui;

import com.topimagesystems.R;
import com.topimagesystems.data.Preferences;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;

// TODO: Auto-generated Javadoc
/**
 * The Class InfoScreenActivity.
 */
public class InfoScreenActivity extends Activity {
	
	/** The engine. */
	private TextView engine;
	
	/** The close screen. */
	private Button closeScreen;
	
	/** The never show again check. */
	private CheckBox neverShowAgainCheck;
	
	/** The preferences. */
	private Preferences preferences;

	/* (non-Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		overridePendingTransition(R.anim.slide_in_up, R.anim.slide_stay);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.info_screen);
		engine = (TextView) findViewById(R.id.infoScreenDetails);
		String txt = engine.getText().toString();		
		engine.setText(txt);
		closeScreen = (Button) findViewById(R.id.closeInfoScreen);
		preferences =  Preferences.getInstance(this);
		neverShowAgainCheck = (CheckBox) findViewById(R.id.dontShowAgainCheck);		
		closeScreen.setOnClickListener(new OnClickListener() {			
			@Override
			public void onClick(View v) {
				if (neverShowAgainCheck.isChecked()){
					preferences.setIsDontShowInfoChecked(true);										
				}
				onBackPressed();
			}
		});
		//engine.setBackgroundColor(getResources().getColor(R.color.infoScreenBackground));		
		//engine.loadUrl(localUrl);		
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see android.app.Activity#onBackPressed()
	 */
	@Override
	public void onBackPressed() {
		super.onBackPressed();
		overridePendingTransition(R.anim.slide_stay, R.anim.slide_out_up);
	}

}
