/*
 * 
 */
package com.topimagesystems.micr;

import com.topimagesystems.Constants;

import android.os.Bundle;

// TODO: Auto-generated Javadoc
/**
 * The Class OCRResult.
 */
public class OCRResult extends JNIResultBase {
	
	/** The digital row length. */
	public int digitalRowLength;
	
	/** The ocr result with delimiter. */
	public String ocrResultWithDelimiter;
	
	/** The ocr raw result. */
	public String ocrRawResult;
	
	/** The score result. */
	public String scoreResult;
	
	/** The mean digit height. */
	public int meanDigitHeight;
	public boolean isValidRead;

	/**
	 * Instantiates a new OCR result.
	 */
	public OCRResult() {
		super();
	}	
	
	/**
	 * Instantiates a new OCR result.
	 *
	 * @param _digitalRowLength the _digital row length
	 * @param _ocrResultWithDelimiter the _ocr result with delimiter
	 * @param _ocrRawResult the _ocr raw result
	 * @param _meanDigitHeight the _mean digit height
	 */
	public OCRResult(int _digitalRowLength,String _ocrResultWithDelimiter,String _ocrRawResult,int _meanDigitHeight) {		
		digitalRowLength = _digitalRowLength;
		ocrResultWithDelimiter = _ocrResultWithDelimiter;
		scoreResult = _ocrRawResult;
		meanDigitHeight = _meanDigitHeight;
		isValidRead = true;
	}

	/**
	 * Instantiates a new OCR result.
	 *
	 * @param bundle the bundle
	 */
	public OCRResult(Bundle bundle) {
		digitalRowLength = bundle.getInt(Constants.INTENT_OCR_DIGITAL_ROW);
		ocrResultWithDelimiter = bundle.getString(Constants.INTENT_OCR_RESULT_DELIMITTED);
		ocrRawResult = bundle.getString(Constants.INTENT_OCR_RAW_RESULT);
		scoreResult = bundle.getString(Constants.INTENT_OCR_SCORE_RESULT);
		meanDigitHeight = bundle.getInt(Constants.INTENT_OCR_MEAN_DIGIT_HEIGHT);
	}

	/**
	 * Instantiates a new OCR result.
	 *
	 * @param result the result to copy from
	 */
	public OCRResult(OCRResult result) {
		digitalRowLength = result.digitalRowLength;
		ocrResultWithDelimiter = result.ocrResultWithDelimiter;
		ocrRawResult = result.ocrRawResult;
		scoreResult = result.scoreResult;
		meanDigitHeight = result.meanDigitHeight;
		isValidRead = result.isValidRead;
	}

	/**
	 * Instantiates a new OCR result.
	 *
	 * @param ocrDataArray the result array as coming from class SessionResultParams
	 */
	public OCRResult(String[] ocrDataArray) {
		if (ocrDataArray.length != 4)
			return;
		digitalRowLength = Integer.valueOf(ocrDataArray[0]);
		ocrResultWithDelimiter = ocrDataArray[1];
		ocrRawResult = ocrDataArray[2];
		scoreResult = ocrDataArray[3];
		isValidRead = true;
		meanDigitHeight = 0;
	}


	/* (non-Javadoc)
	 * @see com.topimagesystems.micr.JNIResultBase#toString()
	 */
	@Override
	public String toString() {
		return "OCRResult [digitalRowLength=" + digitalRowLength + ", ocrResultWithDelimiter=" + ocrResultWithDelimiter + ", ocrRawResult="
				+ ocrRawResult + ", scoreResult=" + scoreResult + ", meanDigitHeight=" + meanDigitHeight + "]";
	}

	/**
	 * To bundle.
	 *
	 * @return the bundle
	 */
	public Bundle toBundle() {
		Bundle result = new Bundle();
		result.putInt(Constants.INTENT_OCR_DIGITAL_ROW, digitalRowLength);
		result.putString(Constants.INTENT_OCR_RESULT_DELIMITTED, ocrResultWithDelimiter);
		result.putString(Constants.INTENT_OCR_RAW_RESULT, ocrRawResult);
		result.putString(Constants.INTENT_OCR_SCORE_RESULT, scoreResult);
		result.putInt(Constants.INTENT_OCR_MEAN_DIGIT_HEIGHT, meanDigitHeight);
		return result;
	}
}