/*
 * 
 */
package com.topimagesystems.micr;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraController.CameraActivityHandler;
import com.topimagesystems.micr.OCRCommon.OCRDetectorStatus;
import com.topimagesystems.util.Logger;

import android.content.Context;

// TODO: Auto-generated Javadoc
/**
 * The Class JavaNotifier.
 */
public class JavaNotifier {

	/** The Constant tag. */
	private final static String tag = Logger.makeLogTag("JavaNotifier");
	
	/** The handler. */
	@SuppressWarnings("unused")
	private CameraActivityHandler handler;
	
	/** The context. */
	@SuppressWarnings("unused")
	private Context context;

	/**
	 * Instantiates a new java notifier.
	 *
	 * @param handler the handler
	 * @param context the context
	 */
	public JavaNotifier(CameraActivityHandler handler, Context context) {
		this.handler = handler;
		this.context = context;
	}

	/**
	 * Notify.
	 *
	 * @param messageCode the message code
	 * @return the int
	 */
	public int notify(int messageCode) {

		final OCRDetectorStatus ocrDetectorStatus = OCRDetectorStatus.instanceOf(messageCode);
		if (ocrDetectorStatus != null) {
			Logger.i(tag, "notify message:" + messageCode + " ocrDetectorStatus:" + ocrDetectorStatus.name());
			final CameraController cameraController = CameraController.getInstance();
			cameraController.updateProcessingMessageFromJNI(ocrDetectorStatus);
			return messageCode;
		}
		else {
			Logger.e(tag, "no matching notify message for :" + messageCode);
		}
		return 0;
	}
	
	/**
	 * Abort.
	 *
	 * @param why the why
	 */
	public void abort(String why)
	{
		Logger.e(tag, "abort is called ! why:" + why);
	}
	
	/**
	 * Native crashed.
	 */
	void nativeCrashed() {
		new RuntimeException("crashed here (native trace should follow after the Java trace)").printStackTrace();
	}
	
	/**
	 * Gets the stack trace.
	 *
	 * @param t the t
	 * @return the stack trace
	 */
	String getStackTrace(Throwable t) {
		ByteArrayOutputStream b = new ByteArrayOutputStream();
		t.printStackTrace(new PrintStream(b, true));
		return b.toString();
	}
}