/*
 * 
 */
package com.topimagesystems.micr;

import org.opencv.core.Mat;

import com.topimagesystems.Constants;

import android.os.Bundle;


// TODO: Auto-generated Javadoc
/**
 *	ImageResult.java
 * 
 *	Created by Elad Mobile on 01/08/2012
 * 	@author Danny Polonsky
 *
 */
public class ImageSessionResult extends JNIResultBase {
	
	/** The mat. */
	public Mat mat;
	
	/** The file path. */
	public String filePath;

	/** The digital row length. */
	public int digitalRowLength;
	
	/** The ocr result with delimiter. */
	public String ocrResultWithDelimiter;
	
	/** The ocr raw result. */
	public String ocrRawResult;
	
	/** The score result. */
	public String scoreResult;
	
	/** The mean digit height. */
	public int meanDigitHeight;
	
	/** The x. */
	public int x;
	
	/** The y. */
	public int y;
	
	/** The width. */
	public int width;
	
	/** The height. */
	public int height;
	
	/** The tiff width. */
	public int tiffWidth;
	
	/** The tiff height. */
	public int tiffHeight;
	
	/** The image result. */
	public boolean imageResult; 

	/**
	 * Instantiates a new image session result.
	 */
	public ImageSessionResult() {
		super();
	}
	
	/**
	 * Instantiates a new image session result.
	 *
	 * @param bundle the bundle
	 */
	public ImageSessionResult(Bundle bundle) {
		super();
		digitalRowLength = bundle.getInt(Constants.INTENT_OCR_DIGITAL_ROW);
		ocrResultWithDelimiter = bundle.getString(Constants.INTENT_OCR_RESULT_DELIMITTED);
		ocrRawResult = bundle.getString(Constants.INTENT_OCR_RAW_RESULT);
		scoreResult = bundle.getString(Constants.INTENT_OCR_SCORE_RESULT);
		meanDigitHeight = bundle.getInt(Constants.INTENT_OCR_MEAN_DIGIT_HEIGHT);
		
	}
	
	
	/* (non-Javadoc)
	 * @see com.topimagesystems.micr.JNIResultBase#toString()
	 */
	@Override
	public String toString() {
		return "OCRResult [digitalRowLength=" + digitalRowLength + ", ocrResultWithDelimiter=" + ocrResultWithDelimiter + ", ocrRawResult="
				+ ocrRawResult + ", scoreResult=" + scoreResult + ", meanDigitHeight=" + meanDigitHeight + "]";
	}

	/**
	 * To bundle.
	 *
	 * @return the bundle
	 */
	public Bundle toBundle() {
		Bundle result = new Bundle();
		result.putInt(Constants.INTENT_OCR_DIGITAL_ROW, digitalRowLength);
		result.putString(Constants.INTENT_OCR_RESULT_DELIMITTED, ocrResultWithDelimiter);
		result.putString(Constants.INTENT_OCR_RAW_RESULT, ocrRawResult);
		result.putString(Constants.INTENT_OCR_SCORE_RESULT, scoreResult);
		result.putInt(Constants.INTENT_OCR_MEAN_DIGIT_HEIGHT, meanDigitHeight);
		return result;
	}

}