/*
 * 
 */
package com.topimagesystems.micr;

import org.opencv.core.Rect;

// TODO: Auto-generated Javadoc
/**
 * BoundingBoxResult.java
 * 
 * Created by Elad Mobile on 01/08/2012
 * 
 * @author Danny Polonsky
 * 
 */
public class BoundingBoxResult extends JNIResultBase {
	
	/** The height. */
	public int x, y, width, height;
	
	/** The orientation. */
	public double orientation;
	
	/** The size indicator. */
	public int sizeIndicator;
	public float[] bottomLeft = new float[2];
	public float[] bottomRight = new float[2];
	public float[] topLeft = new float[2];
	public float[] topRight = new float[2];
	
	/**
	 * Instantiates a new bounding box result.
	 */
	public BoundingBoxResult() {
		super();
	}

	/**
	 * Gets the rect.
	 *
	 * @return the rect
	 */
	public Rect getRect() {
		return new Rect(x, y, width, height);
	}
	
	/**
	 * Sets the rect.
	 *
	 * @param x the x
	 * @param y the y
	 * @param width the width
	 * @param height the height
	 */
	public void setRect(int x, int y,int width,int height) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.micr.JNIResultBase#toString()
	 */
	@Override
	public String toString() {
		return "BoundingBoxResult [" + super.toString() + " [x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + "]]";
	}
}