/*
 * 
 */
package com.topimagesystems.intent;

import android.os.Bundle;

import com.topimagesystems.intent.CaptureIntent.IQAIntentKeys;

// TODO: Auto-generated Javadoc
/**
 * The Class IQASettingsIntent.
 */
public class IQASettingsIntent {

	//	public boolean isIQAMode;
	// corner Data Front
	// corner Data Front TL
	/** The corner data front tlh. */
	public float cornerDataFrontTLH;

	/** The corner data front tlw. */
	public float cornerDataFrontTLW;

	/** The corner data front tla. */
	public float cornerDataFrontTLA;
	// corner Data Front TR
	/** The corner data front trh. */
	public float cornerDataFrontTRH;

	/** The corner data front trw. */
	public float cornerDataFrontTRW;

	/** The corner data front tra. */
	public float cornerDataFrontTRA;
	// corner Data Front BR
	/** The corner data front brh. */
	public float cornerDataFrontBRH;

	/** The corner data front brw. */
	public float cornerDataFrontBRW;

	/** The corner data front bra. */
	public float cornerDataFrontBRA;
	// corner Data Front BL
	/** The corner data front blh. */
	public float cornerDataFrontBLH;

	/** The corner data front blw. */
	public float cornerDataFrontBLW;

	/** The corner data front bla. */
	public float cornerDataFrontBLA;

	// corner Data Back
	// corner Back Front TL
	/** The corner data back tlh. */
	public float cornerDataBackTLH;

	/** The corner data back tlw. */
	public float cornerDataBackTLW;

	/** The corner data back tla. */
	public float cornerDataBackTLA;
	// corner Data Back TR
	/** The corner data back trh. */
	public float cornerDataBackTRH;

	/** The corner data back trw. */
	public float cornerDataBackTRW;

	/** The corner data back tra. */
	public float cornerDataBackTRA;
	// corner Data Back BR
	/** The corner data back brh. */
	public float cornerDataBackBRH;

	/** The corner data back brw. */
	public float cornerDataBackBRW;

	/** The corner data back bra. */
	public float cornerDataBackBRA;
	// corner Data Back BL
	/** The corner data back blh. */
	public float cornerDataBackBLH;

	/** The corner data back blw. */
	public float cornerDataBackBLW;

	/** The corner data back bla. */
	public float cornerDataBackBLA;

	// edge data
	// T
	/** The edge data th. */
	public float edgeDataTH;

	/** The edge data tw. */
	public float edgeDataTW;

	/** The edge data ta. */
	public float edgeDataTA;
	// R
	/** The edge data rh. */
	public float edgeDataRH;

	/** The edge data rw. */
	public float edgeDataRW;

	/** The edge data ra. */
	public float edgeDataRA;
	// B
	/** The edge data bh. */
	public float edgeDataBH;

	/** The edge data bw. */
	public float edgeDataBW;

	/** The edge data ba. */
	public float edgeDataBA;
	// L
	/** The edge data lh. */
	public float edgeDataLH;

	/** The edge data lw. */
	public float edgeDataLW;

	/** The edge data la. */
	public float edgeDataLA;

	/** The max darkness back. */
	public float maxDarknessBack;

	/** The min darkness back. */
	public float minDarknessBack;

	/** The max darkness front. */
	public float maxDarknessFront;

	/** The min darkness front. */
	public float minDarknessFront;

	/** The max rotation skew. */
	public float maxRotationSkew;

	/** The number of spots front. */
	public int numberOfSpotsFront;

	/** The number of spots back. */
	public int numberOfSpotsBack;

	//imageSize
	/** The imagesize front min. */
	public float imagesizeFrontMin;

	/** The imagesize front max. */
	public float imagesizeFrontMax;

	/** The imagesize back min. */
	public float imagesizeBackMin;

	/** The imagesize back max. */
	public float imagesizeBackMax;

	/* The horizontalStreakSumOfBlackPixels */
	public int horizontalStreakSumOfBlackPixels;

	/* The horizontalStreakLineWidth */
	public int horizontalStreakLineWidth;

	/* The horizontalStreakNumLines */
	public int horizontalStreakNumLines;


	/* The carbonStripSumOfBlackPixels */
	public int carbonStripSumOfBlackPixels;

	/* The carbonStripLineWidth */
	public int carbonStripLineWidth;

	/* The carbonStripNumLines */
	public int carbonStripNumLines;

	/* The distance to the top rect */
	public float piggyBackWidthThreshold;

	/* Location threshold from the top rect */
	public float piggyBackLocationThreshold;

	//	public int numberOfSpots=5454;
	/**
	 * Instantiates a new IQA settings intent.
	 */
	public IQASettingsIntent() {
	}

	/**
	 * Instantiates a new IQA settings intent.
	 *
	 * @param bundle the bundle
	 */
	public IQASettingsIntent(Bundle bundle) {
		// front corner data
		// corner data front TL
		cornerDataFrontTLH = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_H_KEY);
		cornerDataFrontTLW = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_W_KEY);
		cornerDataFrontTLA = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_A_KEY);
		// corner data front TR
		cornerDataFrontTRH = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_H_KEY);
		cornerDataFrontTRW = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_W_KEY);
		cornerDataFrontTRA = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_A_KEY);
		// corner data front BR
		cornerDataFrontBRH = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_H_KEY);
		cornerDataFrontBRW = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_W_KEY);
		cornerDataFrontBRA = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_A_KEY);
		// corner data front BL
		cornerDataFrontBLH = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_H_KEY);
		cornerDataFrontBLW = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_W_KEY);
		cornerDataFrontBLA = bundle.getFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_A_KEY);

		// back corner data
		// corner data front TL
		cornerDataBackTLH = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TL_H_KEY);
		cornerDataBackTLW = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TL_W_KEY);
		cornerDataBackTLA = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TL_A_KEY);
		// corner data front TR
		cornerDataBackTRH = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TR_H_KEY);
		cornerDataBackTRW = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TR_W_KEY);
		cornerDataBackTRA = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_TR_A_KEY);
		// corner data front BR
		cornerDataBackBRH = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BR_H_KEY);
		cornerDataBackBRW = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BR_W_KEY);
		cornerDataBackBRA = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BR_A_KEY);
		// corner data front BL
		cornerDataBackBLH = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BL_H_KEY);
		cornerDataBackBLW = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BL_W_KEY);
		cornerDataBackBLA = bundle.getFloat(IQAIntentKeys.CORNERDATA_BACK_BL_A_KEY);

		// edge data
		edgeDataTH = bundle.getFloat(IQAIntentKeys.EDGE_DATA_T_H_KEY);
		edgeDataTW = bundle.getFloat(IQAIntentKeys.EDGE_DATA_T_W_KEY);
		edgeDataTA = bundle.getFloat(IQAIntentKeys.EDGE_DATA_T_A_KEY);

		edgeDataRH = bundle.getFloat(IQAIntentKeys.EDGE_DATA_R_H_KEY);
		edgeDataRW = bundle.getFloat(IQAIntentKeys.EDGE_DATA_R_W_KEY);
		edgeDataRA = bundle.getFloat(IQAIntentKeys.EDGE_DATA_R_A_KEY);

		edgeDataBH = bundle.getFloat(IQAIntentKeys.EDGE_DATA_B_H_KEY);
		edgeDataBW = bundle.getFloat(IQAIntentKeys.EDGE_DATA_B_W_KEY);
		edgeDataBA = bundle.getFloat(IQAIntentKeys.EDGE_DATA_B_A_KEY);

		edgeDataLH = bundle.getFloat(IQAIntentKeys.EDGE_DATA_L_H_KEY);
		edgeDataLW = bundle.getFloat(IQAIntentKeys.EDGE_DATA_L_W_KEY);
		edgeDataLA = bundle.getFloat(IQAIntentKeys.EDGE_DATA_L_A_KEY);

		//
		maxDarknessBack = bundle.getFloat(IQAIntentKeys.MAX_DARNESS_BACK_KEY);
		minDarknessBack = bundle.getFloat(IQAIntentKeys.MIN_DARNESS_BACK_KEY);
		maxDarknessFront = bundle.getFloat(IQAIntentKeys.MAX_DARNESS_FRONT_KEY);
		minDarknessFront = bundle.getFloat(IQAIntentKeys.MIN_DARNESS_FRONT_KEY);
		maxRotationSkew = bundle.getFloat(IQAIntentKeys.MAX_SKEW_KEY);
		numberOfSpotsFront = bundle.getInt(IQAIntentKeys.MAX_SPOTS_FRONT_KEY);
		numberOfSpotsBack = bundle.getInt(IQAIntentKeys.MAX_SPOTS_BACK_KEY);

		imagesizeFrontMin = bundle.getFloat(IQAIntentKeys.MIN_IMAGE_SIZE_FRONT_KEY);
		imagesizeFrontMax = bundle.getFloat(IQAIntentKeys.MAX_IMAGE_SIZE_FRONT_KEY);
		imagesizeBackMin = bundle.getFloat(IQAIntentKeys.MIN_IMAGE_SIZE_BACK_KEY);
		imagesizeBackMax = bundle.getFloat(IQAIntentKeys.MAX_IMAGE_SIZE_BACK_KEY);

		horizontalStreakSumOfBlackPixels = bundle.getInt(IQAIntentKeys.HORIZONTAL_STREAK_SUM_BLACK_PIXELS);
		horizontalStreakLineWidth = bundle.getInt(IQAIntentKeys.HORIZONTAL_STREAK_LINE_WIDTH);
		horizontalStreakNumLines = bundle.getInt(IQAIntentKeys.HORIZONTAL_STREAK_NUM_LINES);

		carbonStripSumOfBlackPixels = bundle.getInt(IQAIntentKeys.CARBON_STRIP_SUM_BLACK_PIXELS);
		carbonStripLineWidth = bundle.getInt(IQAIntentKeys.CARBON_STRIP_LINE_WIDTH);
		carbonStripNumLines = bundle.getInt(IQAIntentKeys.CARBON_STRIP_NUM_LINES);

		piggyBackWidthThreshold = bundle.getFloat(IQAIntentKeys.PIGGY_BACK_WIDTH_THRESHOLD);
		piggyBackLocationThreshold = bundle.getFloat(IQAIntentKeys.PIGGY_BACK_LOCATION_THRESHOLD);

	}

	/**
	 * To bundle.
	 *
	 * @return the bundle
	 */
	public Bundle toBundle() {
		Bundle bundle = new Bundle();

		//		bundle.putBoolean(IQAIntentKeys.IS_IQA_MODE, isIQAMode);
		// Back cornder data
		// TL
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TL_H_KEY, cornerDataBackTLH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TL_W_KEY, cornerDataBackTLW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TL_A_KEY, cornerDataBackTLA);
		// TR
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TR_H_KEY, cornerDataBackTRH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TR_W_KEY, cornerDataBackTRW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_TR_A_KEY, cornerDataBackTRA);
		// BR
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BR_H_KEY, cornerDataBackBRH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BR_W_KEY, cornerDataBackBRW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BR_A_KEY, cornerDataBackBRA);
		// BL
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BL_H_KEY, cornerDataBackBLH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BL_W_KEY, cornerDataBackBLW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_BACK_BL_A_KEY, cornerDataBackBLA);

		// corner Front data
		// TL
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_H_KEY, cornerDataFrontTLH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_W_KEY, cornerDataFrontTLW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TL_A_KEY, cornerDataFrontTLA);
		// TR
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_H_KEY, cornerDataFrontTRH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_W_KEY, cornerDataFrontTRW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_TR_A_KEY, cornerDataFrontTRA);
		// BR
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_H_KEY, cornerDataFrontBRH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_W_KEY, cornerDataFrontBRW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BR_A_KEY, cornerDataFrontBRA);
		// BL
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_H_KEY, cornerDataFrontBLH);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_W_KEY, cornerDataFrontBLW);
		bundle.putFloat(IQAIntentKeys.CORNERDATA_FRONT_BL_A_KEY, cornerDataFrontBLA);

		// edge data
		// T
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_T_H_KEY, edgeDataTH);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_T_W_KEY, edgeDataTW);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_T_A_KEY, edgeDataTA);
		// R
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_R_H_KEY, edgeDataRH);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_R_W_KEY, edgeDataRW);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_R_A_KEY, edgeDataRA);
		// B
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_B_H_KEY, edgeDataBH);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_B_W_KEY, edgeDataBW);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_B_A_KEY, edgeDataBA);
		// L
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_L_H_KEY, edgeDataLH);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_L_W_KEY, edgeDataLW);
		bundle.putFloat(IQAIntentKeys.EDGE_DATA_L_A_KEY, edgeDataLA);

		bundle.putFloat(IQAIntentKeys.MAX_DARNESS_BACK_KEY, maxDarknessBack);
		bundle.putFloat(IQAIntentKeys.MIN_DARNESS_BACK_KEY, minDarknessBack);
		bundle.putFloat(IQAIntentKeys.MAX_DARNESS_FRONT_KEY, maxDarknessFront);
		bundle.putFloat(IQAIntentKeys.MIN_DARNESS_FRONT_KEY, minDarknessFront);
		bundle.putFloat(IQAIntentKeys.MAX_SKEW_KEY, maxRotationSkew);
		bundle.putInt(IQAIntentKeys.MAX_SPOTS_FRONT_KEY, numberOfSpotsFront);
		bundle.putInt(IQAIntentKeys.MAX_SPOTS_BACK_KEY, numberOfSpotsBack);

		bundle.putFloat(IQAIntentKeys.MIN_IMAGE_SIZE_FRONT_KEY, imagesizeFrontMin);
		bundle.putFloat(IQAIntentKeys.MAX_IMAGE_SIZE_FRONT_KEY, imagesizeFrontMax);
		bundle.putFloat(IQAIntentKeys.MIN_IMAGE_SIZE_BACK_KEY, imagesizeBackMin);
		bundle.putFloat(IQAIntentKeys.MAX_IMAGE_SIZE_BACK_KEY, imagesizeBackMax);

		bundle.putInt(IQAIntentKeys.HORIZONTAL_STREAK_SUM_BLACK_PIXELS, horizontalStreakSumOfBlackPixels);
		bundle.putInt(IQAIntentKeys.HORIZONTAL_STREAK_LINE_WIDTH, horizontalStreakLineWidth);
		bundle.putInt(IQAIntentKeys.HORIZONTAL_STREAK_NUM_LINES, horizontalStreakNumLines);

		bundle.putInt(IQAIntentKeys.CARBON_STRIP_SUM_BLACK_PIXELS, carbonStripSumOfBlackPixels);
		bundle.putInt(IQAIntentKeys.CARBON_STRIP_LINE_WIDTH, carbonStripLineWidth);
		bundle.putInt(IQAIntentKeys.CARBON_STRIP_NUM_LINES, carbonStripNumLines);

		bundle.putFloat(IQAIntentKeys.PIGGY_BACK_WIDTH_THRESHOLD, piggyBackWidthThreshold);
		bundle.putFloat(IQAIntentKeys.PIGGY_BACK_LOCATION_THRESHOLD, piggyBackLocationThreshold);

		return bundle;
	}

	/**
	 * Gets the IQA settings default.
	 *
	 * @return the IQA settings default
	 */
	public IQASettingsIntent getIQASettingsDefault() {

		IQASettingsIntent iqaSettings = new IQASettingsIntent();
		IQADefaults defaultParams = new IQADefaults();

		// corner data front TL
		iqaSettings.cornerDataFrontTLH = defaultParams.CORNERDATA_FRONT_TL_H;
		iqaSettings.cornerDataFrontTLW = defaultParams.CORNERDATA_FRONT_TL_W;
		iqaSettings.cornerDataFrontTLA = defaultParams.CORNERDATA_FRONT_TL_A;
		// corner data front TR
		iqaSettings.cornerDataFrontTRH = defaultParams.CORNERDATA_FRONT_TR_H;
		iqaSettings.cornerDataFrontTRW = defaultParams.CORNERDATA_FRONT_TR_W;
		iqaSettings.cornerDataFrontTRA = defaultParams.CORNERDATA_FRONT_TR_A;
		// corner data front BR
		iqaSettings.cornerDataFrontBRH = defaultParams.CORNERDATA_FRONT_BR_H;
		iqaSettings.cornerDataFrontBRW = defaultParams.CORNERDATA_FRONT_BR_W;
		iqaSettings.cornerDataFrontBRA = defaultParams.CORNERDATA_FRONT_BR_A;
		// corner data front BL
		iqaSettings.cornerDataFrontBLH = defaultParams.CORNERDATA_FRONT_BL_H;
		iqaSettings.cornerDataFrontBLW = defaultParams.CORNERDATA_FRONT_BL_W;
		iqaSettings.cornerDataFrontBLA = defaultParams.CORNERDATA_FRONT_BL_A;

		// back corner data
		// corner data front TL
		iqaSettings.cornerDataBackTLH = defaultParams.CORNERDATA_BACK_TL_H;
		iqaSettings.cornerDataBackTLW = defaultParams.CORNERDATA_BACK_TL_W;
		iqaSettings.cornerDataBackTLA = defaultParams.CORNERDATA_BACK_TL_A;
		// corner data front TR
		iqaSettings.cornerDataBackTRH = defaultParams.CORNERDATA_BACK_TR_H;
		iqaSettings.cornerDataBackTRW = defaultParams.CORNERDATA_BACK_TR_W;
		iqaSettings.cornerDataBackTRA = defaultParams.CORNERDATA_BACK_TR_A;
		// corner data front BR
		iqaSettings.cornerDataBackBRH = defaultParams.CORNERDATA_BACK_BR_H;
		iqaSettings.cornerDataBackBRW = defaultParams.CORNERDATA_BACK_BR_W;
		iqaSettings.cornerDataBackBRA = defaultParams.CORNERDATA_BACK_BR_A;
		// corner data front BL
		iqaSettings.cornerDataBackBLH = defaultParams.CORNERDATA_BACK_BL_H;
		iqaSettings.cornerDataBackBLW = defaultParams.CORNERDATA_BACK_BL_W;
		iqaSettings.cornerDataBackBLA = defaultParams.CORNERDATA_BACK_BL_A;

		// edge data
		iqaSettings.edgeDataTH = defaultParams.EDGE_DATA_T_H;
		iqaSettings.edgeDataTW = defaultParams.EDGE_DATA_T_W;
		iqaSettings.edgeDataTA = defaultParams.EDGE_DATA_T_A;

		iqaSettings.edgeDataRH = defaultParams.EDGE_DATA_R_H;
		iqaSettings.edgeDataRW = defaultParams.EDGE_DATA_R_W;
		iqaSettings.edgeDataRA = defaultParams.EDGE_DATA_R_A;

		iqaSettings.edgeDataBH = defaultParams.EDGE_DATA_B_H;
		iqaSettings.edgeDataBW = defaultParams.EDGE_DATA_B_W;
		iqaSettings.edgeDataBA = defaultParams.EDGE_DATA_B_A;

		iqaSettings.edgeDataLH = defaultParams.EDGE_DATA_L_H;
		iqaSettings.edgeDataLW = defaultParams.EDGE_DATA_L_W;
		iqaSettings.edgeDataLA = defaultParams.EDGE_DATA_L_A;

		iqaSettings.maxDarknessFront = defaultParams.MAX_DARNESS_FRONT;
		iqaSettings.minDarknessFront = defaultParams.MIN_DARNESS_FRONT;
		iqaSettings.maxDarknessBack = defaultParams.MAX_DARNESS_BACK;
		iqaSettings.minDarknessBack = defaultParams.MIN_DARNESS_BACK;
		iqaSettings.maxRotationSkew = defaultParams.MAX_SKEW;
		iqaSettings.numberOfSpotsFront = defaultParams.MAX_SPOTS_FRONT;
		iqaSettings.numberOfSpotsBack = defaultParams.MAX_SPOTS_BACK;

		iqaSettings.imagesizeFrontMin = defaultParams.MIN_IMAGE_SIZE_FRONT;
		iqaSettings.imagesizeFrontMax = defaultParams.MAX_IMAGE_SIZE_FRONT;
		iqaSettings.imagesizeBackMin = defaultParams.MIN_IMAGE_SIZE_BACK;
		iqaSettings.imagesizeBackMax = defaultParams.MAX_IMAGE_SIZE_BACK;

		iqaSettings.horizontalStreakSumOfBlackPixels = defaultParams.HORIZONTAL_STREAK_SUM_BLACK_PIXELS;
		iqaSettings.horizontalStreakLineWidth = defaultParams.HORIZONTAL_STREAK_LINE_WIDTH;
		iqaSettings.horizontalStreakNumLines = defaultParams.HORIZONTAL_STREAK_NUM_LINES;

		iqaSettings.carbonStripSumOfBlackPixels = defaultParams.CARBON_STRIP_SUM_BLACK_PIXELS;
		iqaSettings.carbonStripLineWidth = defaultParams.CARBON_STRIP_LINE_WIDTH;
		iqaSettings.carbonStripNumLines = defaultParams.CARBON_STRIP_NUM_LINES;

		iqaSettings.piggyBackWidthThreshold = defaultParams.PIGGY_BACK_DISTANCE_THRESHOLD;
		iqaSettings.piggyBackLocationThreshold = defaultParams.PIGGY_BACK_LOCATION_THRESHOLD;

		return iqaSettings;
	}

	/**
	 * The Class IQADefaults.
	 */
	public class IQADefaults {

		/** The is iqa mode. */
		public final boolean IS_IQA_MODE = false;

		/** The cornerdata front tl w. */
		public final float CORNERDATA_FRONT_TL_W = 1.0f;

		/** The cornerdata front tl h. */
		public final float CORNERDATA_FRONT_TL_H = 1.0f;

		/** The cornerdata front tl a. */
		public final float CORNERDATA_FRONT_TL_A = 0.4f;

		/** The cornerdata front tr w. */
		public final float CORNERDATA_FRONT_TR_W = 1.0f;

		/** The cornerdata front tr h. */
		public final float CORNERDATA_FRONT_TR_H = 1.0f;

		/** The cornerdata front tr a. */
		public final float CORNERDATA_FRONT_TR_A = 0.4f;

		/** The cornerdata front bl w. */
		public final float CORNERDATA_FRONT_BL_W = 1.0f;

		/** The cornerdata front bl h. */
		public final float CORNERDATA_FRONT_BL_H = 1.0f;

		/** The cornerdata front bl a. */
		public final float CORNERDATA_FRONT_BL_A = 0.4f;

		/** The cornerdata front br w. */
		public final float CORNERDATA_FRONT_BR_W = 0.8f;

		/** The cornerdata front br h. */
		public final float CORNERDATA_FRONT_BR_H = 0.8f;

		/** The cornerdata front br a. */
		public final float CORNERDATA_FRONT_BR_A = 0.3f;
		//
		/** The cornerdata back tl w. */
		public final float CORNERDATA_BACK_TL_W = 3.0f;

		/** The cornerdata back tl h. */
		public final float CORNERDATA_BACK_TL_H = 3.0f;

		/** The cornerdata back tl a. */
		public final float CORNERDATA_BACK_TL_A = 1.0f;

		/** The cornerdata back tr w. */
		public final float CORNERDATA_BACK_TR_W = 3.0f;

		/** The cornerdata back tr h. */
		public final float CORNERDATA_BACK_TR_H = 3.0f;

		/** The cornerdata back tr a. */
		public final float CORNERDATA_BACK_TR_A = 1.0f;

		/** The cornerdata back bl w. */
		public final float CORNERDATA_BACK_BL_W = 0.8f;

		/** The cornerdata back bl h. */
		public final float CORNERDATA_BACK_BL_H = 0.8f;

		/** The cornerdata back bl a. */
		public final float CORNERDATA_BACK_BL_A = 0.3f;

		/** The cornerdata back br w. */
		public final float CORNERDATA_BACK_BR_W = 3.0f;

		/** The cornerdata back br h. */
		public final float CORNERDATA_BACK_BR_H = 3.0f;

		/** The cornerdata back br a. */
		public final float CORNERDATA_BACK_BR_A = 1.0f;
		// ---edge
		/** The edge data t w. */
		public final float EDGE_DATA_T_W = 0.8f;

		/** The edge data t h. */
		public final float EDGE_DATA_T_H = 0.8f;

		/** The edge data t a. */
		public final float EDGE_DATA_T_A = 0.3f;

		/** The edge data b w. */
		public final float EDGE_DATA_B_W = 0.8f;

		/** The edge data b h. */
		public final float EDGE_DATA_B_H = 0.8f;

		/** The edge data b a. */
		public final float EDGE_DATA_B_A = 0.3f;

		/** The edge data l w. */
		public final float EDGE_DATA_L_W = 0.8f;

		/** The edge data l h. */
		public final float EDGE_DATA_L_H = 0.8f;

		/** The edge data l a. */
		public final float EDGE_DATA_L_A = 0.3f;

		/** The edge data r w. */
		public final float EDGE_DATA_R_W = 0.8f;

		/** The edge data r h. */
		public final float EDGE_DATA_R_H = 0.8f;

		/** The edge data r a. */
		public final float EDGE_DATA_R_A = 0.3f;

		/** The max skew. */
		public final float MAX_SKEW = 7.5f;

		/** The max darness front. */
		public final float MAX_DARNESS_FRONT = 0.9f;

		/** The min darness front. */
		public final float MIN_DARNESS_FRONT = 0.009f;

		/** The max darness back. */
		public final float MAX_DARNESS_BACK = 0.98f;

		/** The min darness back. */
		public final float MIN_DARNESS_BACK = 0.0038f;

		/** The max spots front. */
		public final int MAX_SPOTS_FRONT = 5852;

		/** The max spots back. */
		public final int MAX_SPOTS_BACK = 5852;

		/** The min image size front. */
		public final float MIN_IMAGE_SIZE_FRONT = 0.5f;

		/** The max image size front. */
		public final float MAX_IMAGE_SIZE_FRONT = 200f;

		/** The min image size back. */
		public final float MIN_IMAGE_SIZE_BACK = 0.5f;

		/** The max image size back. */
		public final float MAX_IMAGE_SIZE_BACK = 200f;

		public final int HORIZONTAL_STREAK_SUM_BLACK_PIXELS = 30;
		public final int HORIZONTAL_STREAK_LINE_WIDTH = 10;
		public final int HORIZONTAL_STREAK_NUM_LINES = 1;

		public final int CARBON_STRIP_SUM_BLACK_PIXELS = 30;
		public final int CARBON_STRIP_LINE_WIDTH = 10;
		public final int CARBON_STRIP_NUM_LINES = 1;

		public final float PIGGY_BACK_DISTANCE_THRESHOLD = 10f;
		public final float PIGGY_BACK_LOCATION_THRESHOLD = 20f;

	}
}